/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.NameReference;
import net.sourceforge.phpdt.internal.compiler.ast.TypeReference;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.ArrayBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.BaseTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.ReferenceBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.Scope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class CastExpression
extends Expression {
    public Expression expression;
    public Expression type;
    public boolean needRuntimeCheckcast;

    public CastExpression(Expression e, Expression t) {
        this.expression = e;
        this.type = t;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
    }

    public final void areTypesCastCompatible(BlockScope scope, TypeBinding castType, TypeBinding expressionType) {
        this.needRuntimeCheckcast = false;
        if (castType == null || expressionType == null) {
            return;
        }
        if (castType.isBaseType()) {
            if (expressionType.isBaseType()) {
                if (expressionType == castType) {
                    this.expression.implicitWidening(castType, expressionType);
                    this.constant = this.expression.constant;
                    return;
                }
                if (expressionType.isCompatibleWith(castType) || BaseTypeBinding.isNarrowing(castType.id, expressionType.id)) {
                    this.expression.implicitConversion = (castType.id << 4) + expressionType.id;
                    if (this.expression.constant != Constant.NotAConstant) {
                        this.constant = this.expression.constant.castTo(this.expression.implicitConversion);
                    }
                    return;
                }
            }
            scope.problemReporter().typeCastError(this, castType, expressionType);
            return;
        }
        if (expressionType == NullBinding) {
            return;
        }
        if (expressionType.isBaseType()) {
            scope.problemReporter().typeCastError(this, castType, expressionType);
            return;
        }
        if (expressionType.isArrayType()) {
            if (castType == expressionType) {
                return;
            }
            if (castType.isArrayType()) {
                TypeBinding exprElementType = ((ArrayBinding)expressionType).elementsType(scope);
                if (exprElementType.isBaseType()) {
                    if (((ArrayBinding)castType).elementsType(scope) == exprElementType) {
                        this.needRuntimeCheckcast = true;
                    } else {
                        scope.problemReporter().typeCastError(this, castType, expressionType);
                    }
                    return;
                }
                this.areTypesCastCompatible(scope, ((ArrayBinding)castType).elementsType(scope), exprElementType);
                return;
            }
            if (castType.isClass()) {
                if (scope.isJavaLangObject(castType)) {
                    return;
                }
            } else if (scope.isJavaLangCloneable(castType) || scope.isJavaIoSerializable(castType)) {
                this.needRuntimeCheckcast = true;
                return;
            }
            scope.problemReporter().typeCastError(this, castType, expressionType);
            return;
        }
        if (expressionType.isClass()) {
            if (castType.isArrayType()) {
                if (scope.isJavaLangObject(expressionType)) {
                    this.needRuntimeCheckcast = true;
                    return;
                }
            } else if (castType.isClass()) {
                if (expressionType.isCompatibleWith(castType)) {
                    if (castType.id == 11) {
                        this.constant = this.expression.constant;
                    }
                    return;
                }
                if (castType.isCompatibleWith(expressionType)) {
                    this.needRuntimeCheckcast = true;
                    return;
                }
            } else if (((ReferenceBinding)expressionType).isFinal()) {
                if (expressionType.isCompatibleWith(castType)) {
                    return;
                }
            } else {
                this.needRuntimeCheckcast = true;
                return;
            }
            scope.problemReporter().typeCastError(this, castType, expressionType);
            return;
        }
        if (castType.isArrayType()) {
            if (scope.isJavaLangCloneable(expressionType) || scope.isJavaIoSerializable(expressionType)) {
                this.needRuntimeCheckcast = true;
            } else {
                scope.problemReporter().typeCastError(this, castType, expressionType);
            }
            return;
        }
        if (castType.isClass()) {
            if (scope.isJavaLangObject(castType)) {
                return;
            }
            if (((ReferenceBinding)castType).isFinal() && !castType.isCompatibleWith(expressionType)) {
                scope.problemReporter().typeCastError(this, castType, expressionType);
                return;
            }
        } else {
            if (castType == expressionType) {
                return;
            }
            if (Scope.compareTypes(castType, expressionType) == 0) {
                MethodBinding[] castTypeMethods = ((ReferenceBinding)castType).methods();
                MethodBinding[] expressionTypeMethods = ((ReferenceBinding)expressionType).methods();
                int exprMethodsLength = expressionTypeMethods.length;
                int i = 0;
                int castMethodsLength = castTypeMethods.length;
                while (i < castMethodsLength) {
                    int j = 0;
                    while (j < exprMethodsLength) {
                        if (castTypeMethods[i].returnType != expressionTypeMethods[j].returnType && castTypeMethods[i].selector == expressionTypeMethods[j].selector && castTypeMethods[i].areParametersEqual(expressionTypeMethods[j])) {
                            scope.problemReporter().typeCastError(this, castType, expressionType);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        this.needRuntimeCheckcast = true;
    }

    public Expression innermostCastedExpression() {
        Expression current = this.expression;
        while (current instanceof CastExpression) {
            current = ((CastExpression)current).expression;
        }
        return current;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('(');
        this.type.print(0, output).append(") ");
        return this.expression.printExpression(0, output);
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        this.implicitConversion = 0;
        if (this.type instanceof TypeReference || this.type instanceof NameReference) {
            this.resolvedType = this.type.resolveType(scope);
            TypeBinding castedExpressionType = this.expression.resolveType(scope);
            if (this.resolvedType != null && castedExpressionType != null) {
                this.areTypesCastCompatible(scope, this.resolvedType, castedExpressionType);
            }
            return this.resolvedType;
        }
        TypeBinding castedExpressionType = this.expression.resolveType(scope);
        if (castedExpressionType == null) {
            return null;
        }
        scope.problemReporter().invalidTypeReference(this.type);
        return null;
    }

    public String toStringExpression() {
        return "(" + this.type.toString(0) + ") " + this.expression.toStringExpression();
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.type.traverse(visitor, blockScope);
            this.expression.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }
}

