/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Assignment;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.OperatorExpression;
import net.sourceforge.phpdt.internal.compiler.ast.OperatorIds;
import net.sourceforge.phpdt.internal.compiler.ast.Reference;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class CompoundAssignment
extends Assignment
implements OperatorIds {
    public int operator;
    public int assignmentImplicitConversion;

    public CompoundAssignment(Expression lhs, Expression expression, int operator, int sourceEnd) {
        super(lhs, expression, sourceEnd);
        lhs.bits &= 0xFFFFDFFF;
        this.operator = operator;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return ((Reference)this.lhs).analyseAssignment(currentScope, flowContext, flowInfo, this, true).unconditionalInits();
    }

    public String operatorToString() {
        switch (this.operator) {
            case 14: {
                return "+=";
            }
            case 13: {
                return "-=";
            }
            case 15: {
                return "*=";
            }
            case 9: {
                return "/=";
            }
            case 2: {
                return "&=";
            }
            case 3: {
                return "|=";
            }
            case 8: {
                return "^=";
            }
            case 16: {
                return "%=";
            }
            case 10: {
                return "<<=";
            }
            case 17: {
                return ">>=";
            }
            case 19: {
                return ">>>=";
            }
        }
        return "unknown operator";
    }

    public TypeBinding resolveType(BlockScope scope) {
        int result;
        this.constant = NotAConstant;
        if (!(this.lhs instanceof Reference)) {
            scope.problemReporter().expressionShouldBeAVariable(this.lhs);
        }
        TypeBinding lhsType = this.lhs.resolveType(scope);
        TypeBinding expressionType = this.expression.resolveType(scope);
        if (lhsType == null || expressionType == null) {
            return null;
        }
        int lhsId = lhsType.id;
        int expressionId = expressionType.id;
        if (this.restrainUsageToNumericTypes() && !lhsType.isNumericType()) {
            scope.problemReporter().operatorOnlyValidOnNumericType(this, lhsType, expressionType);
            return null;
        }
        if (lhsId > 15 || expressionId > 15) {
            if (lhsId != 11) {
                scope.problemReporter().invalidOperator(this, lhsType, expressionType);
                return null;
            }
            expressionId = 1;
        }
        if ((result = OperatorExpression.ResolveTypeTables[this.operator][(lhsId << 4) + expressionId]) == 0) {
            scope.problemReporter().invalidOperator(this, lhsType, expressionType);
            return null;
        }
        if (this.operator == 14) {
            if (scope.isJavaLangObject(lhsType)) {
                scope.problemReporter().invalidOperator(this, lhsType, expressionType);
                return null;
            }
            if ((lhsType.isNumericType() || lhsId == 5) && !expressionType.isNumericType()) {
                scope.problemReporter().invalidOperator(this, lhsType, expressionType);
                return null;
            }
        }
        this.lhs.implicitConversion = result >>> 12;
        this.expression.implicitConversion = result >>> 4 & 0xFF;
        this.assignmentImplicitConversion = (lhsId << 4) + (result & 0xF);
        this.resolvedType = lhsType;
        return this.resolvedType;
    }

    public boolean restrainUsageToNumericTypes() {
        return false;
    }

    public String toStringExpressionNoParenthesis() {
        return String.valueOf(this.lhs.toStringExpression()) + " " + this.operatorToString() + " " + this.expression.toStringExpression();
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.lhs.traverse(visitor, scope);
            this.expression.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

