/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.ASTNode;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.InvocationSite;
import net.sourceforge.phpdt.internal.compiler.lookup.LocalTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodScope;
import net.sourceforge.phpdt.internal.compiler.lookup.ReferenceBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.SourceTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.VariableBinding;

public class ExplicitConstructorCall
extends Statement
implements InvocationSite {
    public Expression[] arguments;
    public Expression qualification;
    public MethodBinding binding;
    public int accessMode;
    public static final int ImplicitSuper = 1;
    public static final int Super = 2;
    public static final int This = 3;
    public VariableBinding[][] implicitArguments;
    boolean discardEnclosingInstance;
    MethodBinding syntheticAccessor;

    public ExplicitConstructorCall(int accessMode) {
        this.accessMode = accessMode;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            ((MethodScope)currentScope).isConstructorCall = true;
            if (this.qualification != null) {
                flowInfo = this.qualification.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
            }
            if (this.arguments != null) {
                int i = 0;
                int max = this.arguments.length;
                while (i < max) {
                    flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                    ++i;
                }
            }
            TypeBinding[] thrownExceptions = this.binding.thrownExceptions;
            if (this.binding.thrownExceptions != NoExceptions) {
                flowContext.checkExceptionHandlers(thrownExceptions, this.accessMode == 1 ? (ASTNode)((Object)currentScope.methodScope().referenceContext) : this, flowInfo, currentScope);
            }
            this.manageEnclosingInstanceAccessIfNecessary(currentScope);
            this.manageSyntheticAccessIfNecessary(currentScope);
            FlowInfo flowInfo2 = flowInfo;
            Object var6_8 = null;
            ((MethodScope)currentScope).isConstructorCall = false;
            return flowInfo2;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            ((MethodScope)currentScope).isConstructorCall = false;
            throw throwable;
        }
    }

    public boolean isImplicitSuper() {
        return this.accessMode == 1;
    }

    public boolean isSuperAccess() {
        return this.accessMode != 3;
    }

    public boolean isTypeAccess() {
        return true;
    }

    void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope) {
        ReferenceBinding superType = this.binding.declaringClass;
        if (superType.isNestedType() && currentScope.enclosingSourceType().isLocalType()) {
            if (superType.isLocalType()) {
                ((LocalTypeBinding)superType).addInnerEmulationDependent(currentScope, this.qualification != null);
            } else {
                currentScope.propagateInnerEmulation(superType, this.qualification != null);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope) {
        if (this.binding.isPrivate() && this.accessMode != 3) {
            this.syntheticAccessor = ((SourceTypeBinding)this.binding.declaringClass).addSyntheticMethod(this.binding, this.isSuperAccess());
            currentScope.problemReporter().needToEmulateMethodAccess(this.binding, this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(BlockScope scope) {
        block20: {
            block19: {
                try {
                    int i;
                    ((MethodScope)scope).isConstructorCall = true;
                    ReferenceBinding receiverType = scope.enclosingSourceType();
                    if (this.accessMode != 3) {
                        receiverType = receiverType.superclass();
                    }
                    if (receiverType == null) {
                        Object var7_3 = null;
                        ((MethodScope)scope).isConstructorCall = false;
                        return;
                    }
                    if (this.qualification != null) {
                        ReferenceBinding enclosingType;
                        if (this.accessMode != 2) {
                            scope.problemReporter().unnecessaryEnclosingInstanceSpecification(this.qualification, receiverType);
                        }
                        if ((enclosingType = receiverType.enclosingType()) == null) {
                            scope.problemReporter().unnecessaryEnclosingInstanceSpecification(this.qualification, receiverType);
                            this.discardEnclosingInstance = true;
                        } else {
                            TypeBinding qTb = this.qualification.resolveTypeExpecting(scope, enclosingType);
                            this.qualification.implicitWidening(qTb, qTb);
                        }
                    }
                    TypeBinding[] argTypes = NoParameters;
                    if (this.arguments != null) {
                        boolean argHasError = false;
                        int length = this.arguments.length;
                        argTypes = new TypeBinding[length];
                        i = 0;
                        while (true) {
                            if (i >= length) {
                                if (!argHasError) break;
                                break block19;
                            }
                            argTypes[i] = this.arguments[i].resolveType(scope);
                            if (argTypes[i] == null) {
                                argHasError = true;
                            }
                            ++i;
                        }
                    }
                    if ((this.binding = scope.getConstructor(receiverType, argTypes, this)).isValidBinding()) {
                        if (this.isMethodUseDeprecated(this.binding, scope)) {
                            scope.problemReporter().deprecatedMethod(this.binding, this);
                        }
                        if (this.arguments != null) {
                            int length = this.arguments.length;
                            TypeBinding[] paramTypes = this.binding.parameters;
                            i = 0;
                            while (i < length) {
                                this.arguments[i].implicitWidening(paramTypes[i], argTypes[i]);
                                ++i;
                            }
                        }
                        if (this.binding.isPrivate()) {
                            this.binding.modifiers |= 0x8000000;
                        }
                        break block20;
                    }
                    if (this.binding.declaringClass == null) {
                        this.binding.declaringClass = receiverType;
                    }
                    scope.problemReporter().invalidConstructor(this, this.binding);
                    break block20;
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    ((MethodScope)scope).isConstructorCall = false;
                    throw throwable;
                }
            }
            Object var7_4 = null;
            ((MethodScope)scope).isConstructorCall = false;
            return;
        }
        Object var7_6 = null;
        ((MethodScope)scope).isConstructorCall = false;
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    public void setDepth(int depth) {
    }

    public void setFieldIndex(int depth) {
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        ExplicitConstructorCall.printIndent(indent, output);
        if (this.qualification != null) {
            this.qualification.printExpression(0, output).append('.');
        }
        if (this.accessMode == 3) {
            output.append("this(");
        } else {
            output.append("super(");
        }
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].printExpression(0, output);
                ++i;
            }
        }
        return output.append(");");
    }

    public String toString(int tab) {
        String s = ExplicitConstructorCall.tabString(tab);
        if (this.qualification != null) {
            s = String.valueOf(s) + this.qualification.toStringExpression() + ".";
        }
        s = this.accessMode == 3 ? String.valueOf(s) + "this(" : String.valueOf(s) + "super(";
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                s = String.valueOf(s) + this.arguments[i].toStringExpression();
                if (i != this.arguments.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + ")";
        return s;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.qualification != null) {
                this.qualification.traverse(visitor, scope);
            }
            if (this.arguments != null) {
                int argumentLength = this.arguments.length;
                int i = 0;
                while (i < argumentLength) {
                    this.arguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, scope);
    }
}

