/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.AbstractVariableDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.ArrayInitializer;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.ArrayBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.BaseTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.FieldBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodScope;
import net.sourceforge.phpdt.internal.compiler.lookup.Scope;
import net.sourceforge.phpdt.internal.compiler.lookup.SourceTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class FieldDeclaration
extends AbstractVariableDeclaration {
    public FieldBinding binding;
    boolean hasBeenResolved = false;
    public int endPart1Position;
    public int endPart2Position;

    public FieldDeclaration() {
    }

    public FieldDeclaration(char[] name, int sourceStart, int sourceEnd) {
        this.name = name;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FieldDeclaration(Expression initialization, char[] name, int sourceStart, int sourceEnd) {
        this.initialization = initialization;
        this.name = name;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseCode(MethodScope initializationScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.binding != null && this.binding.isPrivate() && !this.binding.isPrivateUsed() && !initializationScope.referenceCompilationUnit().compilationResult.hasSyntaxError()) {
            initializationScope.problemReporter().unusedPrivateField(this);
        }
        if (this.binding != null && this.binding.isValidBinding() && this.binding.isStatic() && this.binding.constant == NotAConstant && this.binding.declaringClass.isNestedType() && this.binding.declaringClass.isClass() && !this.binding.declaringClass.isStatic()) {
            initializationScope.problemReporter().unexpectedStaticModifierForField((SourceTypeBinding)this.binding.declaringClass, this);
        }
        if (this.initialization != null) {
            flowInfo = this.initialization.analyseCode(initializationScope, flowContext, flowInfo).unconditionalInits();
            flowInfo.markAsDefinitelyAssigned(this.binding);
        }
        return flowInfo;
    }

    public TypeBinding getTypeBinding(Scope scope) {
        return this.type.getTypeBinding(scope);
    }

    public boolean isField() {
        return true;
    }

    public boolean isStatic() {
        if (this.binding != null) {
            return this.binding.isStatic();
        }
        return (this.modifiers & 8) != 0;
    }

    public String name() {
        return String.valueOf(this.name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(MethodScope initializationScope) {
        if (this.hasBeenResolved) return;
        if (this.binding == null) return;
        if (!this.binding.isValidBinding()) return;
        this.hasBeenResolved = true;
        if (this.isTypeUseDeprecated(this.binding.type, initializationScope)) {
            initializationScope.problemReporter().deprecatedType(this.binding.type, this.type);
        }
        this.type.resolvedType = this.binding.type;
        if (this.initialization == null) {
            this.binding.constant = Constant.NotAConstant;
            return;
        }
        int previous = initializationScope.fieldDeclarationIndex;
        try {
            initializationScope.fieldDeclarationIndex = this.binding.id;
            this.binding.constant = Constant.NotAConstant;
            TypeBinding typeBinding = this.binding.type;
            if (this.initialization instanceof ArrayInitializer) {
                TypeBinding initializationTypeBinding = this.initialization.resolveTypeExpecting(initializationScope, typeBinding);
                if (initializationTypeBinding != null) {
                    ((ArrayInitializer)this.initialization).binding = (ArrayBinding)initializationTypeBinding;
                    this.initialization.implicitWidening(typeBinding, initializationTypeBinding);
                }
            } else {
                TypeBinding initializationTypeBinding = this.initialization.resolveType(initializationScope);
                if (initializationTypeBinding != null) {
                    if (this.initialization.isConstantValueOfTypeAssignableToType(initializationTypeBinding, typeBinding) || typeBinding.isBaseType() && BaseTypeBinding.isWidening(typeBinding.id, initializationTypeBinding.id)) {
                        this.initialization.implicitWidening(typeBinding, initializationTypeBinding);
                    } else if (initializationTypeBinding.isCompatibleWith(typeBinding)) {
                        this.initialization.implicitWidening(typeBinding, initializationTypeBinding);
                    } else {
                        initializationScope.problemReporter().typeMismatchError(initializationTypeBinding, typeBinding, this);
                    }
                    if (this.binding.isFinal()) {
                        this.binding.constant = this.initialization.constant.castTo((this.binding.type.id << 4) + this.initialization.constant.typeID());
                    }
                } else {
                    this.binding.constant = NotAConstant;
                }
            }
            Object var5_8 = null;
            initializationScope.fieldDeclarationIndex = previous;
            if (this.binding.constant != null) return;
            this.binding.constant = Constant.NotAConstant;
            return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            initializationScope.fieldDeclarationIndex = previous;
            if (this.binding.constant != null) throw throwable;
            this.binding.constant = Constant.NotAConstant;
            throw throwable;
        }
    }

    public void traverse(ASTVisitor visitor, MethodScope scope) {
        if (visitor.visit(this, scope)) {
            this.type.traverse(visitor, scope);
            if (this.initialization != null) {
                this.initialization.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldDeclaration) {
            char[] objName = ((FieldDeclaration)obj).name;
            if (this.name.length != objName.length) {
                return false;
            }
            int i = 0;
            while (i < objName.length) {
                if (this.name[i] != objName[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.equals(obj);
    }
}

