/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.ASTNode;
import net.sourceforge.phpdt.internal.compiler.ast.AbstractMethodDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.TryStatement;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.flow.InitializationFlowContext;
import net.sourceforge.phpdt.internal.compiler.lookup.BaseTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.LocalVariableBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodScope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class ReturnStatement
extends Statement {
    public Expression expression;
    public TypeBinding expressionType;
    public boolean isSynchronized;
    public ASTNode[] subroutines;
    public LocalVariableBinding saveValueVariable;

    public ReturnStatement(Expression expr, int s, int e) {
        this.sourceStart = s;
        this.sourceEnd = e;
        this.expression = expr;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        boolean hasValueToSave;
        if (this.expression != null) {
            flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo);
        }
        FlowContext traversedContext = flowContext;
        int subIndex = 0;
        int maxSub = 5;
        boolean saveValueNeeded = false;
        boolean bl = hasValueToSave = this.expression != null && this.expression.constant == NotAConstant;
        do {
            ASTNode sub;
            if ((sub = traversedContext.subRoutine()) != null) {
                if (this.subroutines == null) {
                    this.subroutines = new ASTNode[maxSub];
                }
                if (subIndex == maxSub) {
                    this.subroutines = new ASTNode[maxSub *= 2];
                    System.arraycopy(this.subroutines, 0, this.subroutines, 0, subIndex);
                }
                this.subroutines[subIndex++] = sub;
                if (sub.cannotReturn()) {
                    saveValueNeeded = false;
                    break;
                }
            }
            traversedContext.recordReturnFrom(flowInfo.unconditionalInits());
            ASTNode node = traversedContext.associatedNode;
            if (node instanceof TryStatement) {
                TryStatement tryStatement = (TryStatement)node;
                flowInfo.addInitializationsFrom(tryStatement.subRoutineInits);
                if (!hasValueToSave) continue;
                if (this.saveValueVariable == null) {
                    this.prepareSaveValueLocation(tryStatement);
                }
                saveValueNeeded = true;
                continue;
            }
            if (!(traversedContext instanceof InitializationFlowContext)) continue;
            currentScope.problemReporter().cannotReturnInInitializer(this);
            return FlowInfo.DEAD_END;
        } while ((traversedContext = traversedContext.parent) != null);
        if (this.subroutines != null && subIndex != maxSub) {
            this.subroutines = new ASTNode[subIndex];
            System.arraycopy(this.subroutines, 0, this.subroutines, 0, subIndex);
        }
        if (saveValueNeeded) {
            if (this.saveValueVariable != null) {
                this.saveValueVariable.useFlag = 1;
            }
        } else {
            this.saveValueVariable = null;
            if (!this.isSynchronized && this.expressionType == BooleanBinding) {
                this.expression.bits |= 0x10;
            }
        }
        return FlowInfo.DEAD_END;
    }

    public boolean needValue() {
        return this.subroutines == null || this.saveValueVariable != null || this.isSynchronized;
    }

    public void prepareSaveValueLocation(TryStatement targetTryStatement) {
        this.saveValueVariable = targetTryStatement.secretReturnValue;
    }

    public void resolve(BlockScope scope) {
        BaseTypeBinding methodType;
        MethodBinding methodBinding;
        MethodScope methodScope = scope.methodScope();
        Object object = methodScope.referenceContext instanceof AbstractMethodDeclaration ? ((methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) == null ? null : methodBinding.returnType) : (methodType = VoidBinding);
        if (methodType == VoidBinding) {
            if (this.expression == null) {
                return;
            }
            this.expressionType = this.expression.resolveType(scope);
            if (this.expressionType != null) {
                scope.problemReporter().attemptToReturnNonVoidExpression(this, this.expressionType);
            }
            return;
        }
        if (this.expression == null) {
            if (methodType != null) {
                scope.problemReporter().shouldReturn(methodType, this);
            }
            return;
        }
        this.expressionType = this.expression.resolveType(scope);
        if (this.expressionType == null) {
            return;
        }
        if (methodType != null && this.expression.isConstantValueOfTypeAssignableToType(this.expressionType, methodType)) {
            this.expression.implicitWidening(methodType, this.expressionType);
            return;
        }
        if (this.expressionType == VoidBinding) {
            scope.problemReporter().attemptToReturnVoidValue(this);
            return;
        }
        if (methodType != null && this.expressionType.isCompatibleWith(methodType)) {
            this.expression.implicitWidening(methodType, this.expressionType);
            return;
        }
        if (methodType != null) {
            scope.problemReporter().typeMismatchErrorActualTypeExpectedType(this.expression, this.expressionType, methodType);
        }
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        ReturnStatement.printIndent(tab, output).append("return ");
        if (this.expression != null) {
            this.expression.printExpression(0, output);
        }
        return output.append(';');
    }

    public String toString(int tab) {
        String s = ReturnStatement.tabString(tab);
        s = String.valueOf(s) + "return ";
        if (this.expression != null) {
            s = String.valueOf(s) + this.expression.toStringExpression();
        }
        return s;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.expression != null) {
            this.expression.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

