/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Assignment;
import net.sourceforge.phpdt.internal.compiler.ast.Reference;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodScope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class ThisReference
extends Reference {
    public static ThisReference implicitThis() {
        ThisReference implicitThis = new ThisReference(0, 0);
        implicitThis.bits |= 4;
        return implicitThis;
    }

    public ThisReference(int sourceStart, int sourceEnd) {
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseAssignment(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean isCompound) {
        return flowInfo;
    }

    public boolean checkAccess(MethodScope methodScope) {
        if (methodScope.isConstructorCall) {
            methodScope.problemReporter().fieldsOrThisBeforeConstructorInvocation(this);
            return false;
        }
        if (methodScope.isStatic) {
            methodScope.problemReporter().errorThisSuperInStatic(this);
            return false;
        }
        return true;
    }

    public boolean isImplicitThis() {
        return (this.bits & 4) != 0;
    }

    public boolean isThis() {
        return true;
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = NotAConstant;
        if (!this.isImplicitThis() && !this.checkAccess(scope.methodScope())) {
            return null;
        }
        this.resolvedType = scope.enclosingSourceType();
        return this.resolvedType;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.isImplicitThis()) {
            return output;
        }
        return output.append("this");
    }

    public String toStringExpression() {
        if (this.isImplicitThis()) {
            return "";
        }
        return "this";
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope blockScope) {
        visitor.visit(this, blockScope);
        visitor.endVisit(this, blockScope);
    }
}

