/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Block;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.codegen.Label;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.flow.LoopingFlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.UnconditionalFlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class WhileStatement
extends Statement {
    public Expression condition;
    public Statement action;
    private Label breakLabel;
    private Label continueLabel;
    int preCondInitStateIndex = -1;
    int condIfTrueInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public WhileStatement(Expression condition, Statement action, int s, int e) {
        this.condition = condition;
        this.action = action;
        this.sourceStart = s;
        this.sourceEnd = e;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo actionInfo;
        this.breakLabel = new Label();
        this.continueLabel = new Label();
        Constant cst = this.condition.constant;
        boolean bl = cst != NotAConstant && cst.booleanValue();
        boolean isConditionFalse = cst != NotAConstant && !cst.booleanValue();
        cst = this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst != NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != NotAConstant && !cst.booleanValue();
        this.preCondInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
        LoopingFlowContext condLoopContext = new LoopingFlowContext(flowContext, this, null, null, currentScope);
        FlowInfo postCondInfo = this.condition.analyseCode(currentScope, condLoopContext, flowInfo);
        LoopingFlowContext loopingContext = new LoopingFlowContext(flowContext, this, this.breakLabel, this.continueLabel, currentScope);
        if (isConditionFalse) {
            actionInfo = FlowInfo.DEAD_END;
        } else {
            actionInfo = postCondInfo.initsWhenTrue().copy();
            if (isConditionOptimizedFalse) {
                actionInfo.setReachMode(1);
            }
        }
        this.condIfTrueInitStateIndex = currentScope.methodScope().recordInitializationStates(postCondInfo.initsWhenTrue());
        if (!actionInfo.complainIfUnreachable(this.action, currentScope, false)) {
            actionInfo = this.action.analyseCode(currentScope, loopingContext, actionInfo);
        }
        if (!actionInfo.isReachable() && !loopingContext.initsOnContinue.isReachable()) {
            this.continueLabel = null;
        } else {
            condLoopContext.complainOnFinalAssignmentsInLoop(currentScope, postCondInfo);
            loopingContext.complainOnFinalAssignmentsInLoop(currentScope, actionInfo);
        }
        if (isConditionOptimizedTrue) {
            UnconditionalFlowInfo mergedInfo = loopingContext.initsOnBreak;
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
            return mergedInfo;
        }
        UnconditionalFlowInfo mergedInfo = postCondInfo.initsWhenFalse().unconditionalInits().mergedWith(loopingContext.initsOnBreak);
        if (isConditionOptimizedTrue && this.continueLabel == null) {
            ((FlowInfo)mergedInfo).setReachMode(1);
        }
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public void resetStateForCodeGeneration() {
        if (this.breakLabel != null) {
            this.breakLabel.resetStateForCodeGeneration();
        }
        if (this.continueLabel != null) {
            this.continueLabel.resetStateForCodeGeneration();
        }
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        WhileStatement.printIndent(tab, output).append("while (");
        this.condition.printExpression(0, output).append(')');
        if (this.action == null) {
            output.append(';');
        } else {
            this.action.printStatement(tab + 1, output);
        }
        return output;
    }

    public void resolve(BlockScope scope) {
        TypeBinding type = this.condition.resolveTypeExpecting(scope, BooleanBinding);
        this.condition.implicitWidening(type, type);
        if (this.action != null) {
            this.action.resolve(scope);
        }
    }

    public String toString(int tab) {
        String s = WhileStatement.tabString(tab);
        s = String.valueOf(s) + "while (" + this.condition.toStringExpression() + ")";
        s = this.action == null ? String.valueOf(s) + " {} ;" : (this.action instanceof Block ? String.valueOf(s) + "\n" + this.action.toString(tab + 1) : String.valueOf(s) + " {\n" + this.action.toString(tab + 1) + "}");
        return s;
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.condition.traverse(visitor, blockScope);
            if (this.action != null) {
                this.action.traverse(visitor, blockScope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

