/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.batch;

import java.io.File;
import java.util.Hashtable;
import net.sourceforge.phpdt.internal.compiler.batch.CompilationUnit;
import net.sourceforge.phpdt.internal.compiler.batch.FileSystem;
import net.sourceforge.phpdt.internal.compiler.env.NameEnvironmentAnswer;
import net.sourceforge.phpdt.internal.compiler.util.SuffixConstants;

public class ClasspathDirectory
implements FileSystem.Classpath,
SuffixConstants {
    String path;
    Hashtable directoryCache;
    String[] missingPackageHolder = new String[1];
    String encoding;
    public int mode;
    public static final int SOURCE = 1;
    public static final int BINARY = 2;

    ClasspathDirectory(File directory, String encoding, int mode) {
        this.mode = mode;
        this.path = directory.getAbsolutePath();
        if (!this.path.endsWith(File.separator)) {
            this.path = String.valueOf(this.path) + File.separator;
        }
        this.directoryCache = new Hashtable(11);
        this.encoding = encoding;
    }

    ClasspathDirectory(File directory, String encoding) {
        this(directory, encoding, 3);
    }

    String[] directoryList(String qualifiedPackageName) {
        String[] dirList = (String[])this.directoryCache.get(qualifiedPackageName);
        if (dirList == this.missingPackageHolder) {
            return null;
        }
        if (dirList != null) {
            return dirList;
        }
        File dir = new File(String.valueOf(this.path) + qualifiedPackageName);
        if (dir != null && dir.isDirectory()) {
            String parentPackage;
            String packageName;
            int index = qualifiedPackageName.length();
            int last = qualifiedPackageName.lastIndexOf(File.separatorChar);
            while (--index > last && !Character.isUpperCase(qualifiedPackageName.charAt(index))) {
            }
            if (index <= last || !(last != -1 ? !this.doesFileExist(packageName = qualifiedPackageName.substring(last + 1), parentPackage = qualifiedPackageName.substring(0, last)) : !this.doesFileExist(qualifiedPackageName, ""))) {
                dirList = dir.list();
                if (dirList == null) {
                    dirList = new String[]{};
                }
                this.directoryCache.put(qualifiedPackageName, dirList);
                return dirList;
            }
        }
        this.directoryCache.put(qualifiedPackageName, this.missingPackageHolder);
        return null;
    }

    boolean doesFileExist(String fileName, String qualifiedPackageName) {
        String[] dirList = this.directoryList(qualifiedPackageName);
        if (dirList == null) {
            return false;
        }
        int i = dirList.length;
        while (--i >= 0) {
            if (!fileName.equals(dirList[i])) continue;
            return true;
        }
        return false;
    }

    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        boolean sourceExists;
        if (!this.isPackage(qualifiedPackageName)) {
            return null;
        }
        String fileName = new String(typeName);
        boolean bl = sourceExists = (this.mode & 1) != 0 && this.doesFileExist(String.valueOf(fileName) + ".php", qualifiedPackageName);
        if (sourceExists) {
            String fullSourcePath = String.valueOf(this.path) + qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - 6) + ".php";
            return new NameEnvironmentAnswer(new CompilationUnit(null, fullSourcePath, this.encoding));
        }
        return null;
    }

    public boolean isPackage(String qualifiedPackageName) {
        return this.directoryList(qualifiedPackageName) != null;
    }

    public void reset() {
        this.directoryCache = new Hashtable(11);
    }

    public String toString() {
        return "ClasspathDirectory " + this.path;
    }
}

