/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.lookup;

import java.util.ArrayList;
import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.internal.compiler.ast.CompilationUnitDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.ImportReference;
import net.sourceforge.phpdt.internal.compiler.ast.TypeDeclaration;
import net.sourceforge.phpdt.internal.compiler.lookup.ArrayBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.Binding;
import net.sourceforge.phpdt.internal.compiler.lookup.ClassScope;
import net.sourceforge.phpdt.internal.compiler.lookup.ImportBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.LocalTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.LookupEnvironment;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodVerifier;
import net.sourceforge.phpdt.internal.compiler.lookup.PackageBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.ProblemReferenceBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.ReferenceBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.Scope;
import net.sourceforge.phpdt.internal.compiler.lookup.SourceTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import net.sourceforge.phpdt.internal.compiler.problem.ProblemReporter;
import net.sourceforge.phpdt.internal.compiler.util.CompoundNameVector;
import net.sourceforge.phpdt.internal.compiler.util.HashtableOfObject;
import net.sourceforge.phpdt.internal.compiler.util.HashtableOfType;
import net.sourceforge.phpdt.internal.compiler.util.ObjectVector;
import net.sourceforge.phpdt.internal.compiler.util.SimpleNameVector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

public class CompilationUnitScope
extends Scope {
    public LookupEnvironment environment;
    public CompilationUnitDeclaration referenceContext;
    public char[][] currentPackageName;
    public PackageBinding fPackage;
    public ImportBinding[] imports;
    public SourceTypeBinding[] topLevelTypes;
    private CompoundNameVector qualifiedReferences;
    private SimpleNameVector simpleNameReferences;
    private ObjectVector referencedTypes;
    HashtableOfType constantPoolNameUsage;
    public HashtableOfObject resolvedSingeTypeImports;

    public CompilationUnitScope(CompilationUnitDeclaration unit, LookupEnvironment environment) {
        super(4, null);
        this.environment = environment;
        this.referenceContext = unit;
        unit.scope = this;
        this.currentPackageName = null;
        this.qualifiedReferences = null;
        this.simpleNameReferences = null;
        this.referencedTypes = null;
    }

    void buildFieldsAndMethods() {
        int i = 0;
        int length = this.topLevelTypes.length;
        while (i < length) {
            this.topLevelTypes[i].scope.buildFieldsAndMethods();
            ++i;
        }
    }

    void buildTypeBindings() {
        ArrayList types;
        char[][] expectedPackageName;
        if (this.referenceContext.compilationResult.compilationUnit != null && (expectedPackageName = this.referenceContext.compilationResult.compilationUnit.getPackageName()) != null && !CharOperation.equals(this.currentPackageName, expectedPackageName)) {
            char[][] cArray = this.currentPackageName = expectedPackageName.length == 0 ? CharOperation.NO_CHAR_CHAR : expectedPackageName;
        }
        if (this.currentPackageName == CharOperation.NO_CHAR_CHAR) {
            this.fPackage = this.environment.defaultPackage;
            if (this.fPackage == null) {
                this.problemReporter().mustSpecifyPackage(this.referenceContext);
                return;
            }
        } else {
            this.fPackage = this.environment.createPackage(this.currentPackageName);
            if (this.fPackage == null) {
                return;
            }
            this.recordQualifiedReference(this.currentPackageName);
        }
        int typeLength = (types = this.referenceContext.types) == null ? 0 : types.size();
        this.topLevelTypes = new SourceTypeBinding[typeLength];
        int count = 0;
        int i = 0;
        while (i < typeLength) {
            if (types.get(i) instanceof TypeDeclaration) {
                char[] mainTypeName;
                TypeDeclaration typeDecl = (TypeDeclaration)types.get(i);
                ReferenceBinding typeBinding = this.fPackage.getType0(typeDecl.name);
                this.recordSimpleReference(typeDecl.name);
                if (typeBinding != null && !(typeBinding instanceof UnresolvedReferenceBinding)) {
                    this.problemReporter().duplicateTypes(this.referenceContext, typeDecl);
                } else if (this.fPackage != this.environment.defaultPackage && this.fPackage.getPackage(typeDecl.name) != null) {
                    this.problemReporter().typeCollidesWithPackage(this.referenceContext, typeDecl);
                } else if ((typeDecl.modifiers & 1) != 0 && (mainTypeName = this.referenceContext.getMainTypeName()) != null && !CharOperation.equals(mainTypeName, typeDecl.name)) {
                    this.problemReporter().publicClassMustMatchFileName(this.referenceContext, typeDecl);
                } else {
                    ClassScope child = new ClassScope(this, typeDecl);
                    SourceTypeBinding type = child.buildType(null, this.fPackage);
                    if (type != null) {
                        this.topLevelTypes[count++] = type;
                    }
                }
            }
            ++i;
        }
        if (count != this.topLevelTypes.length) {
            this.topLevelTypes = new SourceTypeBinding[count];
            System.arraycopy(this.topLevelTypes, 0, this.topLevelTypes, 0, count);
        }
    }

    void checkAndSetImports() {
        int numberOfStatements;
        if (this.environment.defaultImports == null) {
            Binding importBinding = this.environment.getTopLevelPackage(JAVA);
            if (importBinding != null) {
                importBinding = importBinding.getTypeOrPackage(JAVA_LANG[1]);
            }
            if (importBinding == null || !importBinding.isValidBinding()) {
                this.problemReporter().isClassPathCorrect(JAVA_LANG_OBJECT, this.referenceCompilationUnit());
            }
            this.environment.defaultImports = new ImportBinding[]{new ImportBinding(JAVA_LANG, true, importBinding, null)};
        }
        if (this.referenceContext.imports == null) {
            this.imports = this.environment.defaultImports;
            return;
        }
        int numberOfImports = numberOfStatements = this.referenceContext.imports.length;
        ImportBinding[] resolvedImports = new ImportBinding[numberOfImports];
        resolvedImports[0] = this.environment.defaultImports[0];
        int index = 1;
        int i = 0;
        while (i < numberOfStatements) {
            block15: {
                ImportReference importReference = this.referenceContext.imports[i];
                IFile file = importReference.getFile();
                char[][] compoundName = null;
                if (file != null) {
                    IPath path = file.getProjectRelativePath();
                    String[] segs = path.segments();
                    compoundName = new char[segs.length][];
                    int j = 0;
                    while (j < segs.length) {
                        compoundName[j] = segs[j].toCharArray();
                        ++j;
                    }
                }
                if (compoundName != null) {
                    int j = 0;
                    while (j < index) {
                        if (resolvedImports[j].onDemand != importReference.onDemand || !CharOperation.equals(compoundName, resolvedImports[j].compoundName)) {
                            ++j;
                            continue;
                        }
                        break block15;
                    }
                    if (!importReference.onDemand || !CharOperation.equals(compoundName, this.currentPackageName)) {
                        if (importReference.onDemand) {
                            Binding importBinding = this.findOnDemandImport(compoundName);
                            if (importBinding.isValidBinding()) {
                                resolvedImports[index++] = new ImportBinding(compoundName, true, importBinding, importReference);
                            }
                        } else {
                            resolvedImports[index++] = new ImportBinding(compoundName, false, null, importReference);
                        }
                    }
                }
            }
            ++i;
        }
        if (resolvedImports.length > index) {
            ImportBinding[] importBindingArray = resolvedImports;
            resolvedImports = new ImportBinding[index];
            System.arraycopy(importBindingArray, 0, resolvedImports, 0, index);
        }
        this.imports = resolvedImports;
    }

    public char[] computeConstantPoolName(LocalTypeBinding localType) {
        char[] candidateName;
        if (localType.constantPoolName() != null) {
            return localType.constantPoolName();
        }
        if (this.constantPoolNameUsage == null) {
            this.constantPoolNameUsage = new HashtableOfType();
        }
        SourceTypeBinding outerMostEnclosingType = localType.scope.outerMostClassScope().enclosingSourceType();
        int index = 0;
        while (true) {
            candidateName = localType.isMemberType() ? (index == 0 ? CharOperation.concat(localType.enclosingType().constantPoolName(), localType.sourceName, '$') : CharOperation.concat(localType.enclosingType().constantPoolName(), '$', String.valueOf(index).toCharArray(), '$', localType.sourceName)) : (localType.isAnonymousType() ? CharOperation.concat(outerMostEnclosingType.constantPoolName(), String.valueOf(index + 1).toCharArray(), '$') : CharOperation.concat(outerMostEnclosingType.constantPoolName(), '$', String.valueOf(index + 1).toCharArray(), '$', localType.sourceName));
            if (this.constantPoolNameUsage.get(candidateName) == null) break;
            ++index;
        }
        this.constantPoolNameUsage.put(candidateName, localType);
        return candidateName;
    }

    void connectTypeHierarchy() {
        int i = 0;
        int length = this.topLevelTypes.length;
        while (i < length) {
            this.topLevelTypes[i].scope.connectTypeHierarchy();
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    void faultInImports() {
        if (this.referenceContext.imports == null) {
            return;
        }
        int numberOfStatements = this.referenceContext.imports.length;
        ImportBinding[] resolvedImports = new ImportBinding[numberOfStatements];
        int index = 0;
        int i = 0;
        while (i < numberOfStatements) {
            ImportReference importReference = this.referenceContext.imports[i];
            IFile file = importReference.getFile();
            if (file != null) {
                void var7_8;
                void var8_9;
                SourceTypeBinding typeBinding = new SourceTypeBinding();
                IPath path = file.getProjectRelativePath();
                String[] segs = path.segments();
                char[][] compoundName = new char[segs.length][];
                int j = 0;
                while (j < segs.length) {
                    compoundName[j] = segs[j].toCharArray();
                    ++j;
                }
                typeBinding.compoundName = compoundName;
                typeBinding.fileName = file.getLocation().toString().toCharArray();
                typeBinding.sourceName = path.lastSegment().toCharArray();
                resolvedImports[index++] = new ImportBinding((char[][])var8_9, false, (Binding)var7_8, importReference);
                this.imports = resolvedImports;
            }
            ++i;
        }
        if (resolvedImports.length > index) {
            ImportBinding[] importBindingArray = resolvedImports;
            resolvedImports = new ImportBinding[index];
            System.arraycopy(importBindingArray, 0, resolvedImports, 0, index);
        }
        this.imports = resolvedImports;
        int length = this.imports.length;
        this.resolvedSingeTypeImports = new HashtableOfObject(length);
        int i2 = 0;
        while (i2 < length) {
            ImportBinding binding = this.imports[i2];
            if (!binding.onDemand) {
                this.resolvedSingeTypeImports.put(binding.compoundName[binding.compoundName.length - 1], binding);
            }
            ++i2;
        }
    }

    public void faultInTypes() {
        this.faultInImports();
        if (this.topLevelTypes == null) {
            this.topLevelTypes = new SourceTypeBinding[0];
        }
        int i = 0;
        int length = this.topLevelTypes.length;
        while (i < length) {
            this.topLevelTypes[i].faultInTypesForFieldsAndMethods();
            ++i;
        }
    }

    private Binding findOnDemandImport(char[][] compoundName) {
        ReferenceBinding type;
        int length;
        int i;
        Binding binding;
        block12: {
            this.recordQualifiedReference(compoundName);
            binding = this.environment.getTopLevelPackage(compoundName[0]);
            i = 1;
            length = compoundName.length;
            if (binding != null) {
                PackageBinding packageBinding = binding;
                while (i < length) {
                    if ((binding = packageBinding.getTypeOrPackage(compoundName[i++])) == null || !binding.isValidBinding()) {
                        binding = null;
                    } else if (binding instanceof PackageBinding) {
                        packageBinding = (PackageBinding)binding;
                        continue;
                    }
                    break block12;
                }
                return packageBinding;
            }
        }
        if (binding == null) {
            type = this.findType(compoundName[0], this.environment.defaultPackage, this.environment.defaultPackage);
            if (type == null || !type.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), 1);
            }
            i = 1;
        } else {
            type = (ReferenceBinding)binding;
        }
        while (i < length) {
            if (!type.canBeSeenBy(this.fPackage)) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), type, 2);
            }
            if ((type = type.getMemberType(compoundName[i])) == null) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i + 1), 1);
            }
            ++i;
        }
        if (!type.canBeSeenBy(this.fPackage)) {
            return new ProblemReferenceBinding(compoundName, type, 2);
        }
        return type;
    }

    private Binding findSingleTypeImport(char[][] compoundName) {
        ReferenceBinding typeBinding = this.findType(compoundName[0], this.environment.defaultPackage, this.fPackage);
        if (typeBinding == null) {
            return new ProblemReferenceBinding(compoundName, 1);
        }
        return typeBinding;
    }

    public ProblemReporter problemReporter() {
        ProblemReporter problemReporter = this.referenceContext.problemReporter;
        problemReporter.referenceContext = this.referenceContext;
        return problemReporter;
    }

    void recordQualifiedReference(char[][] qualifiedName) {
        if (this.qualifiedReferences == null) {
            return;
        }
        int length = qualifiedName.length;
        if (length > 1) {
            while (!this.qualifiedReferences.contains(qualifiedName)) {
                this.qualifiedReferences.add(qualifiedName);
                if (length == 2) {
                    this.recordSimpleReference(qualifiedName[0]);
                    this.recordSimpleReference(qualifiedName[1]);
                    return;
                }
                this.recordSimpleReference(qualifiedName[--length]);
                char[][] cArray = qualifiedName;
                qualifiedName = new char[length][];
                System.arraycopy(cArray, 0, qualifiedName, 0, length);
            }
        } else if (length == 1) {
            this.recordSimpleReference(qualifiedName[0]);
        }
    }

    void recordReference(char[][] qualifiedEnclosingName, char[] simpleName) {
        this.recordQualifiedReference(qualifiedEnclosingName);
        this.recordSimpleReference(simpleName);
    }

    void recordSimpleReference(char[] simpleName) {
        if (this.simpleNameReferences == null) {
            return;
        }
        if (!this.simpleNameReferences.contains(simpleName)) {
            this.simpleNameReferences.add(simpleName);
        }
    }

    void recordTypeReference(TypeBinding type) {
        if (this.referencedTypes == null) {
            return;
        }
        if (type.isArrayType()) {
            type = ((ArrayBinding)type).leafComponentType;
        }
        if (!type.isBaseType() && !this.referencedTypes.containsIdentical(type)) {
            this.referencedTypes.add(type);
        }
    }

    void recordTypeReferences(TypeBinding[] types) {
        if (this.qualifiedReferences == null) {
            return;
        }
        if (types == null || types.length == 0) {
            return;
        }
        int i = 0;
        int max = types.length;
        while (i < max) {
            ReferenceBinding actualType;
            TypeBinding type = types[i];
            if (type.isArrayType()) {
                type = ((ArrayBinding)type).leafComponentType;
            }
            if (!type.isBaseType() && !(actualType = (ReferenceBinding)type).isLocalType()) {
                this.recordQualifiedReference(actualType.isMemberType() ? CharOperation.splitOn('.', actualType.readableName()) : actualType.compoundName);
            }
            ++i;
        }
    }

    Binding resolveSingleTypeImport(ImportBinding importBinding) {
        if (importBinding.resolvedImport == null) {
            importBinding.resolvedImport = this.findSingleTypeImport(importBinding.compoundName);
            if (!importBinding.resolvedImport.isValidBinding() || importBinding.resolvedImport instanceof PackageBinding) {
                if (this.imports != null) {
                    ImportBinding[] newImports = new ImportBinding[this.imports.length - 1];
                    int i = 0;
                    int n = 0;
                    int max = this.imports.length;
                    while (i < max) {
                        if (this.imports[i] != importBinding) {
                            newImports[n++] = this.imports[i];
                        }
                        ++i;
                    }
                    this.imports = newImports;
                }
                return null;
            }
        }
        return importBinding.resolvedImport;
    }

    public void storeDependencyInfo() {
        int i = 0;
        while (i < this.referencedTypes.size) {
            ReferenceBinding[] interfaces;
            ReferenceBinding superclass;
            ReferenceBinding type = (ReferenceBinding)this.referencedTypes.elementAt(i);
            if (!type.isLocalType()) {
                this.recordQualifiedReference(type.isMemberType() ? CharOperation.splitOn('.', type.readableName()) : type.compoundName);
                ReferenceBinding enclosing = type.enclosingType();
                if (enclosing != null && !this.referencedTypes.containsIdentical(enclosing)) {
                    this.referencedTypes.add(enclosing);
                }
            }
            if ((superclass = type.superclass()) != null && !this.referencedTypes.containsIdentical(superclass)) {
                this.referencedTypes.add(superclass);
            }
            if ((interfaces = type.superInterfaces()) != null && interfaces.length > 0) {
                int j = 0;
                int length = interfaces.length;
                while (j < length) {
                    if (!this.referencedTypes.containsIdentical(interfaces[j])) {
                        this.referencedTypes.add(interfaces[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        int size = this.qualifiedReferences.size;
        char[][][] qualifiedRefs = new char[size][][];
        int i2 = 0;
        while (i2 < size) {
            qualifiedRefs[i2] = this.qualifiedReferences.elementAt(i2);
            ++i2;
        }
        this.referenceContext.compilationResult.qualifiedReferences = qualifiedRefs;
        size = this.simpleNameReferences.size;
        char[][] simpleRefs = new char[size][];
        int i3 = 0;
        while (i3 < size) {
            simpleRefs[i3] = this.simpleNameReferences.elementAt(i3);
            ++i3;
        }
        this.referenceContext.compilationResult.simpleNameReferences = simpleRefs;
    }

    public String toString() {
        return "--- CompilationUnit Scope : " + new String(this.referenceContext.getFileName());
    }

    public void verifyMethods(MethodVerifier verifier) {
        int i = 0;
        int length = this.topLevelTypes.length;
        while (i < length) {
            this.topLevelTypes[i].verifyMethods(verifier);
            ++i;
        }
    }
}

