/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.lookup;

import net.sourceforge.phpdt.internal.compiler.ast.AbstractMethodDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.ConstructorDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.QualifiedNameReference;
import net.sourceforge.phpdt.internal.compiler.ast.SingleNameReference;
import net.sourceforge.phpdt.internal.compiler.ast.TypeDeclaration;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.flow.UnconditionalFlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.ReferenceContext;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.ClassScope;
import net.sourceforge.phpdt.internal.compiler.lookup.FieldBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.InvocationSite;
import net.sourceforge.phpdt.internal.compiler.lookup.LocalVariableBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.ProblemFieldBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.SourceTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.SyntheticArgumentBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;
import net.sourceforge.phpdt.internal.compiler.problem.ProblemReporter;

public class MethodScope
extends BlockScope {
    public ReferenceContext referenceContext;
    public boolean isStatic;
    public static final int NotInFieldDecl = -1;
    public boolean isConstructorCall = false;
    public FieldBinding initializedField;
    public int fieldDeclarationIndex = -1;
    public int analysisIndex;
    public boolean isPropagatingInnerClassEmulation;
    public int lastIndex = 0;
    public long[] definiteInits = new long[4];
    public long[][] extraDefiniteInits = new long[4][];
    public SyntheticArgumentBinding[] extraSyntheticArguments;

    public MethodScope(ClassScope parent, ReferenceContext context, boolean isStatic) {
        super(2, parent);
        this.locals = new LocalVariableBinding[5];
        this.referenceContext = context;
        this.isStatic = isStatic;
        this.startIndex = 0;
    }

    private void checkAndSetModifiersForConstructor(MethodBinding methodBinding) {
        int accessorBits;
        int unexpectedModifiers;
        int realModifiers;
        int modifiers = methodBinding.modifiers;
        if ((modifiers & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForMethod(methodBinding.declaringClass, (AbstractMethodDeclaration)this.referenceContext);
        }
        if (((ConstructorDeclaration)this.referenceContext).isDefaultConstructor) {
            if (methodBinding.declaringClass.isPublic()) {
                modifiers |= 1;
            } else if (methodBinding.declaringClass.isProtected()) {
                modifiers |= 4;
            }
        }
        if (((realModifiers = modifiers & 0xFFFF) & (unexpectedModifiers = -8)) != 0) {
            this.problemReporter().illegalModifierForMethod(methodBinding.declaringClass, (AbstractMethodDeclaration)this.referenceContext);
        }
        if (((accessorBits = realModifiers & 7) & accessorBits - 1) != 0) {
            this.problemReporter().illegalVisibilityModifierCombinationForMethod(methodBinding.declaringClass, (AbstractMethodDeclaration)this.referenceContext);
            if ((accessorBits & 1) != 0) {
                if ((accessorBits & 4) != 0) {
                    modifiers ^= 4;
                }
                if ((accessorBits & 2) != 0) {
                    modifiers ^= 2;
                }
            }
            if ((accessorBits & 4) != 0 && (accessorBits & 2) != 0) {
                modifiers ^= 2;
            }
        }
        if (methodBinding.declaringClass.isPrivate() && (modifiers & 2) != 0) {
            modifiers ^= 2;
        }
        methodBinding.modifiers = modifiers;
    }

    private void checkAndSetModifiersForMethod(MethodBinding methodBinding) {
        int accessorBits;
        int modifiers = methodBinding.modifiers;
        if ((modifiers & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForMethod(methodBinding.declaringClass, (AbstractMethodDeclaration)this.referenceContext);
        }
        int realModifiers = modifiers & 0xFFFF;
        if (methodBinding.declaringClass.isInterface()) {
            if ((realModifiers & 0xFFFFFBFE) != 0) {
                this.problemReporter().illegalModifierForInterfaceMethod(methodBinding.declaringClass, (AbstractMethodDeclaration)this.referenceContext);
            }
            return;
        }
        int unexpectedModifiers = -1056;
        if ((realModifiers & unexpectedModifiers) != 0) {
            this.problemReporter().illegalModifierForMethod(methodBinding.declaringClass, (AbstractMethodDeclaration)this.referenceContext);
        }
        if (((accessorBits = realModifiers & 7) & accessorBits - 1) != 0) {
            this.problemReporter().illegalVisibilityModifierCombinationForMethod(methodBinding.declaringClass, (AbstractMethodDeclaration)this.referenceContext);
            if ((accessorBits & 1) != 0) {
                if ((accessorBits & 4) != 0) {
                    modifiers ^= 4;
                }
                if ((accessorBits & 2) != 0) {
                    modifiers ^= 2;
                }
            }
            if ((accessorBits & 4) != 0 && (accessorBits & 2) != 0) {
                modifiers ^= 2;
            }
        }
        if ((modifiers & 0x400) != 0) {
            int incompatibleWithAbstract = 26;
            if ((modifiers & incompatibleWithAbstract) != 0) {
                this.problemReporter().illegalAbstractModifierCombinationForMethod(methodBinding.declaringClass, (AbstractMethodDeclaration)this.referenceContext);
            }
            if (!methodBinding.declaringClass.isAbstract()) {
                this.problemReporter().abstractMethodInAbstractClass((SourceTypeBinding)methodBinding.declaringClass, (AbstractMethodDeclaration)this.referenceContext);
            }
        }
        if ((realModifiers & 8) != 0 && methodBinding.declaringClass.isNestedType() && !methodBinding.declaringClass.isStatic()) {
            this.problemReporter().unexpectedStaticModifierForMethod(methodBinding.declaringClass, (AbstractMethodDeclaration)this.referenceContext);
        }
        methodBinding.modifiers = modifiers;
    }

    MethodBinding createMethod(AbstractMethodDeclaration method) {
        this.referenceContext = method;
        method.scope = this;
        SourceTypeBinding declaringClass = this.referenceType().binding;
        int modifiers = method.modifiers | 0x2000000;
        if (method.isConstructor()) {
            method.binding = new MethodBinding(modifiers, null, null, declaringClass);
            this.checkAndSetModifiersForConstructor(method.binding);
        } else {
            if (declaringClass.isInterface()) {
                modifiers |= 0x401;
            }
            method.binding = new MethodBinding(modifiers, method.selector, null, null, null, declaringClass);
            this.checkAndSetModifiersForMethod(method.binding);
        }
        this.isStatic = method.binding.isStatic();
        return method.binding;
    }

    public FieldBinding findField(TypeBinding receiverType, char[] fieldName, InvocationSite invocationSite) {
        FieldBinding field = super.findField(receiverType, fieldName, invocationSite);
        if (field == null) {
            return null;
        }
        if (!field.isValidBinding()) {
            return field;
        }
        if (field.isStatic()) {
            return field;
        }
        if (!this.isConstructorCall || receiverType != this.enclosingSourceType()) {
            return field;
        }
        if (invocationSite instanceof SingleNameReference) {
            return new ProblemFieldBinding(field.declaringClass, fieldName, 6);
        }
        if (invocationSite instanceof QualifiedNameReference) {
            QualifiedNameReference name = (QualifiedNameReference)invocationSite;
            if (name.binding == null) {
                return new ProblemFieldBinding(field.declaringClass, fieldName, 6);
            }
        }
        return field;
    }

    public boolean isInsideInitializer() {
        return this.referenceContext instanceof TypeDeclaration;
    }

    public boolean isInsideInitializerOrConstructor() {
        return this.referenceContext instanceof TypeDeclaration || this.referenceContext instanceof ConstructorDeclaration;
    }

    public ProblemReporter problemReporter() {
        MethodScope outerMethodScope = this.outerMostMethodScope();
        if (outerMethodScope == this) {
            ProblemReporter problemReporter = this.referenceCompilationUnit().problemReporter;
            problemReporter.referenceContext = this.referenceContext;
            return problemReporter;
        }
        return outerMethodScope.problemReporter();
    }

    public final int recordInitializationStates(FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return -1;
        }
        UnconditionalFlowInfo unconditionalFlowInfo = flowInfo.unconditionalInits();
        long[] extraInits = unconditionalFlowInfo.extraDefiniteInits;
        long inits = unconditionalFlowInfo.definiteInits;
        int i = this.lastIndex;
        block0: while (--i >= 0) {
            if (this.definiteInits[i] != inits) continue;
            long[] otherInits = this.extraDefiniteInits[i];
            if (extraInits != null && otherInits != null) {
                if (extraInits.length != otherInits.length) continue;
                int j = 0;
                int max = extraInits.length;
                while (j < max) {
                    if (extraInits[j] != otherInits[j]) continue block0;
                    ++j;
                }
                return i;
            }
            if (extraInits != null || otherInits != null) continue;
            return i;
        }
        if (this.definiteInits.length == this.lastIndex) {
            this.definiteInits = new long[this.lastIndex + 20];
            System.arraycopy(this.definiteInits, 0, this.definiteInits, 0, this.lastIndex);
            this.extraDefiniteInits = new long[this.lastIndex + 20][];
            System.arraycopy(this.extraDefiniteInits, 0, this.extraDefiniteInits, 0, this.lastIndex);
        }
        this.definiteInits[this.lastIndex] = inits;
        if (extraInits != null) {
            this.extraDefiniteInits[this.lastIndex] = new long[extraInits.length];
            System.arraycopy(extraInits, 0, this.extraDefiniteInits[this.lastIndex], 0, extraInits.length);
        }
        return this.lastIndex++;
    }

    public TypeDeclaration referenceType() {
        return ((ClassScope)this.parent).referenceContext;
    }

    String basicToString(int tab) {
        String newLine = "\n";
        int i = tab;
        while (--i >= 0) {
            newLine = String.valueOf(newLine) + "\t";
        }
        String s = String.valueOf(newLine) + "--- Method Scope ---";
        newLine = String.valueOf(newLine) + "\t";
        s = String.valueOf(s) + newLine + "locals:";
        int i2 = 0;
        while (i2 < this.localIndex) {
            s = String.valueOf(s) + newLine + "\t" + this.locals[i2].toString();
            ++i2;
        }
        s = String.valueOf(s) + newLine + "startIndex = " + this.startIndex;
        s = String.valueOf(s) + newLine + "isConstructorCall = " + this.isConstructorCall;
        s = String.valueOf(s) + newLine + "initializedField = " + this.initializedField;
        s = String.valueOf(s) + newLine + "fieldDeclarationIndex = " + this.fieldDeclarationIndex;
        s = String.valueOf(s) + newLine + "referenceContext = " + this.referenceContext;
        return s;
    }
}

