/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.util.Locale;
import java.util.Map;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.IPackageFragment;
import net.sourceforge.phpdt.core.IProblemRequestor;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.WorkingCopyOwner;
import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.core.compiler.IProblem;
import net.sourceforge.phpdt.internal.compiler.CompilationResult;
import net.sourceforge.phpdt.internal.compiler.Compiler;
import net.sourceforge.phpdt.internal.compiler.DefaultErrorHandlingPolicies;
import net.sourceforge.phpdt.internal.compiler.ICompilerRequestor;
import net.sourceforge.phpdt.internal.compiler.IErrorHandlingPolicy;
import net.sourceforge.phpdt.internal.compiler.IProblemFactory;
import net.sourceforge.phpdt.internal.compiler.ast.CompilationUnitDeclaration;
import net.sourceforge.phpdt.internal.compiler.env.INameEnvironment;
import net.sourceforge.phpdt.internal.compiler.env.ISourceType;
import net.sourceforge.phpdt.internal.compiler.lookup.PackageBinding;
import net.sourceforge.phpdt.internal.compiler.parser.SourceTypeConverter;
import net.sourceforge.phpdt.internal.compiler.parser.UnitParser;
import net.sourceforge.phpdt.internal.compiler.problem.AbortCompilation;
import net.sourceforge.phpdt.internal.compiler.problem.DefaultProblemFactory;
import net.sourceforge.phpdt.internal.core.BasicCompilationUnit;
import net.sourceforge.phpdt.internal.core.JavaModelManager;
import net.sourceforge.phpdt.internal.core.JavaProject;
import net.sourceforge.phpdt.internal.core.SearchableEnvironment;
import net.sourceforge.phpdt.internal.core.util.Util;
import org.eclipse.core.runtime.IProgressMonitor;

public class CompilationUnitProblemFinder
extends Compiler {
    protected CompilationUnitProblemFinder(INameEnvironment environment, IErrorHandlingPolicy policy, Map settings, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        super(environment, policy, settings, requestor, problemFactory, true);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        CompilationResult result = new CompilationResult(sourceTypes[0].getFileName(), 1, 1, 10);
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, true, true, true, this.lookupEnvironment.problemReporter, result);
        if (unit != null) {
            this.lookupEnvironment.buildTypeBindings(unit);
            this.lookupEnvironment.completeTypeBindings(unit, true);
        }
    }

    protected static IErrorHandlingPolicy getHandlingPolicy() {
        return DefaultErrorHandlingPolicies.proceedWithAllProblems();
    }

    protected static INameEnvironment getNameEnvironment(ICompilationUnit sourceUnit) throws JavaModelException {
        return (SearchableEnvironment)((JavaProject)sourceUnit.getJavaProject()).getSearchableNameEnvironment();
    }

    protected static ICompilerRequestor getRequestor() {
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
            }
        };
    }

    protected static IProblemFactory getProblemFactory(final char[] fileName, final IProblemRequestor problemRequestor, final IProgressMonitor monitor) {
        return new DefaultProblemFactory(Locale.getDefault()){

            public IProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new AbortCompilation(true, null);
                }
                IProblem problem = super.createProblem(originatingFileName, problemId, problemArguments, messageArguments, severity, startPosition, endPosition, lineNumber);
                if (CharOperation.equals(originatingFileName, fileName)) {
                    if (JavaModelManager.VERBOSE) {
                        System.out.println("PROBLEM FOUND while reconciling : " + problem.getMessage());
                    }
                    problemRequestor.acceptProblem(problem);
                }
                if (monitor != null && monitor.isCanceled()) {
                    throw new AbortCompilation(true, null);
                }
                return problem;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompilationUnitDeclaration process(CompilationUnitDeclaration unit, ICompilationUnit unitElement, char[] contents, UnitParser parser, WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, IProblemFactory problemFactory, boolean cleanupCU, IProgressMonitor monitor) throws JavaModelException {
        char[] fileName = unitElement.getElementName().toCharArray();
        JavaProject project = (JavaProject)unitElement.getJavaProject();
        CompilationUnitProblemFinder problemFinder = new CompilationUnitProblemFinder(project.newSearchableNameEnvironment(workingCopyOwner), CompilationUnitProblemFinder.getHandlingPolicy(), project.getOptions(true), CompilationUnitProblemFinder.getRequestor(), problemFactory);
        if (parser != null) {
            problemFinder.parser = parser;
        }
        try {
            CompilationUnitDeclaration compilationUnitDeclaration;
            block9: {
                try {
                    IPackageFragment packageFragment = (IPackageFragment)unitElement.getAncestor(4);
                    char[][] expectedPackageName = null;
                    if (packageFragment != null) {
                        expectedPackageName = CharOperation.splitOn('.', packageFragment.getElementName().toCharArray());
                    }
                    if (unit == null) {
                        unit = problemFinder.resolve(new BasicCompilationUnit(contents, expectedPackageName, new String(fileName), unitElement), true, true);
                    } else {
                        problemFinder.resolve(unit, null, true, true);
                    }
                    CompilationUnitProblemFinder.reportProblems(unit, problemRequestor, monitor);
                    compilationUnitDeclaration = unit;
                    Object var14_16 = null;
                    if (!cleanupCU || unit == null) break block9;
                }
                catch (RuntimeException e) {
                    Util.log(e, "Exception occurred during problem detection: ");
                    throw new JavaModelException(e, 1005);
                }
                unit.cleanUp();
            }
            problemFinder.lookupEnvironment.reset();
            return compilationUnitDeclaration;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (cleanupCU && unit != null) {
                unit.cleanUp();
            }
            problemFinder.lookupEnvironment.reset();
            throw throwable;
        }
    }

    public static CompilationUnitDeclaration process(ICompilationUnit unitElement, char[] contents, WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, boolean cleanupCU, IProgressMonitor monitor) throws JavaModelException {
        return CompilationUnitProblemFinder.process(null, unitElement, contents, null, workingCopyOwner, problemRequestor, new DefaultProblemFactory(), cleanupCU, monitor);
    }

    public static CompilationUnitDeclaration process(ICompilationUnit unitElement, IProblemRequestor problemRequestor, IProgressMonitor monitor) throws JavaModelException {
        char[] fileName = unitElement.getElementName().toCharArray();
        IJavaProject project = unitElement.getJavaProject();
        CompilationUnitProblemFinder problemFinder = new CompilationUnitProblemFinder(CompilationUnitProblemFinder.getNameEnvironment(unitElement), CompilationUnitProblemFinder.getHandlingPolicy(), project.getOptions(true), CompilationUnitProblemFinder.getRequestor(), CompilationUnitProblemFinder.getProblemFactory(fileName, problemRequestor, monitor));
        CompilationUnitDeclaration unit = null;
        try {
            String encoding = project.getOption("net.sourceforge.phpeclipse.encoding", true);
            IPackageFragment packageFragment = (IPackageFragment)unitElement.getAncestor(4);
            char[][] expectedPackageName = null;
            if (packageFragment != null) {
                expectedPackageName = CharOperation.splitOn('.', packageFragment.getElementName().toCharArray());
            }
            CompilationUnitDeclaration compilationUnitDeclaration = unit = problemFinder.resolve(new BasicCompilationUnit(unitElement.getSource().toCharArray(), expectedPackageName, new String(fileName), encoding), true, true);
            Object var10_11 = null;
            if (unit != null) {
                unit.cleanUp();
            }
            problemFinder.lookupEnvironment.reset();
            return compilationUnitDeclaration;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (unit != null) {
                unit.cleanUp();
            }
            problemFinder.lookupEnvironment.reset();
            throw throwable;
        }
    }

    private static void reportProblems(CompilationUnitDeclaration unit, IProblemRequestor problemRequestor, IProgressMonitor monitor) {
        CompilationResult unitResult = unit.compilationResult;
        IProblem[] problems = unitResult.getAllProblems();
        int i = 0;
        int problemLength = problems == null ? 0 : problems.length;
        while (i < problemLength) {
            if (JavaModelManager.VERBOSE) {
                System.out.println("PROBLEM FOUND while reconciling : " + problems[i].getMessage());
            }
            if (monitor != null && monitor.isCanceled()) break;
            problemRequestor.acceptProblem(problems[i]);
            ++i;
        }
    }
}

