/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.phpdt.core.IBuffer;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IRegion;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.core.jdom.DOMFactory;
import net.sourceforge.phpdt.core.jdom.IDOMCompilationUnit;
import net.sourceforge.phpdt.internal.core.JavaElement;
import net.sourceforge.phpdt.internal.core.JavaElementDelta;
import net.sourceforge.phpdt.internal.core.JavaModelStatus;
import net.sourceforge.phpdt.internal.core.MultiOperation;
import net.sourceforge.phpdt.internal.core.Region;
import net.sourceforge.phpdt.internal.core.jdom.DOMNode;
import net.sourceforge.phpdt.internal.core.util.Util;
import net.sourceforge.phpdt.internal.corext.Assert;

public class DeleteElementsOperation
extends MultiOperation {
    protected Map fChildrenToRemove;
    protected DOMFactory fFactory = new DOMFactory();

    public DeleteElementsOperation(IJavaElement[] elementsToDelete, boolean force) {
        super(elementsToDelete, force);
    }

    protected String getMainTaskName() {
        return Util.bind("operation.deleteElementProgress");
    }

    protected void groupElements() throws JavaModelException {
        this.fChildrenToRemove = new HashMap(1);
        int uniqueCUs = 0;
        int i = 0;
        int length = this.fElementsToProcess.length;
        while (i < length) {
            IJavaElement e = this.fElementsToProcess[i];
            ICompilationUnit cu = this.getCompilationUnitFor(e);
            if (cu == null) {
                throw new JavaModelException(new JavaModelStatus(976, e));
            }
            IRegion region = (IRegion)this.fChildrenToRemove.get(cu);
            if (region == null) {
                region = new Region();
                this.fChildrenToRemove.put(cu, region);
                ++uniqueCUs;
            }
            region.add(e);
            ++i;
        }
        this.fElementsToProcess = new IJavaElement[uniqueCUs];
        Iterator iter = this.fChildrenToRemove.keySet().iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            this.fElementsToProcess[i2++] = (IJavaElement)iter.next();
        }
    }

    protected void processElement(IJavaElement element) throws JavaModelException {
        ICompilationUnit cu = (ICompilationUnit)element;
        IBuffer buffer = cu.getBuffer();
        if (buffer == null) {
            return;
        }
        JavaElementDelta delta = new JavaElementDelta(cu);
        IJavaElement[] cuElements = ((IRegion)this.fChildrenToRemove.get(cu)).getElements();
        int i = 0;
        int length = cuElements.length;
        while (i < length) {
            char[] contents;
            IJavaElement e = cuElements[i];
            if (e.exists() && (contents = buffer.getCharacters()) != null) {
                IDOMCompilationUnit cuDOM = this.fFactory.createCompilationUnit(contents, cu.getElementName());
                DOMNode node = (DOMNode)((JavaElement)e).findNode(cuDOM);
                if (node == null) {
                    Assert.isTrue(false, "Failed to locate " + e.getElementName() + " in " + cuDOM.getName());
                }
                int startPosition = node.getStartPosition();
                buffer.replace(startPosition, node.getEndPosition() - startPosition + 1, CharOperation.NO_CHAR);
                delta.removed(e);
            }
            ++i;
        }
        if (delta.getAffectedChildren().length > 0) {
            cu.save(this.getSubProgressMonitor(1), this.force);
            if (!cu.isWorkingCopy()) {
                this.addDelta(delta);
                this.setAttribute("hasModifiedResource", "true");
            }
        }
    }

    protected void processElements() throws JavaModelException {
        this.groupElements();
        super.processElements();
    }

    protected void verify(IJavaElement element) throws JavaModelException {
        IJavaElement[] children = ((IRegion)this.fChildrenToRemove.get(element)).getElements();
        int i = 0;
        while (i < children.length) {
            IJavaElement child = children[i];
            if (child.getCorrespondingResource() != null) {
                this.error(967, child);
            }
            if (child.isReadOnly()) {
                this.error(976, child);
            }
            ++i;
        }
    }
}

