/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IOpenable;
import net.sourceforge.phpdt.core.IPackageFragment;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.core.JavaModelStatus;
import net.sourceforge.phpdt.internal.core.MultiOperation;
import net.sourceforge.phpdt.internal.core.util.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class DeleteResourceElementsOperation
extends MultiOperation {
    protected DeleteResourceElementsOperation(IJavaElement[] elementsToProcess, boolean force) {
        super(elementsToProcess, force);
    }

    private void deletePackageFragment(IPackageFragment frag) throws JavaModelException {
        IResource res = frag.getResource();
        if (res != null && res.getType() == 2) {
            IResource fragResource;
            IResource[] remainingFiles;
            IJavaElement[] childrenOfInterest = frag.getChildren();
            if (childrenOfInterest.length > 0) {
                IResource[] resources = new IResource[childrenOfInterest.length];
                int i = 0;
                while (i < childrenOfInterest.length) {
                    resources[i] = childrenOfInterest[i].getCorrespondingResource();
                    ++i;
                }
                this.deleteResources(resources, this.force);
            }
            try {
                remainingFiles = ((IFolder)res).members();
            }
            catch (CoreException ce) {
                throw new JavaModelException(ce);
            }
            boolean isEmpty = true;
            int i = 0;
            int length = remainingFiles.length;
            while (i < length) {
                IResource file = remainingFiles[i];
                if (file instanceof IFile) {
                    this.deleteResource(file, 3);
                } else {
                    isEmpty = false;
                }
                ++i;
            }
            if (isEmpty && (fragResource = frag.getResource()) != null) {
                this.deleteEmptyPackageFragment(frag, false, (IResource)fragResource.getParent());
            }
        }
    }

    protected String getMainTaskName() {
        return Util.bind("operation.deleteResourceProgress");
    }

    protected void processElement(IJavaElement element) throws JavaModelException {
        switch (element.getElementType()) {
            case 5: 
            case 6: {
                this.deleteResource(element.getResource(), this.force ? 3 : 2);
                break;
            }
            case 4: {
                this.deletePackageFragment((IPackageFragment)element);
                break;
            }
            default: {
                throw new JavaModelException(new JavaModelStatus(967, element));
            }
        }
        if (element instanceof IOpenable) {
            ((IOpenable)((Object)element)).close();
        }
    }

    protected void verify(IJavaElement element) throws JavaModelException {
        IResource resource;
        int type;
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if ((type = element.getElementType()) <= 3 || type > 5) {
            this.error(967, element);
        }
        if ((resource = element.getResource()) instanceof IFolder && resource.isLinked()) {
            this.error(995, element);
        }
    }
}

