/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.phpdt.core.ElementChangedEvent;
import net.sourceforge.phpdt.core.IClasspathEntry;
import net.sourceforge.phpdt.core.IElementChangedListener;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaElementDelta;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.core.ClasspathEntry;
import net.sourceforge.phpdt.internal.core.DeltaProcessingState;
import net.sourceforge.phpdt.internal.core.JavaElementDelta;
import net.sourceforge.phpdt.internal.core.JavaElementInfo;
import net.sourceforge.phpdt.internal.core.JavaModel;
import net.sourceforge.phpdt.internal.core.JavaModelInfo;
import net.sourceforge.phpdt.internal.core.JavaModelManager;
import net.sourceforge.phpdt.internal.core.JavaProject;
import net.sourceforge.phpdt.internal.core.JavaProjectElementInfo;
import net.sourceforge.phpdt.internal.core.Openable;
import net.sourceforge.phpdt.internal.core.PackageFragmentInfo;
import net.sourceforge.phpdt.internal.core.PackageFragmentRoot;
import net.sourceforge.phpdt.internal.core.PackageFragmentRootInfo;
import net.sourceforge.phpdt.internal.core.util.Util;
import net.sourceforge.phpdt.internal.ui.util.PHPFileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;

public class DeltaProcessor
implements IResourceChangeListener {
    static final int IGNORE = 0;
    static final int SOURCE = 1;
    static final int BINARY = 2;
    static final String EXTERNAL_JAR_ADDED = "external jar added";
    static final String EXTERNAL_JAR_REMOVED = "external jar removed";
    static final String EXTERNAL_JAR_CHANGED = "external jar changed";
    static final String EXTERNAL_JAR_UNCHANGED = "external jar unchanged";
    static final String INTERNAL_JAR_IGNORE = "internal jar ignore";
    private static final int NON_JAVA_RESOURCE = -1;
    public static boolean DEBUG = false;
    public static boolean VERBOSE = false;
    public static final int DEFAULT_CHANGE_EVENT = 0;
    protected JavaElementDelta currentDelta;
    public Map roots;
    Map otherRoots;
    public boolean rootsAreStale = true;
    public Map oldRoots;
    Map oldOtherRoots;
    Map sourceAttachments;
    Openable currentElement;
    public ArrayList javaModelDeltas = new ArrayList();
    public HashMap reconcileDeltas = new HashMap();
    private boolean isFiring = true;
    public HashMap externalTimeStamps = new HashMap();
    public HashSet projectsToUpdate = new HashSet();
    public HashSet projectsForDependentNamelookupRefresh = new HashSet();
    private DeltaProcessingState state;
    private JavaModelManager manager;
    Map removedRoots;
    HashSet refreshedElements;
    public int overridenEventType = -1;

    public DeltaProcessor(DeltaProcessingState state, JavaModelManager manager) {
        this.state = state;
        this.manager = manager;
    }

    public void addForRefresh(IJavaElement element) {
        if (this.refreshedElements == null) {
            this.refreshedElements = new HashSet();
        }
        this.refreshedElements.add(element);
    }

    void addToProjectsToUpdateWithDependents(IProject project) {
        this.projectsToUpdate.add(JavaCore.create(project));
    }

    protected void addToParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                JavaElementInfo info = (JavaElementInfo)parent.getElementInfo();
                info.addChild(child);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    JavaElementDelta currentDelta() {
        if (this.currentDelta == null) {
            this.currentDelta = new JavaElementDelta(this.manager.getJavaModel());
        }
        return this.currentDelta;
    }

    public static long getTimeStamp(File file) {
        return file.lastModified() + file.length();
    }

    public void initializeRoots() {
        IJavaProject[] projects;
        this.oldRoots = this.roots == null ? new HashMap() : this.roots;
        Map map = this.oldOtherRoots = this.otherRoots == null ? new HashMap() : this.otherRoots;
        if (!this.rootsAreStale) {
            return;
        }
        this.roots = new HashMap();
        this.otherRoots = new HashMap();
        this.sourceAttachments = new HashMap();
        JavaModel model = this.manager.getJavaModel();
        try {
            projects = model.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        int i = 0;
        int length = projects.length;
        while (i < length) {
            block15: {
                IClasspathEntry[] classpath;
                IJavaProject project = projects[i];
                try {
                    classpath = project.getResolvedClasspath(true);
                }
                catch (JavaModelException javaModelException) {
                    break block15;
                }
                int j = 0;
                int classpathLength = classpath.length;
                while (j < classpathLength) {
                    block16: {
                        IClasspathEntry entry = classpath[j];
                        if (entry.getEntryKind() != 2) {
                            IPath path = entry.getPath();
                            if (this.roots.get(path) == null) {
                                this.roots.put(path, new RootInfo(project, path, ((ClasspathEntry)entry).fullExclusionPatternChars()));
                            } else {
                                ArrayList<RootInfo> rootList = (ArrayList<RootInfo>)this.otherRoots.get(path);
                                if (rootList == null) {
                                    rootList = new ArrayList<RootInfo>();
                                    this.otherRoots.put(path, rootList);
                                }
                                rootList.add(new RootInfo(project, path, ((ClasspathEntry)entry).fullExclusionPatternChars()));
                            }
                            if (entry.getEntryKind() == 1) {
                                QualifiedName qName = new QualifiedName("net.sourceforge.phpeclipse", "sourceattachment: " + path.toOSString());
                                try {
                                    ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(qName);
                                }
                                catch (CoreException coreException) {
                                    break block16;
                                }
                                IPath sourceAttachmentPath = entry.getSourceAttachmentPath();
                                if (sourceAttachmentPath != null) {
                                    this.sourceAttachments.put(sourceAttachmentPath, path);
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.rootsAreStale = false;
    }

    public boolean isAffectedBy(IResourceDelta rootDelta) {
        if (rootDelta != null) {
            private class FoundRelevantDeltaException
            extends RuntimeException {
                FoundRelevantDeltaException() {
                }
            }
            try {
                rootDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        switch (delta.getKind()) {
                            case 1: 
                            case 2: {
                                throw new FoundRelevantDeltaException();
                            }
                            case 4: {
                                if (delta.getAffectedChildren().length != 0 || (delta.getFlags() & 0xFFFCFFFF) == 0) break;
                                throw new FoundRelevantDeltaException();
                            }
                        }
                        return true;
                    }
                });
            }
            catch (FoundRelevantDeltaException foundRelevantDeltaException) {
                return true;
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    private boolean isResFilteredFromOutput(OutputsInfo info, IResource res, int elementType) {
        if (info != null) {
            IPath resPath = res.getFullPath();
            int i = 0;
            while (i < info.outputCount) {
                if (info.paths[i].isPrefixOf(resPath)) {
                    if (info.traverseModes[i] != 0) {
                        if (info.traverseModes[i] == 1 && elementType == 6) {
                            return true;
                        }
                        if (elementType == 2 && res instanceof IFile && PHPFileUtil.isPHPFile((IFile)res)) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private IJavaElementDelta mergeDeltas(Collection deltas) {
        if (deltas.size() == 0) {
            return null;
        }
        if (deltas.size() == 1) {
            return (IJavaElementDelta)deltas.iterator().next();
        }
        if (VERBOSE) {
            System.out.println("MERGING " + deltas.size() + " DELTAS [" + Thread.currentThread() + "]");
        }
        Iterator iterator = deltas.iterator();
        JavaElementDelta rootDelta = new JavaElementDelta(this.manager.javaModel);
        boolean insertedTree = false;
        while (iterator.hasNext()) {
            IJavaElement element;
            JavaElementDelta delta = (JavaElementDelta)iterator.next();
            if (VERBOSE) {
                System.out.println(delta.toString());
            }
            if (this.manager.javaModel.equals(element = delta.getElement())) {
                IJavaElementDelta[] children = delta.getAffectedChildren();
                int j = 0;
                while (j < children.length) {
                    JavaElementDelta projectDelta = (JavaElementDelta)children[j];
                    rootDelta.insertDeltaTree(projectDelta.getElement(), projectDelta);
                    insertedTree = true;
                    ++j;
                }
                IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
                if (resourceDeltas == null) continue;
                int i = 0;
                int length = resourceDeltas.length;
                while (i < length) {
                    rootDelta.addResourceDelta(resourceDeltas[i]);
                    insertedTree = true;
                    ++i;
                }
                continue;
            }
            rootDelta.insertDeltaTree(element, delta);
            insertedTree = true;
        }
        if (insertedTree) {
            return rootDelta;
        }
        return null;
    }

    public void registerJavaModelDelta(IJavaElementDelta delta) {
        this.javaModelDeltas.add(delta);
    }

    protected void removeFromParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                JavaElementInfo info = (JavaElementInfo)parent.getElementInfo();
                info.removeChild(child);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    /*
     * Exception decompiling
     */
    public void resourceChanged(IResourceChangeEvent event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 181->184)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void startDeltas() {
        this.isFiring = true;
    }

    private void stopDeltas() {
        this.isFiring = false;
    }

    private void deleting(IProject project) {
        try {
            JavaProject javaProject = (JavaProject)JavaCore.create(project);
            if (this.removedRoots == null) {
                this.removedRoots = new HashMap();
            }
            if (javaProject.isOpen()) {
                this.removedRoots.put(javaProject, javaProject.getPackageFragmentRoots());
            }
            javaProject.close();
            if (this.state.modelProjectsCache == null) {
                this.state.modelProjectsCache = this.manager.getJavaModel().getJavaProjects();
            }
            this.removeFromParentInfo(javaProject);
        }
        catch (JavaModelException javaModelException) {}
    }

    private IJavaElementDelta processResourceDelta(IResourceDelta changes) {
        JavaModel model;
        block10: {
            model = this.manager.getJavaModel();
            if (model.isOpen()) break block10;
            try {
                model.open(null);
            }
            catch (JavaModelException e) {
                if (VERBOSE) {
                    e.printStackTrace();
                }
                IJavaElementDelta iJavaElementDelta = null;
                Object var11_7 = null;
                this.currentDelta = null;
                return iJavaElementDelta;
            }
        }
        try {
            this.state.initializeRoots();
            this.currentElement = null;
            IResourceDelta[] deltas = changes.getAffectedChildren();
            int i = 0;
            while (i < deltas.length) {
                IResourceDelta delta = deltas[i];
                IResource res = delta.getResource();
                IProject proj = (IProject)res;
                boolean wasJavaProject = this.manager.getJavaModel().findJavaProject(proj) != null;
                boolean isJavaProject = JavaProject.hasJavaNature(proj);
                int elementType = !wasJavaProject && !isJavaProject ? -1 : 2;
                if (elementType == -1 || wasJavaProject != isJavaProject && delta.getKind() == 4) {
                    try {
                        this.nonJavaResourcesChanged(model, delta);
                    }
                    catch (JavaModelException javaModelException) {}
                }
                ++i;
            }
            JavaElementDelta javaElementDelta = this.currentDelta;
            Object var11_8 = null;
            this.currentDelta = null;
            return javaElementDelta;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.currentDelta = null;
            throw throwable;
        }
    }

    private void notifyListeners(IJavaElementDelta deltaToNotify, int eventType, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        final ElementChangedEvent extraEvent = new ElementChangedEvent(deltaToNotify, eventType);
        int i = 0;
        while (i < listenerCount) {
            if ((listenerMask[i] & eventType) != 0) {
                final IElementChangedListener listener = listeners[i];
                long start = -1L;
                if (VERBOSE) {
                    System.out.print("Listener #" + (i + 1) + "=" + listener.toString());
                    start = System.currentTimeMillis();
                }
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        Util.log(exception, "Exception occurred in listener of Java element change notification");
                    }

                    public void run() throws Exception {
                        listener.elementChanged(extraEvent);
                    }
                });
                if (VERBOSE) {
                    System.out.println(" -> " + (System.currentTimeMillis() - start) + "ms");
                }
            }
            ++i;
        }
    }

    private void nonJavaResourcesChanged(Openable element, IResourceDelta delta) throws JavaModelException {
        JavaElementDelta current;
        JavaElementDelta elementDelta;
        if (element.isOpen()) {
            JavaElementInfo info = (JavaElementInfo)element.getElementInfo();
            switch (element.getElementType()) {
                case 1: {
                    ((JavaModelInfo)info).nonJavaResources = null;
                    this.currentDelta().addResourceDelta(delta);
                    return;
                }
                case 2: {
                    ((JavaProjectElementInfo)info).setNonJavaResources(null);
                    JavaProject project = (JavaProject)element;
                    PackageFragmentRoot projectRoot = (PackageFragmentRoot)project.getPackageFragmentRoot((IResource)project.getProject());
                    if (!projectRoot.isOpen()) break;
                    ((PackageFragmentRootInfo)projectRoot.getElementInfo()).setNonJavaResources(null);
                    break;
                }
                case 4: {
                    ((PackageFragmentInfo)info).setNonJavaResources(null);
                    break;
                }
                case 3: {
                    ((PackageFragmentRootInfo)info).setNonJavaResources(null);
                }
            }
        }
        if ((elementDelta = (current = this.currentDelta()).find(element)) == null) {
            elementDelta = current.changed(element, 1);
        }
        elementDelta.addResourceDelta(delta);
    }

    public void flush() {
        this.javaModelDeltas = new ArrayList();
    }

    RootInfo enclosingRootInfo(IPath path, int kind) {
        while (path != null && path.segmentCount() > 0) {
            RootInfo rootInfo = this.rootInfo(path, kind);
            if (rootInfo != null) {
                return rootInfo;
            }
            path = path.removeLastSegments(1);
        }
        return null;
    }

    public void fire(IJavaElementDelta customDelta, int eventType) {
        if (!this.isFiring) {
            return;
        }
        if (DEBUG) {
            System.out.println("-----------------------------------------------------------------------------------------------------------------------");
        }
        IJavaElementDelta deltaToNotify = customDelta == null ? this.mergeDeltas(this.javaModelDeltas) : customDelta;
        IElementChangedListener[] listeners = this.state.elementChangedListeners;
        int[] listenerMask = this.state.elementChangedListenerMasks;
        int listenerCount = this.state.elementChangedListenerCount;
        switch (eventType) {
            case 0: {
                this.firePostChangeDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                this.fireReconcileDelta(listeners, listenerMask, listenerCount);
                break;
            }
            case 1: {
                this.firePostChangeDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                this.fireReconcileDelta(listeners, listenerMask, listenerCount);
            }
        }
    }

    private void firePostChangeDelta(IJavaElementDelta deltaToNotify, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        if (DEBUG) {
            System.out.println("FIRING POST_CHANGE Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.flush();
            this.notifyListeners(deltaToNotify, 1, listeners, listenerMask, listenerCount);
        }
    }

    private void fireReconcileDelta(IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        IJavaElementDelta deltaToNotify = this.mergeDeltas(this.reconcileDeltas.values());
        if (DEBUG) {
            System.out.println("FIRING POST_RECONCILE Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.reconcileDeltas = new HashMap();
            this.notifyListeners(deltaToNotify, 4, listeners, listenerMask, listenerCount);
        }
    }

    RootInfo rootInfo(IPath path, int kind) {
        if (kind == 2) {
            return (RootInfo)this.oldRoots.get(path);
        }
        return (RootInfo)this.roots.get(path);
    }

    ArrayList otherRootsInfo(IPath path, int kind) {
        if (kind == 2) {
            return (ArrayList)this.oldOtherRoots.get(path);
        }
        return (ArrayList)this.otherRoots.get(path);
    }

    class OutputsInfo {
        IPath[] paths;
        int[] traverseModes;
        int outputCount;

        OutputsInfo(IPath[] paths, int[] traverseModes, int outputCount) {
            this.paths = paths;
            this.traverseModes = traverseModes;
            this.outputCount = outputCount;
        }

        public String toString() {
            if (this.paths == null) {
                return "<none>";
            }
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < this.outputCount) {
                buffer.append("path=");
                buffer.append(this.paths[i].toString());
                buffer.append("\n->traverse=");
                switch (this.traverseModes[i]) {
                    case 2: {
                        buffer.append("BINARY");
                        break;
                    }
                    case 0: {
                        buffer.append("IGNORE");
                        break;
                    }
                    case 1: {
                        buffer.append("SOURCE");
                        break;
                    }
                    default: {
                        buffer.append("<unknown>");
                    }
                }
                if (i + 1 < this.outputCount) {
                    buffer.append('\n');
                }
                ++i;
            }
            return buffer.toString();
        }
    }

    class RootInfo {
        IJavaProject project;
        IPath rootPath;
        char[][] exclusionPatterns;

        RootInfo(IJavaProject project, IPath rootPath, char[][] exclusionPatterns) {
            this.project = project;
            this.rootPath = rootPath;
            this.exclusionPatterns = exclusionPatterns;
        }

        boolean isRootOfProject(IPath path) {
            return this.rootPath.equals((Object)path) && this.project.getProject().getFullPath().isPrefixOf(path);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("project=");
            if (this.project == null) {
                buffer.append("null");
            } else {
                buffer.append(this.project.getElementName());
            }
            buffer.append("\npath=");
            if (this.rootPath == null) {
                buffer.append("null");
            } else {
                buffer.append(this.rootPath.toString());
            }
            buffer.append("\nexcluding=");
            if (this.exclusionPatterns == null) {
                buffer.append("null");
            } else {
                int i = 0;
                int length = this.exclusionPatterns.length;
                while (i < length) {
                    buffer.append(new String(this.exclusionPatterns[i]));
                    if (i < length - 1) {
                        buffer.append("|");
                    }
                    ++i;
                }
            }
            return buffer.toString();
        }
    }
}

