/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaModel;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.IOpenable;
import net.sourceforge.phpdt.core.IParent;
import net.sourceforge.phpdt.core.ISourceRange;
import net.sourceforge.phpdt.core.ISourceReference;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.WorkingCopyOwner;
import net.sourceforge.phpdt.core.jdom.IDOMCompilationUnit;
import net.sourceforge.phpdt.core.jdom.IDOMNode;
import net.sourceforge.phpdt.internal.core.JavaElementInfo;
import net.sourceforge.phpdt.internal.core.JavaModelManager;
import net.sourceforge.phpdt.internal.core.JavaModelOperation;
import net.sourceforge.phpdt.internal.core.JavaModelStatus;
import net.sourceforge.phpdt.internal.core.SourceRefElement;
import net.sourceforge.phpdt.internal.core.util.MementoTokenizer;
import net.sourceforge.phpdt.internal.core.util.Util;
import net.sourceforge.phpdt.internal.corext.Assert;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class JavaElement
extends PlatformObject
implements IJavaElement {
    public static final char JEM_ESCAPE = '\\';
    public static final char JEM_JAVAPROJECT = '=';
    public static final char JEM_PACKAGEFRAGMENTROOT = '/';
    public static final char JEM_PACKAGEFRAGMENT = '<';
    public static final char JEM_FIELD = '^';
    public static final char JEM_METHOD = '~';
    public static final char JEM_INITIALIZER = '|';
    public static final char JEM_COMPILATIONUNIT = '{';
    public static final char JEM_TYPE = '[';
    public static final char JEM_PACKAGEDECLARATION = '%';
    public static final char JEM_IMPORTDECLARATION = '#';
    public static final char JEM_COUNT = '!';
    public static final char JEM_LOCALVARIABLE = '@';
    protected int occurrenceCount = 1;
    protected JavaElement parent;
    protected String name;
    protected static final Object NO_INFO = new Object();

    protected JavaElement(JavaElement parent, String name) throws IllegalArgumentException {
        this.parent = parent;
        this.name = name;
    }

    public void close() throws JavaModelException {
        JavaModelManager.getJavaModelManager().removeInfoAndChildren(this);
    }

    protected abstract void closing(Object var1) throws JavaModelException;

    protected abstract Object createElementInfo();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.parent == null) {
            return super.equals(o);
        }
        if (o instanceof JavaElement) {
            JavaElement other = (JavaElement)o;
            return this.occurrenceCount == other.occurrenceCount && this.name.equals(other.name) && this.parent.equals(other.parent);
        }
        return false;
    }

    protected boolean equalsDOMNode(IDOMNode node) throws JavaModelException {
        return false;
    }

    protected void escapeMementoName(StringBuffer buffer, String mementoName) {
        int i = 0;
        int length = mementoName.length();
        while (i < length) {
            char character = mementoName.charAt(i);
            switch (character) {
                case '!': 
                case '#': 
                case '%': 
                case '/': 
                case '<': 
                case '=': 
                case '@': 
                case '[': 
                case '\\': 
                case '^': 
                case '{': 
                case '|': 
                case '~': {
                    buffer.append('\\');
                }
            }
            buffer.append(character);
            ++i;
        }
    }

    public boolean exists() {
        try {
            this.getElementInfo();
            return true;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public IDOMNode findNode(IDOMCompilationUnit dom) {
        int type = this.getElementType();
        if (type == 5 || type == 8 || type == 13 || type == 10 || type == 9 || type == 11 || type == 7) {
            ArrayList<JavaElement> path = new ArrayList<JavaElement>();
            IJavaElement element = this;
            while (element != null && element.getElementType() != 5) {
                if (element.getElementType() != 12) {
                    path.add(0, (JavaElement)element);
                }
                element = element.getParent();
            }
            if (path.size() == 0) {
                try {
                    if (this.equalsDOMNode(dom)) {
                        return dom;
                    }
                    return null;
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
            }
            return ((JavaElement)path.get(0)).followPath(path, 0, dom.getFirstChild());
        }
        return null;
    }

    protected IDOMNode followPath(ArrayList path, int position, IDOMNode node) {
        try {
            if (this.equalsDOMNode(node)) {
                if (position == path.size() - 1) {
                    return node;
                }
                if (node.getFirstChild() != null) {
                    return ((JavaElement)path.get(++position)).followPath(path, position, node.getFirstChild());
                }
                return null;
            }
            if (node.getNextNode() != null) {
                return this.followPath(path, position, node.getNextNode());
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IJavaElement getAncestor(int ancestorType) {
        IJavaElement element = this;
        while (element != null) {
            if (element.getElementType() == ancestorType) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    protected abstract void generateInfos(Object var1, HashMap var2, IProgressMonitor var3) throws JavaModelException;

    public IJavaElement[] getChildren() throws JavaModelException {
        return ((JavaElementInfo)this.getElementInfo()).getChildren();
    }

    public ArrayList getChildrenOfType(int type) throws JavaModelException {
        IJavaElement[] children = this.getChildren();
        int size = children.length;
        ArrayList<JavaElement> list = new ArrayList<JavaElement>(size);
        int i = 0;
        while (i < size) {
            JavaElement elt = (JavaElement)children[i];
            if (elt.getElementType() == type) {
                list.add(elt);
            }
            ++i;
        }
        return list;
    }

    public ICompilationUnit getCompilationUnit() {
        return null;
    }

    public Object getElementInfo() throws JavaModelException {
        return this.getElementInfo(null);
    }

    public Object getElementInfo(IProgressMonitor monitor) throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        Object info = manager.getInfo(this);
        if (info != null) {
            return info;
        }
        return this.openWhenClosed(this.createElementInfo(), monitor);
    }

    public String getElementName() {
        return this.name;
    }

    public abstract IJavaElement getHandleFromMemento(String var1, MementoTokenizer var2, WorkingCopyOwner var3);

    public IJavaElement getHandleFromMemento(MementoTokenizer memento, WorkingCopyOwner owner) {
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String token = memento.nextToken();
        return this.getHandleFromMemento(token, memento, owner);
    }

    public IJavaElement getHandleUpdatingCountFromMemento(MementoTokenizer memento, WorkingCopyOwner owner) {
        this.occurrenceCount = Integer.parseInt(memento.nextToken());
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String token = memento.nextToken();
        return this.getHandleFromMemento(token, memento, owner);
    }

    public String getHandleIdentifier() {
        return this.getHandleMemento();
    }

    public String getHandleMemento() {
        StringBuffer buff = new StringBuffer(((JavaElement)this.getParent()).getHandleMemento());
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getElementName());
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
        return buff.toString();
    }

    protected abstract char getHandleMementoDelimiter();

    public IJavaModel getJavaModel() {
        IJavaElement current = this;
        do {
            if (!(current instanceof IJavaModel)) continue;
            return (IJavaModel)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public IJavaProject getJavaProject() {
        IJavaElement current = this;
        do {
            if (!(current instanceof IJavaProject)) continue;
            return (IJavaProject)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    protected int getOccurrenceCount() {
        return this.occurrenceCount;
    }

    public IOpenable getOpenable() {
        return this.getOpenableParent();
    }

    public IOpenable getOpenableParent() {
        return (IOpenable)((Object)this.parent);
    }

    public IJavaElement getParent() {
        return this.parent;
    }

    public IJavaElement getPrimaryElement() {
        return this.getPrimaryElement(true);
    }

    public IJavaElement getPrimaryElement(boolean checkOwner) {
        return this;
    }

    protected IJavaElement getSourceElementAt(int position) throws JavaModelException {
        if (this instanceof ISourceReference) {
            IJavaElement[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                SourceRefElement child;
                ISourceRange range;
                IJavaElement aChild = children[i];
                if (aChild instanceof SourceRefElement && position < (range = (child = (SourceRefElement)children[i]).getSourceRange()).getOffset() + range.getLength() && position >= range.getOffset()) {
                    if (child instanceof IParent) {
                        return child.getSourceElementAt(position);
                    }
                    return child;
                }
                ++i;
            }
        } else {
            Assert.isTrue(false);
        }
        return this;
    }

    public ISchedulingRule getSchedulingRule() {
        IResource resource = this.getResource();
        if (resource == null) {
            private class NoResourceSchedulingRule
            implements ISchedulingRule {
                public IPath path;

                public NoResourceSchedulingRule(IPath path) {
                    this.path = path;
                }

                public boolean contains(ISchedulingRule rule) {
                    if (rule instanceof NoResourceSchedulingRule) {
                        return this.path.isPrefixOf(((NoResourceSchedulingRule)rule).path);
                    }
                    return false;
                }

                public boolean isConflicting(ISchedulingRule rule) {
                    if (rule instanceof NoResourceSchedulingRule) {
                        IPath otherPath = ((NoResourceSchedulingRule)rule).path;
                        return this.path.isPrefixOf(otherPath) || otherPath.isPrefixOf(this.path);
                    }
                    return false;
                }
            }
            return new NoResourceSchedulingRule(this.getPath());
        }
        return resource;
    }

    public boolean hasChildren() throws JavaModelException {
        Object elementInfo = JavaModelManager.getJavaModelManager().getInfo(this);
        if (elementInfo instanceof JavaElementInfo) {
            return ((JavaElementInfo)elementInfo).getChildren().length > 0;
        }
        return true;
    }

    public int hashCode() {
        if (this.parent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes(this.name.hashCode(), this.parent.hashCode());
    }

    public boolean isAncestorOf(IJavaElement e) {
        IJavaElement parentElement = e.getParent();
        while (parentElement != null && !parentElement.equals(this)) {
            parentElement = parentElement.getParent();
        }
        return parentElement != null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isStructureKnown() throws JavaModelException {
        return ((JavaElementInfo)this.getElementInfo()).isStructureKnown();
    }

    protected JavaModelException newNotPresentException() {
        return new JavaModelException(new JavaModelStatus(969, this));
    }

    protected void opening(Object info) {
    }

    /*
     * Exception decompiling
     */
    protected Object openWhenClosed(Object info, IProgressMonitor monitor) throws JavaModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 133->136)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String readableName() {
        return this.getElementName();
    }

    public static void runOperation(JavaModelOperation operation, IProgressMonitor monitor) throws JavaModelException {
        try {
            if (operation.isReadOnly() || ResourcesPlugin.getWorkspace().isTreeLocked()) {
                operation.run(monitor);
            } else {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)operation, monitor);
            }
        }
        catch (CoreException ce) {
            Throwable e;
            if (ce instanceof JavaModelException) {
                throw (JavaModelException)ce;
            }
            if (ce.getStatus().getCode() == 76 && (e = ce.getStatus().getException()) instanceof JavaModelException) {
                throw (JavaModelException)((Object)e);
            }
            throw new JavaModelException(ce);
        }
    }

    protected void setOccurrenceCount(int count) {
        this.occurrenceCount = count;
    }

    protected String tabString(int tab) {
        StringBuffer buffer = new StringBuffer();
        int i = tab;
        while (i > 0) {
            buffer.append("  ");
            --i;
        }
        return buffer.toString();
    }

    public String toDebugString() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(0, buffer);
        return buffer.toString();
    }

    protected void toStringName(StringBuffer buffer) {
        buffer.append(this.getElementName());
        if (this.occurrenceCount > 1) {
            buffer.append("#");
            buffer.append(this.occurrenceCount);
        }
    }

    protected void toString(int tab, StringBuffer buffer) {
        Object info = null;
        if (tab == 0) {
            this.toStringAncestors(buffer);
        }
        this.toStringChildren(tab, buffer, info);
    }

    public String toStringWithAncestors() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        this.toStringAncestors(buffer);
        return buffer.toString();
    }

    protected void toStringAncestors(StringBuffer buffer) {
        JavaElement parent = (JavaElement)this.getParent();
        if (parent != null && parent.getParent() != null) {
            buffer.append(" [in ");
            parent.toStringInfo(0, buffer, NO_INFO);
            parent.toStringAncestors(buffer);
            buffer.append("]");
        }
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (info == null || !(info instanceof JavaElementInfo)) {
            return;
        }
        IJavaElement[] children = ((JavaElementInfo)info).getChildren();
        int i = 0;
        while (i < children.length) {
            buffer.append("\n");
            ((JavaElement)children[i]).toString(tab + 1, buffer);
            ++i;
        }
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        buffer.append(this.getElementName());
        if (info == null) {
            buffer.append(" (not open)");
        }
    }
}

