/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.phpdt.core.IClasspathEntry;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaModelStatus;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.IPackageFragment;
import net.sourceforge.phpdt.core.IPackageFragmentRoot;
import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.WorkingCopyOwner;
import net.sourceforge.phpdt.internal.codeassist.ISearchableNameEnvironment;
import net.sourceforge.phpdt.internal.compiler.util.ObjectVector;
import net.sourceforge.phpdt.internal.core.ClasspathEntry;
import net.sourceforge.phpdt.internal.core.JavaElement;
import net.sourceforge.phpdt.internal.core.JavaModel;
import net.sourceforge.phpdt.internal.core.JavaModelManager;
import net.sourceforge.phpdt.internal.core.JavaModelStatus;
import net.sourceforge.phpdt.internal.core.JavaProjectElementInfo;
import net.sourceforge.phpdt.internal.core.NameLookup;
import net.sourceforge.phpdt.internal.core.Openable;
import net.sourceforge.phpdt.internal.core.OpenableElementInfo;
import net.sourceforge.phpdt.internal.core.PackageFragmentRoot;
import net.sourceforge.phpdt.internal.core.SearchableEnvironment;
import net.sourceforge.phpdt.internal.core.SetClasspathOperation;
import net.sourceforge.phpdt.internal.core.XMLWriter;
import net.sourceforge.phpdt.internal.core.util.MementoTokenizer;
import net.sourceforge.phpdt.internal.core.util.Util;
import net.sourceforge.phpdt.internal.corext.Assert;
import net.sourceforge.phpeclipse.LoadPathEntry;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JavaProject
extends Openable
implements IJavaProject,
IProjectNature {
    protected static final boolean IS_CASE_SENSITIVE = !new File("Temp").equals(new File("temp"));
    protected static final String[] NO_PREREQUISITES = new String[0];
    protected IProject project;
    protected List fLoadPathEntries;
    protected boolean fScratched;
    public static final String CLASSPATH_FILENAME = ".classpath";
    public static final String PREF_FILENAME = ".jprefs";
    public static final IClasspathEntry[] INVALID_CLASSPATH = new IClasspathEntry[0];
    private static final String CUSTOM_DEFAULT_OPTION_VALUE = "#\r\n\r#custom-non-empty-default-value#\r\n\r#";
    private static final IClasspathEntry[] RESOLUTION_IN_PROGRESS = new IClasspathEntry[0];

    public static IPath canonicalizedPath(IPath externalPath) {
        Path result;
        if (externalPath == null) {
            return null;
        }
        if (JavaModelManager.VERBOSE) {
            System.out.println("JAVA MODEL - Canonicalizing " + externalPath.toString());
        }
        if (IS_CASE_SENSITIVE) {
            if (JavaModelManager.VERBOSE) {
                System.out.println("JAVA MODEL - Canonical path is original path (file system is case sensitive)");
            }
            return externalPath;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return externalPath;
        }
        if (workspace.getRoot().findMember(externalPath) != null) {
            if (JavaModelManager.VERBOSE) {
                System.out.println("JAVA MODEL - Canonical path is original path (member of workspace)");
            }
            return externalPath;
        }
        Path canonicalPath = null;
        try {
            canonicalPath = new Path(new File(externalPath.toOSString()).getCanonicalPath());
        }
        catch (IOException iOException) {
            if (JavaModelManager.VERBOSE) {
                System.out.println("JAVA MODEL - Canonical path is original path (IOException)");
            }
            return externalPath;
        }
        int canonicalLength = canonicalPath.segmentCount();
        if (canonicalLength == 0) {
            if (JavaModelManager.VERBOSE) {
                System.out.println("JAVA MODEL - Canonical path is original path (canonical path is empty)");
            }
            return externalPath;
        }
        if (externalPath.isAbsolute()) {
            result = canonicalPath;
        } else {
            int externalLength = externalPath.segmentCount();
            if (canonicalLength >= externalLength) {
                result = canonicalPath.removeFirstSegments(canonicalLength - externalLength);
            } else {
                if (JavaModelManager.VERBOSE) {
                    System.out.println("JAVA MODEL - Canonical path is original path (canonical path is " + canonicalPath.toString() + ")");
                }
                return externalPath;
            }
        }
        if (externalPath.getDevice() == null) {
            result = result.setDevice(null);
        }
        if (JavaModelManager.VERBOSE) {
            System.out.println("JAVA MODEL - Canonical path is " + result.toString());
        }
        return result;
    }

    public JavaProject() {
        super(null, null);
    }

    public JavaProject(IProject project, JavaElement parent) {
        super(parent, project.getName());
        this.project = project;
    }

    public void addLoadPathEntry(IProject anotherPHPProject) {
        this.fScratched = true;
        LoadPathEntry newEntry = new LoadPathEntry(anotherPHPProject);
        this.getLoadPathEntries().add(newEntry);
    }

    public void configure() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("net.sourceforge.phpeclipse.parserbuilder")) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            ICommand command = desc.newCommand();
            command.setBuilderName("net.sourceforge.phpeclipse.parserbuilder");
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            desc.setBuildSpec(newCommands);
            this.project.setDescription(desc, null);
        }
    }

    protected void loadLoadPathEntries() {
        this.fLoadPathEntries = new ArrayList();
        IFile loadPathsFile = this.getLoadPathEntriesFile();
        XMLReader reader = null;
        try {
            reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            reader.setContentHandler(this.getLoadPathEntriesContentHandler());
            reader.parse(new InputSource(loadPathsFile.getContents()));
        }
        catch (Exception exception) {}
    }

    public List getLoadPathEntries() {
        if (this.fLoadPathEntries == null) {
            this.loadLoadPathEntries();
        }
        return this.fLoadPathEntries;
    }

    protected ContentHandler getLoadPathEntriesContentHandler() {
        return new ContentHandler(){

            public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            }

            public void endDocument() throws SAXException {
            }

            public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            }

            public void endPrefixMapping(String arg0) throws SAXException {
            }

            public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
            }

            public void processingInstruction(String arg0, String arg1) throws SAXException {
            }

            public void setDocumentLocator(Locator arg0) {
            }

            public void skippedEntity(String arg0) throws SAXException {
            }

            public void startDocument() throws SAXException {
            }

            public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
                if ("pathentry".equals(qName) && "project".equals(atts.getValue("type"))) {
                    Path referencedProjectPath = new Path(atts.getValue("path"));
                    IProject referencedProject = JavaProject.this.getProject(referencedProjectPath.lastSegment());
                    JavaProject.this.fLoadPathEntries.add(new LoadPathEntry(referencedProject));
                }
            }

            public void startPrefixMapping(String arg0, String arg1) throws SAXException {
            }
        };
    }

    protected IFile getLoadPathEntriesFile() {
        return this.project.getFile(".loadpath");
    }

    protected String getLoadPathXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><loadpath>");
        Iterator pathEntriesIterator = this.fLoadPathEntries.iterator();
        while (pathEntriesIterator.hasNext()) {
            LoadPathEntry entry = (LoadPathEntry)pathEntriesIterator.next();
            buffer.append(entry.toXML());
        }
        buffer.append("</loadpath>");
        return buffer.toString();
    }

    protected void addToBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand javaCommand = this.getJavaCommand(description);
        if (javaCommand == null) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            this.setJavaCommand(description, command);
        }
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        if (!underlyingResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.getRoot();
        return true;
    }

    protected void closing(Object info) {
        super.closing(info);
    }

    private void computeExpandedClasspath(JavaProject initialProject, boolean ignoreUnresolvedVariable, boolean generateMarkerOnError, HashSet rootIDs, ObjectVector accumulatedEntries, Map preferredClasspaths, Map preferredOutputs) throws JavaModelException {
        String projectRootId = this.rootID();
        if (rootIDs.contains(projectRootId)) {
            return;
        }
        rootIDs.add(projectRootId);
        IClasspathEntry[] preferredClasspath = preferredClasspaths != null ? (IClasspathEntry[])preferredClasspaths.get(this) : null;
        IPath preferredOutput = preferredOutputs != null ? (IPath)preferredOutputs.get(this) : null;
        IClasspathEntry[] immediateClasspath = preferredClasspath != null ? this.getResolvedClasspath(preferredClasspath, preferredOutput, ignoreUnresolvedVariable, generateMarkerOnError, null) : this.getResolvedClasspath(ignoreUnresolvedVariable, generateMarkerOnError, false);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        boolean isInitialProject = this.equals(initialProject);
        int i = 0;
        int length = immediateClasspath.length;
        while (i < length) {
            String rootID;
            ClasspathEntry entry = (ClasspathEntry)immediateClasspath[i];
            if ((isInitialProject || entry.isExported()) && !rootIDs.contains(rootID = entry.rootID())) {
                accumulatedEntries.add(entry);
                if (entry.getEntryKind() == 2) {
                    IProject projRsc;
                    IResource member = workspaceRoot.findMember(entry.getPath());
                    if (member != null && member.getType() == 4 && JavaProject.hasJavaNature(projRsc = (IProject)member)) {
                        JavaProject javaProject = (JavaProject)JavaCore.create(projRsc);
                        javaProject.computeExpandedClasspath(initialProject, ignoreUnresolvedVariable, false, rootIDs, accumulatedEntries, preferredClasspaths, preferredOutputs);
                    }
                } else {
                    rootIDs.add(rootID);
                }
            }
            ++i;
        }
    }

    public IPackageFragmentRoot[] computePackageFragmentRoots(IClasspathEntry[] resolvedClasspath, boolean retrieveExportedRoots) throws JavaModelException {
        ObjectVector accumulatedRoots = new ObjectVector();
        this.computePackageFragmentRoots(resolvedClasspath, accumulatedRoots, new HashSet(5), true, true, retrieveExportedRoots);
        Object[] rootArray = new IPackageFragmentRoot[accumulatedRoots.size()];
        accumulatedRoots.copyInto(rootArray);
        return rootArray;
    }

    public IPackageFragmentRoot[] computePackageFragmentRoots(IClasspathEntry resolvedEntry) {
        try {
            return this.computePackageFragmentRoots(new IClasspathEntry[]{resolvedEntry}, false);
        }
        catch (JavaModelException javaModelException) {
            return new IPackageFragmentRoot[0];
        }
    }

    public void computePackageFragmentRoots(IClasspathEntry resolvedEntry, ObjectVector accumulatedRoots, HashSet rootIDs, boolean insideOriginalProject, boolean checkExistency, boolean retrieveExportedRoots) throws JavaModelException {
        String rootID = ((ClasspathEntry)resolvedEntry).rootID();
        if (rootIDs.contains(rootID)) {
            return;
        }
        IPath projectPath = this.getProject().getFullPath();
        IPath entryPath = resolvedEntry.getPath();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        switch (resolvedEntry.getEntryKind()) {
            case 3: {
                if (!projectPath.isPrefixOf(entryPath)) break;
                if (checkExistency) {
                    Object target = JavaModel.getTarget((IContainer)workspaceRoot, entryPath, checkExistency);
                    if (target == null) {
                        return;
                    }
                    if (!(target instanceof IFolder) && !(target instanceof IProject)) break;
                    accumulatedRoots.add(this.getPackageFragmentRoot((IResource)target));
                    rootIDs.add(rootID);
                    break;
                }
                IPackageFragmentRoot root = this.getFolderPackageFragmentRoot(entryPath);
                if (root == null) break;
                accumulatedRoots.add(root);
                rootIDs.add(rootID);
                break;
            }
            case 1: {
                if (!insideOriginalProject && !resolvedEntry.isExported()) {
                    return;
                }
                if (checkExistency) {
                    IResource resource;
                    IPackageFragmentRoot root;
                    Object target = JavaModel.getTarget((IContainer)workspaceRoot, entryPath, checkExistency);
                    if (target == null) {
                        return;
                    }
                    if (!(target instanceof IResource) || (root = this.getPackageFragmentRoot(resource = (IResource)target)) == null) break;
                    accumulatedRoots.add(root);
                    rootIDs.add(rootID);
                    break;
                }
                IPackageFragmentRoot root = this.getPackageFragmentRoot(entryPath);
                if (root == null) break;
                accumulatedRoots.add(root);
                rootIDs.add(rootID);
                break;
            }
            case 2: {
                IProject requiredProjectRsc;
                if (!retrieveExportedRoots) {
                    return;
                }
                if (!insideOriginalProject && !resolvedEntry.isExported()) {
                    return;
                }
                IResource member = workspaceRoot.findMember(entryPath);
                if (member == null || member.getType() != 4 || !JavaProject.hasJavaNature(requiredProjectRsc = (IProject)member)) break;
                rootIDs.add(rootID);
                JavaProject requiredProject = (JavaProject)JavaCore.create(requiredProjectRsc);
                requiredProject.computePackageFragmentRoots(requiredProject.getResolvedClasspath(true), accumulatedRoots, rootIDs, false, checkExistency, retrieveExportedRoots);
            }
        }
    }

    public void computePackageFragmentRoots(IClasspathEntry[] resolvedClasspath, ObjectVector accumulatedRoots, HashSet rootIDs, boolean insideOriginalProject, boolean checkExistency, boolean retrieveExportedRoots) throws JavaModelException {
        if (insideOriginalProject) {
            rootIDs.add(this.rootID());
        }
        int i = 0;
        int length = resolvedClasspath.length;
        while (i < length) {
            this.computePackageFragmentRoots(resolvedClasspath[i], accumulatedRoots, rootIDs, insideOriginalProject, checkExistency, retrieveExportedRoots);
            ++i;
        }
    }

    public String computeSharedPropertyFileName(QualifiedName qName) {
        return String.valueOf('.') + qName.getLocalName();
    }

    public boolean contains(IResource resource) {
        IPath output;
        IClasspathEntry[] classpath;
        try {
            classpath = this.getResolvedClasspath(true);
            output = this.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        IPath fullPath = resource.getFullPath();
        IPath innerMostOutput = output.isPrefixOf(fullPath) ? output : null;
        IClasspathEntry innerMostEntry = null;
        int j = 0;
        int cpLength = classpath.length;
        while (j < cpLength) {
            IPath entryOutput;
            IClasspathEntry entry = classpath[j];
            IPath entryPath = entry.getPath();
            if ((innerMostEntry == null || innerMostEntry.getPath().isPrefixOf(entryPath)) && entryPath.isPrefixOf(fullPath)) {
                innerMostEntry = entry;
            }
            if ((entryOutput = classpath[j].getOutputLocation()) != null && entryOutput.isPrefixOf(fullPath)) {
                innerMostOutput = entryOutput;
            }
            ++j;
        }
        if (innerMostEntry != null) {
            if (innerMostOutput != null && innerMostOutput.segmentCount() > 1 && innerMostEntry.getPath().segmentCount() == 1) {
                return false;
            }
            if (resource instanceof IFolder) {
                return true;
            }
            switch (innerMostEntry.getEntryKind()) {
                case 3: {
                    return true;
                }
                case 1: {
                    return !net.sourceforge.phpdt.internal.compiler.util.Util.isJavaFileName(fullPath.lastSegment());
                }
            }
        }
        return innerMostOutput == null;
    }

    IMarker createClasspathProblemMarker(IJavaModelStatus status) {
        int severity;
        IMarker marker = null;
        String[] arguments = new String[]{};
        boolean isCycleProblem = false;
        boolean isClasspathFileFormatProblem = false;
        switch (status.getCode()) {
            case 1001: {
                isCycleProblem = true;
                if ("error".equals(this.getOption("net.sourceforge.phpeclipse.circularClasspath", true))) {
                    severity = 2;
                    break;
                }
                severity = 1;
                break;
            }
            case 1000: {
                isClasspathFileFormatProblem = true;
                severity = 2;
                break;
            }
            default: {
                IPath path = status.getPath();
                if (path != null) {
                    arguments = new String[]{path.toString()};
                }
                severity = "error".equals(this.getOption("net.sourceforge.phpeclipse.incompleteClasspath", true)) ? 2 : 1;
            }
        }
        try {
            marker = this.getProject().createMarker("net.sourceforge.phpeclipse.buildpath_problem");
            marker.setAttributes(new String[]{"message", "severity", "location", "cycleDetected", "classpathFileFormat", "id", "arguments"}, new Object[]{status.getMessage(), new Integer(severity), Util.bind("classpath.buildPath"), isCycleProblem ? "true" : "false", isClasspathFileFormatProblem ? "true" : "false", new Integer(status.getCode()), Util.getProblemArgumentsForMarker(arguments)});
        }
        catch (CoreException coreException) {}
        return marker;
    }

    protected Object createElementInfo() {
        return new JavaProjectElementInfo();
    }

    public ISearchableNameEnvironment newSearchableNameEnvironment(WorkingCopyOwner owner) throws JavaModelException {
        return new SearchableEnvironment(this, owner);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IClasspathEntry[] decodeClasspath(String xmlClasspath, boolean createMarker, boolean logProblems) {
        ArrayList<IClasspathEntry> paths = new ArrayList<IClasspathEntry>();
        IClasspathEntry defaultOutput = null;
        try {
            Element cpElement;
            block20: {
                if (xmlClasspath == null) {
                    return null;
                }
                StringReader reader = new StringReader(xmlClasspath);
                try {
                    try {
                        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
                    }
                    catch (SAXException sAXException) {
                        throw new IOException(Util.bind("file.badFormat"));
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        throw new IOException(Util.bind("file.badFormat"));
                    }
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    reader.close();
                    throw throwable;
                }
                {
                    Object var9_15 = null;
                    reader.close();
                    if (cpElement.getNodeName().equalsIgnoreCase("classpath")) break block20;
                }
                throw new IOException(Util.bind("file.badFormat"));
            }
            NodeList list = cpElement.getElementsByTagName("classpathentry");
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                IClasspathEntry entry;
                Node node = list.item(i);
                if (node.getNodeType() == 1 && (entry = ClasspathEntry.elementDecode((Element)node, this)) != null) {
                    if (entry.getContentKind() == 10) {
                        defaultOutput = entry;
                    } else {
                        paths.add(entry);
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            if (createMarker && this.getProject().isAccessible()) {
                this.createClasspathProblemMarker(new JavaModelStatus(1000, Util.bind("classpath.xmlFormatError", this.getElementName(), e.getMessage())));
            }
            if (logProblems) {
                Util.log(e, "Exception while retrieving " + this.getPath() + "/.classpath, will mark classpath as invalid");
            }
            return INVALID_CLASSPATH;
        }
        catch (Assert.AssertionFailedException e) {
            if (createMarker && this.getProject().isAccessible()) {
                this.createClasspathProblemMarker(new JavaModelStatus(1000, Util.bind("classpath.illegalEntryInClasspathFile", this.getElementName(), e.getMessage())));
            }
            if (logProblems) {
                Util.log(e, "Exception while retrieving " + this.getPath() + "/.classpath, will mark classpath as invalid");
            }
            return INVALID_CLASSPATH;
        }
        int pathSize = paths.size();
        if (pathSize <= 0 && defaultOutput == null) {
            return null;
        }
        IClasspathEntry[] entries = new IClasspathEntry[pathSize + (defaultOutput == null ? 0 : 1)];
        paths.toArray(entries);
        if (defaultOutput != null) {
            entries[pathSize] = defaultOutput;
        }
        return entries;
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec("net.sourceforge.phpeclipse.parserbuilder");
    }

    protected IClasspathEntry[] defaultClasspath() throws JavaModelException {
        return new IClasspathEntry[]{JavaCore.newSourceEntry(this.getProject().getFullPath())};
    }

    protected IPath defaultOutputLocation() throws JavaModelException {
        return null;
    }

    protected String encodeClasspath(IClasspathEntry[] classpath, IPath outputLocation, boolean indent) throws JavaModelException {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)s, "UTF8");
            XMLWriter xmlWriter = new XMLWriter(writer);
            xmlWriter.startTag("classpath", indent);
            int i = 0;
            while (i < classpath.length) {
                ((ClasspathEntry)classpath[i]).elementEncode(xmlWriter, this.project.getFullPath(), indent, true);
                ++i;
            }
            if (outputLocation != null) {
                outputLocation = outputLocation.removeFirstSegments(1);
                outputLocation = outputLocation.makeRelative();
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("kind", ClasspathEntry.kindToString(10));
                parameters.put("path", String.valueOf(outputLocation));
                xmlWriter.printTag("classpathentry", parameters, indent, true, true);
            }
            xmlWriter.endTag("classpath", indent);
            writer.flush();
            writer.close();
            return s.toString("UTF8");
        }
        catch (IOException e) {
            throw new JavaModelException(e, 985);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaProject)) {
            return false;
        }
        JavaProject other = (JavaProject)o;
        return this.getProject().equals((Object)other.getProject()) && this.occurrenceCount == other.occurrenceCount;
    }

    public boolean exists() {
        if (!JavaProject.hasJavaNature(this.project)) {
            return false;
        }
        return super.exists();
    }

    public IJavaElement findElement(IPath path) throws JavaModelException {
        if (path == null || path.isAbsolute()) {
            throw new JavaModelException(new JavaModelStatus(979, path));
        }
        String extension = path.getFileExtension();
        if (extension == null) {
            path.toString().replace('/', '.');
            return null;
        }
        if (extension.equalsIgnoreCase("java") || extension.equalsIgnoreCase("class")) {
            IPath packagePath = path.removeLastSegments(1);
            String packageName = packagePath.toString().replace('/', '.');
            String typeName = path.lastSegment();
            typeName = typeName.substring(0, typeName.length() - extension.length() - 1);
            if (packageName.length() > 0) {
                String cfr_ignored_0 = String.valueOf(packageName) + "." + typeName;
            }
            return null;
        }
        return null;
    }

    public IPackageFragmentRoot findPackageFragmentRoot(IPath path) throws JavaModelException {
        return this.findPackageFragmentRoot0(JavaProject.canonicalizedPath(path));
    }

    public IPackageFragmentRoot findPackageFragmentRoot0(IPath path) throws JavaModelException {
        IPackageFragmentRoot[] allRoots = this.getAllPackageFragmentRoots();
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(Util.bind("path.mustBeAbsolute"));
        }
        int i = 0;
        while (i < allRoots.length) {
            IPackageFragmentRoot classpathRoot = allRoots[i];
            if (classpathRoot.getPath().equals((Object)path)) {
                return classpathRoot;
            }
            ++i;
        }
        return null;
    }

    public IPackageFragmentRoot[] findPackageFragmentRoots(IClasspathEntry entry) {
        try {
            IClasspathEntry[] classpath = this.getRawClasspath();
            int i = 0;
            int length = classpath.length;
            while (i < length) {
                if (classpath[i].equals(entry)) {
                    return this.computePackageFragmentRoots(this.getResolvedClasspath(new IClasspathEntry[]{entry}, null, true, false, null), false);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return new IPackageFragmentRoot[0];
    }

    protected void flushClasspathProblemMarkers(boolean flushCycleMarkers, boolean flushClasspathFormatMarkers) {
        try {
            IProject project = this.getProject();
            if (project.exists()) {
                IMarker[] markers = project.findMarkers("net.sourceforge.phpeclipse.buildpath_problem", false, 0);
                int i = 0;
                int length = markers.length;
                while (i < length) {
                    IMarker marker = markers[i];
                    if (flushCycleMarkers && flushClasspathFormatMarkers) {
                        marker.delete();
                    } else {
                        String cycleAttr = (String)marker.getAttribute("cycleDetected");
                        String classpathFileFormatAttr = (String)marker.getAttribute("classpathFileFormat");
                        if (flushCycleMarkers == (cycleAttr != null && cycleAttr.equals("true")) && flushClasspathFormatMarkers == (classpathFileFormatAttr != null && classpathFileFormatAttr.equals("true"))) {
                            marker.delete();
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public IPackageFragmentRoot[] getAllPackageFragmentRoots() throws JavaModelException {
        return this.computePackageFragmentRoots(this.getResolvedClasspath(true), true);
    }

    public IClasspathEntry getClasspathEntryFor(IPath path) throws JavaModelException {
        IClasspathEntry[] entries = this.getExpandedClasspath(true);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getPath().equals((Object)path)) {
                return entries[i];
            }
            ++i;
        }
        return null;
    }

    public IMarker getCycleMarker() {
        try {
            IProject project = this.getProject();
            if (project.exists()) {
                IMarker[] markers = project.findMarkers("net.sourceforge.phpeclipse.buildpath_problem", false, 0);
                int i = 0;
                int length = markers.length;
                while (i < length) {
                    IMarker marker = markers[i];
                    String cycleAttr = (String)marker.getAttribute("cycleDetected");
                    if (cycleAttr != null && cycleAttr.equals("true")) {
                        return marker;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public int getElementType() {
        return 2;
    }

    public IClasspathEntry[] getExpandedClasspath(boolean ignoreUnresolvedVariable) throws JavaModelException {
        return this.getExpandedClasspath(ignoreUnresolvedVariable, false, null, null);
    }

    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, owner);
            }
            case '/': {
                String rootPath = "";
                token = null;
                while (memento.hasMoreTokens()) {
                    token = memento.nextToken();
                    char firstChar = token.charAt(0);
                    if (firstChar == '<' || firstChar == '!') break;
                    rootPath = String.valueOf(rootPath) + token;
                }
                JavaElement root = (JavaElement)((Object)this.getPackageFragmentRoot((IPath)new Path(rootPath)));
                if (token != null && token.charAt(0) == '<') {
                    return root.getHandleFromMemento(token, memento, owner);
                }
                return root.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '=';
    }

    public IClasspathEntry[] getExpandedClasspath(boolean ignoreUnresolvedVariable, boolean generateMarkerOnError, Map preferredClasspaths, Map preferredOutputs) throws JavaModelException {
        ObjectVector accumulatedEntries = new ObjectVector();
        this.computeExpandedClasspath(this, ignoreUnresolvedVariable, generateMarkerOnError, new HashSet(5), accumulatedEntries, preferredClasspaths, preferredOutputs);
        Object[] expandedPath = new IClasspathEntry[accumulatedEntries.size()];
        accumulatedEntries.copyInto(expandedPath);
        return expandedPath;
    }

    private ICommand getJavaCommand(IProjectDescription description) throws CoreException {
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("net.sourceforge.phpeclipse.parserbuilder")) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    protected JavaProjectElementInfo getJavaProjectElementInfo() throws JavaModelException {
        return (JavaProjectElementInfo)this.getElementInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameLookup getNameLookup() throws JavaModelException {
        JavaProjectElementInfo info;
        JavaProjectElementInfo javaProjectElementInfo = info = this.getJavaProjectElementInfo();
        synchronized (javaProjectElementInfo) {
            NameLookup nameLookup = info.getNameLookup();
            if (nameLookup == null) {
                nameLookup = new NameLookup(this);
                info.setNameLookup(nameLookup);
            }
            return nameLookup;
        }
    }

    public NameLookup newNameLookup(ICompilationUnit[] workingCopies) throws JavaModelException {
        this.getJavaProjectElementInfo();
        return null;
    }

    public NameLookup newNameLookup(WorkingCopyOwner owner) throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        ICompilationUnit[] workingCopies = owner == null ? null : manager.getWorkingCopies(owner, true);
        return this.newNameLookup(workingCopies);
    }

    public String getOption(String optionName, boolean inheritJavaCoreOptions) {
        if (JavaModelManager.OptionNames.contains(optionName)) {
            Preferences preferences = this.getPreferences();
            if (preferences == null || preferences.isDefault(optionName)) {
                return inheritJavaCoreOptions ? JavaCore.getOption(optionName) : null;
            }
            return preferences.getString(optionName).trim();
        }
        return null;
    }

    public Map getOptions(boolean inheritJavaCoreOptions) {
        String propertyName;
        int i;
        Hashtable options = inheritJavaCoreOptions ? JavaCore.getOptions() : new Hashtable(5);
        Preferences preferences = this.getPreferences();
        if (preferences == null) {
            return options;
        }
        HashSet optionNames = JavaModelManager.OptionNames;
        if (inheritJavaCoreOptions) {
            String[] defaultPropertyNames = preferences.defaultPropertyNames();
            i = 0;
            while (i < defaultPropertyNames.length) {
                propertyName = defaultPropertyNames[i];
                if (optionNames.contains(propertyName)) {
                    options.put(propertyName, preferences.getDefaultString(propertyName).trim());
                }
                ++i;
            }
        }
        String[] propertyNames = preferences.propertyNames();
        i = 0;
        while (i < propertyNames.length) {
            propertyName = propertyNames[i];
            if (optionNames.contains(propertyName)) {
                options.put(propertyName, preferences.getString(propertyName).trim());
            }
            ++i;
        }
        return options;
    }

    public IPath getOutputLocation() throws JavaModelException {
        return this.getOutputLocation(false, true);
    }

    public IPath getOutputLocation(boolean createMarkers, boolean logProblems) throws JavaModelException {
        JavaModelManager.PerProjectInfo perProjectInfo = this.getPerProjectInfo();
        IPath outputLocation = perProjectInfo.outputLocation;
        if (outputLocation != null) {
            return outputLocation;
        }
        this.getRawClasspath(createMarkers, logProblems);
        outputLocation = perProjectInfo.outputLocation;
        if (outputLocation == null) {
            return this.defaultOutputLocation();
        }
        return outputLocation;
    }

    public IPackageFragmentRoot getPackageFragmentRoot(IPath path) {
        if (!path.isAbsolute()) {
            path = this.getPath().append(path);
        }
        int segmentCount = path.segmentCount();
        switch (segmentCount) {
            case 0: {
                return null;
            }
            case 1: {
                return this.getPackageFragmentRoot((IResource)this.getProject());
            }
        }
        return this.getPackageFragmentRoot((IResource)this.getProject().getWorkspace().getRoot().getFolder(path));
    }

    public IPackageFragmentRoot getFolderPackageFragmentRoot(IPath path) {
        if (path.segmentCount() == 1) {
            return this.getPackageFragmentRoot((IResource)this.getProject());
        }
        return this.getPackageFragmentRoot((IResource)this.getProject().getWorkspace().getRoot().getFolder(path));
    }

    public IPackageFragmentRoot getPackageFragmentRoot(IResource resource) {
        switch (resource.getType()) {
            case 1: {
                return null;
            }
            case 2: {
                return new PackageFragmentRoot(resource, this, resource.getName());
            }
            case 4: {
                return new PackageFragmentRoot(resource, this, "");
            }
        }
        return null;
    }

    public IPackageFragmentRoot[] getPackageFragmentRoots() throws JavaModelException {
        IJavaElement[] children = this.getChildren();
        int length = children.length;
        IPackageFragmentRoot[] roots = new IPackageFragmentRoot[length];
        System.arraycopy(children, 0, roots, 0, length);
        return roots;
    }

    public IPackageFragmentRoot[] getPackageFragmentRoots(IClasspathEntry entry) {
        return this.findPackageFragmentRoots(entry);
    }

    protected IPackageFragmentRoot[] getPackageFragmentRoots(IPath path) throws JavaModelException {
        IPackageFragmentRoot[] roots = this.getAllPackageFragmentRoots();
        ArrayList<IPackageFragmentRoot> matches = new ArrayList<IPackageFragmentRoot>();
        int i = 0;
        while (i < roots.length) {
            if (path.isPrefixOf(roots[i].getPath())) {
                matches.add(roots[i]);
            }
            ++i;
        }
        IPackageFragmentRoot[] copy = new IPackageFragmentRoot[matches.size()];
        matches.toArray(copy);
        return copy;
    }

    public IPackageFragment[] getPackageFragments() throws JavaModelException {
        IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
        return this.getPackageFragmentsInRoots(roots);
    }

    public IPackageFragment[] getPackageFragmentsInRoots(IPackageFragmentRoot[] roots) {
        ArrayList<IJavaElement> frags = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            try {
                IJavaElement[] rootFragments = root.getChildren();
                int j = 0;
                while (j < rootFragments.length) {
                    frags.add(rootFragments[j]);
                    ++j;
                }
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        IPackageFragment[] fragments = new IPackageFragment[frags.size()];
        frags.toArray(fragments);
        return fragments;
    }

    public IPath getPath() {
        return this.getProject().getFullPath();
    }

    public JavaModelManager.PerProjectInfo getPerProjectInfo() throws JavaModelException {
        return JavaModelManager.getJavaModelManager().getPerProjectInfoCheckExistence(this.project);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
        this.parent = JavaModelManager.getJavaModelManager().getJavaModel();
        this.name = project.getName();
    }

    protected IProject getProject(String name) {
        return PHPeclipsePlugin.getWorkspace().getRoot().getProject(name);
    }

    public List getReferencedProjects() {
        ArrayList<IProject> referencedProjects = new ArrayList<IProject>();
        Iterator iterator = this.getLoadPathEntries().iterator();
        while (iterator.hasNext()) {
            LoadPathEntry pathEntry = (LoadPathEntry)iterator.next();
            if (pathEntry.getType() != "project") continue;
            referencedProjects.add(pathEntry.getProject());
        }
        return referencedProjects;
    }

    public Preferences getPreferences() {
        IProject project = this.getProject();
        if (!JavaProject.hasJavaNature(project)) {
            return null;
        }
        JavaModelManager.PerProjectInfo perProjectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfo(project, true);
        Preferences preferences = perProjectInfo.preferences;
        if (preferences != null) {
            return preferences;
        }
        preferences = this.loadPreferences();
        if (preferences == null) {
            preferences = new Preferences();
        }
        perProjectInfo.preferences = preferences;
        return preferences;
    }

    public IClasspathEntry[] getRawClasspath() throws JavaModelException {
        return this.getRawClasspath(false, true);
    }

    public IClasspathEntry[] getRawClasspath(boolean createMarkers, boolean logProblems) throws JavaModelException {
        IClasspathEntry entry;
        IClasspathEntry[] classpath;
        JavaModelManager.PerProjectInfo perProjectInfo = null;
        if (createMarkers) {
            this.flushClasspathProblemMarkers(false, true);
            classpath = this.readClasspathFile(createMarkers, logProblems);
        } else {
            perProjectInfo = this.getPerProjectInfo();
            classpath = perProjectInfo.rawClasspath;
            if (classpath != null) {
                return classpath;
            }
            classpath = this.readClasspathFile(createMarkers, logProblems);
        }
        IPath outputLocation = null;
        if (classpath != null && classpath.length > 0 && (entry = classpath[classpath.length - 1]).getContentKind() == 10) {
            outputLocation = entry.getPath();
            IClasspathEntry[] copy = new IClasspathEntry[classpath.length - 1];
            System.arraycopy(classpath, 0, copy, 0, copy.length);
            classpath = copy;
        }
        if (classpath == null) {
            return this.defaultClasspath();
        }
        if (!createMarkers) {
            perProjectInfo.rawClasspath = classpath;
            perProjectInfo.outputLocation = outputLocation;
        }
        return classpath;
    }

    public String[] getRequiredProjectNames() throws JavaModelException {
        return this.projectPrerequisites(this.getResolvedClasspath(true));
    }

    public IClasspathEntry[] getResolvedClasspath(boolean ignoreUnresolvedEntry) throws JavaModelException {
        return this.getResolvedClasspath(ignoreUnresolvedEntry, false);
    }

    public IClasspathEntry[] getResolvedClasspath(boolean ignoreUnresolvedEntry, boolean generateMarkerOnError) throws JavaModelException {
        return this.getResolvedClasspath(ignoreUnresolvedEntry, generateMarkerOnError, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IClasspathEntry[] getResolvedClasspath(boolean ignoreUnresolvedEntry, boolean generateMarkerOnError, boolean returnResolutionInProgress) throws JavaModelException {
        IClasspathEntry[] resolvedPath;
        block11: {
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            JavaModelManager.PerProjectInfo perProjectInfo = null;
            if (ignoreUnresolvedEntry && !generateMarkerOnError && (perProjectInfo = this.getPerProjectInfo()) != null) {
                IClasspathEntry[] infoPath = perProjectInfo.resolvedClasspath;
                if (infoPath != null) {
                    return infoPath;
                }
                if (returnResolutionInProgress && manager.isClasspathBeingResolved(this)) {
                    if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                        Util.verbose("CPResolution: reentering raw classpath resolution, will use empty classpath instead\tproject: " + this.getElementName() + '\n' + "\tinvocation stack trace:");
                        new Exception("<Fake exception>").printStackTrace(System.out);
                    }
                    return RESOLUTION_IN_PROGRESS;
                }
            }
            HashMap reverseMap = perProjectInfo == null ? null : new HashMap(5);
            resolvedPath = null;
            boolean nullOldResolvedCP = perProjectInfo != null && perProjectInfo.resolvedClasspath == null;
            try {
                if (nullOldResolvedCP) {
                    manager.setClasspathBeingResolved(this, true);
                }
                resolvedPath = this.getResolvedClasspath(this.getRawClasspath(generateMarkerOnError, !generateMarkerOnError), generateMarkerOnError ? this.getOutputLocation() : null, ignoreUnresolvedEntry, generateMarkerOnError, reverseMap);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (nullOldResolvedCP) {
                    perProjectInfo.resolvedClasspath = null;
                }
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (nullOldResolvedCP) {
                    perProjectInfo.resolvedClasspath = null;
                }
                if (perProjectInfo == null) break block11;
            }
            if (perProjectInfo.rawClasspath == null && generateMarkerOnError && JavaProject.hasJavaNature(this.project)) {
                this.flushClasspathProblemMarkers(false, true);
                this.createClasspathProblemMarker(new JavaModelStatus(1000, Util.bind("classpath.cannotReadClasspathFile", this.getElementName())));
            }
            perProjectInfo.resolvedClasspath = resolvedPath;
            perProjectInfo.resolvedPathToRawEntries = reverseMap;
            manager.setClasspathBeingResolved(this, false);
        }
        return resolvedPath;
    }

    public IClasspathEntry[] getResolvedClasspath(IClasspathEntry[] classpathEntries, IPath projectOutputLocation, boolean ignoreUnresolvedEntry, boolean generateMarkerOnError, Map reverseMap) throws JavaModelException {
        if (generateMarkerOnError) {
            this.flushClasspathProblemMarkers(false, false);
        }
        int length = classpathEntries.length;
        ArrayList<IClasspathEntry> resolvedEntries = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < length) {
            IClasspathEntry rawEntry = classpathEntries[i];
            IJavaModelStatus status = null;
            switch (rawEntry.getEntryKind()) {
                case 4: {
                    IPath resolvedPath;
                    IClasspathEntry resolvedEntry = JavaCore.getResolvedClasspathEntry(rawEntry);
                    if (resolvedEntry == null) {
                        if (ignoreUnresolvedEntry) break;
                        throw new JavaModelException(status);
                    }
                    if (reverseMap != null && reverseMap.get(resolvedPath = resolvedEntry.getPath()) == null) {
                        reverseMap.put(resolvedPath, rawEntry);
                    }
                    resolvedEntries.add(resolvedEntry);
                    break;
                }
                default: {
                    IPath resolvedPath;
                    if (reverseMap != null && reverseMap.get(resolvedPath = rawEntry.getPath()) == null) {
                        reverseMap.put(resolvedPath, rawEntry);
                    }
                    resolvedEntries.add(rawEntry);
                }
            }
            ++i;
        }
        IClasspathEntry[] resolvedPath = new IClasspathEntry[resolvedEntries.size()];
        resolvedEntries.toArray(resolvedPath);
        return resolvedPath;
    }

    public IResource getResource() {
        return this.getProject();
    }

    public ISearchableNameEnvironment getSearchableNameEnvironment() throws JavaModelException {
        return null;
    }

    public String getSharedProperty(String key) throws CoreException {
        String property = null;
        IFile rscFile = this.getProject().getFile(key);
        if (rscFile.exists()) {
            property = new String(Util.getResourceContentsAsByteArray(rscFile));
        }
        return property;
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.getProject();
    }

    public boolean hasBuildState() {
        return JavaModelManager.getJavaModelManager().getLastBuiltState(this.getProject(), null) != null;
    }

    public boolean hasClasspathCycle(IClasspathEntry[] preferredClasspath) {
        HashSet cycleParticipants = new HashSet();
        this.updateCycleParticipants(preferredClasspath, new ArrayList(2), cycleParticipants, ResourcesPlugin.getWorkspace().getRoot(), new HashSet(2));
        return !cycleParticipants.isEmpty();
    }

    public boolean hasCycleMarker() {
        return this.getCycleMarker() != null;
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    public static boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature("net.sourceforge.phpeclipse.phpnature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean hasSource() {
        IClasspathEntry[] entries;
        try {
            entries = this.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {
            return true;
        }
        int i = 0;
        int max = entries.length;
        while (i < max) {
            if (entries[i].getEntryKind() == 3) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isClasspathEqualsTo(IClasspathEntry[] newClasspath, IPath newOutputLocation, IClasspathEntry[] otherClasspathWithOutput) throws JavaModelException {
        int length;
        if (otherClasspathWithOutput != null && otherClasspathWithOutput.length > 0 && (length = otherClasspathWithOutput.length) == newClasspath.length + 1) {
            int i = 0;
            while (i < length - 1) {
                if (!otherClasspathWithOutput[i].equals(newClasspath[i])) {
                    return false;
                }
                ++i;
            }
            IClasspathEntry output = otherClasspathWithOutput[length - 1];
            if (output.getContentKind() == 10 && output.getPath().equals((Object)newOutputLocation)) {
                return true;
            }
        }
        return false;
    }

    public boolean isOnClasspath(IJavaElement element) {
        IPath path = element.getPath();
        switch (element.getElementType()) {
            case 3: {
                if (((IPackageFragmentRoot)element).isArchive()) break;
                path = path.append("*");
                break;
            }
            case 4: {
                if (((IPackageFragmentRoot)element.getParent()).isArchive()) break;
                path = path.append("*");
            }
        }
        return this.isOnClasspath(path);
    }

    private boolean isOnClasspath(IPath path) {
        IClasspathEntry[] classpath;
        try {
            classpath = this.getResolvedClasspath(true);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (entry.getPath().isPrefixOf(path) && !Util.isExcluded(path, null, ((ClasspathEntry)entry).fullExclusionPatternChars(), true)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isOnClasspath(IResource resource) {
        IPath path = resource.getFullPath();
        if (resource.getType() == 2) {
            path = path.append("*");
        }
        return this.isOnClasspath(path);
    }

    private IPath getPluginWorkingLocation() {
        return this.project.getWorkingLocation("net.sourceforge.phpeclipse");
    }

    /*
     * Exception decompiling
     */
    public Preferences loadPreferences() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 103->106)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String[] projectPrerequisites(IClasspathEntry[] entries) throws JavaModelException {
        ArrayList<String> prerequisites = new ArrayList<String>();
        entries = this.getResolvedClasspath(entries, null, true, false, null);
        int i = 0;
        int length = entries.length;
        while (i < length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 2) {
                prerequisites.add(entry.getPath().lastSegment());
            }
            ++i;
        }
        int size = prerequisites.size();
        if (size == 0) {
            return NO_PREREQUISITES;
        }
        String[] result = new String[size];
        prerequisites.toArray(result);
        return result;
    }

    protected IClasspathEntry[] readClasspathFile(boolean createMarker, boolean logProblems) {
        try {
            String xmlClasspath = this.getSharedProperty(CLASSPATH_FILENAME);
            if (xmlClasspath == null) {
                return null;
            }
            return this.decodeClasspath(xmlClasspath, createMarker, logProblems);
        }
        catch (CoreException e) {
            if (createMarker && this.getProject().isAccessible()) {
                this.createClasspathProblemMarker(new JavaModelStatus(1000, Util.bind("classpath.cannotReadClasspathFile", this.getElementName())));
            }
            if (logProblems) {
                Util.log(e, "Exception while retrieving " + this.getPath() + "/.classpath, will revert to default classpath");
            }
            return null;
        }
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.getProject().setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    public IJavaElement rootedAt(IJavaProject project) {
        return project;
    }

    public String rootID() {
        return "[PRJ]" + this.getProject().getFullPath();
    }

    public boolean saveClasspath(IClasspathEntry[] newClasspath, IPath newOutputLocation) throws JavaModelException {
        if (!this.getProject().exists()) {
            return false;
        }
        IClasspathEntry[] fileEntries = this.readClasspathFile(false, false);
        if (fileEntries != null && this.isClasspathEqualsTo(newClasspath, newOutputLocation, fileEntries)) {
            return false;
        }
        try {
            this.setSharedProperty(CLASSPATH_FILENAME, this.encodeClasspath(newClasspath, newOutputLocation, true));
            return true;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private void savePreferences(Preferences preferences) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 124->128)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setJavaCommand(IProjectDescription description, ICommand newCommand) throws CoreException {
        ICommand[] newCommands;
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldJavaCommand = this.getJavaCommand(description);
        if (oldJavaCommand == null) {
            newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 1, oldCommands.length);
            newCommands[0] = newCommand;
        } else {
            int i = 0;
            int max = oldCommands.length;
            while (i < max) {
                if (oldCommands[i] == oldJavaCommand) {
                    oldCommands[i] = newCommand;
                    break;
                }
                ++i;
            }
            newCommands = oldCommands;
        }
        description.setBuildSpec(newCommands);
        this.getProject().setDescription(description, null);
    }

    public void setOptions(Map newOptions) {
        Preferences preferences = new Preferences();
        this.setPreferences(preferences);
        if (newOptions != null) {
            Iterator keys = newOptions.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!JavaModelManager.OptionNames.contains(key)) continue;
                String value = (String)newOptions.get(key);
                preferences.setDefault(key, CUSTOM_DEFAULT_OPTION_VALUE);
                preferences.setValue(key, value);
            }
        }
        this.savePreferences(preferences);
    }

    public void setOutputLocation(IPath path, IProgressMonitor monitor) throws JavaModelException {
        if (path == null) {
            throw new IllegalArgumentException(Util.bind("path.nullpath"));
        }
        if (path.equals((Object)this.getOutputLocation())) {
            return;
        }
        this.setRawClasspath(SetClasspathOperation.ReuseClasspath, path, monitor);
    }

    public void setPreferences(Preferences preferences) {
        IProject project = this.getProject();
        if (!JavaProject.hasJavaNature(project)) {
            return;
        }
        JavaModelManager.PerProjectInfo perProjectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfo(project, true);
        perProjectInfo.preferences = preferences;
    }

    public void setRawClasspath(IClasspathEntry[] entries, IPath outputLocation, IProgressMonitor monitor) throws JavaModelException {
        this.setRawClasspath(entries, outputLocation, monitor, true, this.getResolvedClasspath(true), true, true);
    }

    public void setRawClasspath(IClasspathEntry[] newEntries, IPath newOutputLocation, IProgressMonitor monitor, boolean canChangeResource, IClasspathEntry[] oldResolvedPath, boolean needValidation, boolean needSave) throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            IClasspathEntry[] newRawPath = newEntries;
            if (newRawPath == null) {
                newRawPath = this.defaultClasspath();
            }
            SetClasspathOperation op = new SetClasspathOperation(this, oldResolvedPath, newRawPath, newOutputLocation, canChangeResource, needValidation, needSave);
            JavaProject.runOperation(op, monitor);
        }
        catch (JavaModelException e) {
            manager.flush();
            throw e;
        }
    }

    public void setRawClasspath(IClasspathEntry[] entries, IProgressMonitor monitor) throws JavaModelException {
        this.setRawClasspath(entries, SetClasspathOperation.ReuseOutputLocation, monitor, true, this.getResolvedClasspath(true), true, true);
    }

    public void setSharedProperty(String key, String value) throws CoreException {
        IFile rscFile = this.getProject().getFile(key);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(value.getBytes());
        if (rscFile.exists()) {
            if (rscFile.isReadOnly()) {
                ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{rscFile}, null);
            }
            rscFile.setContents((InputStream)inputStream, 1, null);
        } else {
            rscFile.create((InputStream)inputStream, 1, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void updateAllCycleMarkers() throws JavaModelException {
        manager = JavaModelManager.getJavaModelManager();
        projects = manager.getJavaModel().getJavaProjects();
        workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        cycleParticipants = new HashSet<E>();
        traversed = new HashSet<E>();
        length = projects.length;
        prereqChain = new ArrayList<E>();
        i = 0;
        while (i < length) {
            project = (JavaProject)projects[i];
            if (!traversed.contains(project.getPath())) {
                prereqChain.clear();
                project.updateCycleParticipants(null, prereqChain, cycleParticipants, workspaceRoot, traversed);
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            project = (JavaProject)projects[i];
            if (cycleParticipants.contains(project.getPath())) {
                cycleMarker = project.getCycleMarker();
                circularCPOption = project.getOption("net.sourceforge.phpeclipse.circularClasspath", true);
                v0 = circularCPSeverity = "error".equals(circularCPOption) != false ? 2 : 1;
                if (cycleMarker != null) {
                    try {
                        existingSeverity = (Integer)cycleMarker.getAttribute("severity");
                        if (existingSeverity == circularCPSeverity) ** GOTO lbl35
                        cycleMarker.setAttribute("severity", circularCPSeverity);
                    }
                    catch (CoreException e) {
                        throw new JavaModelException(e);
                    }
                } else {
                    project.createClasspathProblemMarker(new JavaModelStatus(1001, project));
                }
            } else {
                project.flushClasspathProblemMarkers(true, false);
            }
lbl35:
            // 4 sources

            ++i;
        }
    }

    public void updateCycleParticipants(IClasspathEntry[] preferredClasspath, ArrayList prereqChain, HashSet cycleParticipants, IWorkspaceRoot workspaceRoot, HashSet traversed) {
        IPath path = this.getPath();
        prereqChain.add(path);
        traversed.add(path);
        try {
            IClasspathEntry[] classpath = preferredClasspath == null ? this.getResolvedClasspath(true) : preferredClasspath;
            int i = 0;
            int length = classpath.length;
            while (i < length) {
                IClasspathEntry entry = classpath[i];
                if (entry.getEntryKind() == 2) {
                    IResource member;
                    int index;
                    IPath prereqProjectPath = entry.getPath();
                    int n = index = cycleParticipants.contains(prereqProjectPath) ? 0 : prereqChain.indexOf(prereqProjectPath);
                    if (index >= 0) {
                        int size = prereqChain.size();
                        while (index < size) {
                            cycleParticipants.add(prereqChain.get(index));
                            ++index;
                        }
                    } else if (!traversed.contains(prereqProjectPath) && (member = workspaceRoot.findMember(prereqProjectPath)) != null && member.getType() == 4) {
                        JavaProject project = (JavaProject)JavaCore.create((IProject)member);
                        project.updateCycleParticipants(null, prereqChain, cycleParticipants, workspaceRoot, traversed);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        prereqChain.remove(path);
    }

    public void updatePackageFragmentRoots() {
        if (this.isOpen()) {
            try {
                JavaProjectElementInfo info = this.getJavaProjectElementInfo();
                IClasspathEntry[] classpath = this.getResolvedClasspath(true);
                info.setNonJavaResources(null);
                info.setChildren(this.computePackageFragmentRoots(classpath, false));
            }
            catch (JavaModelException javaModelException) {
                try {
                    this.close();
                }
                catch (JavaModelException javaModelException2) {}
            }
        }
    }

    public void removeLoadPathEntry(IProject anotherPHPProject) {
        Iterator entries = this.getLoadPathEntries().iterator();
        while (entries.hasNext()) {
            LoadPathEntry entry = (LoadPathEntry)entries.next();
            if (entry.getType() != "project" || !entry.getProject().getName().equals(anotherPHPProject.getName())) continue;
            this.getLoadPathEntries().remove(entry);
            this.fScratched = true;
            break;
        }
    }

    public void save() throws CoreException {
        if (this.fScratched) {
            ByteArrayInputStream xmlPath = new ByteArrayInputStream(this.getLoadPathXML().getBytes());
            IFile loadPathsFile = this.getLoadPathEntriesFile();
            if (!loadPathsFile.exists()) {
                loadPathsFile.create((InputStream)xmlPath, true, null);
            } else {
                loadPathsFile.setContents((InputStream)xmlPath, true, false, null);
            }
            this.fScratched = false;
        }
    }
}

