/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import net.sourceforge.phpdt.core.IClasspathEntry;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.core.ClasspathEntry;
import net.sourceforge.phpdt.internal.core.JavaProject;
import net.sourceforge.phpdt.internal.core.NameLookup;
import net.sourceforge.phpdt.internal.core.OpenableElementInfo;
import net.sourceforge.phpdt.internal.core.util.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

class JavaProjectElementInfo
extends OpenableElementInfo {
    protected NameLookup fNameLookup = null;
    private Object[] fNonJavaResources = null;

    private Object[] computeNonJavaResources(JavaProject project) {
        IPath projectPath = project.getProject().getFullPath();
        boolean srcIsProject = false;
        char[][] exclusionPatterns = null;
        IClasspathEntry[] classpath = null;
        IPath projectOutput = null;
        try {
            classpath = project.getResolvedClasspath(true);
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry entry = classpath[i];
                if (projectPath.equals((Object)entry.getPath())) {
                    srcIsProject = true;
                    exclusionPatterns = ((ClasspathEntry)entry).fullExclusionPatternChars();
                    break;
                }
                ++i;
            }
            projectOutput = project.getOutputLocation();
            projectPath.equals((Object)projectOutput);
        }
        catch (JavaModelException javaModelException) {}
        Object[] nonJavaResources = new IResource[5];
        int nonJavaResourcesCounter = 0;
        try {
            IResource[] members = ((IContainer)project.getResource()).members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource res = members[i];
                switch (res.getType()) {
                    case 1: {
                        IPath resFullPath = res.getFullPath();
                        res.getName();
                        if (srcIsProject && !Util.isExcluded(res, exclusionPatterns)) break;
                        if (nonJavaResources.length == nonJavaResourcesCounter) {
                            Object[] objectArray = nonJavaResources;
                            nonJavaResources = new IResource[nonJavaResourcesCounter * 2];
                            System.arraycopy(objectArray, 0, nonJavaResources, 0, nonJavaResourcesCounter);
                        }
                        nonJavaResources[nonJavaResourcesCounter++] = res;
                        break;
                    }
                    case 2: {
                        IPath resFullPath = res.getFullPath();
                        if (srcIsProject && !Util.isExcluded(res, exclusionPatterns) && Util.isValidFolderNameForPackage(res.getName()) || this.isClasspathEntryOrOutputLocation(resFullPath, classpath, projectOutput)) break;
                        if (nonJavaResources.length == nonJavaResourcesCounter) {
                            Object[] objectArray = nonJavaResources;
                            nonJavaResources = new IResource[nonJavaResourcesCounter * 2];
                            System.arraycopy(objectArray, 0, nonJavaResources, 0, nonJavaResourcesCounter);
                        }
                        nonJavaResources[nonJavaResourcesCounter++] = res;
                    }
                }
                ++i;
            }
            if (nonJavaResources.length != nonJavaResourcesCounter) {
                Object[] objectArray = nonJavaResources;
                nonJavaResources = new IResource[nonJavaResourcesCounter];
                System.arraycopy(objectArray, 0, nonJavaResources, 0, nonJavaResourcesCounter);
            }
        }
        catch (CoreException coreException) {
            nonJavaResources = NO_NON_JAVA_RESOURCES;
            nonJavaResourcesCounter = 0;
        }
        return nonJavaResources;
    }

    protected NameLookup getNameLookup() {
        return this.fNameLookup;
    }

    Object[] getNonJavaResources(JavaProject project) {
        Object[] nonJavaResources = this.fNonJavaResources;
        if (nonJavaResources == null) {
            nonJavaResources = this.computeNonJavaResources(project);
            this.fNonJavaResources = nonJavaResources;
        }
        return nonJavaResources;
    }

    private boolean isClasspathEntryOrOutputLocation(IPath path, IClasspathEntry[] resolvedClasspath, IPath projectOutput) {
        if (projectOutput.equals((Object)path)) {
            return true;
        }
        int i = 0;
        int length = resolvedClasspath.length;
        while (i < length) {
            IClasspathEntry entry = resolvedClasspath[i];
            if (entry.getPath().equals((Object)path)) {
                return true;
            }
            IPath output = entry.getOutputLocation();
            if (output != null && output.equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void setNameLookup(NameLookup newNameLookup) {
        this.fNameLookup = newNameLookup;
    }

    synchronized void setNonJavaResources(Object[] resources) {
        this.fNonJavaResources = resources;
    }
}

