/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.util.HashSet;
import java.util.Iterator;
import net.sourceforge.phpdt.core.IJavaElementDelta;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.IPackageFragmentRoot;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.core.CompilationUnit;
import net.sourceforge.phpdt.internal.core.JavaElementInfo;
import net.sourceforge.phpdt.internal.core.JavaModelManager;
import net.sourceforge.phpdt.internal.core.JavaProject;
import net.sourceforge.phpdt.internal.core.Openable;

public class ModelUpdater {
    HashSet projectsToUpdate = new HashSet();

    protected void addToParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                JavaElementInfo info = (JavaElementInfo)parent.getElementInfo();
                info.addChild(child);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    protected static void close(Openable element) {
        try {
            element.close();
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void elementAdded(Openable element) {
        int elementType = element.getElementType();
        if (elementType == 2) {
            this.addToParentInfo(element);
            this.projectsToUpdate.add(element);
        } else {
            this.addToParentInfo(element);
            ModelUpdater.close(element);
        }
        switch (elementType) {
            case 3: {
                this.projectsToUpdate.add(element.getJavaProject());
                break;
            }
            case 4: {
                JavaProject cfr_ignored_0 = (JavaProject)element.getJavaProject();
            }
        }
    }

    protected void elementChanged(Openable element) {
        ModelUpdater.close(element);
    }

    protected void elementRemoved(Openable element) {
        if (element.isOpen()) {
            ModelUpdater.close(element);
        }
        this.removeFromParentInfo(element);
        int elementType = element.getElementType();
        switch (elementType) {
            case 1: {
                break;
            }
            case 2: {
                JavaModelManager.getJavaModelManager().removePerProjectInfo((JavaProject)element);
                break;
            }
            case 3: {
                this.projectsToUpdate.add(element.getJavaProject());
                break;
            }
            case 4: {
                JavaProject cfr_ignored_0 = (JavaProject)element.getJavaProject();
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processJavaDelta(IJavaElementDelta delta) {
        try {
            this.traverseDelta(delta, null, null);
            Iterator iterator = this.projectsToUpdate.iterator();
            while (iterator.hasNext()) {
                JavaProject project = (JavaProject)iterator.next();
                project.updatePackageFragmentRoots();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.projectsToUpdate = new HashSet();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.projectsToUpdate = new HashSet();
            return;
        }
    }

    protected void removeFromParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                JavaElementInfo info = (JavaElementInfo)parent.getElementInfo();
                info.removeChild(child);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    protected void traverseDelta(IJavaElementDelta delta, IPackageFragmentRoot root, IJavaProject project) {
        boolean processChildren = true;
        Openable element = (Openable)delta.getElement();
        switch (element.getElementType()) {
            case 2: {
                project = (IJavaProject)((Object)element);
                break;
            }
            case 3: {
                root = (IPackageFragmentRoot)((Object)element);
                break;
            }
            case 5: {
                CompilationUnit cu = (CompilationUnit)element;
                if (cu.isWorkingCopy() && !cu.isPrimary()) {
                    return;
                }
            }
            case 6: {
                processChildren = false;
            }
        }
        switch (delta.getKind()) {
            case 1: {
                this.elementAdded(element);
                break;
            }
            case 2: {
                this.elementRemoved(element);
                break;
            }
            case 4: {
                if ((delta.getFlags() & 1) == 0) break;
                this.elementChanged(element);
            }
        }
        if (processChildren) {
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                IJavaElementDelta childDelta = children[i];
                this.traverseDelta(childDelta, root, project);
                ++i;
            }
        }
    }
}

