/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.phpdt.core.IClasspathEntry;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.IPackageFragment;
import net.sourceforge.phpdt.core.IPackageFragmentRoot;
import net.sourceforge.phpdt.core.IType;
import net.sourceforge.phpdt.core.IWorkingCopy;
import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.core.IJavaElementRequestor;
import net.sourceforge.phpdt.internal.core.JavaElementRequestor;
import net.sourceforge.phpdt.internal.core.JavaProject;
import net.sourceforge.phpdt.internal.core.util.PerThreadObject;
import net.sourceforge.phpdt.internal.core.util.Util;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class NameLookup {
    public static final int ACCEPT_CLASSES = 2;
    public static final int ACCEPT_INTERFACES = 4;
    protected IPackageFragmentRoot[] fPackageFragmentRoots = null;
    protected Map fPackageFragments;
    protected IWorkspace workspace;
    protected PerThreadObject unitsToLookInside = new PerThreadObject();

    public NameLookup(IJavaProject project) throws JavaModelException {
        this.configureFromProject(project);
    }

    protected boolean acceptType(IType type, int acceptFlags) {
        if (acceptFlags == 0) {
            return true;
        }
        try {
            if (type.isClass()) {
                return (acceptFlags & 2) != 0;
            }
            return (acceptFlags & 4) != 0;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private void configureFromProject(IJavaProject project) throws JavaModelException {
        this.workspace = ResourcesPlugin.getWorkspace();
        this.fPackageFragmentRoots = ((JavaProject)project).getAllPackageFragmentRoots();
        this.fPackageFragments = new HashMap();
        IPackageFragment[] frags = this.getPackageFragmentsInRoots(this.fPackageFragmentRoots, project);
        int i = 0;
        while (i < frags.length) {
            IPackageFragment fragment = frags[i];
            IPackageFragment[] entry = (IPackageFragment[])this.fPackageFragments.get(fragment.getElementName());
            if (entry == null) {
                entry = new IPackageFragment[]{fragment};
                this.fPackageFragments.put(fragment.getElementName(), entry);
            } else {
                IPackageFragment[] copy = new IPackageFragment[entry.length + 1];
                System.arraycopy(entry, 0, copy, 0, entry.length);
                copy[entry.length] = fragment;
                this.fPackageFragments.put(fragment.getElementName(), copy);
            }
            ++i;
        }
    }

    private void findAllTypes(String prefix, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        int count = this.fPackageFragmentRoots.length;
        int i = 0;
        while (i < count) {
            block7: {
                if (requestor.isCanceled()) {
                    return;
                }
                IPackageFragmentRoot root = this.fPackageFragmentRoots[i];
                IJavaElement[] packages = null;
                try {
                    packages = root.getChildren();
                }
                catch (JavaModelException javaModelException) {
                    break block7;
                }
                if (packages != null) {
                    int j = 0;
                    int packageCount = packages.length;
                    while (j < packageCount) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        this.seekTypes(prefix, (IPackageFragment)packages[j], partialMatch, acceptFlags, requestor);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public ICompilationUnit findCompilationUnit(String qualifiedTypeName) {
        String pkgName = "";
        String cuName = qualifiedTypeName;
        int index = qualifiedTypeName.lastIndexOf(46);
        if (index != -1) {
            pkgName = qualifiedTypeName.substring(0, index);
            cuName = qualifiedTypeName.substring(index + 1);
        }
        if ((index = cuName.indexOf(36)) != -1) {
            cuName = cuName.substring(0, index);
        }
        cuName = String.valueOf(cuName) + ".java";
        IPackageFragment[] frags = (IPackageFragment[])this.fPackageFragments.get(pkgName);
        if (frags != null) {
            int i = 0;
            while (i < frags.length) {
                IPackageFragment cfr_ignored_0 = frags[i];
                ++i;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IPackageFragment findPackageFragment(IPath path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(Util.bind("path.mustBeAbsolute"));
        }
        IResource possibleFragment = this.workspace.getRoot().findMember(path);
        if (possibleFragment == null) {
            int i = 0;
            while (i < this.fPackageFragmentRoots.length) {
                block15: {
                    IPath rootPath;
                    int matchingCount;
                    IPackageFragmentRoot root = this.fPackageFragmentRoots[i];
                    if (root.isExternal() && (matchingCount = (rootPath = root.getPath()).matchingFirstSegments(path)) != 0) {
                        String name = path.toOSString();
                        name = name.substring(rootPath.toOSString().length() + 1, name.length());
                        name = name.replace(File.separatorChar, '.');
                        IJavaElement[] list = null;
                        try {
                            list = root.getChildren();
                        }
                        catch (JavaModelException javaModelException) {
                            break block15;
                        }
                        int elementCount = list.length;
                        int j = 0;
                        while (j < elementCount) {
                            IPackageFragment packageFragment = (IPackageFragment)list[j];
                            if (this.nameMatches(name, packageFragment, false)) {
                                return packageFragment;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            return null;
        }
        IJavaElement fromFactory = JavaCore.create(possibleFragment);
        if (fromFactory == null) {
            return null;
        }
        if (fromFactory instanceof IPackageFragment) {
            return (IPackageFragment)fromFactory;
        }
        if (!(fromFactory instanceof IJavaProject)) return null;
        JavaProject project = (JavaProject)fromFactory;
        try {
            IClasspathEntry entry = project.getClasspathEntryFor(path);
            if (entry == null) return null;
            IPackageFragmentRoot root = project.getPackageFragmentRoot(project.getResource());
            IPackageFragment[] pkgs = (IPackageFragment[])this.fPackageFragments.get("");
            if (pkgs == null) {
                return null;
            }
            int i = 0;
            while (i < pkgs.length) {
                if (pkgs[i].getParent().equals(root)) {
                    return pkgs[i];
                }
                ++i;
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IPackageFragment[] findPackageFragments(String name, boolean partialMatch) {
        int count = this.fPackageFragmentRoots.length;
        if (partialMatch) {
            name = name.toLowerCase();
            int i = 0;
            while (i < count) {
                block11: {
                    IPackageFragmentRoot root = this.fPackageFragmentRoots[i];
                    IJavaElement[] list = null;
                    try {
                        list = root.getChildren();
                    }
                    catch (JavaModelException javaModelException) {
                        break block11;
                    }
                    int elementCount = list.length;
                    IPackageFragment[] result = new IPackageFragment[elementCount];
                    int resultLength = 0;
                    int j = 0;
                    while (j < elementCount) {
                        IPackageFragment packageFragment = (IPackageFragment)list[j];
                        if (this.nameMatches(name, packageFragment, true)) {
                            result[resultLength++] = packageFragment;
                        }
                        ++j;
                    }
                    if (resultLength > 0) {
                        IPackageFragment[] iPackageFragmentArray = result;
                        result = new IPackageFragment[resultLength];
                        System.arraycopy(iPackageFragmentArray, 0, result, 0, resultLength);
                        return result;
                    }
                    return null;
                }
                ++i;
            }
        } else {
            IPackageFragment[] fragments = (IPackageFragment[])this.fPackageFragments.get(name);
            if (fragments != null) {
                IPackageFragment[] result = new IPackageFragment[fragments.length];
                int resultLength = 0;
                int i = 0;
                while (i < fragments.length) {
                    IPackageFragment packageFragment = fragments[i];
                    result[resultLength++] = packageFragment;
                    ++i;
                }
                if (resultLength > 0) {
                    IPackageFragment[] iPackageFragmentArray = result;
                    result = new IPackageFragment[resultLength];
                    System.arraycopy(iPackageFragmentArray, 0, result, 0, resultLength);
                    return result;
                }
                return null;
            }
        }
        return null;
    }

    public IType findType(String typeName, String packageName, boolean partialMatch, int acceptFlags) {
        if (packageName == null) {
            packageName = "";
        }
        JavaElementRequestor elementRequestor = new JavaElementRequestor();
        this.seekPackageFragments(packageName, false, elementRequestor);
        IPackageFragment[] packages = elementRequestor.getPackageFragments();
        int i = 0;
        int length = packages.length;
        while (i < length) {
            IType type = this.findType(typeName, packages[i], partialMatch, acceptFlags);
            if (type != null) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private IPackageFragment[] getPackageFragmentsInRoots(IPackageFragmentRoot[] roots, IJavaProject project) {
        ArrayList<IJavaElement> frags = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            try {
                IJavaElement[] children = root.getChildren();
                int length = children.length;
                if (length != 0) {
                    int j;
                    if (children[0].getParent().getParent().equals(project)) {
                        j = 0;
                        while (j < length) {
                            frags.add(children[j]);
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < length) {
                            frags.add(root.getPackageFragment(children[j].getElementName()));
                            ++j;
                        }
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        IPackageFragment[] fragments = new IPackageFragment[frags.size()];
        frags.toArray(fragments);
        return fragments;
    }

    public IType findType(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags) {
        if (pkg == null) {
            return null;
        }
        return null;
    }

    public IType findType(String name, boolean partialMatch, int acceptFlags) {
        int index = name.lastIndexOf(46);
        String className = null;
        String packageName = null;
        if (index == -1) {
            packageName = "";
            className = name;
        } else {
            packageName = name.substring(0, index);
            className = name.substring(index + 1);
        }
        return this.findType(className, packageName, partialMatch, acceptFlags);
    }

    protected boolean nameMatches(String searchName, IJavaElement element, boolean partialMatch) {
        if (partialMatch) {
            return element.getElementName().toLowerCase().startsWith(searchName);
        }
        return element.getElementName().equals(searchName);
    }

    public void seekPackageFragments(String name, boolean partialMatch, IJavaElementRequestor requestor) {
        int count = this.fPackageFragmentRoots.length;
        String matchName = partialMatch ? name.toLowerCase() : name;
        int i = 0;
        while (i < count) {
            block7: {
                if (requestor.isCanceled()) {
                    return;
                }
                IPackageFragmentRoot root = this.fPackageFragmentRoots[i];
                IJavaElement[] list = null;
                try {
                    list = root.getChildren();
                }
                catch (JavaModelException javaModelException) {
                    break block7;
                }
                int elementCount = list.length;
                int j = 0;
                while (j < elementCount) {
                    if (requestor.isCanceled()) {
                        return;
                    }
                    IPackageFragment packageFragment = (IPackageFragment)list[j];
                    if (this.nameMatches(matchName, packageFragment, partialMatch)) {
                        requestor.acceptPackageFragment(packageFragment);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void seekTypes(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        String matchName;
        String string = matchName = partialMatch ? name.toLowerCase() : name;
        if (matchName.indexOf(46) >= 0) {
            matchName = matchName.replace('.', '$');
        }
        if (pkg == null) {
            this.findAllTypes(matchName, partialMatch, acceptFlags, requestor);
            return;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
        try {
            int packageFlavor = root.getKind();
            switch (packageFlavor) {
                case 1: {
                    this.seekTypesInSourcePackage(matchName, pkg, partialMatch, acceptFlags, requestor);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            return;
        }
    }

    protected void seekTypesInSourcePackage(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        ICompilationUnit[] compilationUnits = null;
        try {
            compilationUnits = pkg.getCompilationUnits();
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        int length = compilationUnits.length;
        String matchName = name;
        int index = name.indexOf(36);
        boolean potentialMemberType = false;
        String potentialMatchName = null;
        if (index != -1) {
            potentialMatchName = name.substring(0, index);
            potentialMemberType = true;
        }
        String unitName = partialMatch ? matchName.toLowerCase() : String.valueOf(matchName) + ".java";
        String potentialUnitName = null;
        if (potentialMemberType) {
            potentialUnitName = partialMatch ? potentialMatchName.toLowerCase() : String.valueOf(potentialMatchName) + ".java";
        }
        int i = 0;
        while (i < length) {
            block20: {
                IType type;
                int j;
                int typeLength;
                IType[] types;
                if (requestor.isCanceled()) {
                    return;
                }
                ICompilationUnit compilationUnit = compilationUnits[i];
                ICompilationUnit unitToLookInside = null;
                Map workingCopies = (Map)this.unitsToLookInside.getCurrent();
                if (workingCopies != null && (unitToLookInside = (ICompilationUnit)workingCopies.get(compilationUnit)) != null) {
                    compilationUnit = unitToLookInside;
                }
                if (unitToLookInside != null && !potentialMemberType || this.nameMatches(unitName, compilationUnit, partialMatch)) {
                    types = null;
                    try {
                        types = compilationUnit.getTypes();
                    }
                    catch (JavaModelException javaModelException) {
                        break block20;
                    }
                    typeLength = types.length;
                    j = 0;
                    while (j < typeLength) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        type = types[j];
                        if (this.nameMatches(matchName, type, partialMatch) && this.acceptType(type, acceptFlags)) {
                            requestor.acceptType(type);
                        }
                        ++j;
                    }
                } else if (potentialMemberType && this.nameMatches(potentialUnitName, compilationUnit, partialMatch)) {
                    types = null;
                    try {
                        types = compilationUnit.getTypes();
                    }
                    catch (JavaModelException javaModelException) {
                        break block20;
                    }
                    typeLength = types.length;
                    j = 0;
                    while (j < typeLength) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        type = types[j];
                        if (this.nameMatches(potentialMatchName, type, partialMatch)) {
                            this.seekQualifiedMemberTypes(name.substring(index + 1, name.length()), type, partialMatch, requestor, acceptFlags);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public void setUnitsToLookInside(IWorkingCopy[] unitsToLookInside) {
        if (unitsToLookInside == null) {
            this.unitsToLookInside.setCurrent(null);
        } else {
            HashMap<IWorkingCopy, IWorkingCopy> workingCopies = new HashMap<IWorkingCopy, IWorkingCopy>();
            this.unitsToLookInside.setCurrent(workingCopies);
            int i = 0;
            int length = unitsToLookInside.length;
            while (i < length) {
                IWorkingCopy unitToLookInside = unitsToLookInside[i];
                ICompilationUnit original = (ICompilationUnit)unitToLookInside.getOriginalElement();
                if (original != null) {
                    workingCopies.put(original, unitToLookInside);
                } else {
                    workingCopies.put(unitToLookInside, unitToLookInside);
                }
                ++i;
            }
        }
    }

    protected void seekQualifiedMemberTypes(String qualifiedName, IType type, boolean partialMatch, IJavaElementRequestor requestor, int acceptFlags) {
        if (type == null) {
            return;
        }
        IType[] types = null;
        try {
            types = type.getTypes();
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        String matchName = qualifiedName;
        int index = qualifiedName.indexOf(36);
        boolean nested = false;
        if (index != -1) {
            matchName = qualifiedName.substring(0, index);
            nested = true;
        }
        int length = types.length;
        int i = 0;
        while (i < length) {
            if (requestor.isCanceled()) {
                return;
            }
            IType memberType = types[i];
            if (this.nameMatches(matchName, memberType, partialMatch)) {
                if (nested) {
                    this.seekQualifiedMemberTypes(qualifiedName.substring(index + 1, qualifiedName.length()), memberType, partialMatch, requestor, acceptFlags);
                } else if (this.acceptType(memberType, acceptFlags)) {
                    requestor.acceptMemberType(memberType);
                }
            }
            ++i;
        }
    }
}

