/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core.builder;

import java.util.ArrayList;
import net.sourceforge.phpdt.core.compiler.IProblem;
import net.sourceforge.phpdt.internal.compiler.CompilationResult;
import net.sourceforge.phpdt.internal.compiler.problem.ProblemHandler;
import net.sourceforge.phpdt.internal.compiler.util.Util;
import net.sourceforge.phpdt.internal.core.builder.AbortIncrementalBuildException;
import net.sourceforge.phpdt.internal.core.builder.AbstractImageBuilder;
import net.sourceforge.phpdt.internal.core.builder.ClasspathMultiDirectory;
import net.sourceforge.phpdt.internal.core.builder.PHPBuilder;
import net.sourceforge.phpdt.internal.core.builder.ParserVisitor;
import net.sourceforge.phpdt.internal.core.builder.SourceFile;
import net.sourceforge.phpdt.internal.core.util.SimpleLookupTable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class IncrementalImageBuilder
extends AbstractImageBuilder {
    protected ArrayList sourceFiles;
    protected ArrayList previousSourceFiles;
    protected ArrayList qualifiedStrings;
    protected ArrayList simpleStrings;
    protected SimpleLookupTable secondaryTypesToRemove;
    protected boolean hasStructuralChanges;
    protected int compileLoop;
    public static int MaxCompileLoop = 5;

    protected IncrementalImageBuilder(PHPBuilder javaBuilder) {
        super(javaBuilder);
        this.nameEnvironment.isIncrementalBuild = true;
        this.newState.copyFrom(javaBuilder.lastState);
        this.sourceFiles = new ArrayList(33);
        this.previousSourceFiles = null;
        this.qualifiedStrings = new ArrayList(33);
        this.simpleStrings = new ArrayList(33);
        this.hasStructuralChanges = false;
        this.compileLoop = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean build(SimpleLookupTable deltas) {
        block16: {
            block17: {
                if (PHPBuilder.DEBUG) {
                    System.out.println("INCREMENTAL build");
                }
                try {
                    block15: {
                        try {
                            this.resetCollections();
                            this.notifier.subTask(net.sourceforge.phpdt.internal.core.util.Util.bind("build.analyzingDeltas"));
                            IResourceDelta sourceDelta = (IResourceDelta)deltas.get(this.javaBuilder.currentProject);
                            if (sourceDelta != null) {
                                sourceDelta.accept((IResourceDeltaVisitor)new ParserVisitor(this.javaBuilder.currentProject, this.notifier.monitor));
                                if (!this.findSourceFiles(sourceDelta)) {
                                    Object var5_5 = null;
                                    break block15;
                                }
                            }
                            this.notifier.updateProgressDelta(0.1f);
                            this.notifier.updateProgressDelta(0.1f);
                            this.notifier.subTask(net.sourceforge.phpdt.internal.core.util.Util.bind("build.analyzingSources"));
                            this.addAffectedSourceFiles();
                            this.notifier.updateProgressDelta(0.05f);
                            this.compileLoop = 0;
                            float increment = 0.4f;
                            while (true) {
                                if (this.sourceFiles.size() <= 0) {
                                    if (this.hasStructuralChanges && this.javaBuilder.javaProject.hasCycleMarker()) {
                                        this.javaBuilder.mustPropagateStructuralChanges();
                                    }
                                    break block16;
                                }
                                if (++this.compileLoop > MaxCompileLoop) {
                                    if (PHPBuilder.DEBUG) {
                                        System.out.println("ABORTING incremental build... exceeded loop count");
                                    }
                                    break block17;
                                }
                                this.notifier.checkCancel();
                                SourceFile[] allSourceFiles = new SourceFile[this.sourceFiles.size()];
                                this.sourceFiles.toArray(allSourceFiles);
                                this.resetCollections();
                                this.workQueue.addAll(allSourceFiles);
                                this.notifier.setProgressPerCompilationUnit(increment / (float)allSourceFiles.length);
                                increment /= 2.0f;
                                this.compile(allSourceFiles);
                                this.addAffectedSourceFiles();
                            }
                        }
                        catch (AbortIncrementalBuildException e) {
                            if (PHPBuilder.DEBUG) {
                                System.out.println("ABORTING incremental build... cannot find " + e.qualifiedTypeName + ". Could have been renamed inside its existing source file.");
                            }
                            Object var5_7 = null;
                            this.cleanUp();
                            return false;
                        }
                        catch (CoreException e) {
                            throw this.internalException(e);
                        }
                    }
                    this.cleanUp();
                    return false;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    this.cleanUp();
                    throw throwable;
                }
            }
            Object var5_6 = null;
            this.cleanUp();
            return false;
        }
        Object var5_9 = null;
        this.cleanUp();
        return true;
    }

    protected void addAffectedSourceFiles() {
        if (this.qualifiedStrings.isEmpty() && this.simpleStrings.isEmpty()) {
            return;
        }
    }

    protected void addDependentsOf(IPath path, boolean hasStructuralChanges) {
        String typeName;
        int memberIndex;
        String packageName;
        if (hasStructuralChanges) {
            this.newState.tagAsStructurallyChanged();
            this.hasStructuralChanges = true;
        }
        if (!this.qualifiedStrings.contains(packageName = (path = path.setDevice(null)).removeLastSegments(1).toString())) {
            this.qualifiedStrings.add(packageName);
        }
        if ((memberIndex = (typeName = path.lastSegment()).indexOf(36)) > 0) {
            typeName = typeName.substring(0, memberIndex);
        }
        if (!this.simpleStrings.contains(typeName)) {
            if (PHPBuilder.DEBUG) {
                System.out.println("  will look for dependents of " + typeName + " in " + packageName);
            }
            this.simpleStrings.add(typeName);
        }
    }

    protected void cleanUp() {
        super.cleanUp();
        this.sourceFiles = null;
        this.previousSourceFiles = null;
        this.qualifiedStrings = null;
        this.simpleStrings = null;
        this.secondaryTypesToRemove = null;
        this.hasStructuralChanges = false;
        this.compileLoop = 0;
    }

    /*
     * Unable to fully structure code
     */
    protected void findAffectedSourceFiles(IResourceDelta binaryDelta, int segmentCount) {
        resource = binaryDelta.getResource();
        switch (resource.getType()) {
            case 2: {
                switch (binaryDelta.getKind()) {
                    case 1: 
                    case 2: {
                        packagePath = resource.getFullPath().removeFirstSegments(segmentCount);
                        packageName = packagePath.toString();
                        if (binaryDelta.getKind() != 1) ** GOTO lbl12
                        if (PHPBuilder.DEBUG) {
                            System.out.println("Skipped dependents of added package " + packageName);
                        }
                        ** GOTO lbl14
lbl12:
                        // 1 sources

                        if (PHPBuilder.DEBUG) {
                            System.out.println("Skipped dependents of removed package " + packageName);
                        }
                    }
lbl14:
                    // 5 sources

                    case 4: {
                        children = binaryDelta.getAffectedChildren();
                        i = 0;
                        l = children.length;
                        while (i < l) {
                            this.findAffectedSourceFiles(children[i], segmentCount);
                            ++i;
                        }
                        break;
                    }
                }
                return;
            }
        }
    }

    protected boolean findSourceFiles(IResourceDelta delta) throws CoreException {
        int i = 0;
        int l = this.sourceLocations.length;
        while (i < l) {
            ClasspathMultiDirectory md = this.sourceLocations[i];
            if (md.sourceFolder.equals((Object)this.javaBuilder.currentProject)) {
                int segmentCount = delta.getFullPath().segmentCount();
                IResourceDelta[] children = delta.getAffectedChildren();
                int j = 0;
                int m = children.length;
                while (j < m) {
                    if (!this.isExcludedFromProject(children[j].getFullPath())) {
                        this.findSourceFiles(children[j], md, segmentCount);
                    }
                    ++j;
                }
            } else {
                IResourceDelta sourceDelta = delta.findMember(md.sourceFolder.getProjectRelativePath());
                if (sourceDelta != null) {
                    if (sourceDelta.getKind() == 2) {
                        if (PHPBuilder.DEBUG) {
                            System.out.println("ABORTING incremental build... found removed source folder");
                        }
                        return false;
                    }
                    int segmentCount = sourceDelta.getFullPath().segmentCount();
                    IResourceDelta[] children = sourceDelta.getAffectedChildren();
                    int j = 0;
                    int m = children.length;
                    while (j < m) {
                        this.findSourceFiles(children[j], md, segmentCount);
                        ++j;
                    }
                }
            }
            this.notifier.checkCancel();
            ++i;
        }
        return true;
    }

    protected void findSourceFiles(IResourceDelta sourceDelta, ClasspathMultiDirectory md, int segmentCount) throws CoreException {
        IResource resource = sourceDelta.getResource();
        if (md.exclusionPatterns != null && net.sourceforge.phpdt.internal.core.util.Util.isExcluded(resource, md.exclusionPatterns)) {
            return;
        }
        switch (resource.getType()) {
            case 2: {
                switch (sourceDelta.getKind()) {
                    case 1: {
                        IPath addedPackagePath = resource.getFullPath().removeFirstSegments(segmentCount);
                        if (PHPBuilder.DEBUG) {
                            System.out.println("Found added package " + addedPackagePath);
                        }
                        this.addDependentsOf(addedPackagePath, true);
                    }
                    case 4: {
                        IResourceDelta[] children = sourceDelta.getAffectedChildren();
                        int i = 0;
                        int l = children.length;
                        while (i < l) {
                            this.findSourceFiles(children[i], md, segmentCount);
                            ++i;
                        }
                        return;
                    }
                    case 2: {
                        IPath removedPackagePath = resource.getFullPath().removeFirstSegments(segmentCount);
                        if (this.sourceLocations.length > 1) {
                            int i = 0;
                            int l = this.sourceLocations.length;
                            while (i < l) {
                                if (this.sourceLocations[i].sourceFolder.getFolder(removedPackagePath).exists()) {
                                    IResourceDelta[] removedChildren = sourceDelta.getAffectedChildren();
                                    int j = 0;
                                    int m = removedChildren.length;
                                    while (j < m) {
                                        this.findSourceFiles(removedChildren[j], md, segmentCount);
                                        ++j;
                                    }
                                    return;
                                }
                                ++i;
                            }
                        }
                        if (PHPBuilder.DEBUG) {
                            System.out.println("Found removed package " + removedPackagePath);
                        }
                        this.addDependentsOf(removedPackagePath, true);
                        this.newState.removePackage(sourceDelta);
                    }
                }
                return;
            }
            case 1: {
                String resourceName = resource.getName();
                if (Util.isJavaFileName(resourceName)) {
                    IPath typePath = resource.getFullPath().removeFirstSegments(segmentCount).removeFileExtension();
                    String typeLocator = resource.getProjectRelativePath().toString();
                    switch (sourceDelta.getKind()) {
                        case 1: {
                            if (PHPBuilder.DEBUG) {
                                System.out.println("Compile this added source file " + typeLocator);
                            }
                            this.sourceFiles.add(new SourceFile((IFile)resource, md, this.encoding));
                            typePath.toString();
                            return;
                        }
                        case 2: {
                            if (PHPBuilder.DEBUG) {
                                System.out.println("Found removed source file " + typePath.toString());
                            }
                            this.addDependentsOf(typePath, true);
                            return;
                        }
                        case 4: {
                            if ((sourceDelta.getFlags() & 0x100) == 0) {
                                return;
                            }
                            if (PHPBuilder.DEBUG) {
                                System.out.println("Compile this changed source file " + typeLocator);
                            }
                            this.sourceFiles.add(new SourceFile((IFile)resource, md, this.encoding));
                        }
                    }
                    return;
                }
                if (!md.hasIndependentOutputFolder) break;
                if (this.javaBuilder.filterExtraResource(resource)) {
                    return;
                }
                IPath resourcePath = resource.getFullPath().removeFirstSegments(segmentCount);
                switch (sourceDelta.getKind()) {
                    case 1: {
                        if (PHPBuilder.DEBUG) {
                            System.out.println("Copying added file " + resourcePath);
                        }
                        return;
                    }
                    case 2: {
                        return;
                    }
                    case 4: {
                        if ((sourceDelta.getFlags() & 0x100) == 0) {
                            return;
                        }
                        if (!PHPBuilder.DEBUG) break;
                        System.out.println("Copying changed file " + resourcePath);
                    }
                }
                return;
            }
        }
    }

    protected void finishedWith(String sourceLocator, CompilationResult result, char[] mainTypeName, ArrayList definedTypeNames, ArrayList duplicateTypeNames) throws CoreException {
    }

    protected void resetCollections() {
        this.previousSourceFiles = this.sourceFiles.isEmpty() ? null : (ArrayList)this.sourceFiles.clone();
        this.sourceFiles.clear();
        this.qualifiedStrings.clear();
        this.simpleStrings.clear();
        this.workQueue.clear();
    }

    protected void updateProblemsFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        IMarker[] markers = PHPBuilder.getProblemsFor((IResource)sourceFile.resource);
        IProblem[] problems = result.getProblems();
        if (problems == null && markers.length == 0) {
            return;
        }
        if (problems != null) {
            int i = 0;
            while (i < problems.length) {
                if (problems[i].getSourceLineNumber() == 1) {
                    problems[i].setSourceLineNumber(ProblemHandler.searchLineNumber(result.lineSeparatorPositions, problems[i].getSourceStart()));
                }
                ++i;
            }
        }
        this.notifier.updateProblemCounts(markers, problems);
        PHPBuilder.removeProblemsFor((IResource)sourceFile.resource);
        this.storeProblemsFor(sourceFile, problems);
    }

    protected void updateTasksFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        IMarker[] markers = PHPBuilder.getTasksFor((IResource)sourceFile.resource);
        IProblem[] tasks = result.getTasks();
        if (tasks == null && markers.length == 0) {
            return;
        }
        PHPBuilder.removeTasksFor((IResource)sourceFile.resource);
        this.storeTasksFor(sourceFile, tasks);
    }

    public String toString() {
        return "incremental image builder for:\n\tnew state: " + this.newState;
    }
}

