/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core.jdom;

import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.jdom.IDOMImport;
import net.sourceforge.phpdt.internal.compiler.util.Util;
import net.sourceforge.phpdt.internal.core.jdom.DOMNode;
import net.sourceforge.phpdt.internal.core.util.CharArrayBuffer;

class DOMImport
extends DOMNode
implements IDOMImport {
    protected boolean fOnDemand;

    DOMImport() {
        this.fName = "java.lang.*";
        this.setMask(2048, true);
    }

    DOMImport(char[] document, int[] sourceRange, String name, int[] nameRange, boolean onDemand) {
        super(document, sourceRange, name, nameRange);
        this.fOnDemand = onDemand;
        this.setMask(2048, true);
    }

    DOMImport(char[] document, int[] sourceRange, String name, boolean onDemand) {
        this(document, sourceRange, name, new int[]{-1, -1}, onDemand);
        this.fOnDemand = onDemand;
        this.setMask(2048, false);
    }

    protected void appendFragmentedContents(CharArrayBuffer buffer) {
        if (this.fNameRange[0] < 0) {
            buffer.append("include ").append(this.fName).append(';').append(Util.LINE_SEPARATOR);
        } else {
            buffer.append(this.fDocument, this.fSourceRange[0], this.fNameRange[0] - this.fSourceRange[0]);
            buffer.append(this.fName);
            buffer.append(this.fDocument, this.fNameRange[1] + 1, this.fSourceRange[1] - this.fNameRange[1]);
        }
    }

    public String getContents() {
        if (this.fName == null) {
            return null;
        }
        return super.getContents();
    }

    public IJavaElement getJavaElement(IJavaElement parent) throws IllegalArgumentException {
        throw new IllegalArgumentException(Util.bind("element.illegalParent"));
    }

    public int getNodeType() {
        return 3;
    }

    public boolean isOnDemand() {
        return this.fOnDemand;
    }

    protected DOMNode newDOMNode() {
        return new DOMImport();
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(Util.bind("element.nullName"));
        }
        this.becomeDetailed();
        super.setName(name);
        this.fOnDemand = name.endsWith(".*");
    }

    public String toString() {
        return "IMPORT: " + this.getName();
    }
}

