/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core.util;

public class CharArrayBuffer {
    protected char[][] fBuffer;
    public static final int DEFAULT_BUFFER_SIZE = 10;
    protected int fEnd;
    protected int fSize;
    protected int[][] fRanges;

    public CharArrayBuffer() {
        this(null, 10);
    }

    public CharArrayBuffer(char[] first) {
        this(first, 10);
    }

    public CharArrayBuffer(char[] first, int size) {
        this.fSize = size > 0 ? size : 10;
        this.fBuffer = new char[this.fSize][];
        this.fRanges = new int[this.fSize][];
        this.fEnd = 0;
        if (first != null) {
            this.append(first, 0, first.length);
        }
    }

    public CharArrayBuffer(int size) {
        this(null, size);
    }

    public CharArrayBuffer append(char[] src) {
        if (src != null) {
            this.append(src, 0, src.length);
        }
        return this;
    }

    public CharArrayBuffer append(char[] src, int start, int length) {
        if (start < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (src != null) {
            int srcLength = src.length;
            if (start > srcLength) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (length + start > srcLength) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (length > 0) {
                if (this.fEnd == this.fSize) {
                    int size2 = this.fSize * 2;
                    this.fBuffer = new char[size2][];
                    System.arraycopy(this.fBuffer, 0, this.fBuffer, 0, this.fSize);
                    this.fRanges = new int[size2][];
                    System.arraycopy(this.fRanges, 0, this.fRanges, 0, this.fSize);
                    this.fSize *= 2;
                }
                this.fBuffer[this.fEnd] = src;
                this.fRanges[this.fEnd] = new int[]{start, length};
                ++this.fEnd;
            }
        }
        return this;
    }

    public CharArrayBuffer append(char c) {
        this.append(new char[]{c}, 0, 1);
        return this;
    }

    public CharArrayBuffer append(String src) {
        if (src != null) {
            this.append(src.toCharArray(), 0, src.length());
        }
        return this;
    }

    public char[] getContents() {
        if (this.fEnd == 0) {
            return null;
        }
        int size = 0;
        int i = 0;
        while (i < this.fEnd) {
            size += this.fRanges[i][1];
            ++i;
        }
        if (size > 0) {
            char[] result = new char[size];
            int current = 0;
            int i2 = 0;
            while (i2 < this.fEnd) {
                int[] range = this.fRanges[i2];
                int length = range[1];
                System.arraycopy(this.fBuffer[i2], range[0], result, current, length);
                current += length;
                ++i2;
            }
            return result;
        }
        return null;
    }

    public String toString() {
        char[] contents = this.getContents();
        return contents != null ? new String(contents) : null;
    }
}

