/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.codemanipulation;

import net.sourceforge.phpdt.core.Flags;
import net.sourceforge.phpdt.core.IField;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.IMethod;
import net.sourceforge.phpdt.core.IType;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.NamingConventions;
import net.sourceforge.phpdt.core.Signature;
import net.sourceforge.phpdt.internal.corext.codemanipulation.StubUtility;
import net.sourceforge.phpdt.internal.corext.util.JavaModelUtil;
import net.sourceforge.phpdt.internal.corext.util.JdtFlags;
import net.sourceforge.phpdt.ui.CodeGeneration;
import net.sourceforge.phpdt.ui.PreferenceConstants;
import org.eclipse.core.runtime.CoreException;

public class GetterSetterUtil {
    private static final String[] EMPTY = new String[0];

    private GetterSetterUtil() {
    }

    public static String getGetterName(IField field, String[] excludedNames) throws JavaModelException {
        boolean useIs = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.gettersetter.use.is");
        return GetterSetterUtil.getGetterName(field, excludedNames, useIs);
    }

    private static String getGetterName(IField field, String[] excludedNames, boolean useIsForBoolGetters) throws JavaModelException {
        if (excludedNames == null) {
            excludedNames = EMPTY;
        }
        return GetterSetterUtil.getGetterName(field.getJavaProject(), field.getElementName(), field.getFlags(), useIsForBoolGetters && JavaModelUtil.isBoolean(field), excludedNames);
    }

    public static String getGetterName(IJavaProject project, String fieldName, int flags, boolean isBoolean, String[] excludedNames) {
        return NamingConventions.suggestGetterName(project, fieldName, flags, isBoolean, excludedNames);
    }

    public static String getSetterName(IJavaProject project, String fieldName, int flags, boolean isBoolean, String[] excludedNames) {
        return NamingConventions.suggestSetterName(project, fieldName, flags, isBoolean, excludedNames);
    }

    public static String getSetterName(IField field, String[] excludedNames) throws JavaModelException {
        if (excludedNames == null) {
            excludedNames = EMPTY;
        }
        return NamingConventions.suggestSetterName(field.getJavaProject(), field.getElementName(), field.getFlags(), JavaModelUtil.isBoolean(field), excludedNames);
    }

    public static IMethod getGetter(IField field) throws JavaModelException {
        IMethod primaryCandidate = JavaModelUtil.findMethod(GetterSetterUtil.getGetterName(field, EMPTY, true), new String[0], false, field.getDeclaringType());
        if (!JavaModelUtil.isBoolean(field) || primaryCandidate != null && primaryCandidate.exists()) {
            return primaryCandidate;
        }
        String secondCandidateName = GetterSetterUtil.getGetterName(field, EMPTY, false);
        return JavaModelUtil.findMethod(secondCandidateName, new String[0], false, field.getDeclaringType());
    }

    public static IMethod getSetter(IField field) throws JavaModelException {
        String[] args = new String[]{field.getTypeSignature()};
        return JavaModelUtil.findMethod(GetterSetterUtil.getSetterName(field, EMPTY), args, false, field.getDeclaringType());
    }

    public static String getSetterStub(IField field, String setterName, boolean addComments, int flags) throws CoreException {
        String body;
        String comment;
        String fieldName = field.getElementName();
        IType parentType = field.getDeclaringType();
        String returnSig = field.getTypeSignature();
        String typeName = Signature.toString(returnSig);
        IJavaProject project = field.getJavaProject();
        String accessorName = NamingConventions.removePrefixAndSuffixForFieldName(project, fieldName, field.getFlags());
        String argname = StubUtility.suggestArgumentName(project, accessorName, EMPTY);
        boolean isStatic = Flags.isStatic(flags);
        boolean isFinal = Flags.isFinal(flags);
        StringBuffer buf = new StringBuffer();
        if (addComments && (comment = CodeGeneration.getSetterComment(field.getCompilationUnit(), parentType.getTypeQualifiedName('.'), setterName, field.getElementName(), typeName, argname, accessorName, String.valueOf('\n'))) != null) {
            buf.append(comment);
            buf.append('\n');
        }
        buf.append(JdtFlags.getVisibilityString(flags));
        buf.append(' ');
        if (isStatic) {
            buf.append("static ");
        }
        if (isFinal) {
            buf.append("final ");
        }
        buf.append("void ");
        buf.append(setterName);
        buf.append('(');
        buf.append(typeName);
        buf.append(' ');
        buf.append(argname);
        buf.append(") {\n");
        boolean useThis = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.keywordthis");
        if (argname.equals(fieldName) || useThis && !isStatic) {
            fieldName = isStatic ? String.valueOf(parentType.getElementName()) + '.' + fieldName : "this." + fieldName;
        }
        if ((body = CodeGeneration.getSetterMethodBodyContent(field.getCompilationUnit(), parentType.getTypeQualifiedName('.'), setterName, fieldName, argname, String.valueOf('\n'))) != null) {
            buf.append(body);
        }
        buf.append("}\n");
        return buf.toString();
    }

    public static String getGetterStub(IField field, String getterName, boolean addComments, int flags) throws CoreException {
        String body;
        String comment;
        String fieldName = field.getElementName();
        IType parentType = field.getDeclaringType();
        boolean isStatic = Flags.isStatic(flags);
        boolean isFinal = Flags.isFinal(flags);
        String typeName = Signature.toString(field.getTypeSignature());
        String accessorName = NamingConventions.removePrefixAndSuffixForFieldName(field.getJavaProject(), fieldName, field.getFlags());
        StringBuffer buf = new StringBuffer();
        if (addComments && (comment = CodeGeneration.getGetterComment(field.getCompilationUnit(), parentType.getTypeQualifiedName('.'), getterName, field.getElementName(), typeName, accessorName, String.valueOf('\n'))) != null) {
            buf.append(comment);
            buf.append('\n');
        }
        buf.append(JdtFlags.getVisibilityString(flags));
        buf.append(' ');
        if (isStatic) {
            buf.append("static ");
        }
        if (isFinal) {
            buf.append("final ");
        }
        buf.append(typeName);
        buf.append(' ');
        buf.append(getterName);
        buf.append("() {\n");
        boolean useThis = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.keywordthis");
        if (useThis && !isStatic) {
            fieldName = "this." + fieldName;
        }
        if ((body = CodeGeneration.getGetterMethodBodyContent(field.getCompilationUnit(), parentType.getTypeQualifiedName('.'), getterName, fieldName, String.valueOf('\n'))) != null) {
            buf.append(body);
        }
        buf.append("}\n");
        return buf.toString();
    }
}

