/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.phpdoc;

import net.sourceforge.phpdt.internal.corext.phpdoc.SingleCharReader;
import net.sourceforge.phpdt.internal.corext.util.Strings;

public class PHPDocCharArrayCommentReader
extends SingleCharReader {
    private char[] fCharArray;
    private int fCurrPos;
    private int fStartPos;
    private int fEndPos;
    private boolean fWasNewLine;

    public PHPDocCharArrayCommentReader(char[] buf) {
        this(buf, 0, buf.length);
    }

    public PHPDocCharArrayCommentReader(char[] buf, int start, int end) {
        this.fCharArray = buf;
        this.fStartPos = start + 3;
        this.fEndPos = end - 2;
        this.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() {
        char ch;
        if (this.fCurrPos >= this.fEndPos) return -1;
        if (this.fWasNewLine) {
            do {
                ch = this.fCharArray[this.fCurrPos++];
            } while (this.fCurrPos < this.fEndPos && Character.isWhitespace(ch));
            if (ch == '*') {
                if (this.fCurrPos >= this.fEndPos) return -1;
                while ((ch = this.fCharArray[this.fCurrPos++]) == '*') {
                }
            }
        } else {
            ch = this.fCharArray[this.fCurrPos++];
        }
        this.fWasNewLine = Strings.isLineDelimiterChar(ch);
        return ch;
    }

    public void close() {
        this.fCharArray = null;
    }

    public void reset() {
        this.fCurrPos = this.fStartPos;
        this.fWasNewLine = true;
    }
}

