/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.phpdoc;

import java.io.FileReader;
import java.io.IOException;
import net.sourceforge.phpdt.internal.corext.phpdoc.PHPDocCharArrayCommentReader;
import net.sourceforge.phpeclipse.builder.PHPIdentifierLocation;

public class PHPDocUtil {
    public static void appendPHPDoc(StringBuffer hoverInfoBuffer, String filename, PHPIdentifierLocation location) {
        hoverInfoBuffer.append(location.toString());
        hoverInfoBuffer.append(" - <b>");
        try {
            hoverInfoBuffer.append(PHPDocUtil.getUsage(filename, location));
            hoverInfoBuffer.append("</b><br>");
            if (location.getPHPDocOffset() >= 0) {
                FileReader phpFileReader = new FileReader(filename);
                char[] phpDocDeclarationCharArray = new char[location.getPHPDocLength()];
                phpFileReader.skip(location.getPHPDocOffset());
                phpFileReader.read(phpDocDeclarationCharArray, 0, location.getPHPDocLength());
                PHPDocCharArrayCommentReader phpdocConverter = new PHPDocCharArrayCommentReader(phpDocDeclarationCharArray);
                hoverInfoBuffer.append(phpdocConverter.getString());
                phpFileReader.close();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static String getUsage(String filename, PHPIdentifierLocation location) {
        String usage = location.getUsage();
        if (usage != null) {
            return usage;
        }
        usage = "";
        try {
            FileReader phpFileReader = new FileReader(filename);
            if (location.getOffset() >= 0 && (location.isMethod() || location.isConstructor() || location.isFunction() || location.isDefine())) {
                char[] functionDeclarationCharArray = new char[256];
                int offset = location.getOffset();
                phpFileReader.skip(offset);
                int length = phpFileReader.read(functionDeclarationCharArray, 0, 256);
                if (length == -1) {
                    length = 256;
                }
                int i = 0;
                while (i < length) {
                    if (functionDeclarationCharArray[i] == ')') {
                        length = i + 1;
                        break;
                    }
                    if (functionDeclarationCharArray[i] == '{' || functionDeclarationCharArray[i] == '}') {
                        length = i;
                        break;
                    }
                    ++i;
                }
                usage = new String(functionDeclarationCharArray, 0, length);
            }
            phpFileReader.close();
        }
        catch (IOException iOException) {}
        location.setUsage(usage);
        return usage;
    }
}

