/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.template.php;

import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.internal.corext.template.php.CompilationUnitContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;

public class HTMLUnitContext
extends CompilationUnitContext {
    private static final String specialChars = "&<#{";

    public HTMLUnitContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ICompilationUnit compilationUnit) {
        super(type, document, completionOffset, completionLength, compilationUnit);
    }

    public boolean canEvaluate(Template template) {
        String key = this.getKey();
        if (this.fForceEvaluation) {
            return true;
        }
        return template.matches(key, this.getContextType().getId()) && key.length() != 0 && template.getName().toLowerCase().startsWith(key.toLowerCase());
    }

    public int getStart() {
        IDocument document = this.getDocument();
        try {
            int start = this.getCompletionOffset();
            char ch = ' ';
            while (start != 0) {
                ch = document.getChar(start - 1);
                if (specialChars.indexOf(ch) != -1) {
                    return --start;
                }
                if (!Character.isUnicodeIdentifierPart(ch)) break;
                --start;
            }
            if (start != 0 && Character.isUnicodeIdentifierStart(document.getChar(start - 1)) && --start != 0 && specialChars.indexOf(document.getChar(start - 1)) != -1) {
                --start;
            }
            return start;
        }
        catch (BadLocationException badLocationException) {
            return this.getCompletionOffset();
        }
    }

    public int getEnd() {
        if (this.getCompletionLength() == 0) {
            return super.getEnd();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != end && Character.isWhitespace(document.getChar(end - 1))) {
                --end;
            }
            return end;
        }
        catch (BadLocationException badLocationException) {
            return super.getEnd();
        }
    }

    public String getKey() {
        if (this.getCompletionLength() == 0) {
            return super.getKey();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getStart();
            int end = this.getCompletionOffset();
            return start <= end ? document.get(start, end - start) : "";
        }
        catch (BadLocationException badLocationException) {
            return super.getKey();
        }
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        return buffer;
    }
}

