/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.textmanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.phpdt.internal.corext.textmanipulation.MultiTextEdit;
import net.sourceforge.phpdt.internal.corext.textmanipulation.TextBuffer;
import net.sourceforge.phpdt.internal.corext.textmanipulation.TextEdit;
import net.sourceforge.phpdt.internal.corext.textmanipulation.TextEditNode;
import net.sourceforge.phpdt.internal.corext.textmanipulation.TextEditNodeComparator;
import net.sourceforge.phpdt.internal.corext.textmanipulation.UndoMemento;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class TextBufferEditor {
    private TextBuffer fBuffer;
    private List fEdits;
    private TextEditNode.RootNode fRootNode;
    private int fNumberOfNodes;
    private int fConnectCount;
    private int fMode;
    static final int UNDEFINED = 0;
    static final int REDO = 1;
    static final int UNDO = 2;

    public TextBufferEditor(TextBuffer buffer) {
        this.fBuffer = buffer;
        this.fEdits = new ArrayList();
    }

    public TextBuffer getTextBuffer() {
        return this.fBuffer;
    }

    public void add(TextEdit edit) throws CoreException {
        this.internalAdd(edit);
        this.fMode = 1;
    }

    public void add(MultiTextEdit edit) throws CoreException {
        edit.connect(this);
        this.fMode = 1;
    }

    public void add(UndoMemento undo) throws CoreException {
        List list = undo.fEdits;
        int i = list.size() - 1;
        while (i >= 0) {
            this.internalAdd((TextEdit)list.get(i));
            --i;
        }
        this.fMode = undo.fMode;
    }

    public boolean canPerformEdits() {
        if (this.fRootNode != null) {
            return true;
        }
        this.fRootNode = this.buildTree();
        if (this.fRootNode == null) {
            return false;
        }
        if (this.fRootNode.validate(this.fBuffer.getLength())) {
            return true;
        }
        this.fRootNode = null;
        return false;
    }

    public void clear() {
        this.fRootNode = null;
        this.fMode = 0;
        this.fEdits.clear();
    }

    public UndoMemento performEdits(IProgressMonitor pm) throws CoreException {
        UndoMemento undoMemento;
        int size;
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        if ((size = this.fEdits.size()) == 0) {
            return new UndoMemento(this.fMode == 2 ? 1 : 2);
        }
        if (this.fRootNode == null) {
            this.fRootNode = this.buildTree();
            if (this.fRootNode != null) {
                this.fRootNode.validate(this.fBuffer.getLength());
            }
        }
        try {
            pm.beginTask("", this.fNumberOfNodes + 10);
            UndoMemento undo = null;
            if (this.fMode == 1) {
                undo = this.fRootNode.performDo(this.fBuffer, pm);
                this.fRootNode.performedDo();
            } else {
                undo = this.fRootNode.performUndo(this.fBuffer, pm);
                this.fRootNode.performedUndo();
            }
            pm.worked(10);
            undoMemento = undo;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            pm.done();
            this.clear();
            throw throwable;
        }
        pm.done();
        this.clear();
        return undoMemento;
    }

    private TextEditNode.RootNode buildTree() {
        TextEditNode[] nodes = new TextEditNode[this.fEdits.size()];
        int i = this.fEdits.size() - 1;
        while (i >= 0) {
            nodes[i] = TextEditNode.create((TextEdit)this.fEdits.get(i));
            --i;
        }
        this.fNumberOfNodes = nodes.length;
        Arrays.sort(nodes, new TextEditNodeComparator());
        TextEditNode.RootNode root = new TextEditNode.RootNode(this.fBuffer.getLength());
        int i2 = 0;
        while (i2 < nodes.length) {
            root.add(nodes[i2]);
            ++i2;
        }
        return root;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void internalAdd(TextEdit edit) throws CoreException {
        edit.index = this.fEdits.size();
        edit.isSynthetic = this.fConnectCount > 0;
        try {
            ++this.fConnectCount;
            edit.connect(this);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            --this.fConnectCount;
            throw throwable;
        }
        {
            Object var2_4 = null;
            --this.fConnectCount;
            this.fEdits.add(edit);
        }
    }
}

