/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.util;

import java.util.Map;
import net.sourceforge.phpdt.core.ToolFactory;
import net.sourceforge.phpdt.internal.corext.Assert;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatterUtil {
    public static String createIndentString(int indent) {
        String str = ToolFactory.createCodeFormatter().format("x", indent, null, "");
        return str.substring(0, str.indexOf(120));
    }

    public static int getTabWidth() {
        Preferences preferences = PHPeclipsePlugin.getDefault().getPluginPreferences();
        return preferences.getInt("net.sourceforge.phpeclipse.formatter.tabulation.size");
    }

    private static String getOldAPICompatibleResult(String string, TextEdit edit, int indentationLevel, int[] positions, String lineSeparator, Map options) {
        Position[] p = null;
        if (positions != null) {
            p = new Position[positions.length];
            int i = 0;
            while (i < positions.length) {
                p[i] = new Position(positions[i], 0);
                ++i;
            }
        }
        String res = CodeFormatterUtil.evaluateFormatterEdit(string, edit, p);
        if (positions != null) {
            int i = 0;
            while (i < positions.length) {
                Position curr = p[i];
                positions[i] = curr.getOffset();
                ++i;
            }
        }
        return res;
    }

    public static String evaluateFormatterEdit(String string, TextEdit edit, Position[] positions) {
        try {
            Document doc = CodeFormatterUtil.createDocument(string, positions);
            edit.apply((IDocument)doc, 0);
            if (positions != null) {
                int i = 0;
                while (i < positions.length) {
                    Assert.isTrue(!positions[i].isDeleted, "Position got deleted");
                    ++i;
                }
            }
            return doc.get();
        }
        catch (BadLocationException e) {
            PHPeclipsePlugin.log(e);
            Assert.isTrue(false, "Fromatter created edits with wrong positions: " + e.getMessage());
            return null;
        }
    }

    private static TextEdit shifEdit(TextEdit oldEdit, int diff) {
        MultiTextEdit newEdit;
        ReplaceEdit edit;
        if (oldEdit instanceof ReplaceEdit) {
            edit = (ReplaceEdit)oldEdit;
            newEdit = new ReplaceEdit(edit.getOffset() - diff, edit.getLength(), edit.getText());
        } else if (oldEdit instanceof InsertEdit) {
            edit = (InsertEdit)oldEdit;
            newEdit = new InsertEdit(edit.getOffset() - diff, edit.getText());
        } else if (oldEdit instanceof DeleteEdit) {
            edit = (DeleteEdit)oldEdit;
            newEdit = new DeleteEdit(edit.getOffset() - diff, edit.getLength());
        } else if (oldEdit instanceof MultiTextEdit) {
            newEdit = new MultiTextEdit();
        } else {
            return null;
        }
        TextEdit[] children = oldEdit.getChildren();
        int i = 0;
        while (i < children.length) {
            TextEdit shifted = CodeFormatterUtil.shifEdit(children[i], diff);
            if (shifted != null) {
                newEdit.addChild(shifted);
            }
            ++i;
        }
        return newEdit;
    }

    private static Document createDocument(String string, Position[] positions) throws IllegalArgumentException {
        Document doc;
        block5: {
            doc = new Document(string);
            try {
                if (positions == null) break block5;
                doc.addPositionCategory("myCategory");
                doc.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater("myCategory"){

                    protected boolean notDeleted() {
                        if (this.fOffset < this.fPosition.offset && this.fPosition.offset + this.fPosition.length < this.fOffset + this.fLength) {
                            this.fPosition.offset = this.fOffset + this.fLength;
                            return false;
                        }
                        return true;
                    }
                });
                int i = 0;
                while (i < positions.length) {
                    try {
                        doc.addPosition("myCategory", positions[i]);
                    }
                    catch (BadLocationException badLocationException) {
                        throw new IllegalArgumentException("Position outside of string. offset: " + positions[i].offset + ", length: " + positions[i].length + ", string size: " + string.length());
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
        return doc;
    }
}

