/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.formatter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.phpdt.core.ICodeFormatter;
import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.core.compiler.ITerminalSymbols;
import net.sourceforge.phpdt.core.compiler.InvalidInputException;
import net.sourceforge.phpdt.internal.compiler.ConfigurableOption;
import net.sourceforge.phpdt.internal.compiler.parser.Scanner;
import net.sourceforge.phpdt.internal.formatter.impl.FormatterOptions;
import net.sourceforge.phpdt.internal.formatter.impl.SplitLine;

public class CodeFormatter
implements ITerminalSymbols,
ICodeFormatter {
    public FormatterOptions options;
    public static final int BLOCK = 130;
    public static final int NONINDENT_BLOCK = -100;
    StringBuffer formattedSource;
    StringBuffer currentLineBuffer;
    Scanner scanner;
    private int[] constructions = new int[10];
    private int constructionsCount = 0;
    private int indentationLevel;
    private int initialIndentationLevel;
    Scanner splitScanner;
    int currentCommentOffset = -1;
    int currentLineIndentationLevel = this.indentationLevel = this.initialIndentationLevel;
    int maxLineSize = 30;
    private boolean containsOpenCloseBraces;
    private int indentationLevelForOpenCloseBraces;
    private int[] positionsToMap;
    private int[] mappedPositions;
    private int indexToMap;
    private int indexInMap;
    private int globalDelta;
    private int lineDelta;
    private int splitDelta;
    private int beginningOfLineIndex;
    private int multipleLineCommentCounter;
    static /* synthetic */ Class class$0;

    public CodeFormatter(ConfigurableOption[] settings) {
        this(CodeFormatter.convertConfigurableOptions(settings));
    }

    public CodeFormatter() {
        this((Map)null);
    }

    public CodeFormatter(Map settings) {
        this.scanner = new Scanner(true, true, false, false, true, null, null, true);
        this.scanner.recordLineSeparator = true;
        this.scanner.ignorePHPOneLiner = true;
        this.splitScanner = new Scanner(true, true, false, false, true, null, null, true);
        this.splitScanner.ignorePHPOneLiner = true;
        this.currentLineBuffer = new StringBuffer();
        this.options = new FormatterOptions(settings);
    }

    private static boolean breakLineBeforeOperator(int operator) {
        switch (operator) {
            case 49: 
            case 134: 
            case 140: {
                return false;
            }
        }
        return true;
    }

    private static Map convertConfigurableOptions(ConfigurableOption[] settings) {
        Hashtable<String, String> options = new Hashtable<String, String>(10);
        int i = 0;
        while (i < settings.length) {
            String string = settings[i].getComponentName();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("net.sourceforge.phpdt.internal.formatter.CodeFormatter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (string.equals(clazz.getName())) {
                String optionName = settings[i].getOptionName();
                int valueIndex = settings[i].getCurrentValueIndex();
                if (optionName.equals("newline.openingBrace")) {
                    options.put("net.sourceforge.phpdt.core.formatter.newline.openingBrace", valueIndex == 0 ? "insert" : "do not insert");
                } else if (optionName.equals("newline.controlStatement")) {
                    options.put("net.sourceforge.phpdt.core.formatter.newline.controlStatement", valueIndex == 0 ? "insert" : "do not insert");
                } else if (optionName.equals("newline.clearAll")) {
                    options.put("net.sourceforge.phpdt.core.formatter.newline.clearAll", valueIndex == 0 ? "clear all" : "preserve one");
                } else if (optionName.equals("newline.elseIf")) {
                    options.put("net.sourceforge.phpdt.core.formatter.newline.elseIf", valueIndex == 0 ? "do not insert" : "insert");
                } else if (optionName.equals("newline.emptyBlock")) {
                    options.put("net.sourceforge.phpdt.core.formatter.newline.emptyBlock", valueIndex == 0 ? "insert" : "do not insert");
                } else if (optionName.equals("lineSplit")) {
                    options.put("net.sourceforge.phpdt.core.formatter.lineSplit", String.valueOf(valueIndex));
                } else if (optionName.equals("style.assignment")) {
                    options.put("net.sourceforge.phpdt.core.formatter.style.assignment", valueIndex == 0 ? "compact" : "normal");
                } else if (optionName.equals("tabulation.char")) {
                    options.put("net.sourceforge.phpdt.core.formatter.tabulation.char", valueIndex == 0 ? "tab" : "space");
                } else if (optionName.equals("tabulation.size")) {
                    options.put("net.sourceforge.phpdt.core.formatter.tabulation.size", String.valueOf(valueIndex));
                }
            }
            ++i;
        }
        return options;
    }

    private final String copyRemainingSource() {
        char[] str = this.scanner.source;
        int startPosition = this.scanner.startPosition;
        int length = str.length - startPosition;
        StringBuffer bufr = new StringBuffer(length);
        if (startPosition < str.length) {
            bufr.append(str, startPosition, length);
        }
        return bufr.toString();
    }

    private void dumpTab(int tabCount) {
        if (this.options.indentWithTab) {
            int j = 0;
            while (j < tabCount) {
                this.formattedSource.append('\t');
                this.increaseSplitDelta(1);
                ++j;
            }
        } else {
            int i = 0;
            int max = this.options.tabSize * tabCount;
            while (i < max) {
                this.formattedSource.append(' ');
                this.increaseSplitDelta(1);
                ++i;
            }
        }
    }

    private void flushBuffer() {
        String currentString = this.currentLineBuffer.toString();
        this.splitDelta = 0;
        this.beginningOfLineIndex = this.formattedSource.length();
        if (this.containsOpenCloseBraces) {
            this.containsOpenCloseBraces = false;
            this.outputLine(currentString, false, this.indentationLevelForOpenCloseBraces, 0, -1, null, 0);
            this.indentationLevelForOpenCloseBraces = this.currentLineIndentationLevel;
        } else {
            this.outputLine(currentString, false, this.currentLineIndentationLevel, 0, -1, null, 0);
        }
        int scannerSourceLength = this.scanner.source.length;
        if (scannerSourceLength > 2 && this.scanner.startPosition < scannerSourceLength) {
            if (this.scanner.source[scannerSourceLength - 1] == '\n' && this.scanner.source[scannerSourceLength - 2] == '\r') {
                this.formattedSource.append(this.options.lineSeparatorSequence);
                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 2);
            } else if (this.scanner.source[scannerSourceLength - 1] == '\n') {
                this.formattedSource.append(this.options.lineSeparatorSequence);
                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
            } else if (this.scanner.source[scannerSourceLength - 1] == '\r') {
                this.formattedSource.append(this.options.lineSeparatorSequence);
                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
            }
        }
        this.updateMappedPositions(this.scanner.startPosition);
    }

    private void format() {
        int token = 0;
        int previousToken = 0;
        int previousCompilableToken = 0;
        int indentationOffset = 0;
        int newLinesInWhitespace = 0;
        int pendingNewLines = 0;
        boolean expectingOpenBrace = false;
        boolean clearNonBlockIndents = false;
        boolean pendingSpace = true;
        boolean pendingNewlineAfterParen = false;
        boolean inAssignment = false;
        boolean inArrayAssignment = false;
        boolean inThrowsClause = false;
        boolean inClassOrInterfaceHeader = false;
        int dollarBraceCount = 0;
        int openBracketCount = 0;
        int unarySignModifier = 0;
        int openParenthesisCount = 1;
        int[] openParenthesis = new int[10];
        int tokenBeforeColonCount = 0;
        int[] tokenBeforeColon = new int[10];
        this.constructionsCount = 0;
        int nlicsToken = 0;
        boolean specialElse = false;
        this.currentLineIndentationLevel += this.constructionsCount;
        int arrayDeclarationCount = 0;
        int[] arrayDeclarationParenthesis = new int[10];
        try {
            while (true) {
                block105: {
                    try {
                        token = this.scanner.getNextToken();
                        if (token != 901) break block105;
                        int length = this.scanner.currentPosition;
                        int index = length - 1;
                        while (index >= 0) {
                            switch (this.scanner.source[index]) {
                                case '\n': 
                                case '\r': {
                                    --this.scanner.currentPosition;
                                    break;
                                }
                                default: {
                                    break block105;
                                }
                            }
                            --index;
                        }
                    }
                    catch (InvalidInputException e) {
                        if (!this.handleInvalidToken(e)) {
                            throw e;
                        }
                        token = 0;
                    }
                }
                if (token == 0) break;
                if (token == 161) {
                    this.outputCurrentTokenWithoutIndent(161, 0);
                    continue;
                }
                if (token == 2) {
                    int newLineCount = 1;
                    if (this.scanner.startPosition == 0) {
                        newLineCount = 0;
                    }
                    this.outputCurrentTokenWithoutIndent(2, newLineCount);
                    int srcLen = this.scanner.source.length;
                    if (this.scanner.currentPosition >= srcLen - 1) continue;
                    this.newLine(1);
                    continue;
                }
                if (clearNonBlockIndents && token != 900) {
                    switch (token) {
                        case 1003: {
                            if (this.constructionsCount > 0 && this.constructions[this.constructionsCount - 1] == 1003) {
                                pendingNewLines = 1;
                                specialElse = true;
                            }
                            this.indentationLevel += this.popInclusiveUntil(1001);
                            break;
                        }
                        case 1007: {
                            if (nlicsToken == 1023) {
                                this.indentationLevel += this.pop(1023);
                                break;
                            }
                        }
                        default: {
                            this.indentationLevel += this.popExclusiveUntilBlockOrCase();
                        }
                    }
                    clearNonBlockIndents = false;
                }
                if (token == 10010 || token == 1025) {
                    this.indentationLevel += this.pop(10010);
                }
                if ((token == 1021 || token == 1057) && previousToken != 32) {
                    inClassOrInterfaceHeader = true;
                }
                boolean bl = pendingNewlineAfterParen = pendingNewlineAfterParen || previousCompilableToken == 129 && token == 130;
                if (pendingNewlineAfterParen && token != 900) {
                    pendingNewlineAfterParen = false;
                    if (!(token == 130 || CodeFormatter.isComment(token) || token == 32 || previousCompilableToken == 129 && token == 140)) {
                        this.newLine(1);
                        this.currentLineIndentationLevel = this.indentationLevel;
                        pendingNewLines = 0;
                        pendingSpace = false;
                    } else if (token == 130 && this.options.newLineBeforeOpeningBraceMode) {
                        this.newLine(1);
                        this.currentLineIndentationLevel = this.constructionsCount > 0 && this.constructions[this.constructionsCount - 1] != 130 && this.constructions[this.constructionsCount - 1] != -100 ? this.indentationLevel - 1 : this.indentationLevel;
                        pendingNewLines = 0;
                        pendingSpace = false;
                    }
                }
                if (token == 130 && this.options.newLineBeforeOpeningBraceMode && this.constructionsCount > 0 && this.constructions[this.constructionsCount - 1] == 1023) {
                    this.newLine(1);
                    this.currentLineIndentationLevel = this.indentationLevel - 1;
                    pendingNewLines = 0;
                    pendingSpace = false;
                }
                if (token == 130 && inThrowsClause) {
                    inThrowsClause = false;
                    if (this.options.newLineBeforeOpeningBraceMode) {
                        this.newLine(1);
                        this.currentLineIndentationLevel = this.indentationLevel;
                        pendingNewLines = 0;
                        pendingSpace = false;
                    }
                }
                if (token == 130 && inClassOrInterfaceHeader) {
                    inClassOrInterfaceHeader = false;
                    if (this.options.newLineBeforeOpeningBraceMode) {
                        this.newLine(1);
                        this.currentLineIndentationLevel = this.indentationLevel;
                        pendingNewLines = 0;
                        pendingSpace = false;
                    }
                }
                if (token == 129 && arrayDeclarationCount > 0 && previousCompilableToken == 128) {
                    pendingNewLines = 0;
                }
                if ((pendingNewLines > 0 && !CodeFormatter.isComment(token) || newLinesInWhitespace > 0 && openParenthesisCount <= 1 && CodeFormatter.isComment(token) || previousCompilableToken == 130 && token == 131 || newLinesInWhitespace > 0 && previousCompilableToken == 32) && token != 900) {
                    boolean commaAndCloseBrace;
                    boolean closeBraceAndCloseParen = previousToken == 131 && token == 129;
                    boolean nlicsOption = previousToken == 131 && !this.options.newlineInControlStatementMode && (token == 1003 || token == 1007 && nlicsToken == 1023 || token == 1051 || token == 1052);
                    boolean semiColonAndCloseBrace = previousToken == 131 && token == 140;
                    boolean commentAndOpenBrace = previousToken == 902 && token == 130;
                    boolean bl2 = commaAndCloseBrace = previousToken == 131 && token == 134;
                    if (specialElse || !commentAndOpenBrace && !closeBraceAndCloseParen && !nlicsOption && !semiColonAndCloseBrace && !commaAndCloseBrace) {
                        if (!this.options.clearAllBlankLinesMode) {
                            pendingNewLines = pendingNewLines < newLinesInWhitespace ? newLinesInWhitespace : pendingNewLines;
                            int n = pendingNewLines = pendingNewLines > 2 ? 2 : pendingNewLines;
                        }
                        if (previousCompilableToken == 130 && token == 131) {
                            this.containsOpenCloseBraces = true;
                            this.indentationLevelForOpenCloseBraces = this.currentLineIndentationLevel;
                            if (CodeFormatter.isComment(previousToken)) {
                                this.newLine(pendingNewLines);
                            } else if (this.options.newLineInEmptyBlockMode) {
                                if (inArrayAssignment) {
                                    this.newLine(1);
                                } else {
                                    this.newLine(pendingNewLines);
                                }
                            }
                        } else if (previousToken != 902 && previousToken != 903 || token != 140) {
                            this.newLine(pendingNewLines);
                        }
                        if ((previousCompilableToken == 140 || previousCompilableToken == 130 || previousCompilableToken == 131 || CodeFormatter.isComment(previousToken)) && token == 131) {
                            indentationOffset = -1;
                            this.indentationLevel += this.popExclusiveUntilBlock();
                        }
                        this.currentLineIndentationLevel = previousToken == 901 && inAssignment ? ++this.currentLineIndentationLevel : this.indentationLevel + indentationOffset;
                        pendingSpace = false;
                        indentationOffset = 0;
                    }
                    pendingNewLines = 0;
                    newLinesInWhitespace = 0;
                    specialElse = false;
                    if (nlicsToken == 1023 && token == 1007) {
                        nlicsToken = 0;
                    }
                }
                boolean phpTagAndWhitespace = previousToken == 2 && token == 900;
                switch (token) {
                    case 1003: {
                        expectingOpenBrace = true;
                        pendingNewlineAfterParen = true;
                        this.indentationLevel += this.pushControlStatement(token);
                        break;
                    }
                    case 1025: 
                    case 10010: {
                        if (tokenBeforeColonCount == tokenBeforeColon.length) {
                            int[] nArray = tokenBeforeColon;
                            tokenBeforeColon = new int[tokenBeforeColonCount * 2];
                            System.arraycopy(nArray, 0, tokenBeforeColon, 0, tokenBeforeColonCount);
                        }
                        tokenBeforeColon[tokenBeforeColonCount++] = 10010;
                        this.indentationLevel += this.pushControlStatement(10010);
                        break;
                    }
                    case 62: {
                        if (tokenBeforeColonCount == tokenBeforeColon.length) {
                            int[] nArray = tokenBeforeColon;
                            tokenBeforeColon = new int[tokenBeforeColonCount * 2];
                            System.arraycopy(nArray, 0, tokenBeforeColon, 0, tokenBeforeColonCount);
                        }
                        tokenBeforeColon[tokenBeforeColonCount++] = token;
                        break;
                    }
                    case 1001: 
                    case 1005: 
                    case 1007: 
                    case 1009: 
                    case 1028: {
                        if (openParenthesisCount == openParenthesis.length) {
                            int[] nArray = openParenthesis;
                            openParenthesis = new int[openParenthesisCount * 2];
                            System.arraycopy(nArray, 0, openParenthesis, 0, openParenthesisCount);
                        }
                        openParenthesis[openParenthesisCount++] = 0;
                        expectingOpenBrace = true;
                        this.indentationLevel += this.pushControlStatement(token);
                        break;
                    }
                    case 1053: {
                        pendingNewlineAfterParen = true;
                    }
                    case 1051: {
                        expectingOpenBrace = true;
                        this.indentationLevel += this.pushControlStatement(1051);
                        break;
                    }
                    case 1023: {
                        expectingOpenBrace = true;
                        this.indentationLevel += this.pushControlStatement(token);
                        nlicsToken = token;
                        break;
                    }
                    case 1022: {
                        break;
                    }
                    case 128: {
                        if (previousCompilableToken != 132 && previousToken != 138 && previousToken != 0 && previousToken != 31 && previousToken != 128 && previousToken != 54 && previousToken != 140 && previousToken != 130 && previousToken != 131 && previousToken != 1060) {
                            this.space();
                        }
                        if (openParenthesisCount > 0) {
                            int n = openParenthesisCount - 1;
                            openParenthesis[n] = openParenthesis[n] + 1;
                        } else {
                            openParenthesis[0] = openParenthesis[0] + 1;
                        }
                        pendingSpace = false;
                        if (previousCompilableToken != 1032) break;
                        arrayDeclarationParenthesis[++arrayDeclarationCount] = openParenthesis[openParenthesisCount];
                        ++this.indentationLevel;
                        pendingNewLines = 1;
                        break;
                    }
                    case 129: {
                        if (arrayDeclarationCount > 0 && arrayDeclarationParenthesis[arrayDeclarationCount] == openParenthesis[openParenthesisCount]) {
                            if (previousCompilableToken != 128) {
                                this.newLine(1);
                            }
                            this.currentLineIndentationLevel = --this.indentationLevel;
                            pendingNewLines = 0;
                            --arrayDeclarationCount;
                        }
                        if (openParenthesisCount > 1 && openParenthesis[openParenthesisCount - 1] > 0) {
                            int n = openParenthesisCount - 1;
                            openParenthesis[n] = openParenthesis[n] - 1;
                            if (openParenthesis[openParenthesisCount - 1] <= 0) {
                                pendingNewlineAfterParen = true;
                                inAssignment = false;
                                --openParenthesisCount;
                            }
                        } else {
                            openParenthesis[0] = openParenthesis[0] - 1;
                        }
                        pendingSpace = false;
                        break;
                    }
                    case 130: {
                        if (previousCompilableToken == 126) {
                            ++dollarBraceCount;
                            break;
                        }
                        if (previousCompilableToken == 133 || previousCompilableToken == 49) {
                            inArrayAssignment = true;
                            inAssignment = false;
                        }
                        if (inArrayAssignment) {
                            this.indentationLevel += this.pushBlock();
                            break;
                        }
                        pendingNewLines = 1;
                        this.indentationLevel += this.pushBlock();
                        inAssignment = false;
                        break;
                    }
                    case 131: {
                        if (dollarBraceCount > 0) {
                            --dollarBraceCount;
                            break;
                        }
                        if (previousCompilableToken == 129) {
                            pendingSpace = false;
                        }
                        if (inArrayAssignment) {
                            inArrayAssignment = false;
                            pendingNewLines = 1;
                            this.indentationLevel += this.popInclusiveUntilBlock();
                            break;
                        }
                        pendingNewLines = 1;
                        this.indentationLevel += this.popInclusiveUntilBlock();
                        if (previousCompilableToken == 129) {
                            this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                            this.increaseLineDelta(this.options.lineSeparatorSequence.length);
                        }
                        if (this.constructionsCount <= 0) break;
                        switch (this.constructions[this.constructionsCount - 1]) {
                            case 1001: 
                            case 1003: 
                            case 1005: 
                            case 1007: 
                            case 1009: 
                            case 1023: 
                            case 1028: 
                            case 1051: 
                            case 1052: 
                            case 1053: {
                                clearNonBlockIndents = true;
                            }
                        }
                        break;
                    }
                    case 132: {
                        ++openBracketCount;
                        pendingSpace = false;
                        break;
                    }
                    case 133: {
                        openBracketCount -= openBracketCount > 0 ? 1 : 0;
                        pendingSpace = false;
                        break;
                    }
                    case 134: {
                        pendingSpace = false;
                        if (arrayDeclarationCount <= 0) break;
                        pendingNewLines = 1;
                        break;
                    }
                    case 32: {
                        this.space();
                        pendingSpace = false;
                        break;
                    }
                    case 140: {
                        if (openParenthesisCount <= 1) {
                            pendingNewLines = 1;
                            if (expectingOpenBrace) {
                                clearNonBlockIndents = true;
                                expectingOpenBrace = false;
                            }
                        }
                        inAssignment = false;
                        pendingSpace = false;
                        break;
                    }
                    case 144: 
                    case 145: {
                        if (previousToken != 138 && previousToken != 133 && previousToken != 150) break;
                        pendingSpace = false;
                        break;
                    }
                    case 36: 
                    case 37: {
                        if (CodeFormatter.isLiteralToken(previousToken) || previousToken == 138 || previousToken == 129 || previousToken == 133) break;
                        unarySignModifier = 1;
                        break;
                    }
                    case 47: {
                        if (tokenBeforeColonCount <= 0) break;
                        if (tokenBeforeColon[tokenBeforeColonCount - 1] == 10010) {
                            pendingNewLines = 1;
                        }
                        --tokenBeforeColonCount;
                        break;
                    }
                    case 49: {
                        inAssignment = true;
                        break;
                    }
                    case 901: {
                        pendingNewLines = 1;
                        if (!inAssignment) break;
                        ++this.currentLineIndentationLevel;
                        break;
                    }
                    case 902: 
                    case 903: {
                        this.currentCommentOffset = this.getCurrentCommentOffset();
                        pendingNewLines = 1;
                        break;
                    }
                    case 900: {
                        if (!phpTagAndWhitespace) {
                            char[] source = this.scanner.source;
                            newLinesInWhitespace = 0;
                            int i = this.scanner.startPosition;
                            int max = this.scanner.currentPosition;
                            while (i < max) {
                                if (source[i] == '\r') {
                                    newLinesInWhitespace = i < max - 1 ? (source[++i] == '\n' ? ++newLinesInWhitespace : ++newLinesInWhitespace) : ++newLinesInWhitespace;
                                } else if (source[i] == '\n') {
                                    ++newLinesInWhitespace;
                                }
                                ++i;
                            }
                            this.increaseLineDelta(this.scanner.startPosition - this.scanner.currentPosition);
                            break;
                        }
                    }
                    default: {
                        if (token != 138 && !CodeFormatter.isLiteralToken(token) && token != 1060) break;
                        if (previousToken == 145 || previousToken == 144 || previousToken == 50 && this.options.compactDereferencingMode || previousToken == 37 && unarySignModifier > 0 || previousToken == 36 && unarySignModifier > 0) {
                            pendingSpace = false;
                        }
                        unarySignModifier = 0;
                    }
                }
                if (token != 900 || phpTagAndWhitespace) {
                    boolean openAndCloseBrace;
                    if (token == 50 && this.options.compactDereferencingMode) {
                        pendingSpace = false;
                    }
                    boolean bl3 = openAndCloseBrace = previousCompilableToken == 130 && token == 131;
                    if (!(!pendingSpace || !this.insertSpaceAfter(previousToken) || inAssignment && (previousToken == 130 || token == 131) || previousToken == 901 || this.options.compactAssignmentMode && token == 49 || openAndCloseBrace)) {
                        this.space();
                    }
                    this.outputCurrentToken(token);
                    if (token == 901 && openParenthesisCount > 1) {
                        pendingNewLines = 0;
                        this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                        this.increaseLineDelta(this.options.lineSeparatorSequence.length);
                    }
                    pendingSpace = true;
                }
                if (token == 900 && !phpTagAndWhitespace) continue;
                previousToken = token;
                if (token == 902 || token == 901 || token == 903) continue;
                previousCompilableToken = token;
            }
            this.output(this.copyRemainingSource());
            this.flushBuffer();
        }
        catch (InvalidInputException invalidInputException) {
            this.output(this.copyRemainingSource());
            this.flushBuffer();
        }
    }

    public String formatSourceString(String sourceString) {
        char[] sourceChars = sourceString.toCharArray();
        this.formattedSource = new StringBuffer(sourceChars.length);
        this.scanner.setSource(sourceChars);
        this.format();
        return this.formattedSource.toString();
    }

    public String format(String string, int indentationLevel) {
        return this.format(string, indentationLevel, null);
    }

    public String format(String string, int indentationLevel, int[] positions) {
        return this.format(string, indentationLevel, positions, null);
    }

    public String format(String string, int indentationLevel, int[] positions, String lineSeparator) {
        if (lineSeparator != null) {
            this.options.setLineSeparator(lineSeparator);
        }
        if (positions != null) {
            this.setPositionsToMap(positions);
            this.setInitialIndentationLevel(indentationLevel);
            String formattedString = this.formatSourceString(string);
            int[] mappedPositions = this.getMappedPositions();
            System.arraycopy(mappedPositions, 0, positions, 0, positions.length);
            return formattedString;
        }
        this.setInitialIndentationLevel(indentationLevel);
        return this.formatSourceString(string);
    }

    public String format(String string) {
        return this.format(string, 0, null);
    }

    public static String format(String sourceString, int initialIndentationLevel, ConfigurableOption[] options) {
        CodeFormatter formatter = new CodeFormatter(options);
        formatter.setInitialIndentationLevel(initialIndentationLevel);
        return formatter.formatSourceString(sourceString);
    }

    private int getCurrentCommentOffset() {
        int linePtr = this.scanner.linePtr;
        if (linePtr < 0) {
            return 0;
        }
        int offset = 0;
        int beginningOfLine = this.scanner.lineEnds[linePtr];
        int currentStartPosition = this.scanner.startPosition;
        char[] source = this.scanner.source;
        while (beginningOfLine > currentStartPosition) {
            if (linePtr > 0) {
                beginningOfLine = this.scanner.lineEnds[--linePtr];
                continue;
            }
            beginningOfLine = 0;
            break;
        }
        int i = currentStartPosition - 1;
        while (i >= beginningOfLine) {
            char currentCharacter = source[i];
            switch (currentCharacter) {
                case '\t': {
                    offset += this.options.tabSize;
                    break;
                }
                case ' ': {
                    ++offset;
                    break;
                }
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    return offset;
                }
            }
            --i;
        }
        return offset;
    }

    public static ConfigurableOption[] getDefaultOptions(Locale locale) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.phpdt.internal.formatter.CodeFormatter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String componentName = clazz.getName();
        FormatterOptions options = new FormatterOptions();
        return new ConfigurableOption[]{new ConfigurableOption(componentName, "newline.openingBrace", locale, options.newLineBeforeOpeningBraceMode ? 0 : 1), new ConfigurableOption(componentName, "newline.controlStatement", locale, options.newlineInControlStatementMode ? 0 : 1), new ConfigurableOption(componentName, "newline.clearAll", locale, options.clearAllBlankLinesMode ? 0 : 1), new ConfigurableOption(componentName, "newline.emptyBlock", locale, options.newLineInEmptyBlockMode ? 0 : 1), new ConfigurableOption(componentName, "line.split", locale, options.maxLineLength), new ConfigurableOption(componentName, "style.compactAssignment", locale, options.compactAssignmentMode ? 0 : 1), new ConfigurableOption(componentName, "tabulation.char", locale, options.indentWithTab ? 0 : 1), new ConfigurableOption(componentName, "tabulation.size", locale, options.tabSize)};
    }

    public int[] getMappedPositions() {
        if (this.mappedPositions != null) {
            int i = 0;
            while (i < this.mappedPositions.length) {
                if (this.mappedPositions[i] >= this.formattedSource.length()) {
                    this.mappedPositions[i] = this.formattedSource.length() - 1;
                }
                ++i;
            }
        }
        return this.mappedPositions;
    }

    private static int getTokenPriority(int token) {
        switch (token) {
            case 1030: {
                return 10;
            }
            case 140: {
                return 20;
            }
            case 134: {
                return 25;
            }
            case 49: {
                return 30;
            }
            case 44: 
            case 45: {
                return 40;
            }
            case 47: 
            case 62: {
                return 50;
            }
            case 38: 
            case 39: 
            case 157: 
            case 158: {
                return 60;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return 70;
            }
            case 36: 
            case 37: {
                return 80;
            }
            case 30: 
            case 34: 
            case 35: {
                return 90;
            }
            case 155: 
            case 156: {
                return 100;
            }
            case 33: 
            case 52: 
            case 160: {
                return 110;
            }
            case 48: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 146: 
            case 147: 
            case 148: 
            case 149: {
                return 120;
            }
            case 32: {
                return 130;
            }
        }
        return Integer.MAX_VALUE;
    }

    private boolean handleInvalidToken(Exception e) {
        return e.getMessage().equals("Invalid_Character_Constant") || e.getMessage().equals("Invalid_Char_In_String") || e.getMessage().equals("Invalid_Escape");
    }

    private final void increaseGlobalDelta(int offset) {
        this.globalDelta += offset;
    }

    private final void increaseLineDelta(int offset) {
        this.lineDelta += offset;
    }

    private final void increaseSplitDelta(int offset) {
        this.splitDelta += offset;
    }

    private boolean insertSpaceAfter(int token) {
        switch (token) {
            case 0: 
            case 31: 
            case 54: 
            case 126: 
            case 128: 
            case 132: 
            case 900: 
            case 901: {
                return false;
            }
        }
        return true;
    }

    private boolean insertSpaceBefore(int token) {
        switch (token) {
            case 49: {
                return !this.options.compactAssignmentMode;
            }
        }
        return false;
    }

    private static boolean isComment(int token) {
        boolean result = token == 902 || token == 901 || token == 903;
        return result;
    }

    private static boolean isLiteralToken(int token) {
        boolean result = token == 151 || token == 152 || token == 136;
        return result;
    }

    private void newLine(int newLineCount) {
        this.splitDelta = 0;
        this.beginningOfLineIndex = this.formattedSource.length();
        String currentLine = this.currentLineBuffer.toString();
        if (this.containsOpenCloseBraces) {
            this.containsOpenCloseBraces = false;
            this.outputLine(currentLine, false, this.indentationLevelForOpenCloseBraces, 0, -1, null, 0);
            this.indentationLevelForOpenCloseBraces = this.currentLineIndentationLevel;
        } else {
            this.outputLine(currentLine, false, this.currentLineIndentationLevel, 0, -1, null, 0);
        }
        int i = 0;
        while (i < newLineCount) {
            this.formattedSource.append(this.options.lineSeparatorSequence);
            this.increaseSplitDelta(this.options.lineSeparatorSequence.length);
            ++i;
        }
        int currentLength = currentLine.length();
        this.currentLineBuffer = new StringBuffer(currentLength > this.maxLineSize ? (this.maxLineSize = currentLength) : this.maxLineSize);
        this.increaseGlobalDelta(this.splitDelta);
        this.increaseGlobalDelta(this.lineDelta);
        this.lineDelta = 0;
        this.currentLineIndentationLevel = this.initialIndentationLevel;
    }

    private String operatorString(int operator) {
        switch (operator) {
            case 1030: {
                return "extends";
            }
            case 140: {
                return ";";
            }
            case 134: {
                return ",";
            }
            case 49: {
                return "=";
            }
            case 44: {
                return "&&";
            }
            case 45: {
                return "||";
            }
            case 62: {
                return "?";
            }
            case 47: {
                return ":";
            }
            case 63: {
                return "::";
            }
            case 38: {
                return "==";
            }
            case 157: {
                return "===";
            }
            case 51: {
                return "=>";
            }
            case 39: {
                return "!=";
            }
            case 158: {
                return "!==";
            }
            case 42: {
                return "<";
            }
            case 43: {
                return "<=";
            }
            case 40: {
                return ">";
            }
            case 41: {
                return ">=";
            }
            case 37: {
                return "+";
            }
            case 36: {
                return "-";
            }
            case 35: {
                return "*";
            }
            case 34: {
                return "/";
            }
            case 30: {
                return "%";
            }
            case 155: {
                return "<<";
            }
            case 156: {
                return ">>";
            }
            case 52: {
                return "&";
            }
            case 160: {
                return "|";
            }
            case 33: {
                return "^";
            }
            case 149: {
                return "*=";
            }
            case 147: {
                return "/=";
            }
            case 56: {
                return "%=";
            }
            case 146: {
                return "+=";
            }
            case 148: {
                return "-=";
            }
            case 50: {
                return "->";
            }
            case 59: {
                return "<<=";
            }
            case 58: {
                return ">>=";
            }
            case 60: {
                return "&=";
            }
            case 57: {
                return "^=";
            }
            case 61: {
                return "|=";
            }
            case 48: {
                return ".=";
            }
            case 32: {
                return ".";
            }
        }
        return "";
    }

    private void output(String stringToOutput) {
        int i = 0;
        int max = stringToOutput.length();
        while (i < max) {
            char currentCharacter = stringToOutput.charAt(i);
            if (currentCharacter != '\t') {
                this.currentLineBuffer.append(currentCharacter);
            }
            ++i;
        }
    }

    private void outputCurrentTokenWithoutIndent(int token, int newLineCount) {
        this.newLine(newLineCount);
        this.formattedSource.append(this.scanner.source, this.scanner.startPosition, this.scanner.currentPosition - this.scanner.startPosition);
    }

    private void outputCurrentToken(int token) {
        char[] source = this.scanner.source;
        int startPosition = this.scanner.startPosition;
        switch (token) {
            case 901: 
            case 902: 
            case 903: {
                boolean endOfLine = false;
                int currentCommentOffset = this.getCurrentCommentOffset();
                int beginningOfLineSpaces = 0;
                endOfLine = false;
                currentCommentOffset = this.getCurrentCommentOffset();
                beginningOfLineSpaces = 0;
                boolean pendingCarriageReturn = false;
                int i = startPosition;
                int max = this.scanner.currentPosition;
                while (i < max) {
                    char currentCharacter = source[i];
                    this.updateMappedPositions(i);
                    switch (currentCharacter) {
                        case '\r': {
                            pendingCarriageReturn = true;
                            endOfLine = true;
                            break;
                        }
                        case '\n': {
                            if (pendingCarriageReturn) {
                                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 2);
                            } else {
                                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
                            }
                            pendingCarriageReturn = false;
                            this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                            beginningOfLineSpaces = 0;
                            endOfLine = true;
                            break;
                        }
                        case '\t': {
                            if (pendingCarriageReturn) {
                                pendingCarriageReturn = false;
                                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
                                this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                                beginningOfLineSpaces = 0;
                                endOfLine = true;
                            }
                            if (endOfLine) {
                                if ((beginningOfLineSpaces += this.options.tabSize) > currentCommentOffset) {
                                    this.currentLineBuffer.append(currentCharacter);
                                    break;
                                }
                                this.increaseGlobalDelta(-1);
                                break;
                            }
                            this.currentLineBuffer.append(currentCharacter);
                            break;
                        }
                        case ' ': {
                            if (pendingCarriageReturn) {
                                pendingCarriageReturn = false;
                                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
                                this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                                beginningOfLineSpaces = 0;
                                endOfLine = true;
                            }
                            if (endOfLine) {
                                if (++beginningOfLineSpaces > currentCommentOffset) {
                                    this.currentLineBuffer.append(currentCharacter);
                                    break;
                                }
                                this.increaseGlobalDelta(-1);
                                break;
                            }
                            this.currentLineBuffer.append(currentCharacter);
                            break;
                        }
                        default: {
                            if (pendingCarriageReturn) {
                                pendingCarriageReturn = false;
                                this.increaseGlobalDelta(this.options.lineSeparatorSequence.length - 1);
                                this.currentLineBuffer.append(this.options.lineSeparatorSequence);
                                beginningOfLineSpaces = 0;
                                endOfLine = true;
                                break;
                            }
                            beginningOfLineSpaces = 0;
                            this.currentLineBuffer.append(currentCharacter);
                            endOfLine = false;
                        }
                    }
                    ++i;
                }
                this.updateMappedPositions(this.scanner.currentPosition - 1);
                ++this.multipleLineCommentCounter;
                break;
            }
            default: {
                int i = startPosition;
                int max = this.scanner.currentPosition;
                while (i < max) {
                    char currentCharacter = source[i];
                    this.updateMappedPositions(i);
                    this.currentLineBuffer.append(currentCharacter);
                    ++i;
                }
                break block0;
            }
        }
    }

    private void outputLine(String currentString, boolean preIndented, int depth, int operator, int substringIndex, int[] startSubstringIndexes, int offsetInGlobalLine) {
        boolean placeOperatorAhead;
        boolean emptyFirstSubString = false;
        String operatorString = this.operatorString(operator);
        boolean placeOperatorBehind = !CodeFormatter.breakLineBeforeOperator(operator);
        boolean bl = placeOperatorAhead = !placeOperatorBehind;
        if (placeOperatorAhead) {
            if (!preIndented) {
                this.dumpTab(depth);
                preIndented = true;
            }
            if (operator != 0) {
                if (this.insertSpaceBefore(operator)) {
                    this.formattedSource.append(' ');
                    this.increaseSplitDelta(1);
                }
                this.formattedSource.append(operatorString);
                this.increaseSplitDelta(operatorString.length());
                if (this.insertSpaceAfter(operator) && operator != 1058 && operator != 1030) {
                    this.formattedSource.append(' ');
                    this.increaseSplitDelta(1);
                }
            }
        }
        SplitLine splitLine = null;
        if (this.options.maxLineLength == 0 || this.getLength(currentString, depth) < this.options.maxLineLength || (splitLine = this.split(currentString, offsetInGlobalLine)) == null) {
            if (operator == 1030 || operator == 1058) {
                this.formattedSource.append(' ');
                this.increaseSplitDelta(1);
            }
            if (placeOperatorBehind && !preIndented) {
                this.dumpTab(depth);
            }
            int max = currentString.length();
            if (this.multipleLineCommentCounter != 0) {
                try {
                    BufferedReader reader = new BufferedReader(new StringReader(currentString));
                    String line = reader.readLine();
                    while (line != null) {
                        this.updateMappedPositionsWhileSplitting(this.beginningOfLineIndex, this.beginningOfLineIndex + line.length() + this.options.lineSeparatorSequence.length);
                        this.formattedSource.append(line);
                        this.beginningOfLineIndex += line.length();
                        line = reader.readLine();
                        if (line == null) continue;
                        this.formattedSource.append(this.options.lineSeparatorSequence);
                        this.beginningOfLineIndex += this.options.lineSeparatorSequence.length;
                        this.dumpTab(this.currentLineIndentationLevel);
                    }
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.updateMappedPositionsWhileSplitting(this.beginningOfLineIndex, this.beginningOfLineIndex + max);
                int i = 0;
                while (i < max) {
                    char currentChar = currentString.charAt(i);
                    switch (currentChar) {
                        case '\r': {
                            break;
                        }
                        case '\n': {
                            if (i == max - 1) break;
                            this.formattedSource.append(this.options.lineSeparatorSequence);
                            this.dumpTab(depth - 1);
                            break;
                        }
                        default: {
                            this.formattedSource.append(currentChar);
                        }
                    }
                    ++i;
                }
            }
            if (substringIndex != -1) {
                if (this.multipleLineCommentCounter == 0) {
                    int startPosition = this.beginningOfLineIndex + startSubstringIndexes[substringIndex];
                    this.updateMappedPositionsWhileSplitting(startPosition, startPosition + max);
                }
                if (substringIndex + 1 != startSubstringIndexes.length) {
                    this.increaseSplitDelta(startSubstringIndexes[substringIndex] + max - startSubstringIndexes[substringIndex + 1]);
                }
            }
            if (placeOperatorBehind) {
                if (this.insertSpaceBefore(operator)) {
                    this.formattedSource.append(' ');
                    if (operator != 0) {
                        this.increaseSplitDelta(1);
                    }
                }
                this.formattedSource.append(operatorString);
                if (operator != 0) {
                    this.increaseSplitDelta(operatorString.length());
                }
            }
            return;
        }
        if (this.options.maxLineLength != 0 && splitLine != null && operator == 1030) {
            this.formattedSource.append(this.options.lineSeparatorSequence);
            this.increaseSplitDelta(this.options.lineSeparatorSequence.length);
            this.dumpTab(depth + 1);
        } else if (operator == 1030) {
            this.formattedSource.append(' ');
            this.increaseSplitDelta(1);
        }
        String[] result = splitLine.substrings;
        int[] splitOperators = splitLine.operators;
        if (result[0].length() == 0) {
            --depth;
            emptyFirstSubString = true;
        }
        int i = 0;
        int max = result.length;
        while (i < max) {
            String currentResult = result[i];
            if (currentResult.length() != 0 || splitOperators[i] != 0) {
                int newDepth = currentResult.startsWith("/*") || currentResult.startsWith("//") ? this.indentationLevel - 1 : depth;
                this.outputLine(currentResult, i == 0 || i == 1 && emptyFirstSubString ? preIndented : false, i == 0 ? newDepth : newDepth + 1, splitOperators[i], i, splitLine.startSubstringsIndexes, currentString.indexOf(currentResult));
                if (i != max - 1) {
                    this.formattedSource.append(this.options.lineSeparatorSequence);
                    this.increaseSplitDelta(this.options.lineSeparatorSequence.length);
                }
            }
            ++i;
        }
        if (result.length == splitOperators.length - 1) {
            int lastOperator = splitOperators[result.length];
            String lastOperatorString = this.operatorString(lastOperator);
            this.formattedSource.append(this.options.lineSeparatorSequence);
            this.increaseSplitDelta(this.options.lineSeparatorSequence.length);
            if (CodeFormatter.breakLineBeforeOperator(lastOperator)) {
                this.dumpTab(depth + 1);
                if (lastOperator != 0) {
                    if (this.insertSpaceBefore(lastOperator)) {
                        this.formattedSource.append(' ');
                        this.increaseSplitDelta(1);
                    }
                    this.formattedSource.append(lastOperatorString);
                    this.increaseSplitDelta(lastOperatorString.length());
                    if (this.insertSpaceAfter(lastOperator) && lastOperator != 1058 && lastOperator != 1030) {
                        this.formattedSource.append(' ');
                        this.increaseSplitDelta(1);
                    }
                }
            }
        }
        if (placeOperatorBehind) {
            if (this.insertSpaceBefore(operator)) {
                this.formattedSource.append(' ');
                this.increaseSplitDelta(1);
            }
            this.formattedSource.append(operatorString);
        }
    }

    private int pop(int token) {
        int delta = 0;
        if (this.constructionsCount > 0 && this.constructions[this.constructionsCount - 1] == token) {
            --delta;
            --this.constructionsCount;
        }
        return delta;
    }

    private int popBlock() {
        int delta = 0;
        if (this.constructionsCount > 0 && (this.constructions[this.constructionsCount - 1] == 130 || this.constructions[this.constructionsCount - 1] == -100)) {
            if (this.constructions[this.constructionsCount - 1] == 130) {
                --delta;
            }
            --this.constructionsCount;
        }
        return delta;
    }

    private int popExclusiveUntil(int token) {
        int delta = 0;
        int startCount = this.constructionsCount;
        int i = startCount - 1;
        while (i >= 0 && this.constructions[i] != token) {
            if (this.constructions[i] != -100) {
                --delta;
            }
            --this.constructionsCount;
            --i;
        }
        return delta;
    }

    private int popExclusiveUntilBlock() {
        int startCount = this.constructionsCount;
        int delta = 0;
        int i = startCount - 1;
        while (i >= 0 && this.constructions[i] != 130 && this.constructions[i] != -100) {
            --this.constructionsCount;
            --delta;
            --i;
        }
        return delta;
    }

    private int popExclusiveUntilBlockOrCase() {
        int startCount = this.constructionsCount;
        int delta = 0;
        int i = startCount - 1;
        while (i >= 0 && this.constructions[i] != 130 && this.constructions[i] != -100 && this.constructions[i] != 10010) {
            --this.constructionsCount;
            --delta;
            --i;
        }
        return delta;
    }

    private int popInclusiveUntil(int token) {
        int startCount = this.constructionsCount;
        int delta = 0;
        int i = startCount - 1;
        while (i >= 0 && this.constructions[i] != token) {
            if (this.constructions[i] != -100) {
                --delta;
            }
            --this.constructionsCount;
            --i;
        }
        if (this.constructionsCount > 0) {
            if (this.constructions[this.constructionsCount - 1] != -100) {
                --delta;
            }
            --this.constructionsCount;
        }
        return delta;
    }

    private int popInclusiveUntilBlock() {
        int startCount = this.constructionsCount;
        int delta = 0;
        int i = startCount - 1;
        while (i >= 0 && this.constructions[i] != 130 && this.constructions[i] != -100) {
            --delta;
            --this.constructionsCount;
            --i;
        }
        if (this.constructionsCount > 0) {
            if (this.constructions[this.constructionsCount - 1] == 130) {
                --delta;
            }
            --this.constructionsCount;
        }
        return delta;
    }

    private int pushBlock() {
        int delta = 0;
        if (this.constructionsCount == this.constructions.length) {
            this.constructions = new int[this.constructionsCount * 2];
            System.arraycopy(this.constructions, 0, this.constructions, 0, this.constructionsCount);
        }
        if (this.constructionsCount == 0 || this.constructions[this.constructionsCount - 1] == 130 || this.constructions[this.constructionsCount - 1] == -100 || this.constructions[this.constructionsCount - 1] == 10010) {
            ++delta;
            this.constructions[this.constructionsCount++] = 130;
        } else {
            this.constructions[this.constructionsCount++] = -100;
        }
        return delta;
    }

    private int pushControlStatement(int token) {
        if (this.constructionsCount == this.constructions.length) {
            this.constructions = new int[this.constructionsCount * 2];
            System.arraycopy(this.constructions, 0, this.constructions, 0, this.constructionsCount);
        }
        this.constructions[this.constructionsCount++] = token;
        return 1;
    }

    private static boolean separateFirstArgumentOn(int currentToken) {
        return currentToken != 1001 && currentToken != 128 && currentToken != 31 && currentToken != 1007 && currentToken != 1005 && currentToken != 1028 && currentToken != 1009;
    }

    public void setPositionsToMap(int[] positions) {
        this.positionsToMap = positions;
        this.lineDelta = 0;
        this.globalDelta = 0;
        this.mappedPositions = new int[positions.length];
    }

    private void space() {
        this.currentLineBuffer.append(' ');
        this.increaseLineDelta(1);
    }

    public SplitLine split(String stringToSplit) {
        return this.split(stringToSplit, 0);
    }

    public SplitLine split(String stringToSplit, int offsetInGlobalLine) {
        if (stringToSplit.indexOf("//$NON-NLS") != -1) {
            return null;
        }
        return null;
    }

    private void updateMappedPositions(int startPosition) {
        if (this.positionsToMap == null) {
            return;
        }
        char[] source = this.scanner.source;
        int sourceLength = source.length;
        while (this.indexToMap < this.positionsToMap.length && this.positionsToMap[this.indexToMap] <= startPosition) {
            int posToMap = this.positionsToMap[this.indexToMap];
            if (posToMap < 0 || posToMap >= sourceLength) {
                if (posToMap == sourceLength) {
                    this.mappedPositions[this.indexToMap] = this.formattedSource.length();
                }
                this.indexToMap = this.positionsToMap.length;
                return;
            }
            this.mappedPositions[this.indexToMap] = CharOperation.isWhitespace(source[posToMap]) ? startPosition + this.globalDelta + this.lineDelta : (posToMap == sourceLength - 1 ? startPosition + this.globalDelta + this.lineDelta : posToMap + this.globalDelta + this.lineDelta);
            ++this.indexToMap;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateMappedPositionsWhileSplitting(int startPosition, int endPosition) {
        if (this.mappedPositions != null && this.mappedPositions.length != this.indexInMap) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            v0 = this.indexInMap++;
            this.mappedPositions[v0] = this.mappedPositions[v0] + this.splitDelta;
lbl5:
            // 2 sources

            ** while (this.indexInMap < this.mappedPositions.length && startPosition <= this.mappedPositions[this.indexInMap] && this.mappedPositions[this.indexInMap] < endPosition && this.indexInMap < this.indexToMap)
        }
lbl6:
        // 1 sources

    }

    private int getLength(String s, int tabDepth) {
        int length = 0;
        int i = 0;
        while (i < tabDepth) {
            length += this.options.tabSize;
            ++i;
        }
        i = 0;
        int max = s.length();
        while (i < max) {
            char currentChar = s.charAt(i);
            switch (currentChar) {
                case '\t': {
                    length += this.options.tabSize;
                    break;
                }
                default: {
                    ++length;
                }
            }
            ++i;
        }
        return length;
    }

    public void setInitialIndentationLevel(int newIndentationLevel) {
        this.currentLineIndentationLevel = this.indentationLevel = newIndentationLevel;
        this.initialIndentationLevel = this.indentationLevel;
    }
}

