/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.ISourceReference;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.ui.JavaElementLabelProvider;
import net.sourceforge.phpeclipse.phpeditor.EditorUtility;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class OpenActionUtil {
    private OpenActionUtil() {
    }

    public static void open(Object element) throws JavaModelException, PartInitException {
        OpenActionUtil.open(element, true);
    }

    public static void open(Object element, boolean activate) throws JavaModelException, PartInitException {
        IEditorPart part = EditorUtility.openInEditor(element, activate);
        if (element instanceof IJavaElement) {
            EditorUtility.revealInEditor(part, (IJavaElement)element);
        }
    }

    public static List filterResolveResults(IJavaElement[] codeResolveResults) {
        int nResults = codeResolveResults.length;
        ArrayList<IJavaElement> refs = new ArrayList<IJavaElement>(nResults);
        int i = 0;
        while (i < nResults) {
            if (codeResolveResults[i] instanceof ISourceReference) {
                refs.add(codeResolveResults[i]);
            }
            ++i;
        }
        return refs;
    }

    public static IJavaElement selectJavaElement(IJavaElement[] elements, Shell shell, String title, String message) {
        Object[] selection;
        int nResults = elements.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return elements[0];
        }
        int flags = JavaElementLabelProvider.SHOW_DEFAULT | 0x400 | 0x40;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements((Object[])elements);
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            nResults = selection.length;
            int i = 0;
            while (i < nResults) {
                Object current = selection[i];
                if (current instanceof IJavaElement) {
                    return (IJavaElement)current;
                }
                ++i;
            }
        }
        return null;
    }
}

