/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.actions;

import java.util.Iterator;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IType;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.ui.actions.ActionMessages;
import net.sourceforge.phpdt.internal.ui.actions.OpenActionUtil;
import net.sourceforge.phpdt.internal.ui.util.ExceptionHandler;
import net.sourceforge.phpdt.ui.IWorkingCopyManager;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.phpeditor.PHPEditor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;

public class SelectionConverter {
    private static final IJavaElement[] EMPTY_RESULT = new IJavaElement[0];

    private SelectionConverter() {
    }

    public static IStructuredSelection getStructuredSelection(IWorkbenchPart part) throws JavaModelException {
        ISelection selection;
        if (part instanceof PHPEditor) {
            return new StructuredSelection((Object[])SelectionConverter.codeResolve((PHPEditor)part));
        }
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public static IJavaElement[] getElements(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            IJavaElement[] result = new IJavaElement[selection.size()];
            int i = 0;
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof IJavaElement)) {
                    return EMPTY_RESULT;
                }
                result[i] = (IJavaElement)element;
                ++i;
            }
            return result;
        }
        return EMPTY_RESULT;
    }

    public static boolean canOperateOn(PHPEditor editor) {
        if (editor == null) {
            return false;
        }
        return SelectionConverter.getInput(editor) != null;
    }

    public static IJavaElement[] codeResolveOrInput(PHPEditor editor) throws JavaModelException {
        ITextSelection selection;
        IJavaElement input = SelectionConverter.getInput(editor);
        IJavaElement[] result = SelectionConverter.codeResolve(input, selection = (ITextSelection)editor.getSelectionProvider().getSelection());
        if (result.length == 0) {
            result = new IJavaElement[]{input};
        }
        return result;
    }

    public static IJavaElement[] codeResolveOrInputHandled(PHPEditor editor, Shell shell, String title) {
        try {
            return SelectionConverter.codeResolveOrInput(editor);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle(e, shell, title, ActionMessages.getString("SelectionConverter.codeResolve_failed"));
            return null;
        }
    }

    public static IJavaElement codeResolveOrInput(PHPEditor editor, Shell shell, String title, String message) throws JavaModelException {
        IJavaElement[] elements = SelectionConverter.codeResolveOrInput(editor);
        if (elements == null || elements.length == 0) {
            return null;
        }
        IJavaElement candidate = elements[0];
        if (elements.length > 1) {
            candidate = OpenActionUtil.selectJavaElement(elements, shell, title, message);
        }
        return candidate;
    }

    public static IJavaElement codeResolveOrInputHandled(PHPEditor editor, Shell shell, String title, String message) {
        try {
            return SelectionConverter.codeResolveOrInput(editor, shell, title, message);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle(e, shell, title, ActionMessages.getString("SelectionConverter.codeResolveOrInput_failed"));
            return null;
        }
    }

    public static IJavaElement[] codeResolve(PHPEditor editor) throws JavaModelException {
        return SelectionConverter.codeResolve(SelectionConverter.getInput(editor), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IJavaElement codeResolve(PHPEditor editor, Shell shell, String title, String message) throws JavaModelException {
        IJavaElement[] elements = SelectionConverter.codeResolve(editor);
        if (elements == null || elements.length == 0) {
            return null;
        }
        IJavaElement candidate = elements[0];
        if (elements.length > 1) {
            candidate = OpenActionUtil.selectJavaElement(elements, shell, title, message);
        }
        return candidate;
    }

    public static IJavaElement[] codeResolveHandled(PHPEditor editor, Shell shell, String title) {
        try {
            return SelectionConverter.codeResolve(editor);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle(e, shell, title, ActionMessages.getString("SelectionConverter.codeResolve_failed"));
            return null;
        }
    }

    public static IJavaElement getElementAtOffset(PHPEditor editor) throws JavaModelException {
        return SelectionConverter.getElementAtOffset(SelectionConverter.getInput(editor), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IType getTypeAtOffset(PHPEditor editor) throws JavaModelException {
        ICompilationUnit unit;
        IJavaElement element = SelectionConverter.getElementAtOffset(editor);
        IType type = (IType)element.getAncestor(7);
        if (type == null && (unit = SelectionConverter.getInputAsCompilationUnit(editor)) != null) {
            type = unit.findPrimaryType();
        }
        return type;
    }

    public static IJavaElement getInput(PHPEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        IWorkingCopyManager manager = PHPeclipsePlugin.getDefault().getWorkingCopyManager();
        return manager.getWorkingCopy(input);
    }

    public static ICompilationUnit getInputAsCompilationUnit(PHPEditor editor) {
        IJavaElement editorInput = SelectionConverter.getInput(editor);
        if (editorInput instanceof ICompilationUnit) {
            return (ICompilationUnit)editorInput;
        }
        return null;
    }

    private static IJavaElement[] codeResolve(IJavaElement input, ITextSelection selection) throws JavaModelException {
        return EMPTY_RESULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IJavaElement getElementAtOffset(IJavaElement input, ITextSelection selection) throws JavaModelException {
        if (input instanceof ICompilationUnit) {
            IJavaElement ref;
            ICompilationUnit cunit = (ICompilationUnit)input;
            if (cunit.isWorkingCopy()) {
                ICompilationUnit iCompilationUnit = cunit;
                synchronized (iCompilationUnit) {
                    cunit.reconcile();
                }
            }
            if ((ref = cunit.getElementAt(selection.getOffset())) == null) {
                return input;
            }
            return ref;
        }
        return null;
    }
}

