/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.filters;

import net.sourceforge.phpdt.core.IClasspathEntry;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.JavaCore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class OutputFolderFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            IProject proj = folder.getProject();
            try {
                if (!proj.hasNature("net.sourceforge.phpeclipse.phpnature")) {
                    return true;
                }
                IJavaProject jProject = JavaCore.create(folder.getProject());
                if (jProject == null || !jProject.exists()) {
                    return true;
                }
                IPath defaultOutputLocation = jProject.getOutputLocation();
                IPath folderPath = folder.getFullPath();
                if (defaultOutputLocation != null && defaultOutputLocation.equals((Object)folderPath)) {
                    return false;
                }
                IClasspathEntry[] cpEntries = jProject.getRawClasspath();
                int i = 0;
                int length = cpEntries.length;
                while (i < length) {
                    IPath outputLocation = cpEntries[i].getOutputLocation();
                    if (outputLocation != null && outputLocation.equals((Object)folderPath)) {
                        return false;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                return true;
            }
        }
        return true;
    }
}

