/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Hashtable;
import net.sourceforge.phpdt.core.ICodeFormatter;
import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.core.ToolFactory;
import net.sourceforge.phpdt.internal.ui.PHPUIMessages;
import net.sourceforge.phpdt.internal.ui.dialogs.StatusInfo;
import net.sourceforge.phpdt.internal.ui.dialogs.StatusUtil;
import net.sourceforge.phpdt.internal.ui.util.TabFolderLayout;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CodeFormatterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREF_NEWLINE_OPENING_BRACES = "net.sourceforge.phpeclipse.formatter.newline.openingBrace";
    private static final String PREF_NEWLINE_CONTROL_STATEMENT = "net.sourceforge.phpeclipse.formatter.newline.controlStatement";
    private static final String PREF_NEWLINE_CLEAR_ALL = "net.sourceforge.phpeclipse.formatter.newline.clearAll";
    private static final String PREF_NEWLINE_EMPTY_BLOCK = "net.sourceforge.phpeclipse.formatter.newline.emptyBlock";
    private static final String PREF_LINE_SPLIT = "net.sourceforge.phpeclipse.formatter.lineSplit";
    private static final String PREF_STYLE_COMPACT_ASSIGNEMENT = "net.sourceforge.phpeclipse.formatter.style.assignment";
    private static final String PREF_TAB_CHAR = "net.sourceforge.phpeclipse.formatter.tabulation.char";
    private static final String PREF_TAB_SIZE = "net.sourceforge.phpeclipse.formatter.tabulation.size";
    private static final String INSERT = "insert";
    private static final String DO_NOT_INSERT = "do not insert";
    private static final String COMPACT = "compact";
    private static final String NORMAL = "normal";
    private static final String TAB = "tab";
    private static final String SPACE = "space";
    private static final String CLEAR_ALL = "clear all";
    private static final String PRESERVE_ONE = "preserve one";
    private Hashtable fWorkingValues;
    private ArrayList fCheckBoxes;
    private ArrayList fTextBoxes;
    private SelectionListener fButtonSelectionListener;
    private ModifyListener fTextModifyListener;
    private String fPreviewText;
    private IDocument fPreviewDocument;
    private Text fTabSizeTextBox;

    private static String[] getAllKeys() {
        return new String[]{PREF_NEWLINE_OPENING_BRACES, PREF_NEWLINE_CONTROL_STATEMENT, PREF_NEWLINE_CLEAR_ALL, PREF_NEWLINE_EMPTY_BLOCK, PREF_LINE_SPLIT, PREF_STYLE_COMPACT_ASSIGNEMENT, PREF_TAB_CHAR, PREF_TAB_SIZE};
    }

    public static int getTabSize() {
        String string = (String)JavaCore.getOptions().get(PREF_TAB_SIZE);
        return CodeFormatterPreferencePage.getPositiveIntValue(string, 4);
    }

    public static boolean isCompactingAssignment() {
        return COMPACT.equals(JavaCore.getOptions().get(PREF_STYLE_COMPACT_ASSIGNEMENT));
    }

    public static boolean useSpaces() {
        return SPACE.equals(JavaCore.getOptions().get(PREF_TAB_CHAR));
    }

    private static int getPositiveIntValue(String string, int dflt) {
        try {
            int i = Integer.parseInt(string);
            if (i >= 0) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return dflt;
    }

    public CodeFormatterPreferencePage() {
        this.setPreferenceStore(PHPeclipsePlugin.getDefault().getPreferenceStore());
        this.setDescription(PHPUIMessages.getString("CodeFormatterPreferencePage.description"));
        this.fWorkingValues = JavaCore.getOptions();
        this.fCheckBoxes = new ArrayList();
        this.fTextBoxes = new ArrayList();
        this.fButtonSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!e.widget.isDisposed()) {
                    CodeFormatterPreferencePage.this.controlChanged((Button)e.widget);
                }
            }
        };
        this.fTextModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!e.widget.isDisposed()) {
                    CodeFormatterPreferencePage.this.textChanged((Text)e.widget);
                }
            }
        };
        this.fPreviewDocument = new Document();
        this.fPreviewText = this.loadPreviewFile("CodeFormatterPreviewCode.txt");
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        String[] insertNotInsert = new String[]{INSERT, DO_NOT_INSERT};
        layout = new GridLayout();
        layout.numColumns = 2;
        Composite newlineComposite = new Composite((Composite)folder, 0);
        newlineComposite.setLayout((Layout)layout);
        String label = PHPUIMessages.getString("CodeFormatterPreferencePage.newline_opening_braces.label");
        this.addCheckBox(newlineComposite, label, PREF_NEWLINE_OPENING_BRACES, insertNotInsert);
        label = PHPUIMessages.getString("CodeFormatterPreferencePage.newline_control_statement.label");
        this.addCheckBox(newlineComposite, label, PREF_NEWLINE_CONTROL_STATEMENT, insertNotInsert);
        label = PHPUIMessages.getString("CodeFormatterPreferencePage.newline_clear_lines");
        this.addCheckBox(newlineComposite, label, PREF_NEWLINE_CLEAR_ALL, new String[]{CLEAR_ALL, PRESERVE_ONE});
        label = PHPUIMessages.getString("CodeFormatterPreferencePage.newline_empty_block.label");
        this.addCheckBox(newlineComposite, label, PREF_NEWLINE_EMPTY_BLOCK, insertNotInsert);
        layout = new GridLayout();
        layout.numColumns = 2;
        Composite lineSplittingComposite = new Composite((Composite)folder, 0);
        lineSplittingComposite.setLayout((Layout)layout);
        label = PHPUIMessages.getString("CodeFormatterPreferencePage.split_line.label");
        this.addTextField(lineSplittingComposite, label, PREF_LINE_SPLIT);
        layout = new GridLayout();
        layout.numColumns = 2;
        Composite styleComposite = new Composite((Composite)folder, 0);
        styleComposite.setLayout((Layout)layout);
        label = PHPUIMessages.getString("CodeFormatterPreferencePage.style_compact_assignement.label");
        this.addCheckBox(styleComposite, label, PREF_STYLE_COMPACT_ASSIGNEMENT, new String[]{COMPACT, NORMAL});
        label = PHPUIMessages.getString("CodeFormatterPreferencePage.tab_char.label");
        this.addCheckBox(styleComposite, label, PREF_TAB_CHAR, new String[]{TAB, SPACE});
        label = PHPUIMessages.getString("CodeFormatterPreferencePage.tab_size.label");
        this.fTabSizeTextBox = this.addTextField(styleComposite, label, PREF_TAB_SIZE);
        TabItem item = new TabItem(folder, 0);
        item.setText(PHPUIMessages.getString("CodeFormatterPreferencePage.tab.newline.tabtitle"));
        item.setControl((Control)newlineComposite);
        item = new TabItem(folder, 0);
        item.setText(PHPUIMessages.getString("CodeFormatterPreferencePage.tab.linesplit.tabtitle"));
        item.setControl((Control)lineSplittingComposite);
        item = new TabItem(folder, 0);
        item.setText(PHPUIMessages.getString("CodeFormatterPreferencePage.tab.style.tabtitle"));
        item.setControl((Control)styleComposite);
        this.updatePreview();
        return composite;
    }

    private Button addCheckBox(Composite parent, String label, String key, String[] values) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        checkBox.setData((Object)data);
        checkBox.setLayoutData((Object)gd);
        String currValue = (String)this.fWorkingValues.get(key);
        checkBox.setSelection(data.getSelection(currValue) == 0);
        checkBox.addSelectionListener(this.fButtonSelectionListener);
        this.fCheckBoxes.add(checkBox);
        return checkBox;
    }

    private Text addTextField(Composite parent, String label, String key) {
        Label labelControl = new Label(parent, 0);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)new GridData());
        Text textBox = new Text(parent, 2052);
        textBox.setData((Object)key);
        textBox.setLayoutData((Object)new GridData());
        String currValue = (String)this.fWorkingValues.get(key);
        textBox.setText(String.valueOf(CodeFormatterPreferencePage.getPositiveIntValue(currValue, 1)));
        textBox.setTextLimit(3);
        textBox.addModifyListener(this.fTextModifyListener);
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(5);
        textBox.setLayoutData((Object)gd);
        this.fTextBoxes.add(textBox);
        return textBox;
    }

    private void controlChanged(Button button) {
        ControlData data = (ControlData)button.getData();
        boolean selection = button.getSelection();
        String newValue = data.getValue(selection);
        this.fWorkingValues.put(data.getKey(), newValue);
        this.updatePreview();
        if (PREF_TAB_CHAR.equals(data.getKey())) {
            this.updateStatus(new StatusInfo());
            if (selection) {
                this.fTabSizeTextBox.setText((String)this.fWorkingValues.get(PREF_TAB_SIZE));
            }
        }
    }

    private void textChanged(Text textControl) {
        String key = (String)textControl.getData();
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number);
        if (!status.matches(4)) {
            this.fWorkingValues.put(key, number);
        }
        this.updateStatus(status);
        this.updatePreview();
    }

    public boolean performOk() {
        String[] allKeys = CodeFormatterPreferencePage.getAllKeys();
        Hashtable actualOptions = JavaCore.getOptions();
        int i = 0;
        while (i < allKeys.length) {
            String key = allKeys[i];
            String val = (String)this.fWorkingValues.get(key);
            actualOptions.put(key, val);
            ++i;
        }
        JavaCore.setOptions(actualOptions);
        PHPeclipsePlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        this.fWorkingValues = JavaCore.getDefaultOptions();
        this.updateControls();
        super.performDefaults();
    }

    /*
     * Exception decompiling
     */
    private String loadPreviewFile(String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 111->114)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updatePreview() {
        ICodeFormatter formatter = ToolFactory.createDefaultCodeFormatter(this.fWorkingValues);
        this.fPreviewDocument.set(formatter.format(this.fPreviewText, 0, null, "\n"));
    }

    private void updateControls() {
        String currValue;
        Button curr;
        int i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            ControlData data = (ControlData)(curr = (Button)this.fCheckBoxes.get(i)).getData();
            curr.setSelection(data.getSelection(currValue = (String)this.fWorkingValues.get(data.getKey())) == 0);
            --i;
        }
        i = this.fTextBoxes.size() - 1;
        while (i >= 0) {
            curr = (Text)this.fTextBoxes.get(i);
            String key = (String)curr.getData();
            currValue = (String)this.fWorkingValues.get(key);
            curr.setText(currValue);
            --i;
        }
    }

    private IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PHPUIMessages.getString("CodeFormatterPreferencePage.empty_input"));
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(PHPUIMessages.getFormattedString("CodeFormatterPreferencePage.invalid_input", number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(PHPUIMessages.getFormattedString("CodeFormatterPreferencePage.invalid_input", number));
            }
        }
        return status;
    }

    private void updateStatus(IStatus status) {
        if (!status.matches(4)) {
            int i = 0;
            while (i < this.fTextBoxes.size()) {
                Text curr = (Text)this.fTextBoxes.get(i);
                if (curr != this.fTabSizeTextBox || !this.usesTabs()) {
                    IStatus currStatus = this.validatePositiveNumber(curr.getText());
                    status = StatusUtil.getMoreSevere(currStatus, status);
                }
                ++i;
            }
        }
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    private boolean usesTabs() {
        return TAB.equals(this.fWorkingValues.get(PREF_TAB_CHAR));
    }

    private static class ControlData {
        private String fKey;
        private String[] fValues;

        public ControlData(String key, String[] values) {
            this.fKey = key;
            this.fValues = values;
        }

        public String getKey() {
            return this.fKey;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.fValues[index];
        }

        public String getValue(int index) {
            return this.fValues[index];
        }

        public int getSelection(String value) {
            int i = 0;
            while (i < this.fValues.length) {
                if (value.equals(this.fValues[i])) {
                    return i;
                }
                ++i;
            }
            throw new IllegalArgumentException();
        }
    }
}

