/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.preferences;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import net.sourceforge.phpdt.internal.ui.dialogs.StatusInfo;
import net.sourceforge.phpdt.internal.ui.dialogs.StatusUtil;
import net.sourceforge.phpdt.internal.ui.preferences.FoldingConfigurationBlock;
import net.sourceforge.phpdt.internal.ui.preferences.JavaEditorHoverConfigurationBlock;
import net.sourceforge.phpdt.internal.ui.preferences.JavaSourcePreviewerUpdater;
import net.sourceforge.phpdt.internal.ui.preferences.OverlayPreferenceStore;
import net.sourceforge.phpdt.internal.ui.preferences.PreferencesMessages;
import net.sourceforge.phpdt.internal.ui.text.PreferencesAdapter;
import net.sourceforge.phpdt.internal.ui.util.TabFolderLayout;
import net.sourceforge.phpdt.ui.text.JavaTextTools;
import net.sourceforge.phpdt.ui.text.PHPSourceViewerConfiguration;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.phpeditor.EditorUtility;
import net.sourceforge.phpeclipse.phpeditor.JavaSourceViewer;
import net.sourceforge.phpeclipse.preferences.ColorEditor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

public class JavaEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String BOLD = "_bold";
    private static final String COMPILER_TASK_TAGS = "net.sourceforge.phpeclipse.compiler.taskTags";
    private static final String DELIMITER = PreferencesMessages.getString("JavaEditorPreferencePage.navigation.delimiter");
    public final OverlayPreferenceStore.OverlayKey[] fKeys;
    private final String[][] fSyntaxColorListModel = new String[][]{{PreferencesMessages.getString("JavaEditorPreferencePage.multiLineComment"), "_php_multilineComment"}, {PreferencesMessages.getString("JavaEditorPreferencePage.singleLineComment"), "_php_singlelineComment"}, {PreferencesMessages.getString("JavaEditorPreferencePage.tags"), "_php_tag"}, {PreferencesMessages.getString("JavaEditorPreferencePage.keywords"), "_php_keyword"}, {PreferencesMessages.getString("JavaEditorPreferencePage.functionNames"), "_php_functionname"}, {PreferencesMessages.getString("JavaEditorPreferencePage.variables"), "_php_variable"}, {PreferencesMessages.getString("JavaEditorPreferencePage.variables_dollar"), "_php_variable_dollar"}, {PreferencesMessages.getString("JavaEditorPreferencePage.constants"), "_php_constant"}, {PreferencesMessages.getString("JavaEditorPreferencePage.types"), "_php_type"}, {PreferencesMessages.getString("JavaEditorPreferencePage.strings_dq"), "_php_string"}, {PreferencesMessages.getString("JavaEditorPreferencePage.strings_sq"), "_php_string_sq"}, {PreferencesMessages.getString("JavaEditorPreferencePage.others"), "_php_default"}, {PreferencesMessages.getString("JavaEditorPreferencePage.operators"), "__php_operator"}, {PreferencesMessages.getString("JavaEditorPreferencePage.returnKeyword"), "__php_keyword_return"}, {PreferencesMessages.getString("JavaEditorPreferencePage.braces"), "__php_brace_operator"}, {PreferencesMessages.getString("JavaEditorPreferencePage.phpDocKeywords"), "_php_doc_keyword"}, {PreferencesMessages.getString("JavaEditorPreferencePage.phpDocHtmlTags"), "_php_doc_tag"}, {PreferencesMessages.getString("JavaEditorPreferencePage.phpDocLinks"), "_php_doc_link"}, {PreferencesMessages.getString("JavaEditorPreferencePage.phpDocOthers"), "_php_doc_default"}};
    private final String[][] fAppearanceColorListModel = new String[][]{{PreferencesMessages.getString("JavaEditorPreferencePage.lineNumberForegroundColor"), "lineNumberColor"}, {PreferencesMessages.getString("JavaEditorPreferencePage.matchingBracketsHighlightColor2"), "matchingBracketsColor"}, {PreferencesMessages.getString("JavaEditorPreferencePage.currentLineHighlighColor"), "currentLineColor"}, {PreferencesMessages.getString("JavaEditorPreferencePage.printMarginColor2"), "printMarginColor"}, {PreferencesMessages.getString("JavaEditorPreferencePage.findScopeColor2"), "AbstractTextEditor.Color.FindScope"}, {PreferencesMessages.getString("JavaEditorPreferencePage.linkColor2"), "linkColor"}};
    private OverlayPreferenceStore fOverlayStore;
    private JavaTextTools fJavaTextTools;
    private JavaEditorHoverConfigurationBlock fJavaEditorHoverConfigurationBlock;
    private FoldingConfigurationBlock fFoldingConfigurationBlock;
    private Map fColorButtons = new HashMap();
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            JavaEditorPreferencePage.this.fOverlayStore.setValue((String)JavaEditorPreferencePage.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private Map fTextFields = new HashMap();
    private ModifyListener fTextFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            JavaEditorPreferencePage.this.fOverlayStore.setValue((String)JavaEditorPreferencePage.this.fTextFields.get(text), text.getText());
        }
    };
    private ArrayList fNumberFields = new ArrayList();
    private ModifyListener fNumberFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            JavaEditorPreferencePage.this.numberFieldChanged((Text)e.widget);
        }
    };
    private List fSyntaxColorList;
    private List fAppearanceColorList;
    private List fAnnotationList;
    private ColorEditor fSyntaxForegroundColorEditor;
    private ColorEditor fAppearanceColorEditor;
    private ColorEditor fAnnotationForegroundColorEditor;
    private ColorEditor fContentAssistColorEditor;
    private ColorEditor fBackgroundColorEditor;
    private Button fBackgroundDefaultRadioButton;
    private Button fBackgroundCustomRadioButton;
    private Button fBackgroundColorButton;
    private Button fBoldCheckBox;
    private Button fEscapeStringsButtonDQ;
    private Button fEscapeStringsButtonSQ;
    private SourceViewer fPreviewViewer;
    private Color fBackgroundColor;
    private Control fAutoInsertDelayText;
    private Control fAutoInsertJavaTriggerText;
    private Control fAutoInsertJavaDocTriggerText;
    private Label fAutoInsertDelayLabel;
    private Label fAutoInsertJavaTriggerLabel;
    private Label fAutoInsertJavaDocTriggerLabel;
    private Button fShowInTextCheckBox;
    private Combo fDecorationStyleCombo;
    private Button fHighlightInTextCheckBox;
    private Button fShowInOverviewRulerCheckBox;
    private Button fShowInVerticalRulerCheckBox;
    private Text fBrowserLikeLinksKeyModifierText;
    private Button fBrowserLikeLinksCheckBox;
    private StatusInfo fBrowserLikeLinksKeyModifierStatus;

    public JavaEditorPreferencePage() {
        this.setDescription(PreferencesMessages.getString("JavaEditorPreferencePage.description"));
        this.setPreferenceStore(PHPeclipsePlugin.getDefault().getPreferenceStore());
        MarkerAnnotationPreferences markerAnnotationPreferences = new MarkerAnnotationPreferences();
        this.fKeys = this.createOverlayStoreKeys(markerAnnotationPreferences);
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.fKeys);
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys(MarkerAnnotationPreferences preferences) {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        Iterator e = preferences.getAnnotationPreferences().iterator();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.Foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.Foreground.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.Background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.Background.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "tabWidth"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "_php_multilineComment"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "_php_multilineComment_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "_php_singlelineComment"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "_php_singlelineComment_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "_php_keyword"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "_php_keyword_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "_php_tag"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "_php_tag_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "_php_functionname"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "_php_functionname_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "_php_variable"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "_php_variable_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "_php_variable_dollar"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "_php_variable_dollar_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "_php_constant"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "_php_constant_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "_php_type"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "_php_type_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "_php_string"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "_php_string_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "_php_string_sq"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "_php_string_sq_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "_php_default"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "_php_default_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "_php_comment_task_tag"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "_php_comment_task_tag_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "__php_operator"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "__php_operator_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "__php_keyword_return"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "__php_keyword_return_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "__php_brace_operator"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "__php_brace_operator_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "_php_doc_keyword"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "_php_doc_keyword_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "_php_doc_tag"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "_php_doc_tag_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "_php_doc_link"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "_php_doc_link_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "_php_doc_default"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "_php_doc_default_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "matchingBracketsColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "matchingBrackets"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "currentLineColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "currentLine"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "printMarginColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "printMarginColumn"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "printMargin"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.FindScope"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "linkColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "JavaEditor.ShowTemporaryProblem"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "handleTemporaryProblems"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "overviewRuler"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "lineNumberColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "lineNumberRuler"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "spacesForTabs"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoactivation"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "content_assist_autoactivation_delay"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoinsert"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_proposals_background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_proposals_foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_parameters_background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_parameters_foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_completion_replacement_background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_completion_replacement_foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_autoactivation_triggers_php"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_autoactivation_triggers_phpdoc"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_show_visible_proposals"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_order_proposals"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_case_sensitivity"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_add_import"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_insert_completion"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_fill_method_arguments"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_guess_method_arguments"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "smartPaste"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeStringsPHPDQ"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeStringsPHPSQ"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeBracketsPHP"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeJavaDocs"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "wrapWords"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "wrapStringsDQ"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "escapeStringsDQ"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "wrapStringsDQ"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "escapeStringsSQ"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "addJavaDocTags"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "formatJavaDocs"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_p_trim_on_save"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Navigation.SmartHomeEnd"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "subWordNavigation"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "disable_overwrite_mode"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "hoverModifiers"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "hoverModifierMasks"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "browserLikeLinks"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "browserLikeLinksKeyModifier"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "browserLikeLinksKeyModifierMask"));
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, info.getColorPreferenceKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getTextPreferenceKey()));
            if (info.getHighlightPreferenceKey() != null) {
                overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getHighlightPreferenceKey()));
            }
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getOverviewRulerPreferenceKey()));
            if (info.getVerticalRulerPreferenceKey() != null) {
                overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getVerticalRulerPreferenceKey()));
            }
            if (info.getTextStylePreferenceKey() == null) continue;
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, info.getTextStylePreferenceKey()));
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "net.sourceforge.phpeclipse.java_editor_preference_page_context");
    }

    private void handleSyntaxColorListSelection() {
        int i = this.fSyntaxColorList.getSelectionIndex();
        String key = this.fSyntaxColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fSyntaxForegroundColorEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.fOverlayStore.getBoolean(String.valueOf(key) + BOLD));
    }

    private void handleAppearanceColorListSelection() {
        int i = this.fAppearanceColorList.getSelectionIndex();
        String key = this.fAppearanceColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fAppearanceColorEditor.setColorValue(rgb);
    }

    private Control createSyntaxPage(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Group backgroundComposite = new Group(colorComposite, 16);
        backgroundComposite.setLayout((Layout)new RowLayout());
        backgroundComposite.setText(PreferencesMessages.getString("JavaEditorPreferencePage.backgroundColor"));
        SelectionListener backgroundSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean custom = JavaEditorPreferencePage.this.fBackgroundCustomRadioButton.getSelection();
                JavaEditorPreferencePage.this.fBackgroundColorButton.setEnabled(custom);
                JavaEditorPreferencePage.this.fOverlayStore.setValue("AbstractTextEditor.Color.Background.SystemDefault", !custom);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fBackgroundDefaultRadioButton = new Button((Composite)backgroundComposite, 16400);
        this.fBackgroundDefaultRadioButton.setText(PreferencesMessages.getString("JavaEditorPreferencePage.systemDefault"));
        this.fBackgroundDefaultRadioButton.addSelectionListener(backgroundSelectionListener);
        this.fBackgroundCustomRadioButton = new Button((Composite)backgroundComposite, 16400);
        this.fBackgroundCustomRadioButton.setText(PreferencesMessages.getString("JavaEditorPreferencePage.custom"));
        this.fBackgroundCustomRadioButton.addSelectionListener(backgroundSelectionListener);
        this.fBackgroundColorEditor = new ColorEditor((Composite)backgroundComposite);
        this.fBackgroundColorButton = this.fBackgroundColorEditor.getButton();
        Label label = new Label(colorComposite, 16384);
        label.setText(PreferencesMessages.getString("JavaEditorPreferencePage.foreground"));
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        editorComposite.setLayoutData((Object)gd);
        this.fSyntaxColorList = new List(editorComposite, 2564);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fSyntaxColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(stylesComposite, 16384);
        label.setText(PreferencesMessages.getString("JavaEditorPreferencePage.color"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fSyntaxForegroundColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fSyntaxForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setText(PreferencesMessages.getString("JavaEditorPreferencePage.bold"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        label = new Label(colorComposite, 16384);
        label.setText(PreferencesMessages.getString("JavaEditorPreferencePage.preview"));
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(colorComposite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        previewer.setLayoutData((Object)gd);
        this.fSyntaxColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JavaEditorPreferencePage.this.handleSyntaxColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = JavaEditorPreferencePage.this.fSyntaxColorList.getSelectionIndex();
                String key = JavaEditorPreferencePage.this.fSyntaxColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)JavaEditorPreferencePage.this.fOverlayStore, (String)key, (RGB)JavaEditorPreferencePage.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fBackgroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PreferenceConverter.setValue((IPreferenceStore)JavaEditorPreferencePage.this.fOverlayStore, (String)"AbstractTextEditor.Color.Background", (RGB)JavaEditorPreferencePage.this.fBackgroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = JavaEditorPreferencePage.this.fSyntaxColorList.getSelectionIndex();
                String key = JavaEditorPreferencePage.this.fSyntaxColorListModel[i][1];
                JavaEditorPreferencePage.this.fOverlayStore.setValue(String.valueOf(key) + JavaEditorPreferencePage.BOLD, JavaEditorPreferencePage.this.fBoldCheckBox.getSelection());
            }
        });
        return colorComposite;
    }

    private Control createPreviewer(Composite parent) {
        Preferences coreStore = this.createTemporaryCorePreferenceStore();
        this.fJavaTextTools = new JavaTextTools(this.fOverlayStore, coreStore, false);
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{this.fOverlayStore, new PreferencesAdapter(this.createTemporaryCorePreferenceStore()), generalTextStore});
        this.fPreviewViewer = new JavaSourceViewer(parent, null, null, false, 2816, (IPreferenceStore)store);
        JavaTextTools tools = PHPeclipsePlugin.getDefault().getJavaTextTools();
        PHPSourceViewerConfiguration configuration = new PHPSourceViewerConfiguration(tools.getColorManager(), (IPreferenceStore)store, null, "___php_partitioning");
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        Font font = JFaceResources.getFont((String)"net.sourceforge.phpdt.ui.editors.textfont");
        this.fPreviewViewer.getTextWidget().setFont(font);
        new JavaSourcePreviewerUpdater(this.fPreviewViewer, configuration, (IPreferenceStore)store);
        this.fPreviewViewer.setEditable(false);
        String content = this.loadPreviewContentFromFile("ColorSettingPreviewCode.txt");
        Document document = new Document(content);
        this.fJavaTextTools.setupJavaDocumentPartitioner((IDocument)document, "___php_partitioning");
        this.fPreviewViewer.setDocument((IDocument)document);
        return this.fPreviewViewer.getControl();
    }

    private Preferences createTemporaryCorePreferenceStore() {
        Preferences result = new Preferences();
        result.setValue(COMPILER_TASK_TAGS, "TASK");
        return result;
    }

    private Control createAppearancePage(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        String label = PreferencesMessages.getString("JavaEditorPreferencePage.displayedTabWidth");
        this.addTextField(appearanceComposite, label, "tabWidth", 3, 0, true);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.printMarginColumn");
        this.addTextField(appearanceComposite, label, "printMarginColumn", 3, 0, true);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.showOverviewRuler");
        this.addCheckBox(appearanceComposite, label, "overviewRuler", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.showLineNumbers");
        this.addCheckBox(appearanceComposite, label, "lineNumberRuler", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.highlightMatchingBrackets");
        this.addCheckBox(appearanceComposite, label, "matchingBrackets", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.highlightCurrentLine");
        this.addCheckBox(appearanceComposite, label, "currentLine", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.showPrintMargin");
        this.addCheckBox(appearanceComposite, label, "printMargin", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.markOccurrences");
        label = PreferencesMessages.getString("JavaEditorPreferencePage.stickyOccurrences");
        Label l = new Label(appearanceComposite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        l.setLayoutData((Object)gd);
        l = new Label(appearanceComposite, 16384);
        l.setText(PreferencesMessages.getString("JavaEditorPreferencePage.appearanceOptions"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(appearanceComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAppearanceColorList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.fAppearanceColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        l = new Label(stylesComposite, 16384);
        l.setText(PreferencesMessages.getString("JavaEditorPreferencePage.color"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.fAppearanceColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fAppearanceColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fAppearanceColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JavaEditorPreferencePage.this.handleAppearanceColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = JavaEditorPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                String key = JavaEditorPreferencePage.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)JavaEditorPreferencePage.this.fOverlayStore, (String)key, (RGB)JavaEditorPreferencePage.this.fAppearanceColorEditor.getColorValue());
            }
        });
        return appearanceComposite;
    }

    private String[][] createAnnotationTypeListModel(MarkerAnnotationPreferences preferences) {
        ArrayList<String[]> listModelItems = new ArrayList<String[]>();
        TreeSet sortedPreferences = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (!(o2 instanceof AnnotationPreference)) {
                    return -1;
                }
                if (!(o1 instanceof AnnotationPreference)) {
                    return 1;
                }
                AnnotationPreference a1 = (AnnotationPreference)o1;
                AnnotationPreference a2 = (AnnotationPreference)o2;
                return Collator.getInstance().compare(a1.getPreferenceLabel(), a2.getPreferenceLabel());
            }
        });
        sortedPreferences.addAll(preferences.getAnnotationPreferences());
        Iterator e = sortedPreferences.iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            listModelItems.add(new String[]{info.getPreferenceLabel(), info.getColorPreferenceKey(), info.getTextPreferenceKey(), info.getOverviewRulerPreferenceKey(), info.getHighlightPreferenceKey(), info.getVerticalRulerPreferenceKey(), info.getTextStylePreferenceKey()});
        }
        String[][] items = new String[listModelItems.size()][];
        listModelItems.toArray((T[])items);
        return items;
    }

    private Control createTypingPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        Group group = new Group(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setText(PreferencesMessages.getString("JavaEditorPreferencePage.typing.description"));
        String label = PreferencesMessages.getString("JavaEditorPreferencePage.wrapWords");
        this.addCheckBox((Composite)group, label, "wrapWords", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.wrapStringsDQ");
        Button button = this.addCheckBox((Composite)group, label, "wrapStringsDQ", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.escapeStringsDQ");
        this.fEscapeStringsButtonDQ = this.addCheckBox((Composite)group, label, "escapeStringsDQ", 1);
        JavaEditorPreferencePage.createDependency(button, (Control)this.fEscapeStringsButtonDQ);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.wrapStringsSQ");
        this.addCheckBox((Composite)group, label, "wrapStringsDQ", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.escapeStringsSQ");
        this.fEscapeStringsButtonSQ = this.addCheckBox((Composite)group, label, "escapeStringsSQ", 1);
        JavaEditorPreferencePage.createDependency(button, (Control)this.fEscapeStringsButtonSQ);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.smartPaste");
        this.addCheckBox((Composite)group, label, "smartPaste", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.insertSpaceForTabs");
        this.addCheckBox((Composite)group, label, "spacesForTabs", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.closeStringsDQ");
        this.addCheckBox((Composite)group, label, "closeStringsPHPDQ", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.closeStringsSQ");
        this.addCheckBox((Composite)group, label, "closeStringsPHPSQ", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.closeBrackets");
        this.addCheckBox((Composite)group, label, "closeBracketsPHP", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.closeJavaDocs");
        button = this.addCheckBox((Composite)group, label, "closeJavaDocs", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.formatJavaDocs");
        button = this.addCheckBox((Composite)group, label, "formatJavaDocs", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.p_rtrim_on_save");
        this.addCheckBox((Composite)group, label, "editor_p_trim_on_save", 1);
        return composite;
    }

    private void addFiller(Composite composite) {
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    private static void indent(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = 20;
        control.setLayoutData((Object)gridData);
    }

    private static void createDependency(final Button master, final Control slave) {
        JavaEditorPreferencePage.indent(slave);
        master.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                slave.setEnabled(master.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addCompletionRadioButtons(Composite contentAssistComposite) {
        Composite completionComposite = new Composite(contentAssistComposite, 0);
        GridData ccgd = new GridData();
        ccgd.horizontalSpan = 2;
        completionComposite.setLayoutData((Object)ccgd);
        GridLayout ccgl = new GridLayout();
        ccgl.marginWidth = 0;
        ccgl.numColumns = 2;
        completionComposite.setLayout((Layout)ccgl);
    }

    private Control createNavigationPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        String text = PreferencesMessages.getString("JavaEditorPreferencePage.navigation.browserLikeLinks");
        this.fBrowserLikeLinksCheckBox = this.addCheckBox(composite, text, "browserLikeLinks", 0);
        this.fBrowserLikeLinksCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean state = JavaEditorPreferencePage.this.fBrowserLikeLinksCheckBox.getSelection();
                JavaEditorPreferencePage.this.fBrowserLikeLinksKeyModifierText.setEnabled(state);
                JavaEditorPreferencePage.this.handleBrowserLikeLinksKeyModifierModified();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        text = PreferencesMessages.getString("JavaEditorPreferencePage.navigation.browserLikeLinksKeyModifier");
        this.fBrowserLikeLinksKeyModifierText = this.addTextField(composite, text, "browserLikeLinksKeyModifier", 20, 0, false);
        this.fBrowserLikeLinksKeyModifierText.setTextLimit(Text.LIMIT);
        if (this.computeStateMask(this.fOverlayStore.getString("browserLikeLinksKeyModifier")) == -1) {
            int stateMask = this.fOverlayStore.getInt("browserLikeLinksKeyModifierMask");
            if (stateMask == -1) {
                this.fBrowserLikeLinksKeyModifierText.setText("");
            } else {
                this.fBrowserLikeLinksKeyModifierText.setText(EditorUtility.getModifierString(stateMask));
            }
        }
        this.fBrowserLikeLinksKeyModifierText.addKeyListener(new KeyListener(){
            private boolean isModifierCandidate;

            public void keyPressed(KeyEvent e) {
                this.isModifierCandidate = e.keyCode > 0 && e.character == '\u0000' && e.stateMask == 0;
            }

            public void keyReleased(KeyEvent e) {
                if (this.isModifierCandidate && e.stateMask > 0 && e.stateMask == e.stateMask && e.character == '\u0000') {
                    boolean needsPostfixDelimiter;
                    String modifierString = JavaEditorPreferencePage.this.fBrowserLikeLinksKeyModifierText.getText();
                    Point selection = JavaEditorPreferencePage.this.fBrowserLikeLinksKeyModifierText.getSelection();
                    int i = selection.x - 1;
                    while (i > -1 && Character.isWhitespace(modifierString.charAt(i))) {
                        --i;
                    }
                    boolean needsPrefixDelimiter = i > -1 && !String.valueOf(modifierString.charAt(i)).equals(DELIMITER);
                    i = selection.y;
                    while (i < modifierString.length() && Character.isWhitespace(modifierString.charAt(i))) {
                        ++i;
                    }
                    boolean bl = needsPostfixDelimiter = i < modifierString.length() && !String.valueOf(modifierString.charAt(i)).equals(DELIMITER);
                    String insertString = needsPrefixDelimiter && needsPostfixDelimiter ? PreferencesMessages.getFormattedString("JavaEditorPreferencePage.navigation.insertDelimiterAndModifierAndDelimiter", new String[]{Action.findModifierString((int)e.stateMask)}) : (needsPrefixDelimiter ? PreferencesMessages.getFormattedString("JavaEditorPreferencePage.navigation.insertDelimiterAndModifier", new String[]{Action.findModifierString((int)e.stateMask)}) : (needsPostfixDelimiter ? PreferencesMessages.getFormattedString("JavaEditorPreferencePage.navigation.insertModifierAndDelimiter", new String[]{Action.findModifierString((int)e.stateMask)}) : Action.findModifierString((int)e.stateMask)));
                    JavaEditorPreferencePage.this.fBrowserLikeLinksKeyModifierText.insert(insertString);
                }
            }
        });
        this.fBrowserLikeLinksKeyModifierText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaEditorPreferencePage.this.handleBrowserLikeLinksKeyModifierModified();
            }
        });
        return composite;
    }

    private void handleBrowserLikeLinksKeyModifierModified() {
        String modifiers = this.fBrowserLikeLinksKeyModifierText.getText();
        int stateMask = this.computeStateMask(modifiers);
        if (this.fBrowserLikeLinksCheckBox.getSelection() && (stateMask == -1 || (stateMask & 0x20000) != 0)) {
            this.fBrowserLikeLinksKeyModifierStatus = stateMask == -1 ? new StatusInfo(4, PreferencesMessages.getFormattedString("JavaEditorPreferencePage.navigation.modifierIsNotValid", modifiers)) : new StatusInfo(4, PreferencesMessages.getString("JavaEditorPreferencePage.navigation.shiftIsDisabled"));
            this.setValid(false);
            StatusUtil.applyToStatusLine((DialogPage)this, this.fBrowserLikeLinksKeyModifierStatus);
        } else {
            this.fBrowserLikeLinksKeyModifierStatus = new StatusInfo();
            this.updateStatus(this.fBrowserLikeLinksKeyModifierStatus);
        }
    }

    private IStatus getBrowserLikeLinksKeyModifierStatus() {
        if (this.fBrowserLikeLinksKeyModifierStatus == null) {
            this.fBrowserLikeLinksKeyModifierStatus = new StatusInfo();
        }
        return this.fBrowserLikeLinksKeyModifierStatus;
    }

    private int computeStateMask(String modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.length() == 0) {
            return 0;
        }
        int stateMask = 0;
        StringTokenizer modifierTokenizer = new StringTokenizer(modifiers, ",;.:+-* ");
        while (modifierTokenizer.hasMoreTokens()) {
            int modifier = EditorUtility.findLocalizedModifier(modifierTokenizer.nextToken());
            if (modifier == 0 || (stateMask & modifier) == modifier) {
                return -1;
            }
            stateMask |= modifier;
        }
        return stateMask;
    }

    protected Control createContents(Composite parent) {
        this.initializeDefaultColors();
        this.fFoldingConfigurationBlock = new FoldingConfigurationBlock(this.fOverlayStore);
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("JavaEditorPreferencePage.general"));
        item.setControl(this.createAppearancePage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("JavaEditorPreferencePage.colors"));
        item.setControl(this.createSyntaxPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("JavaEditorPreferencePage.typing.tabTitle"));
        item.setControl(this.createTypingPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("JavaEditorPreferencePage.hoverTab.title"));
        this.fJavaEditorHoverConfigurationBlock = new JavaEditorHoverConfigurationBlock(this, this.fOverlayStore);
        item.setControl(this.fJavaEditorHoverConfigurationBlock.createControl((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("JavaEditorPreferencePage.navigationTab.title"));
        item.setControl(this.createNavigationPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("JavaEditorPreferencePage.folding.title"));
        item.setControl(this.fFoldingConfigurationBlock.createControl((Composite)folder));
        this.initialize();
        Dialog.applyDialogFont((Control)folder);
        return folder;
    }

    private void initialize() {
        this.initializeFields();
        int i = 0;
        while (i < this.fSyntaxColorListModel.length) {
            this.fSyntaxColorList.add(this.fSyntaxColorListModel[i][0]);
            ++i;
        }
        this.fSyntaxColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (JavaEditorPreferencePage.this.fSyntaxColorList != null && !JavaEditorPreferencePage.this.fSyntaxColorList.isDisposed()) {
                    JavaEditorPreferencePage.this.fSyntaxColorList.select(0);
                    JavaEditorPreferencePage.this.handleSyntaxColorListSelection();
                }
            }
        });
        i = 0;
        while (i < this.fAppearanceColorListModel.length) {
            this.fAppearanceColorList.add(this.fAppearanceColorListModel[i][0]);
            ++i;
        }
        this.fAppearanceColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (JavaEditorPreferencePage.this.fAppearanceColorList != null && !JavaEditorPreferencePage.this.fAppearanceColorList.isDisposed()) {
                    JavaEditorPreferencePage.this.fAppearanceColorList.select(0);
                    JavaEditorPreferencePage.this.handleAppearanceColorListSelection();
                }
            }
        });
        this.fFoldingConfigurationBlock.initialize();
    }

    private void initializeFields() {
        String key;
        Iterator e = this.fColorButtons.keySet().iterator();
        while (e.hasNext()) {
            ColorEditor c = (ColorEditor)e.next();
            key = (String)this.fColorButtons.get(c);
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
            c.setColorValue(rgb);
        }
        e = this.fCheckBoxes.keySet().iterator();
        while (e.hasNext()) {
            Button b = (Button)e.next();
            key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
        e = this.fTextFields.keySet().iterator();
        while (e.hasNext()) {
            Text t = (Text)e.next();
            key = (String)this.fTextFields.get(t);
            t.setText(this.fOverlayStore.getString(key));
        }
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.Background");
        this.fBackgroundColorEditor.setColorValue(rgb);
        boolean default_ = this.fOverlayStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        this.fBackgroundDefaultRadioButton.setSelection(default_);
        this.fBackgroundCustomRadioButton.setSelection(!default_);
        this.fBackgroundColorButton.setEnabled(!default_);
        this.fOverlayStore.getBoolean("closeJavaDocs");
        this.fEscapeStringsButtonDQ.setEnabled(this.fOverlayStore.getBoolean("wrapStringsDQ"));
        this.fEscapeStringsButtonSQ.setEnabled(this.fOverlayStore.getBoolean("wrapStringsDQ"));
        this.fBrowserLikeLinksKeyModifierText.setEnabled(this.fBrowserLikeLinksCheckBox.getSelection());
        this.updateAutoactivationControls();
    }

    private void initializeDefaultColors() {
        RGB rgb;
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.Background")) {
            rgb = this.getControl().getDisplay().getSystemColor(25).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.Background", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.Background", (RGB)rgb);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.Foreground")) {
            rgb = this.getControl().getDisplay().getSystemColor(24).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.Foreground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.Foreground", (RGB)rgb);
        }
    }

    private void updateAutoactivationControls() {
    }

    public boolean performOk() {
        this.fFoldingConfigurationBlock.performOk();
        this.fOverlayStore.setValue("browserLikeLinksKeyModifierMask", this.computeStateMask(this.fBrowserLikeLinksKeyModifierText.getText()));
        this.fOverlayStore.propagate();
        PHPeclipsePlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        this.handleSyntaxColorListSelection();
        this.handleAppearanceColorListSelection();
        this.fFoldingConfigurationBlock.performDefaults();
        super.performDefaults();
        this.fPreviewViewer.invalidateTextPresentation();
    }

    public void dispose() {
        this.fFoldingConfigurationBlock.dispose();
        if (this.fJavaTextTools != null) {
            this.fJavaTextTools.dispose();
            this.fJavaTextTools = null;
        }
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        if (this.fBackgroundColor != null && !this.fBackgroundColor.isDisposed()) {
            this.fBackgroundColor.dispose();
        }
        super.dispose();
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private Text addTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        return JavaEditorPreferencePage.getTextControl(this.addLabelledTextField(composite, label, key, textLimit, indentation, isNumber));
    }

    private static Label getLabelControl(Control[] labelledTextField) {
        return (Label)labelledTextField[0];
    }

    private static Text getTextControl(Control[] labelledTextField) {
        return (Text)labelledTextField[1];
    }

    private Control[] addLabelledTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        this.fTextFields.put(textControl, key);
        if (isNumber) {
            this.fNumberFields.add(textControl);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return new Control[]{labelControl, textControl};
    }

    /*
     * Exception decompiling
     */
    private String loadPreviewContentFromFile(String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 112->115)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number);
        if (!status.matches(4)) {
            this.fOverlayStore.setValue((String)this.fTextFields.get(textControl), number);
        }
        this.updateStatus(status);
    }

    private IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.getString("JavaEditorPreferencePage.empty_input"));
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(PreferencesMessages.getFormattedString("JavaEditorPreferencePage.invalid_input", number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(PreferencesMessages.getFormattedString("JavaEditorPreferencePage.invalid_input", number));
            }
        }
        return status;
    }

    void updateStatus(IStatus status) {
        if (!status.matches(4)) {
            int i = 0;
            while (i < this.fNumberFields.size()) {
                Text text = (Text)this.fNumberFields.get(i);
                IStatus s = this.validatePositiveNumber(text.getText());
                status = StatusUtil.getMoreSevere(s, status);
                ++i;
            }
        }
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }
}

