/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.phpdt.internal.ui.preferences.PreferencesMessages;
import net.sourceforge.phpdt.internal.ui.util.SWTUtil;
import net.sourceforge.phpdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import net.sourceforge.phpdt.internal.ui.viewsupport.JavaElementImageProvider;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.ListDialogField;
import net.sourceforge.phpdt.ui.JavaElementImageDescriptor;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MembersOrderPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String ALL_ENTRIES = "T,SI,SF,SM,I,F,C,M";
    private static final String PREF_OUTLINE_SORT_OPTION = "outlinesortoption";
    public static final String CONSTRUCTORS = "C";
    public static final String FIELDS = "F";
    public static final String METHODS = "M";
    public static final String STATIC_METHODS = "SM";
    public static final String STATIC_FIELDS = "SF";
    public static final String INIT = "I";
    public static final String STATIC_INIT = "SI";
    public static final String TYPES = "T";
    private ListDialogField fSortOrderList;

    private static List getSortOrderList(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        ArrayList<String> entries = new ArrayList<String>();
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            entries.add(token);
            ++i;
        }
        return entries;
    }

    private static boolean isValidEntries(List entries) {
        StringTokenizer tokenizer = new StringTokenizer(ALL_ENTRIES, ",");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!entries.contains(token)) {
                return false;
            }
            ++i;
        }
        return i == entries.size();
    }

    public MembersOrderPreferencePage() {
        this.setPreferenceStore(PHPeclipsePlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.getString("MembersOrderPreferencePage.label.description"));
        String string = this.getPreferenceStore().getString(PREF_OUTLINE_SORT_OPTION);
        String upLabel = PreferencesMessages.getString("MembersOrderPreferencePage.button.up");
        String downLabel = PreferencesMessages.getString("MembersOrderPreferencePage.button.down");
        String[] buttonlabels = new String[]{upLabel, downLabel};
        this.fSortOrderList = new ListDialogField(null, buttonlabels, (ILabelProvider)new MemberSortLabelProvider());
        this.fSortOrderList.setDownButtonIndex(1);
        this.fSortOrderList.setUpButtonIndex(0);
        List entries = MembersOrderPreferencePage.getSortOrderList(string);
        if (!MembersOrderPreferencePage.isValidEntries(entries)) {
            string = PHPeclipsePlugin.getDefault().getPreferenceStore().getDefaultString(PREF_OUTLINE_SORT_OPTION);
            entries = MembersOrderPreferencePage.getSortOrderList(string);
        }
        this.fSortOrderList.setElements(entries);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 768;
        composite.setLayoutData((Object)data);
        this.createSortOrderListDialogField(composite, 3);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createSortOrderListDialogField(Composite composite, int span) {
        this.fSortOrderList.doFillIntoGrid(composite, span);
        this.fSortOrderList.getLabelControl(null).dispose();
        GridData data = (GridData)this.fSortOrderList.getListControl(null).getLayoutData();
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 0;
        data.heightHint = SWTUtil.getTableHeightHint(this.fSortOrderList.getTableViewer().getTable(), 8);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        String string = this.getPreferenceStore().getDefaultString(PREF_OUTLINE_SORT_OPTION);
        this.fSortOrderList.setElements(MembersOrderPreferencePage.getSortOrderList(string));
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        StringBuffer buf = new StringBuffer();
        List curr = this.fSortOrderList.getElements();
        Iterator iter = curr.iterator();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            buf.append(s);
            buf.append(',');
        }
        store.setValue(PREF_OUTLINE_SORT_OPTION, buf.toString());
        PHPeclipsePlugin.getDefault().savePluginPreferences();
        return true;
    }

    private class MemberSortLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof String) {
                String s = (String)element;
                if (s.equals(MembersOrderPreferencePage.FIELDS)) {
                    return PreferencesMessages.getString("MembersOrderPreferencePage.fields.label");
                }
                if (s.equals(MembersOrderPreferencePage.CONSTRUCTORS)) {
                    return PreferencesMessages.getString("MembersOrderPreferencePage.constructors.label");
                }
                if (s.equals(MembersOrderPreferencePage.METHODS)) {
                    return PreferencesMessages.getString("MembersOrderPreferencePage.methods.label");
                }
                if (s.equals(MembersOrderPreferencePage.STATIC_FIELDS)) {
                    return PreferencesMessages.getString("MembersOrderPreferencePage.staticfields.label");
                }
                if (s.equals(MembersOrderPreferencePage.STATIC_METHODS)) {
                    return PreferencesMessages.getString("MembersOrderPreferencePage.staticmethods.label");
                }
                if (s.equals(MembersOrderPreferencePage.INIT)) {
                    return PreferencesMessages.getString("MembersOrderPreferencePage.initialisers.label");
                }
                if (s.equals(MembersOrderPreferencePage.STATIC_INIT)) {
                    return PreferencesMessages.getString("MembersOrderPreferencePage.staticinitialisers.label");
                }
                if (s.equals(MembersOrderPreferencePage.TYPES)) {
                    return PreferencesMessages.getString("MembersOrderPreferencePage.types.label");
                }
            }
            return "";
        }

        public Image getImage(Object element) {
            ImageDescriptorRegistry registry = PHPeclipsePlugin.getImageDescriptorRegistry();
            Object descriptor = null;
            if (element instanceof String) {
                int visibility = 1;
                String s = (String)element;
                if (s.equals(MembersOrderPreferencePage.FIELDS)) {
                    descriptor = JavaElementImageProvider.getFieldImageDescriptor(false, visibility);
                } else if (s.equals(MembersOrderPreferencePage.CONSTRUCTORS)) {
                    descriptor = JavaElementImageProvider.getMethodImageDescriptor(false, visibility);
                    descriptor = new JavaElementImageDescriptor((ImageDescriptor)descriptor, 512, JavaElementImageProvider.SMALL_SIZE);
                } else if (s.equals(MembersOrderPreferencePage.METHODS)) {
                    descriptor = JavaElementImageProvider.getMethodImageDescriptor(false, visibility);
                } else if (s.equals(MembersOrderPreferencePage.STATIC_FIELDS)) {
                    descriptor = JavaElementImageProvider.getFieldImageDescriptor(false, visibility);
                    descriptor = new JavaElementImageDescriptor((ImageDescriptor)descriptor, 8, JavaElementImageProvider.SMALL_SIZE);
                } else if (s.equals(MembersOrderPreferencePage.STATIC_METHODS)) {
                    descriptor = JavaElementImageProvider.getMethodImageDescriptor(false, visibility);
                    descriptor = new JavaElementImageDescriptor((ImageDescriptor)descriptor, 8, JavaElementImageProvider.SMALL_SIZE);
                } else if (s.equals(MembersOrderPreferencePage.INIT)) {
                    descriptor = JavaElementImageProvider.getMethodImageDescriptor(false, visibility);
                } else if (s.equals(MembersOrderPreferencePage.STATIC_INIT)) {
                    descriptor = JavaElementImageProvider.getMethodImageDescriptor(false, visibility);
                    descriptor = new JavaElementImageDescriptor((ImageDescriptor)descriptor, 8, JavaElementImageProvider.SMALL_SIZE);
                } else {
                    descriptor = s.equals(MembersOrderPreferencePage.TYPES) ? JavaElementImageProvider.getTypeImageDescriptor(false, true, 1) : JavaElementImageProvider.getMethodImageDescriptor(false, 1);
                }
                return registry.get((ImageDescriptor)descriptor);
            }
            return null;
        }
    }
}

