/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.internal.ui.preferences.MockupPreferenceStore;
import net.sourceforge.phpdt.internal.ui.preferences.PreferencesMessages;
import net.sourceforge.phpdt.internal.ui.wizards.IStatusChangeListener;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class OptionsConfigurationBlock {
    protected Map fWorkingValues;
    protected ArrayList fCheckBoxes;
    protected ArrayList fComboBoxes;
    protected ArrayList fTextBoxes;
    protected HashMap fLabels;
    private SelectionListener fSelectionListener;
    private ModifyListener fTextModifyListener;
    protected IStatusChangeListener fContext;
    protected IJavaProject fProject;
    protected String[] fAllKeys;
    private Shell fShell;

    public OptionsConfigurationBlock(IStatusChangeListener context, IJavaProject project, String[] allKeys) {
        this.fContext = context;
        this.fProject = project;
        this.fAllKeys = allKeys;
        this.fWorkingValues = this.getOptions(true);
        this.testIfOptionsComplete(this.fWorkingValues, allKeys);
        this.fCheckBoxes = new ArrayList();
        this.fComboBoxes = new ArrayList();
        this.fTextBoxes = new ArrayList(2);
        this.fLabels = new HashMap();
    }

    private void testIfOptionsComplete(Map workingValues, String[] allKeys) {
        int i = 0;
        while (i < allKeys.length) {
            if (workingValues.get(allKeys[i]) == null) {
                PHPeclipsePlugin.logErrorMessage("preference option missing: " + allKeys[i] + " (" + this.getClass().getName() + ')');
            }
            ++i;
        }
    }

    protected Map getOptions(boolean inheritJavaCoreOptions) {
        if (this.fProject != null) {
            return this.fProject.getOptions(inheritJavaCoreOptions);
        }
        return JavaCore.getOptions();
    }

    protected Map getDefaultOptions() {
        return JavaCore.getDefaultOptions();
    }

    public final boolean hasProjectSpecificOptions() {
        if (this.fProject != null) {
            Map settings = this.fProject.getOptions(false);
            String[] allKeys = this.fAllKeys;
            int i = 0;
            while (i < allKeys.length) {
                if (settings.get(allKeys[i]) != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void setOptions(Map map) {
        if (this.fProject != null) {
            Map oldOptions = this.fProject.getOptions(false);
            this.fProject.setOptions(map);
            this.firePropertyChangeEvents(oldOptions, map);
        } else {
            JavaCore.setOptions((Hashtable)map);
        }
    }

    private void firePropertyChangeEvents(Map oldOptions, Map newOptions) {
        Map.Entry entry;
        oldOptions = new HashMap(oldOptions);
        IProject source = this.fProject.getProject();
        MockupPreferenceStore store = PHPeclipsePlugin.getDefault().getMockupPreferenceStore();
        Iterator iter = newOptions.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            String name = (String)entry.getKey();
            Object oldValue = oldOptions.get(name);
            Object newValue = entry.getValue();
            if (oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null) {
                store.firePropertyChangeEvent(source, name, oldValue, newValue);
            }
            oldOptions.remove(name);
        }
        iter = oldOptions.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            store.firePropertyChangeEvent(source, (String)entry.getKey(), entry.getValue(), null);
        }
    }

    protected Shell getShell() {
        return this.fShell;
    }

    protected void setShell(Shell shell) {
        this.fShell = shell;
    }

    protected abstract Control createContents(Composite var1);

    protected Button addCheckBox(Composite parent, String label, String key, String[] values, int indent) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = indent;
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        checkBox.setData((Object)data);
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.getSelectionListener());
        String currValue = (String)this.fWorkingValues.get(key);
        checkBox.setSelection(data.getSelection(currValue) == 0);
        this.fCheckBoxes.add(checkBox);
        return checkBox;
    }

    protected Combo addComboBox(Composite parent, String label, String key, String[] values, String[] valueLabels, int indent) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 16448);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = new Combo(parent, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        comboBox.setLayoutData((Object)new GridData(256));
        comboBox.addSelectionListener(this.getSelectionListener());
        this.fLabels.put(comboBox, labelControl);
        Label placeHolder = new Label(parent, 0);
        placeHolder.setLayoutData((Object)new GridData(768));
        String currValue = (String)this.fWorkingValues.get(key);
        comboBox.select(data.getSelection(currValue));
        this.fComboBoxes.add(comboBox);
        return comboBox;
    }

    protected void addInversedComboBox(Composite parent, String label, String key, String[] values, String[] valueLabels, int indent) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indent;
        gd.horizontalSpan = 3;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gd);
        Combo comboBox = new Combo(composite, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        comboBox.setLayoutData((Object)new GridData(256));
        comboBox.addSelectionListener(this.getSelectionListener());
        Label labelControl = new Label(composite, 16448);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)new GridData());
        this.fLabels.put(comboBox, labelControl);
        String currValue = (String)this.fWorkingValues.get(key);
        comboBox.select(data.getSelection(currValue));
        this.fComboBoxes.add(comboBox);
    }

    protected Text addTextField(Composite parent, String label, String key, int indent, int widthHint) {
        Label labelControl = new Label(parent, 0);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)new GridData());
        Text textBox = new Text(parent, 2052);
        textBox.setData((Object)key);
        textBox.setLayoutData((Object)new GridData());
        this.fLabels.put(textBox, labelControl);
        String currValue = (String)this.fWorkingValues.get(key);
        if (currValue != null) {
            textBox.setText(currValue);
        }
        textBox.addModifyListener(this.getTextModifyListener());
        GridData data = new GridData(256);
        if (widthHint != 0) {
            data.widthHint = widthHint;
        }
        data.horizontalIndent = indent;
        data.horizontalSpan = 2;
        textBox.setLayoutData((Object)data);
        this.fTextBoxes.add(textBox);
        return textBox;
    }

    protected SelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    OptionsConfigurationBlock.this.controlChanged(e.widget);
                }
            };
        }
        return this.fSelectionListener;
    }

    protected ModifyListener getTextModifyListener() {
        if (this.fTextModifyListener == null) {
            this.fTextModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OptionsConfigurationBlock.this.textChanged((Text)e.widget);
                }
            };
        }
        return this.fTextModifyListener;
    }

    protected void controlChanged(Widget widget) {
        ControlData data = (ControlData)widget.getData();
        String newValue = null;
        if (widget instanceof Button) {
            newValue = data.getValue(((Button)widget).getSelection());
        } else if (widget instanceof Combo) {
            newValue = data.getValue(((Combo)widget).getSelectionIndex());
        } else {
            return;
        }
        this.fWorkingValues.put(data.getKey(), newValue);
        this.validateSettings(data.getKey(), newValue);
    }

    protected void textChanged(Text textControl) {
        String key = (String)textControl.getData();
        String number = textControl.getText();
        this.fWorkingValues.put(key, number);
        this.validateSettings(key, number);
    }

    protected boolean checkValue(String key, String value) {
        return value.equals(this.fWorkingValues.get(key));
    }

    protected abstract void validateSettings(String var1, String var2);

    protected String[] getTokens(String text, String separator) {
        StringTokenizer tok = new StringTokenizer(text, separator);
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (i < res.length) {
            res[i] = tok.nextToken().trim();
            ++i;
        }
        return res;
    }

    public boolean performOk(boolean enabled) {
        String[] allKeys = this.fAllKeys;
        Map actualOptions = this.getOptions(false);
        boolean hasChanges = false;
        int i = 0;
        while (i < allKeys.length) {
            String key = allKeys[i];
            String oldVal = (String)actualOptions.get(key);
            String val = null;
            if (enabled) {
                val = (String)this.fWorkingValues.get(key);
                if (val != null && !val.equals(oldVal)) {
                    hasChanges = true;
                    actualOptions.put(key, val);
                }
            } else if (oldVal != null) {
                actualOptions.remove(key);
                hasChanges = true;
            }
            ++i;
        }
        if (hasChanges) {
            boolean res;
            boolean doBuild = false;
            String[] strings = this.getFullBuildDialogStrings(this.fProject == null);
            if (strings != null) {
                MessageDialog dialog = new MessageDialog(this.getShell(), strings[0], null, strings[1], 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                int res2 = dialog.open();
                if (res2 == 0) {
                    doBuild = true;
                } else if (res2 != 1) {
                    return false;
                }
            }
            this.setOptions(actualOptions);
            if (doBuild && !(res = this.doFullBuild())) {
                return false;
            }
        }
        return true;
    }

    protected abstract String[] getFullBuildDialogStrings(boolean var1);

    protected boolean doFullBuild() {
        Job buildJob = new Job(PreferencesMessages.getString("OptionsConfigurationBlock.job.title")){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        if (OptionsConfigurationBlock.this.fProject != null) {
                            monitor.setTaskName(PreferencesMessages.getFormattedString("OptionsConfigurationBlock.buildproject.taskname", OptionsConfigurationBlock.this.fProject.getElementName()));
                            OptionsConfigurationBlock.this.fProject.getProject().build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            PHPeclipsePlugin.getWorkspace().build(10, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else {
                            monitor.setTaskName(PreferencesMessages.getString("OptionsConfigurationBlock.buildall.taskname"));
                            PHPeclipsePlugin.getWorkspace().build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                        }
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        Object var3_5 = null;
                        monitor.done();
                        return iStatus;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        Object var3_6 = null;
                        monitor.done();
                        return iStatus;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_8 = null;
                }
                monitor.done();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
            }
        };
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        buildJob.schedule();
        return true;
    }

    public void performDefaults() {
        this.fWorkingValues = this.getDefaultOptions();
        this.updateControls();
        this.validateSettings(null, null);
    }

    protected void updateControls() {
        int i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            this.updateCheckBox((Button)this.fCheckBoxes.get(i));
            --i;
        }
        i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            this.updateCombo((Combo)this.fComboBoxes.get(i));
            --i;
        }
        i = this.fTextBoxes.size() - 1;
        while (i >= 0) {
            this.updateText((Text)this.fTextBoxes.get(i));
            --i;
        }
    }

    protected void updateCombo(Combo curr) {
        ControlData data = (ControlData)curr.getData();
        String currValue = (String)this.fWorkingValues.get(data.getKey());
        curr.select(data.getSelection(currValue));
    }

    protected void updateCheckBox(Button curr) {
        String currValue;
        ControlData data = (ControlData)curr.getData();
        curr.setSelection(data.getSelection(currValue = (String)this.fWorkingValues.get(data.getKey())) == 0);
    }

    protected void updateText(Text curr) {
        String key = (String)curr.getData();
        String currValue = (String)this.fWorkingValues.get(key);
        if (currValue != null) {
            curr.setText(currValue);
        }
    }

    protected Button getCheckBox(String key) {
        int i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            Button curr = (Button)this.fCheckBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    protected Combo getComboBox(String key) {
        int i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            Combo curr = (Combo)this.fComboBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        return null;
    }

    protected void setComboEnabled(String key, boolean enabled) {
        Combo combo = this.getComboBox(key);
        Label label = (Label)this.fLabels.get(combo);
        combo.setEnabled(enabled);
        label.setEnabled(enabled);
    }

    protected static class ControlData {
        private String fKey;
        private String[] fValues;

        public ControlData(String key, String[] values) {
            this.fKey = key;
            this.fValues = values;
        }

        public String getKey() {
            return this.fKey;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.fValues[index];
        }

        public String getValue(int index) {
            return this.fValues[index];
        }

        public int getSelection(String value) {
            if (value != null) {
                int i = 0;
                while (i < this.fValues.length) {
                    if (value.equals(this.fValues[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return this.fValues.length - 1;
        }
    }
}

