/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.phpdt.ui.text.IColorManager;
import net.sourceforge.phpdt.ui.text.IColorManagerExtension;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractJavaScanner
extends BufferedRuleBasedScanner {
    private IColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private Map fTokenMap = new HashMap();
    private String[] fPropertyNamesColor;
    private String[] fPropertyNamesStyle;

    protected abstract String[] getTokenProperties();

    protected abstract List createRules();

    public AbstractJavaScanner(IColorManager manager, IPreferenceStore store) {
        this.fColorManager = manager;
        this.fPreferenceStore = store;
    }

    public final void initialize() {
        this.fPropertyNamesColor = this.getTokenProperties();
        int length = this.fPropertyNamesColor.length;
        this.fPropertyNamesStyle = new String[length];
        int i = 0;
        while (i < length) {
            this.fPropertyNamesStyle[i] = String.valueOf(this.fPropertyNamesColor[i]) + "_bold";
            this.addToken(this.fPropertyNamesColor[i], this.fPropertyNamesStyle[i]);
            ++i;
        }
        this.initializeRules();
    }

    private void addToken(String colorKey, String styleKey) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey);
        if (this.fColorManager instanceof IColorManagerExtension) {
            IColorManagerExtension ext = (IColorManagerExtension)((Object)this.fColorManager);
            ext.unbindColor(colorKey);
            ext.bindColor(colorKey, rgb);
        }
        boolean bold = this.fPreferenceStore.getBoolean(styleKey);
        this.fTokenMap.put(colorKey, new Token((Object)new TextAttribute(this.fColorManager.getColor(colorKey), null, bold ? 1 : 0)));
    }

    protected Token getToken(String key) {
        return (Token)this.fTokenMap.get(key);
    }

    private void initializeRules() {
        List rules = this.createRules();
        if (rules != null) {
            IRule[] result = new IRule[rules.size()];
            rules.toArray(result);
            this.setRules(result);
        }
    }

    private int indexOf(String property) {
        if (property != null) {
            int length = this.fPropertyNamesColor.length;
            int i = 0;
            while (i < length) {
                if (property.equals(this.fPropertyNamesColor[i]) || property.equals(this.fPropertyNamesStyle[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.indexOf(event.getProperty()) >= 0;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        String p = event.getProperty();
        int index = this.indexOf(p);
        Token token = this.getToken(this.fPropertyNamesColor[index]);
        if (this.fPropertyNamesColor[index].equals(p)) {
            this.adaptToColorChange(token, event);
        } else {
            this.adaptToStyleChange(token, event);
        }
    }

    private void adaptToColorChange(Token token, PropertyChangeEvent event) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            Object data;
            String property = event.getProperty();
            if (this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension ext = (IColorManagerExtension)((Object)this.fColorManager);
                ext.unbindColor(property);
                ext.bindColor(property, rgb);
            }
            if ((data = token.getData()) instanceof TextAttribute) {
                TextAttribute oldAttr = (TextAttribute)data;
                token.setData((Object)new TextAttribute(this.fColorManager.getColor(property), oldAttr.getBackground(), oldAttr.getStyle()));
            }
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent event) {
        boolean bold = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            bold = (Boolean)value;
        } else if (value instanceof String) {
            String s = (String)value;
            if ("true".equals(s)) {
                bold = true;
            } else if ("false".equals(s)) {
                bold = false;
            }
        }
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            boolean isBold;
            TextAttribute oldAttr = (TextAttribute)data;
            boolean bl = isBold = oldAttr.getStyle() == 1;
            if (isBold != bold) {
                token.setData((Object)new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), bold ? 1 : 0));
            }
        }
    }
}

