/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text;

import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.ui.actions.SelectionConverter;
import net.sourceforge.phpdt.internal.ui.text.JavaWordFinder;
import net.sourceforge.phpeclipse.phpeditor.PHPEditor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class JavaElementProvider
implements IInformationProvider,
IInformationProviderExtension {
    private PHPEditor fEditor;
    private boolean fUseCodeResolve = false;

    public JavaElementProvider(IEditorPart editor) {
        if (editor instanceof PHPEditor) {
            this.fEditor = (PHPEditor)editor;
        }
    }

    public JavaElementProvider(IEditorPart editor, boolean useCodeResolve) {
        this(editor);
        this.fUseCodeResolve = useCodeResolve;
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        if (textViewer != null && this.fEditor != null) {
            IRegion region = JavaWordFinder.findWord(textViewer.getDocument(), offset);
            if (region != null) {
                return region;
            }
            return new Region(offset, 0);
        }
        return null;
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        return this.getInformation2(textViewer, subject).toString();
    }

    public Object getInformation2(ITextViewer textViewer, IRegion subject) {
        if (this.fEditor == null) {
            return null;
        }
        try {
            IStructuredSelection sel;
            if (this.fUseCodeResolve && !(sel = SelectionConverter.getStructuredSelection((IWorkbenchPart)this.fEditor)).isEmpty()) {
                return sel.getFirstElement();
            }
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null) {
                return element;
            }
            return SelectionConverter.getInput(this.fEditor);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }
}

