/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text;

import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IParent;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.ui.actions.OpenActionUtil;
import net.sourceforge.phpdt.internal.ui.util.StringMatcher;
import net.sourceforge.phpdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import net.sourceforge.phpdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import net.sourceforge.phpdt.ui.JavaElementSorter;
import net.sourceforge.phpdt.ui.StandardJavaElementContentProvider;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class JavaOutlineInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2 {
    private static final int BORDER = 1;
    private static final int RIGHT_MARGIN = 3;
    private Shell fShell;
    Composite fComposite;
    private Text fFilterText;
    private TreeViewer fTreeViewer;
    private int fMaxWidth = -1;
    private int fMaxHeight = -1;
    private StringMatcher fStringMatcher;

    public JavaOutlineInformationControl(Shell parent, int style) {
        this(parent, 16, style);
    }

    public JavaOutlineInformationControl(Shell parent) {
        this(parent, 0);
    }

    public JavaOutlineInformationControl(Shell parent, int shellStyle, int treeStyle) {
        this.fShell = new Shell(parent, shellStyle);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        this.fComposite = new Composite((Composite)this.fShell, 16);
        GridLayout layout = new GridLayout(1, false);
        this.fComposite.setLayout((Layout)layout);
        this.fComposite.setLayoutData((Object)new GridData(768));
        this.createFilterText(this.fComposite);
        this.createTreeViewer(this.fComposite, treeStyle);
        int border = (shellStyle & 8) == 0 ? 0 : 1;
        this.fShell.setLayout((Layout)new BorderFillLayout(border));
        this.setInfoSystemColor();
        this.installFilter();
    }

    private void createTreeViewer(Composite parent, int style) {
        Tree tree = new Tree(parent, 4 | style & 0xFFFFFFFD);
        GridData data = new GridData(1808);
        tree.setLayoutData((Object)data);
        this.fTreeViewer = new TreeViewer(tree);
        this.fTreeViewer.setContentProvider((IContentProvider)new StandardJavaElementContentProvider(true, true));
        this.fTreeViewer.setSorter((ViewerSorter)new JavaElementSorter());
        this.fTreeViewer.setAutoExpandLevel(-1);
        AppearanceAwareLabelProvider lprovider = new AppearanceAwareLabelProvider(1090519561, 1);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(lprovider));
        this.fTreeViewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    JavaOutlineInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fTreeViewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                JavaOutlineInformationControl.this.gotoSelectedElement();
            }
        });
    }

    private Text createFilterText(Composite parent) {
        this.fFilterText = new Text(parent, 0x800000);
        GridData data = new GridData();
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        this.fFilterText.setLayoutData((Object)data);
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    JavaOutlineInformationControl.this.gotoSelectedElement();
                }
                if (e.keyCode == 0x1000002) {
                    JavaOutlineInformationControl.this.fTreeViewer.getTree().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    JavaOutlineInformationControl.this.fTreeViewer.getTree().setFocus();
                }
                if (e.character == '\u001b') {
                    JavaOutlineInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        Label separator = new Label(parent, 259);
        separator.setLayoutData((Object)new GridData(768));
        return this.fFilterText;
    }

    private void setInfoSystemColor() {
        Display display = this.fShell.getDisplay();
        this.setForegroundColor(display.getSystemColor(28));
        this.setBackgroundColor(display.getSystemColor(29));
    }

    private void installFilter() {
        final NamePatternFilter viewerFilter = new NamePatternFilter();
        this.fTreeViewer.addFilter((ViewerFilter)viewerFilter);
        this.fFilterText.setText("");
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String pattern = JavaOutlineInformationControl.this.fFilterText.getText();
                if (pattern != null) {
                    int length = pattern.length();
                    if (length == 0) {
                        pattern = null;
                    } else if (pattern.charAt(length - 1) != '*') {
                        pattern = String.valueOf(pattern) + '*';
                    }
                } else {
                    pattern = null;
                }
                viewerFilter.setPattern(pattern);
                JavaOutlineInformationControl.this.fStringMatcher = viewerFilter.getMatcher();
                JavaOutlineInformationControl.this.fTreeViewer.getControl().setRedraw(false);
                JavaOutlineInformationControl.this.fTreeViewer.refresh();
                JavaOutlineInformationControl.this.fTreeViewer.expandAll();
                JavaOutlineInformationControl.this.selectFirstMatch();
                JavaOutlineInformationControl.this.fTreeViewer.getControl().setRedraw(true);
            }
        });
    }

    private void gotoSelectedElement() {
        Object selectedElement = ((IStructuredSelection)this.fTreeViewer.getSelection()).getFirstElement();
        if (selectedElement != null) {
            try {
                this.dispose();
                OpenActionUtil.open(selectedElement, true);
            }
            catch (CoreException ex) {
                PHPeclipsePlugin.log(ex);
            }
        }
    }

    private void selectFirstMatch() {
        Tree tree = this.fTreeViewer.getTree();
        IJavaElement element = this.findElement(tree.getItems());
        if (element != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
        } else {
            this.fTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private IJavaElement findElement(TreeItem[] items) {
        ILabelProvider labelProvider = (ILabelProvider)this.fTreeViewer.getLabelProvider();
        int i = 0;
        while (i < items.length) {
            String label;
            IJavaElement element = (IJavaElement)items[i].getData();
            if (this.fStringMatcher == null) {
                return element;
            }
            if (element != null && this.fStringMatcher.match(label = labelProvider.getText((Object)element))) {
                return element;
            }
            element = this.findElement(items[i].getItems());
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public void setInformation(String information) {
    }

    public void setInput(Object information) {
        this.fFilterText.setText("");
        if (information == null || information instanceof String) {
            this.setInput(null);
            return;
        }
        IJavaElement je = (IJavaElement)information;
        IJavaElement sel = null;
        ICompilationUnit cu = (ICompilationUnit)je.getAncestor(5);
        sel = cu != null ? cu : je.getAncestor(6);
        this.fTreeViewer.setInput((Object)sel);
        this.fTreeViewer.setSelection((ISelection)new StructuredSelection(information));
    }

    public void setVisible(boolean visible) {
        this.fShell.setVisible(visible);
    }

    public void dispose() {
        if (this.fShell != null) {
            if (!this.fShell.isDisposed()) {
                this.fShell.dispose();
            }
            this.fShell = null;
            this.fTreeViewer = null;
            this.fComposite = null;
            this.fFilterText = null;
        }
    }

    public boolean hasContents() {
        return this.fTreeViewer != null && this.fTreeViewer.getInput() != null;
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.fMaxWidth = maxWidth;
        this.fMaxHeight = maxHeight;
    }

    public Point computeSizeHint() {
        return this.fShell.computeSize(-1, -1);
    }

    public void setLocation(Point location) {
        Rectangle trim = this.fShell.computeTrim(0, 0, 0, 0);
        Point textLocation = this.fComposite.getLocation();
        location.x += trim.x - textLocation.x;
        location.y += trim.y - textLocation.y;
        this.fShell.setLocation(location);
    }

    public void setSize(int width, int height) {
        this.fShell.setSize(width, height);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fTreeViewer.getTree().setForeground(foreground);
        this.fFilterText.setForeground(foreground);
        this.fComposite.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fTreeViewer.getTree().setBackground(background);
        this.fFilterText.setBackground(background);
        this.fComposite.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fTreeViewer.getControl().isFocusControl() || this.fFilterText.isFocusControl();
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fFilterText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.fShell.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fShell.removeFocusListener(listener);
    }

    private static class NamePatternFilter
    extends ViewerFilter {
        private String fPattern;
        private StringMatcher fMatcher;
        private ILabelProvider fLabelProvider;
        private Viewer fViewer;

        NamePatternFilter() {
        }

        private StringMatcher getMatcher() {
            return this.fMatcher;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.fMatcher == null) {
                return true;
            }
            ILabelProvider labelProvider = this.getLabelProvider(viewer);
            String matchName = null;
            if (labelProvider != null) {
                matchName = labelProvider.getText(element);
            } else if (element instanceof IJavaElement) {
                matchName = ((IJavaElement)element).getElementName();
            }
            if (matchName != null && this.fMatcher.match(matchName)) {
                return true;
            }
            return this.hasUnfilteredChild(viewer, element);
        }

        private ILabelProvider getLabelProvider(Viewer viewer) {
            if (this.fViewer == viewer) {
                return this.fLabelProvider;
            }
            this.fLabelProvider = null;
            IBaseLabelProvider baseLabelProvider = null;
            if (viewer instanceof StructuredViewer) {
                baseLabelProvider = ((StructuredViewer)viewer).getLabelProvider();
            }
            if (baseLabelProvider instanceof ILabelProvider) {
                this.fLabelProvider = (ILabelProvider)baseLabelProvider;
            }
            return this.fLabelProvider;
        }

        private boolean hasUnfilteredChild(Viewer viewer, Object element) {
            if (element instanceof IParent) {
                IJavaElement[] children;
                try {
                    children = ((IParent)element).getChildren();
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
                int i = 0;
                while (i < children.length) {
                    if (this.select(viewer, element, children[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public void setPattern(String pattern) {
            this.fPattern = pattern;
            if (this.fPattern == null) {
                this.fMatcher = null;
                return;
            }
            boolean ignoreCase = pattern.toLowerCase().equals(pattern);
            this.fMatcher = new StringMatcher(pattern, ignoreCase, false);
        }
    }

    private static class BorderFillLayout
    extends Layout {
        final int fBorderSize;

        public BorderFillLayout(int borderSize) {
            if (borderSize < 0) {
                throw new IllegalArgumentException();
            }
            this.fBorderSize = borderSize;
        }

        public int getBorderSize() {
            return this.fBorderSize;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point minSize = new Point(0, 0);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    Point size = children[i].computeSize(wHint, hHint, flushCache);
                    minSize.x = Math.max(minSize.x, size.x);
                    minSize.y = Math.max(minSize.y, size.y);
                    ++i;
                }
            }
            minSize.x += this.fBorderSize * 2 + 3;
            minSize.y += this.fBorderSize * 2;
            return minSize;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point minSize = new Point(composite.getClientArea().width, composite.getClientArea().height);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    Control child = children[i];
                    child.setSize(minSize.x - this.fBorderSize * 2, minSize.y - this.fBorderSize * 2);
                    child.setLocation(this.fBorderSize, this.fBorderSize);
                    ++i;
                }
            }
        }
    }
}

