/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text;

import net.sourceforge.phpdt.core.ElementChangedEvent;
import net.sourceforge.phpdt.core.IElementChangedListener;
import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.internal.ui.text.JavaCompositeReconcilingStrategy;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.phpeditor.PHPUnitEditor;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaReconciler
extends MonoReconciler {
    private ITextEditor fTextEditor;
    private IPartListener fPartListener;
    private ShellListener fActivationListener;
    private Object fMutex;
    private IElementChangedListener fJavaElementChangedListener;
    private volatile boolean fHasJavaModelChanged = true;
    private IResourceChangeListener fResourceChangeListener;
    private boolean fIninitalProcessDone = false;

    public JavaReconciler(ITextEditor editor, JavaCompositeReconcilingStrategy strategy, boolean isIncremental) {
        super((IReconcilingStrategy)strategy, isIncremental);
        this.fTextEditor = editor;
        this.fMutex = editor instanceof PHPUnitEditor ? ((PHPUnitEditor)editor).getReconcilerLock() : new Object();
    }

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        this.fPartListener = new PartListener();
        IWorkbenchPartSite site = this.fTextEditor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().addPartListener(this.fPartListener);
        this.fActivationListener = new ActivationListener((Control)textViewer.getTextWidget());
        Shell shell = window.getShell();
        shell.addShellListener(this.fActivationListener);
        this.fJavaElementChangedListener = new ElementChangedListener();
        JavaCore.addElementChangedListener(this.fJavaElementChangedListener);
        this.fResourceChangeListener = new ResourceChangeListener();
        IWorkspace workspace = PHPeclipsePlugin.getWorkspace();
        workspace.addResourceChangeListener(this.fResourceChangeListener);
    }

    public void uninstall() {
        IWorkbenchPartSite site = this.fTextEditor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().removePartListener(this.fPartListener);
        this.fPartListener = null;
        Shell shell = window.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.removeShellListener(this.fActivationListener);
        }
        this.fActivationListener = null;
        JavaCore.removeElementChangedListener(this.fJavaElementChangedListener);
        this.fJavaElementChangedListener = null;
        IWorkspace workspace = PHPeclipsePlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.fResourceChangeListener);
        this.fResourceChangeListener = null;
        super.uninstall();
    }

    protected void forceReconciling() {
        if (!this.fIninitalProcessDone) {
            return;
        }
        super.forceReconciling();
        JavaCompositeReconcilingStrategy strategy = (JavaCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        strategy.notifyListeners(false);
    }

    protected void aboutToBeReconciled() {
        JavaCompositeReconcilingStrategy strategy = (JavaCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        strategy.aboutToBeReconciled();
    }

    protected void reconcilerReset() {
        super.reconcilerReset();
        JavaCompositeReconcilingStrategy strategy = (JavaCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        strategy.notifyListeners(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialProcess() {
        Object object = this.fMutex;
        synchronized (object) {
            super.initialProcess();
        }
        this.fIninitalProcessDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(DirtyRegion dirtyRegion) {
        Object object = this.fMutex;
        synchronized (object) {
            super.process(dirtyRegion);
        }
    }

    private synchronized boolean hasJavaModelChanged() {
        return this.fHasJavaModelChanged;
    }

    private synchronized void setJavaModelChanged(boolean state) {
        this.fHasJavaModelChanged = state;
    }

    private class PartListener
    implements IPartListener {
        PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == JavaReconciler.this.fTextEditor && JavaReconciler.this.hasJavaModelChanged()) {
                JavaReconciler.this.forceReconciling();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == JavaReconciler.this.fTextEditor) {
                JavaReconciler.this.setJavaModelChanged(false);
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    private class ActivationListener
    extends ShellAdapter {
        private Control fControl;

        public ActivationListener(Control control) {
            this.fControl = control;
        }

        public void shellActivated(ShellEvent e) {
            if (!this.fControl.isDisposed() && this.fControl.isVisible() && JavaReconciler.this.hasJavaModelChanged()) {
                JavaReconciler.this.forceReconciling();
            }
        }

        public void shellDeactivated(ShellEvent e) {
            JavaReconciler.this.setJavaModelChanged(false);
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            JavaReconciler.this.setJavaModelChanged(true);
        }
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        private IResource getResource() {
            IEditorInput input = JavaReconciler.this.fTextEditor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFileEditorInput fileInput = (IFileEditorInput)input;
                return fileInput.getFile();
            }
            return null;
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IMarkerDelta[] deltas;
            IResourceDelta child;
            IResourceDelta delta = e.getDelta();
            IResource resource = this.getResource();
            if (delta != null && resource != null && (child = delta.findMember(resource.getFullPath())) != null && (deltas = child.getMarkerDeltas()).length > 0) {
                JavaReconciler.this.forceReconciling();
            }
        }
    }
}

