/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.java;

import net.sourceforge.phpdt.core.ICodeFormatter;
import net.sourceforge.phpdt.core.ToolFactory;
import net.sourceforge.phpdt.internal.corext.codemanipulation.StubUtility;
import net.sourceforge.phpdt.internal.corext.util.Strings;
import net.sourceforge.phpdt.internal.ui.preferences.CodeFormatterPreferencePage;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;

public class JavaFormattingStrategy
implements IFormattingStrategy {
    private String fInitialIndentation;
    private ISourceViewer fViewer;

    public JavaFormattingStrategy(ISourceViewer viewer) {
        this.fViewer = viewer;
    }

    public void formatterStarts(String initialIndentation) {
        this.fInitialIndentation = initialIndentation;
    }

    public void formatterStops() {
    }

    public String format(String content, boolean isLineStart, String indentation, int[] positions) {
        ICodeFormatter formatter = ToolFactory.createCodeFormatter();
        IDocument doc = this.fViewer.getDocument();
        String lineDelimiter = StubUtility.getLineDelimiterFor(doc);
        int indent = 0;
        if (this.fInitialIndentation != null) {
            indent = Strings.computeIndent(this.fInitialIndentation, CodeFormatterPreferencePage.getTabSize());
        }
        return formatter.format(content, indent, positions, lineDelimiter);
    }
}

