/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.phpdoc;

import java.text.BreakIterator;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IMethod;
import net.sourceforge.phpdt.core.ISourceRange;
import net.sourceforge.phpdt.core.IType;
import net.sourceforge.phpdt.internal.corext.util.Strings;
import net.sourceforge.phpdt.ui.CodeGeneration;
import net.sourceforge.phpdt.ui.IWorkingCopyManager;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class JavaDocAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private String fPartitioning;
    private static final String[] fgInlineTags = new String[]{"<b>", "<i>", "<em>", "<strong>", "<code>"};

    public JavaDocAutoIndentStrategy(String partitioning) {
        this.fPartitioning = partitioning;
    }

    private static String getLineDelimiter(IDocument document) {
        try {
            if (document.getNumberOfLines() > 1) {
                return document.getLineDelimiter(0);
            }
        }
        catch (BadLocationException e) {
            PHPeclipsePlugin.log(e);
        }
        return System.getProperty("line.separator");
    }

    private void jdocIndentAfterNewLine(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            IRegion info = d.getLineInformationOfOffset(p);
            int start = info.getOffset();
            int end = this.findEndOfWhiteSpace(d, start, c.offset);
            StringBuffer buf = new StringBuffer(c.text);
            if (end >= start) {
                String indentation = this.jdocExtractLinePrefix(d, d.getLineOfOffset(c.offset));
                buf.append(indentation);
                if (end < c.offset && d.getChar(end) == '/') {
                    buf.append(" * ");
                    if (PHPeclipsePlugin.getDefault().getPreferenceStore().getBoolean("closeJavaDocs") && JavaDocAutoIndentStrategy.isNewComment(d, c.offset, this.fPartitioning)) {
                        String lineDelimiter = JavaDocAutoIndentStrategy.getLineDelimiter(d);
                        String endTag = String.valueOf(lineDelimiter) + indentation + " */";
                        d.replace(c.offset, 0, endTag);
                        JavaDocAutoIndentStrategy.getCompilationUnit();
                    }
                }
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    private String createJavaDocTags(IDocument document, DocumentCommand command, String indentation, String lineDelimiter, ICompilationUnit unit) throws CoreException, BadLocationException {
        IJavaElement element = unit.getElementAt(command.offset);
        if (element == null) {
            return null;
        }
        switch (element.getElementType()) {
            case 7: {
                return this.createTypeTags(document, command, indentation, lineDelimiter, (IType)element);
            }
            case 9: {
                return this.createMethodTags(document, command, indentation, lineDelimiter, (IMethod)element);
            }
        }
        return null;
    }

    private String prepareTemplateComment(String comment, String indentation, String lineDelimiter) {
        if (comment.endsWith("*/")) {
            comment = comment.substring(0, comment.length() - 2);
        }
        if ((comment = comment.trim()).startsWith("/*")) {
            comment = comment.length() > 2 && comment.charAt(2) == '*' ? comment.substring(3) : comment.substring(2);
        }
        return Strings.changeIndent(comment, 0, JavaDocAutoIndentStrategy.getTabWidth(), indentation, lineDelimiter);
    }

    public static int getTabWidth() {
        Preferences preferences = PHPeclipsePlugin.getDefault().getPluginPreferences();
        return preferences.getInt("tabWidth");
    }

    private String createTypeTags(IDocument document, DocumentCommand command, String indentation, String lineDelimiter, IType type) throws CoreException {
        String comment = CodeGeneration.getTypeComment(type.getCompilationUnit(), type.getTypeQualifiedName('.'), lineDelimiter);
        if (comment != null) {
            return this.prepareTemplateComment(comment.trim(), indentation, lineDelimiter);
        }
        return null;
    }

    private String createMethodTags(IDocument document, DocumentCommand command, String indentation, String lineDelimiter, IMethod method) throws CoreException, BadLocationException {
        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)command.offset, (boolean)false);
        ISourceRange sourceRange = method.getSourceRange();
        if (sourceRange == null || sourceRange.getOffset() != partition.getOffset()) {
            return null;
        }
        return null;
    }

    protected void jdocIndentForCommentEnd(IDocument d, DocumentCommand c) {
        if (c.offset < 2 || d.getLength() == 0) {
            return;
        }
        try {
            if ("* ".equals(d.get(c.offset - 2, 2))) {
                ++c.length;
                --c.offset;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private static boolean isNewComment(IDocument document, int commandOffset, String partitioning) {
        try {
            int lineIndex = document.getLineOfOffset(commandOffset) + 1;
            if (lineIndex >= document.getNumberOfLines()) {
                return true;
            }
            IRegion line = document.getLineInformation(lineIndex);
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)commandOffset, (boolean)false);
            int partitionEnd = partition.getOffset() + partition.getLength();
            if (line.getOffset() >= partitionEnd) {
                return false;
            }
            if (document.getLength() == partitionEnd) {
                return true;
            }
            String comment = document.get(partition.getOffset(), partition.getLength());
            return comment.indexOf("/*", 2) != -1;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isSmartMode() {
        IEditorPart part;
        IWorkbenchPage page = PHPeclipsePlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) instanceof ITextEditorExtension3) {
            ITextEditorExtension3 extension = (ITextEditorExtension3)part;
            return extension.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!this.isSmartMode()) {
            return;
        }
        try {
            String[] lineDelimiters;
            int index;
            if (command.text != null && command.length == 0 && (index = TextUtilities.endsWith((String[])(lineDelimiters = document.getLegalLineDelimiters()), (String)command.text)) > -1) {
                if (lineDelimiters[index].equals(command.text)) {
                    this.jdocIndentAfterNewLine(document, command);
                }
                return;
            }
            if (command.text != null && command.text.equals("/")) {
                this.jdocIndentForCommentEnd(document, command);
                return;
            }
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)command.offset, (boolean)true);
            int partitionStart = partition.getOffset();
            int partitionEnd = partition.getLength() + partitionStart;
            String text = command.text;
            int offset = command.offset;
            int length = command.length;
            int PREFIX_LENGTH = "/*".length();
            int POSTFIX_LENGTH = "*/".length();
            if (offset < partitionStart + PREFIX_LENGTH || offset + length > partitionEnd - POSTFIX_LENGTH || text != null && text.length() >= 2 && (text.indexOf("*/") != -1 || document.getChar(offset) == '*' && text.startsWith("/"))) {
                return;
            }
            if (command.text == null || command.text.length() == 0) {
                this.jdocHandleBackspaceDelete(document, command);
            } else if (command.text != null && command.length == 0 && command.text.length() > 0) {
                this.jdocWrapParagraphOnInsert(document, command);
            }
        }
        catch (BadLocationException e) {
            PHPeclipsePlugin.log(e);
        }
    }

    private void flushCommand(IDocument document, DocumentCommand command) throws BadLocationException {
        if (!command.doit) {
            return;
        }
        document.replace(command.offset, command.length, command.text);
        command.doit = false;
        if (command.text != null) {
            command.offset += command.text.length();
        }
        command.length = 0;
        command.text = null;
    }

    protected void jdocWrapParagraphOnInsert(IDocument document, DocumentCommand command) throws BadLocationException {
        if (!JavaDocAutoIndentStrategy.getPreferenceStore().getBoolean("formatJavaDocs")) {
            return;
        }
        int line = document.getLineOfOffset(command.offset);
        IRegion region = document.getLineInformation(line);
        int lineOffset = region.getOffset();
        int lineLength = region.getLength();
        String lineContents = document.get(lineOffset, lineLength);
        StringBuffer buffer = new StringBuffer(lineContents);
        int start = command.offset - lineOffset;
        int end = command.length + start;
        buffer.replace(start, end, command.text);
        if (command.text != null && command.text.length() != 0 && command.text.trim().length() == 0) {
            String endOfLine = document.get(command.offset, lineOffset + lineLength - command.offset);
            if (endOfLine.length() == 0) {
                this.flushCommand(document, command);
                if (this.isLineTooShort(document, line)) {
                    int[] caretOffset = new int[]{command.offset};
                    this.jdocWrapParagraphFromLine(document, line, caretOffset, false);
                    command.offset = caretOffset[0];
                    return;
                }
                if (line < document.getNumberOfLines() - 1 && this.isJavaDocLine(document, line + 1)) {
                    String lineDelimiter = document.getLineDelimiter(line);
                    String nextLinePrefix = this.jdocExtractLinePrefix(document, line + 1);
                    command.offset += lineDelimiter.length() + nextLinePrefix.length();
                }
                return;
            }
            if (endOfLine.trim().length() == 0) {
                return;
            }
        }
        String prefix = this.jdocExtractLinePrefix(document, line);
        boolean wrapAlways = command.offset >= lineOffset && command.offset <= lineOffset + prefix.length();
        this.flushCommand(document, command);
        if (wrapAlways || JavaDocAutoIndentStrategy.calculateDisplayedWidth(buffer.toString()) > JavaDocAutoIndentStrategy.getMargin() || this.isLineTooShort(document, line)) {
            int[] caretOffset = new int[]{command.offset};
            this.jdocWrapParagraphFromLine(document, line, caretOffset, wrapAlways);
            if (!wrapAlways) {
                command.offset = caretOffset[0];
            }
        }
    }

    private void jdocWrapParagraphFromLine(IDocument document, int line, int[] caretOffset, boolean always) throws BadLocationException {
        String indent = this.jdocExtractLinePrefix(document, line);
        if (!always) {
            if (!indent.trim().startsWith("*")) {
                return;
            }
            if (indent.trim().startsWith("*/")) {
                return;
            }
            if (!this.isLineTooLong(document, line) && !this.isLineTooShort(document, line)) {
                return;
            }
        }
        boolean caretRelativeToParagraphOffset = false;
        int caret = caretOffset[0];
        int caretLine = document.getLineOfOffset(caret);
        int lineOffset = document.getLineOffset(line);
        int paragraphOffset = lineOffset + indent.length();
        if (paragraphOffset < caret) {
            caret -= paragraphOffset;
            caretRelativeToParagraphOffset = true;
        } else {
            caret -= lineOffset;
        }
        StringBuffer buffer = new StringBuffer();
        int currentLine = line;
        while (line == currentLine || this.isJavaDocLine(document, currentLine)) {
            if (buffer.length() != 0 && !Character.isWhitespace(buffer.charAt(buffer.length() - 1))) {
                buffer.append(' ');
                if (currentLine <= caretLine) {
                    ++caret;
                }
            }
            String string = this.getLineContents(document, currentLine);
            buffer.append(string);
            ++currentLine;
        }
        String paragraph = buffer.toString();
        if (paragraph.trim().length() == 0) {
            return;
        }
        caretOffset[0] = caretRelativeToParagraphOffset ? caret : 0;
        String delimiter = document.getLineDelimiter(0);
        String wrapped = JavaDocAutoIndentStrategy.formatParagraph(paragraph, caretOffset, indent, delimiter, JavaDocAutoIndentStrategy.getMargin());
        int beginning = document.getLineOffset(line);
        int end = document.getLineOffset(currentLine);
        document.replace(beginning, end - beginning, wrapped.toString());
        caretOffset[0] = caretRelativeToParagraphOffset ? caretOffset[0] + beginning : caret + beginning;
    }

    private static String formatParagraph(String paragraph, int[] offset, String prefix, String lineDelimiter, int margin) {
        LineBreakIterator iterator = new LineBreakIterator(paragraph);
        StringBuffer paragraphBuffer = new StringBuffer();
        StringBuffer lineBuffer = new StringBuffer();
        StringBuffer whiteSpaceBuffer = new StringBuffer();
        int index = offset[0];
        int indexBuffer = -1;
        if (lineDelimiter == null) {
            lineDelimiter = "";
        }
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String word = paragraph.substring(start, end);
            if (word.trim().length() == 0) {
                whiteSpaceBuffer.append(word);
            } else if (lineBuffer.length() == 0) {
                lineBuffer.append(prefix);
                lineBuffer.append(whiteSpaceBuffer.toString());
                lineBuffer.append(word);
            } else {
                String line = String.valueOf(lineBuffer.toString()) + whiteSpaceBuffer.toString() + word.toString();
                if (JavaDocAutoIndentStrategy.calculateDisplayedWidth(line) > margin) {
                    paragraphBuffer.append(lineBuffer.toString());
                    paragraphBuffer.append(lineDelimiter);
                    lineBuffer.setLength(0);
                    lineBuffer.append(prefix);
                    lineBuffer.append(word);
                    if (indexBuffer != -1) {
                        offset[0] = indexBuffer;
                        if (whiteSpaceBuffer.length() != 0 && index < start && index >= start - whiteSpaceBuffer.length()) {
                            offset[0] = offset[0] - (index - (start - whiteSpaceBuffer.length()));
                        }
                        indexBuffer = -1;
                    }
                    whiteSpaceBuffer.setLength(0);
                } else {
                    lineBuffer.append(whiteSpaceBuffer.toString());
                    lineBuffer.append(word);
                    whiteSpaceBuffer.setLength(0);
                }
            }
            if (index >= start && index < end) {
                indexBuffer = paragraphBuffer.length() + lineBuffer.length() + (index - start);
                if (word.trim().length() != 0) {
                    indexBuffer -= word.length();
                }
            }
            start = end;
            end = iterator.next();
        }
        paragraphBuffer.append(lineBuffer.toString());
        paragraphBuffer.append(lineDelimiter);
        if (indexBuffer != -1) {
            offset[0] = indexBuffer;
        } else if (offset[0] == paragraph.length()) {
            offset[0] = paragraphBuffer.length() - lineDelimiter.length();
        }
        return paragraphBuffer.toString();
    }

    private static IPreferenceStore getPreferenceStore() {
        return PHPeclipsePlugin.getDefault().getPreferenceStore();
    }

    private static int calculateDisplayedWidth(String string) {
        int tabWidth = JavaDocAutoIndentStrategy.getPreferenceStore().getInt("tabWidth");
        if (tabWidth <= 0) {
            tabWidth = 2;
        }
        int column = 0;
        int i = 0;
        while (i < string.length()) {
            column = '\t' == string.charAt(i) ? (column += tabWidth - column % tabWidth) : ++column;
            ++i;
        }
        return column;
    }

    private String jdocExtractLinePrefix(IDocument d, int line) throws BadLocationException {
        IRegion region = d.getLineInformation(line);
        int lineOffset = region.getOffset();
        int index = this.findEndOfWhiteSpace(d, lineOffset, lineOffset + d.getLineLength(line));
        if (d.getChar(index) == '*' && ++index != lineOffset + region.getLength() && d.getChar(index) == ' ') {
            ++index;
        }
        return d.get(lineOffset, index - lineOffset);
    }

    private String getLineContents(IDocument d, int line) throws BadLocationException {
        int offset = d.getLineOffset(line);
        int length = d.getLineLength(line);
        String lineDelimiter = d.getLineDelimiter(line);
        if (lineDelimiter != null) {
            length -= lineDelimiter.length();
        }
        String lineContents = d.get(offset, length);
        int trim = this.jdocExtractLinePrefix(d, line).length();
        return lineContents.substring(trim);
    }

    private static String getLine(IDocument document, int line) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        return document.get(region.getOffset(), region.getLength());
    }

    private boolean isLineTooShort(IDocument document, int line) throws BadLocationException {
        if (!this.isJavaDocLine(document, line + 1)) {
            return false;
        }
        String nextLine = this.getLineContents(document, line + 1);
        return nextLine.trim().length() != 0;
    }

    private boolean isLineTooLong(IDocument document, int line) throws BadLocationException {
        String lineContents = JavaDocAutoIndentStrategy.getLine(document, line);
        return JavaDocAutoIndentStrategy.calculateDisplayedWidth(lineContents) > JavaDocAutoIndentStrategy.getMargin();
    }

    private static int getMargin() {
        return JavaDocAutoIndentStrategy.getPreferenceStore().getInt("printMarginColumn");
    }

    private boolean isInlineTag(String string) {
        int i = 0;
        while (i < fgInlineTags.length) {
            if (string.startsWith(fgInlineTags[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isJavaDocLine(IDocument document, int line) throws BadLocationException {
        if (document.getNumberOfLines() < line) {
            return false;
        }
        int offset = document.getLineOffset(line);
        int length = document.getLineLength(line);
        int firstChar = this.findEndOfWhiteSpace(document, offset, offset + length);
        String lineContents = document.get(firstChar, length -= firstChar - offset);
        String prefix = lineContents.trim();
        if (!prefix.startsWith("*") || prefix.startsWith("*/")) {
            return false;
        }
        if ((lineContents = lineContents.substring(1).trim().toLowerCase()).length() == 0) {
            return false;
        }
        if (lineContents.startsWith("@")) {
            return false;
        }
        return !lineContents.startsWith("<") || this.isInlineTag(lineContents);
    }

    protected void jdocHandleBackspaceDelete(IDocument document, DocumentCommand c) {
        if (!JavaDocAutoIndentStrategy.getPreferenceStore().getBoolean("formatJavaDocs")) {
            return;
        }
        try {
            String text = document.get(c.offset, c.length);
            int line = document.getLineOfOffset(c.offset);
            int lineOffset = document.getLineOffset(line);
            String lineDelimiter = document.getLineDelimiter(line);
            if (lineDelimiter != null && lineDelimiter.equals(text)) {
                String prefix = this.jdocExtractLinePrefix(document, line + 1);
                if (prefix.length() > 0) {
                    int length = document.getLineDelimiter(line).length() + prefix.length();
                    document.replace(c.offset, length, null);
                    c.doit = false;
                    c.length = 0;
                    return;
                }
            } else {
                if (document.getChar(c.offset - 1) == '*' && this.jdocExtractLinePrefix(document, line).length() - 1 >= c.offset - lineOffset) {
                    lineDelimiter = document.getLineDelimiter(line - 1);
                    String prefix = this.jdocExtractLinePrefix(document, line);
                    int length = (lineDelimiter != null ? lineDelimiter.length() : 0) + prefix.length();
                    document.replace(c.offset - length + 1, length, null);
                    c.doit = false;
                    c.offset -= length - 1;
                    c.length = 0;
                    return;
                }
                document.replace(c.offset, c.length, null);
                c.doit = false;
                c.length = 0;
            }
        }
        catch (BadLocationException e) {
            PHPeclipsePlugin.log(e);
        }
        try {
            int line = document.getLineOfOffset(c.offset);
            int lineOffset = document.getLineOffset(line);
            String prefix = this.jdocExtractLinePrefix(document, line);
            boolean always = c.offset > lineOffset && c.offset <= lineOffset + prefix.length();
            int[] caretOffset = new int[]{c.offset};
            this.jdocWrapParagraphFromLine(document, document.getLineOfOffset(c.offset), caretOffset, always);
            c.offset = caretOffset[0];
        }
        catch (BadLocationException e) {
            PHPeclipsePlugin.log(e);
        }
    }

    private static ICompilationUnit getCompilationUnit() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        IWorkingCopyManager manager = PHPeclipsePlugin.getDefault().getWorkingCopyManager();
        ICompilationUnit unit = manager.getWorkingCopy(editor.getEditorInput());
        if (unit == null) {
            return null;
        }
        return unit;
    }

    private static class LineBreakIterator {
        private final String fString;
        private final BreakIterator fIterator = BreakIterator.getLineInstance();
        private int fStart;
        private int fEnd;
        private int fBufferedEnd;

        public LineBreakIterator(String string) {
            this.fString = string;
            this.fIterator.setText(string);
        }

        public int first() {
            this.fBufferedEnd = -1;
            this.fStart = this.fIterator.first();
            return this.fStart;
        }

        public int next() {
            if (this.fBufferedEnd != -1) {
                this.fStart = this.fEnd;
                this.fEnd = this.fBufferedEnd;
                this.fBufferedEnd = -1;
                return this.fEnd;
            }
            this.fStart = this.fEnd;
            this.fEnd = this.fIterator.next();
            if (this.fEnd == -1) {
                return this.fEnd;
            }
            String string = this.fString.substring(this.fStart, this.fEnd);
            if (string.trim().length() == 0) {
                return this.fEnd;
            }
            String word = string.trim();
            if (word.length() == string.length()) {
                return this.fEnd;
            }
            this.fBufferedEnd = this.fEnd;
            return this.fStart + word.length();
        }
    }
}

