/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.phpdoc;

import java.util.Arrays;
import java.util.Comparator;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.internal.ui.text.java.IPHPCompletionProposal;
import net.sourceforge.phpdt.internal.ui.text.java.PHPCompletionProposalComparator;
import net.sourceforge.phpdt.internal.ui.text.template.contentassist.TemplateEngine;
import net.sourceforge.phpdt.internal.ui.text.template.contentassist.TemplateProposal;
import net.sourceforge.phpdt.ui.IWorkingCopyManager;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.ui.IEditorPart;

public class PHPDocCompletionProcessor
implements IContentAssistProcessor {
    private char[] fProposalAutoActivationSet;
    private PHPCompletionProposalComparator fComparator;
    private TemplateEngine fTemplateEngine;
    private boolean fRestrictToMatchingCase;
    private IEditorPart fEditor;
    protected IWorkingCopyManager fManager;

    public PHPDocCompletionProcessor(IEditorPart editor) {
        this.fEditor = editor;
        this.fManager = PHPeclipsePlugin.getDefault().getWorkingCopyManager();
        TemplateContextType contextType = PHPeclipsePlugin.getDefault().getTemplateContextRegistry().getContextType("phpdoc");
        if (contextType != null) {
            this.fTemplateEngine = new TemplateEngine(contextType);
        }
        this.fRestrictToMatchingCase = false;
        this.fComparator = new PHPCompletionProposalComparator();
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }

    public void restrictProposalsToMatchingCases(boolean restrict) {
        this.fRestrictToMatchingCase = restrict;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        ICompilationUnit unit = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
        viewer.getDocument();
        IPHPCompletionProposal[] results = new IPHPCompletionProposal[]{};
        if (this.fTemplateEngine != null) {
            this.fTemplateEngine.reset();
            this.fTemplateEngine.complete(viewer, documentOffset, unit);
            TemplateProposal[] templateResults = this.fTemplateEngine.getResults();
            if (results.length == 0) {
                results = templateResults;
            } else {
                IPHPCompletionProposal[] total = new IPHPCompletionProposal[results.length + templateResults.length];
                System.arraycopy(templateResults, 0, total, 0, templateResults.length);
                System.arraycopy(results, 0, total, templateResults.length, results.length);
                results = total;
            }
        }
        return this.order(results);
    }

    private IPHPCompletionProposal[] order(IPHPCompletionProposal[] proposals) {
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    private static class PHPDocCompletionProposalComparator
    implements Comparator {
        PHPDocCompletionProposalComparator() {
        }

        public int compare(Object o1, Object o2) {
            ICompletionProposal c1 = (ICompletionProposal)o1;
            ICompletionProposal c2 = (ICompletionProposal)o2;
            return c1.getDisplayString().compareTo(c2.getDisplayString());
        }
    }
}

