/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedMap;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.internal.corext.template.php.CompilationUnitContextType;
import net.sourceforge.phpdt.internal.corext.template.php.JavaContext;
import net.sourceforge.phpdt.internal.corext.template.php.JavaContextType;
import net.sourceforge.phpdt.internal.ui.text.java.IPHPCompletionProposal;
import net.sourceforge.phpdt.internal.ui.text.template.DeclarationProposal;
import net.sourceforge.phpeclipse.builder.PHPIdentifierLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.swt.graphics.Point;

public class DeclarationEngine {
    private JavaContextType fContextType;
    private ArrayList fProposals = new ArrayList();
    private int fLastSignificantToken;
    private IProject fProject;
    private String fFileName;

    public DeclarationEngine(IProject project, JavaContextType contextType, int lastSignificantToken, IFile file) {
        this.fProject = project;
        this.fContextType = contextType;
        this.fLastSignificantToken = lastSignificantToken;
        this.fFileName = file != null ? file.getProjectRelativePath().toString() : "";
    }

    public void reset() {
        this.fProposals.clear();
    }

    public IPHPCompletionProposal[] getResults() {
        return this.fProposals.toArray(new IPHPCompletionProposal[this.fProposals.size()]);
    }

    public void completeObject(ITextViewer viewer, int completionPosition, SortedMap map, ICompilationUnit compilationUnit) {
        IDocument document = viewer.getDocument();
        if (!(this.fContextType instanceof CompilationUnitContextType)) {
            return;
        }
        Point selection = viewer.getSelectedRange();
        String selectedText = null;
        if (selection.y != 0) {
            try {
                selectedText = document.get(selection.x, selection.y);
            }
            catch (BadLocationException badLocationException) {}
        }
        JavaContext context = (JavaContext)this.fContextType.createContext(document, completionPosition, selection.y, compilationUnit);
        context.setVariable("selection", selectedText);
        int start = context.getStart();
        int end = context.getEnd();
        String prefix = context.getKey();
        Region region = new Region(start, end - start);
        String identifier = null;
        SortedMap subMap = map.subMap(prefix, String.valueOf(prefix) + '\u00ad');
        Iterator<String> iter = subMap.keySet().iterator();
        int maxProposals = 200;
        while (iter.hasNext()) {
            identifier = iter.next();
            if (!context.canEvaluate(identifier)) continue;
            ArrayList list = (ArrayList)subMap.get(identifier);
            int i = 0;
            while (i < list.size()) {
                block13: {
                    PHPIdentifierLocation location = (PHPIdentifierLocation)list.get(i);
                    int type = location.getType();
                    switch (this.fLastSignificantToken) {
                        case 50: {
                            if (type == 4 || type == 3) break;
                            break block13;
                        }
                        case 150: {
                            if (type == 4 || type == 3) break;
                            break block13;
                        }
                        case 2000: {
                            if (type == 4 || type == 3) break;
                            break block13;
                        }
                        case 1022: {
                            if (type == 1 || type == 6) break;
                            break block13;
                        }
                        default: {
                            if (type == 4 || type == 6 || type == 3) break block13;
                        }
                    }
                    if (maxProposals-- < 0) {
                        return;
                    }
                    this.fProposals.add(new DeclarationProposal(this.fProject, identifier, location, (TemplateContext)context, (IRegion)region, viewer));
                }
                ++i;
            }
        }
    }

    public void complete(ITextViewer viewer, int completionPosition, SortedMap map, ICompilationUnit compilationUnit) {
        IDocument document = viewer.getDocument();
        if (!(this.fContextType instanceof CompilationUnitContextType)) {
            return;
        }
        Point selection = viewer.getSelectedRange();
        String selectedText = null;
        if (selection.y != 0) {
            try {
                selectedText = document.get(selection.x, selection.y);
            }
            catch (BadLocationException badLocationException) {}
        }
        JavaContext context = (JavaContext)this.fContextType.createContext(document, completionPosition, selection.y, compilationUnit);
        context.setVariable("selection", selectedText);
        int start = context.getStart();
        int end = context.getEnd();
        String prefix = context.getKey();
        Region region = new Region(start, end - start);
        String identifier = null;
        SortedMap subMap = map.subMap(prefix, String.valueOf(prefix) + '\u00ad');
        Iterator<String> iter = subMap.keySet().iterator();
        int maxProposals = 200;
        while (iter.hasNext()) {
            identifier = iter.next();
            if (!context.canEvaluate(identifier)) continue;
            ArrayList list = (ArrayList)subMap.get(identifier);
            int i = 0;
            while (i < list.size()) {
                block13: {
                    PHPIdentifierLocation location = (PHPIdentifierLocation)list.get(i);
                    int type = location.getType();
                    switch (this.fLastSignificantToken) {
                        case 50: {
                            if (type == 4 || type == 3) break;
                            break block13;
                        }
                        case 150: {
                            if ((type == 4 || type == 3) && !this.fFileName.equals(location.getFilename())) break;
                            break block13;
                        }
                        case 2000: {
                            if ((type == 4 || type == 3) && this.fFileName.equals(location.getFilename())) break;
                            break block13;
                        }
                        case 1022: {
                            if (type == 1 || type == 6) break;
                            break block13;
                        }
                        default: {
                            if (type == 4 || type == 6 || type == 3) break block13;
                        }
                    }
                    if (maxProposals-- < 0) {
                        return;
                    }
                    this.fProposals.add(new DeclarationProposal(this.fProject, identifier, location, (TemplateContext)context, (IRegion)region, viewer));
                }
                ++i;
            }
        }
    }
}

