/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.template;

import net.sourceforge.phpdt.internal.corext.phpdoc.PHPDocUtil;
import net.sourceforge.phpdt.internal.corext.template.TemplateMessages;
import net.sourceforge.phpdt.internal.corext.template.php.JavaContext;
import net.sourceforge.phpdt.internal.ui.PHPUiImages;
import net.sourceforge.phpdt.internal.ui.text.link.LinkedPositionManager;
import net.sourceforge.phpdt.internal.ui.text.link.LinkedPositionUI;
import net.sourceforge.phpdt.internal.ui.text.template.AbstractProposal;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.builder.PHPIdentifierLocation;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.swt.graphics.Image;

public class DeclarationProposal
extends AbstractProposal {
    private IProject fProject;
    private final TemplateContext fContext;
    private final PHPIdentifierLocation fLocation;
    String fInfo;
    private final IRegion fRegion;
    private final String fIdentifierName;

    public DeclarationProposal(IProject project, String identifierName, PHPIdentifierLocation location, TemplateContext context, IRegion region, ITextViewer viewer) {
        super(viewer);
        this.fProject = project;
        this.fIdentifierName = identifierName;
        this.fLocation = location;
        this.fContext = context;
        this.fRegion = region;
        this.fInfo = null;
    }

    public void apply(IDocument document) {
        try {
            int start = this.fRegion.getOffset();
            int end = this.fRegion.getOffset() + this.fRegion.getLength();
            switch (this.fLocation.getType()) {
                case 2: {
                    document.replace(start, end - start, String.valueOf(this.fIdentifierName) + "()");
                    break;
                }
                case 6: {
                    document.replace(start, end - start, String.valueOf(this.fIdentifierName) + "()");
                    break;
                }
                case 4: {
                    document.replace(start, end - start, String.valueOf(this.fIdentifierName) + "()");
                    break;
                }
                default: {
                    document.replace(start, end - start, this.fIdentifierName);
                }
            }
            LinkedPositionManager manager = new LinkedPositionManager(document);
            LinkedPositionUI editor = new LinkedPositionUI(this.fViewer, manager);
            switch (this.fLocation.getType()) {
                case 2: {
                    editor.setFinalCaretOffset(this.fIdentifierName.length() + start + 1);
                    break;
                }
                case 6: {
                    editor.setFinalCaretOffset(this.fIdentifierName.length() + start + 1);
                    break;
                }
                case 4: {
                    editor.setFinalCaretOffset(this.fIdentifierName.length() + start + 1);
                    break;
                }
                default: {
                    editor.setFinalCaretOffset(this.fIdentifierName.length() + start);
                }
            }
            editor.enter();
            this.fSelectedRegion = editor.getSelectedRegion();
        }
        catch (BadLocationException e) {
            PHPeclipsePlugin.log(e);
            this.openErrorDialog(e);
        }
    }

    public String getAdditionalProposalInfo() {
        if (this.fInfo == null) {
            this.fInfo = this.computeProposalInfo();
        }
        return this.fInfo;
    }

    private String computeProposalInfo() {
        StringBuffer hoverInfoBuffer = new StringBuffer();
        String workspaceLocation = this.fProject != null ? String.valueOf(this.fProject.getLocation().toString()) + '/' : PHPeclipsePlugin.getWorkspace().getRoot().getLocation().toString();
        String filename = String.valueOf(workspaceLocation) + this.fLocation.getFilename();
        PHPDocUtil.appendPHPDoc(hoverInfoBuffer, filename, this.fLocation);
        return hoverInfoBuffer.toString();
    }

    public IContextInformation getContextInformation() {
        if (this.fContextInfo == null && this.fLocation != null) {
            this.fInfo = this.fLocation.getUsage();
            if (this.fInfo != null) {
                int i1;
                int i0 = this.fInfo.indexOf(40);
                int newline = this.fInfo.indexOf(10);
                this.fContextInfo = i0 >= 0 && (i0 < newline || newline < 0) ? ((i1 = this.fInfo.indexOf(41, i0 + 1)) > 0 ? new ContextInformation(null, this.fInfo.substring(i0 + 1, i1)) : new ContextInformation(null, this.fInfo)) : new ContextInformation(null, this.fInfo);
            }
        }
        return this.fContextInfo;
    }

    public String getDisplayString() {
        String workspaceLocation = this.fProject != null ? String.valueOf(this.fProject.getName().toString()) + '/' : PHPeclipsePlugin.getWorkspace().getRoot().getLocation().toString();
        String filename = String.valueOf(workspaceLocation) + this.fLocation.getFilename();
        String usage = PHPDocUtil.getUsage(filename, this.fLocation);
        String result = String.valueOf(this.fIdentifierName) + TemplateMessages.getString("TemplateProposal.delimiter");
        if (usage.length() > 0) {
            result = String.valueOf(result) + usage + TemplateMessages.getString("TemplateProposal.delimiter");
        }
        result = String.valueOf(result) + filename;
        return result;
    }

    public Image getImage() {
        switch (this.fLocation.getType()) {
            case 2: {
                return PHPUiImages.get("net.sourceforge.phpdt.internal.ui.fun_obj.gif");
            }
            case 1: {
                return PHPUiImages.get("net.sourceforge.phpdt.internal.ui.class_default_obj.gif");
            }
            case 6: {
                return PHPUiImages.get("net.sourceforge.phpdt.internal.ui.class_default_obj.gif");
            }
            case 4: {
                return PHPUiImages.get("net.sourceforge.phpdt.internal.ui.fun_obj.gif");
            }
            case 5: {
                return PHPUiImages.get("net.sourceforge.phpdt.internal.ui.define_obj.gif");
            }
            case 3: {
                return PHPUiImages.get("net.sourceforge.phpdt.internal.ui.var_obj.gif");
            }
            case 7: {
                return PHPUiImages.get("net.sourceforge.phpdt.internal.ui.var_obj.gif");
            }
        }
        return PHPUiImages.get("net.sourceforge.phpdt.internal.ui.fun_obj.gif");
    }

    public int getRelevance() {
        if (this.fContext instanceof JavaContext) {
            JavaContext context = (JavaContext)this.fContext;
            switch (context.getCharacterBeforeStart()) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return 80;
                }
                case ':': 
                case '>': {
                    return 85;
                }
            }
            return 0;
        }
        return 80;
    }
}

