/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.template;

import java.util.ArrayList;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.internal.corext.template.php.CompilationUnitContextType;
import net.sourceforge.phpdt.internal.corext.template.php.JavaContext;
import net.sourceforge.phpdt.internal.corext.template.php.JavaContextType;
import net.sourceforge.phpdt.internal.ui.PHPUiImages;
import net.sourceforge.phpdt.internal.ui.text.java.IPHPCompletionProposal;
import net.sourceforge.phpdt.internal.ui.text.template.IdentifierProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.swt.graphics.Point;

public class IdentifierEngine {
    private JavaContextType fContextType;
    private ArrayList fProposals = new ArrayList();

    public IdentifierEngine(JavaContextType contextType) {
        this.fContextType = contextType;
    }

    public void reset() {
        this.fProposals.clear();
    }

    public IPHPCompletionProposal[] getResults() {
        return this.fProposals.toArray(new IPHPCompletionProposal[this.fProposals.size()]);
    }

    public void complete(ITextViewer viewer, int completionPosition, Object[] identifiers, ICompilationUnit compilationUnit) {
        IDocument document = viewer.getDocument();
        if (!(this.fContextType instanceof CompilationUnitContextType)) {
            return;
        }
        Point selection = viewer.getSelectedRange();
        String selectedText = null;
        if (selection.y != 0) {
            try {
                selectedText = document.get(selection.x, selection.y);
            }
            catch (BadLocationException badLocationException) {}
        }
        JavaContext context = (JavaContext)this.fContextType.createContext(document, completionPosition, selection.y, compilationUnit);
        context.setVariable("selection", selectedText);
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        String identifier = null;
        int maxProposals = 200;
        int i = 0;
        while (i != identifiers.length) {
            identifier = (String)identifiers[i];
            if (context.canEvaluate(identifier)) {
                if (maxProposals-- < 0) {
                    return;
                }
                this.fProposals.add(new IdentifierProposal(identifier, (TemplateContext)context, (IRegion)region, viewer, PHPUiImages.get("net.sourceforge.phpdt.internal.ui.fun_obj.gif"), PHPUiImages.get("net.sourceforge.phpdt.internal.ui.var_obj.gif")));
            }
            ++i;
        }
    }
}

