/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.template.contentassist;

import net.sourceforge.phpdt.internal.corext.template.php.CompilationUnitContext;
import net.sourceforge.phpdt.internal.corext.template.php.JavaContext;
import net.sourceforge.phpdt.internal.ui.text.java.IPHPCompletionProposal;
import net.sourceforge.phpdt.internal.ui.text.template.contentassist.InclusivePositionUpdater;
import net.sourceforge.phpdt.internal.ui.text.template.contentassist.MultiVariable;
import net.sourceforge.phpdt.internal.ui.text.template.contentassist.MultiVariableGuess;
import net.sourceforge.phpdt.internal.ui.text.template.contentassist.PositionBasedCompletionProposal;
import net.sourceforge.phpdt.internal.ui.text.template.contentassist.TemplateContentAssistMessages;
import net.sourceforge.phpdt.internal.ui.text.template.contentassist.TemplateInformationControlCreator;
import net.sourceforge.phpdt.internal.ui.text.template.contentassist.VariablePosition;
import net.sourceforge.phpdt.internal.ui.util.ExceptionHandler;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.phpeditor.EditorHighlightingSynchronizer;
import net.sourceforge.phpeclipse.phpeditor.PHPEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class TemplateProposal
implements IPHPCompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension3 {
    private final Template fTemplate;
    private final TemplateContext fContext;
    private final Image fImage;
    private IRegion fRegion;
    private int fRelevance;
    private IRegion fSelectedRegion;
    private String fDisplayString;

    public TemplateProposal(Template template, TemplateContext context, IRegion region, Image image) {
        Assert.isNotNull((Object)template);
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)region);
        this.fTemplate = template;
        this.fContext = context;
        this.fImage = image;
        this.fRegion = region;
        this.fDisplayString = null;
        if (context instanceof JavaContext) {
            switch (((JavaContext)context).getCharacterBeforeStart()) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.fRelevance = 90;
                    break;
                }
                default: {
                    this.fRelevance = 0;
                    break;
                }
            }
        } else {
            this.fRelevance = 90;
        }
    }

    public final void apply(IDocument document) {
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        try {
            TemplateBuffer templateBuffer;
            this.fContext.setReadOnly(false);
            try {
                templateBuffer = this.fContext.evaluate(this.fTemplate);
            }
            catch (TemplateException templateException) {
                this.fSelectedRegion = this.fRegion;
                return;
            }
            int start = this.getReplaceOffset();
            int end = this.getReplaceEndOffset();
            end = Math.max(end, offset);
            IDocument document = viewer.getDocument();
            String templateString = templateBuffer.getString();
            document.replace(start, end - start, templateString);
            LinkedModeModel model = new LinkedModeModel();
            TemplateVariable[] variables = templateBuffer.getVariables();
            MultiVariableGuess guess = this.fContext instanceof CompilationUnitContext ? ((CompilationUnitContext)this.fContext).getMultiVariableGuess() : null;
            boolean hasPositions = false;
            int i = 0;
            while (i != variables.length) {
                TemplateVariable variable = variables[i];
                if (!variable.isUnambiguous()) {
                    VariablePosition first;
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    int[] offsets = variable.getOffsets();
                    int length = variable.getLength();
                    if (guess != null && variable instanceof MultiVariable) {
                        first = new VariablePosition(document, offsets[0] + start, length, guess, (MultiVariable)variable);
                        guess.addSlave(first);
                    } else {
                        String[] values = variable.getValues();
                        ICompletionProposal[] proposals = new ICompletionProposal[values.length];
                        int j = 0;
                        while (j < values.length) {
                            this.ensurePositionCategoryInstalled(document, model);
                            Position pos = new Position(offsets[0] + start, length);
                            document.addPosition(this.getCategory(), pos);
                            proposals[j] = new PositionBasedCompletionProposal(values[j], pos, length);
                            ++j;
                        }
                        first = proposals.length > 1 ? new ProposalPosition(document, offsets[0] + start, length, proposals) : new LinkedPosition(document, offsets[0] + start, length);
                    }
                    int j = 0;
                    while (j != offsets.length) {
                        if (j == 0) {
                            group.addPosition((LinkedPosition)first);
                        } else {
                            group.addPosition(new LinkedPosition(document, offsets[j] + start, length));
                        }
                        ++j;
                    }
                    model.addGroup(group);
                    hasPositions = true;
                }
                ++i;
            }
            if (hasPositions) {
                model.forceInstall();
                PHPEditor editor = this.getJavaEditor();
                if (editor != null) {
                    model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
                }
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
                ui.setExitPosition(viewer, this.getCaretOffset(templateBuffer) + start, 0, Integer.MAX_VALUE);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            } else {
                this.fSelectedRegion = new Region(this.getCaretOffset(templateBuffer) + start, 0);
            }
        }
        catch (BadLocationException e) {
            PHPeclipsePlugin.log(e);
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            this.fSelectedRegion = this.fRegion;
        }
        catch (BadPositionCategoryException e) {
            PHPeclipsePlugin.log(e);
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            this.fSelectedRegion = this.fRegion;
        }
    }

    private PHPEditor getJavaEditor() {
        IEditorPart part = PHPeclipsePlugin.getActivePage().getActiveEditor();
        if (part instanceof PHPEditor) {
            return (PHPEditor)part;
        }
        return null;
    }

    private int getReplaceOffset() {
        int start;
        if (this.fContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = (DocumentTemplateContext)this.fContext;
            start = docContext.getStart();
        } else {
            start = this.fRegion.getOffset();
        }
        return start;
    }

    private int getReplaceEndOffset() {
        int end;
        if (this.fContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = (DocumentTemplateContext)this.fContext;
            end = docContext.getEnd();
        } else {
            end = this.fRegion.getOffset() + this.fRegion.getLength();
        }
        return end;
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            final InclusivePositionUpdater updater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater((IPositionUpdater)updater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    try {
                        document.removePositionCategory(TemplateProposal.this.getCategory());
                    }
                    catch (BadPositionCategoryException badPositionCategoryException) {}
                    document.removePositionUpdater((IPositionUpdater)updater);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private String getCategory() {
        return "TemplateProposalCategory_" + this.toString();
    }

    private int getCaretOffset(TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            if (variable.getType().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return buffer.getString().length();
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        try {
            TemplateBuffer templateBuffer;
            this.fContext.setReadOnly(true);
            try {
                templateBuffer = this.fContext.evaluate(this.fTemplate);
            }
            catch (TemplateException templateException) {
                return null;
            }
            return templateBuffer.getString();
        }
        catch (BadLocationException e) {
            this.handleException(PHPeclipsePlugin.getActiveWorkbenchShell(), new CoreException((IStatus)new Status(4, PHPeclipsePlugin.getPluginId(), 0, "", (Throwable)e)));
            return null;
        }
    }

    public String getDisplayString() {
        if (this.fDisplayString == null) {
            this.fDisplayString = String.valueOf(this.fTemplate.getName()) + TemplateContentAssistMessages.getString("TemplateProposal.delimiter") + this.fTemplate.getDescription();
        }
        return this.fDisplayString;
    }

    public void setDisplayString(String displayString) {
        this.fDisplayString = displayString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    private void openErrorDialog(Shell shell, Exception e) {
        MessageDialog.openError((Shell)shell, (String)TemplateContentAssistMessages.getString("TemplateEvaluator.error.title"), (String)e.getMessage());
    }

    private void handleException(Shell shell, CoreException e) {
        ExceptionHandler.handle(e, shell, TemplateContentAssistMessages.getString("TemplateEvaluator.error.title"), null);
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    public Template getTemplate() {
        return this.fTemplate;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return new TemplateInformationControlCreator();
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            int replaceOffset = this.getReplaceOffset();
            if (offset >= replaceOffset) {
                String content = document.get(replaceOffset, offset - replaceOffset);
                return this.fTemplate.getName().startsWith(content);
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.fTemplate.getName();
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplaceOffset();
    }
}

