/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.util;

import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.internal.ui.dialogs.ElementListSelectionDialog;
import net.sourceforge.phpdt.internal.ui.util.ResourceSelector;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class PHPProjectSelector
extends ResourceSelector {
    public PHPProjectSelector(Composite parent) {
        super(parent);
        this.browseDialogTitle = "Project Selection";
    }

    public IProject getSelection() {
        String projectName = this.getSelectionText();
        if (projectName != null && !projectName.equals("")) {
            return PHPeclipsePlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return null;
    }

    protected void handleBrowseSelected() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider());
        dialog.setTitle(this.browseDialogTitle);
        dialog.setMessage(this.browseDialogMessage);
        dialog.setElements(JavaCore.getPHPProjects());
        if (dialog.open() == 0) {
            this.textField.setText(((IProject)dialog.getFirstResult()).getName());
        }
    }

    protected String validateResourceSelection() {
        IProject project = this.getSelection();
        return project == null ? "" : project.getName();
    }
}

