/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.viewsupport;

import net.sourceforge.phpdt.core.Flags;
import net.sourceforge.phpdt.core.IField;
import net.sourceforge.phpdt.core.IMember;
import net.sourceforge.phpdt.core.IType;
import net.sourceforge.phpdt.core.JavaModelException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class MemberFilter
extends ViewerFilter {
    public static final int FILTER_NONPUBLIC = 1;
    public static final int FILTER_STATIC = 2;
    public static final int FILTER_FIELDS = 4;
    private int fFilterProperties;

    public final void addFilter(int filter) {
        this.fFilterProperties |= filter;
    }

    public final void removeFilter(int filter) {
        this.fFilterProperties &= 0xFFFFFFFF ^ filter;
    }

    public final boolean hasFilter(int filter) {
        return (this.fFilterProperties & filter) != 0;
    }

    public boolean isFilterProperty(Object element, Object property) {
        return false;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        try {
            if (this.hasFilter(4) && element instanceof IField) {
                return false;
            }
            if (element instanceof IMember) {
                IMember member = (IMember)element;
                if (member.getElementName().startsWith("<")) {
                    return false;
                }
                int flags = member.getFlags();
                if (this.hasFilter(2) && (Flags.isStatic(flags) || this.isFieldInInterface(member)) && member.getElementType() != 7) {
                    return false;
                }
                if (this.hasFilter(1) && !Flags.isPublic(flags) && !this.isMemberInInterface(member) && !this.isTopLevelType(member)) {
                    return false;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return true;
    }

    private boolean isMemberInInterface(IMember member) throws JavaModelException {
        IType parent = member.getDeclaringType();
        return parent != null && parent.isInterface();
    }

    private boolean isFieldInInterface(IMember member) throws JavaModelException {
        return member.getElementType() == 8 && member.getDeclaringType().isInterface();
    }

    private boolean isTopLevelType(IMember member) throws JavaModelException {
        IType parent = member.getDeclaringType();
        return parent == null;
    }
}

