/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.ltk.core;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.phpdt.core.compiler.InvalidInputException;
import net.sourceforge.phpdt.internal.compiler.parser.Scanner;
import net.sourceforge.phpdt.internal.compiler.parser.SyntaxError;
import net.sourceforge.phpdt.internal.ui.util.PHPFileUtil;
import net.sourceforge.phpdt.ltk.core.CoreTexts;
import net.sourceforge.phpdt.ltk.core.RenameIdentifierInfo;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.IConditionChecker;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenameIdentifierDelegate {
    protected final RenameIdentifierInfo info;
    protected final Map phpFiles;
    static /* synthetic */ Class class$0;

    public RenameIdentifierDelegate(RenameIdentifierInfo info) {
        this.info = info;
        this.phpFiles = new HashMap();
    }

    RefactoringStatus checkInitialConditions() {
        RefactoringStatus result = new RefactoringStatus();
        IFile sourceFile = this.info.getSourceFile();
        if (sourceFile == null || !sourceFile.exists()) {
            result.addFatalError(CoreTexts.renamePropertyDelegate_noSourceFile);
        } else if (this.info.getSourceFile().isReadOnly()) {
            result.addFatalError(CoreTexts.renamePropertyDelegate_roFile);
        } else if (this.isEmpty(this.info.getOldName())) {
            result.addFatalError(CoreTexts.renamePropertyDelegate_noPHPKey);
        }
        return result;
    }

    RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext ctxt) {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask(CoreTexts.renamePropertyDelegate_checking, 100);
        new ArrayList();
        if (this.info.isAllProjects()) {
            IWorkspaceRoot rootContainer = ResourcesPlugin.getWorkspace().getRoot();
            try {
                IResource[] members = rootContainer.members();
                int i = 0;
                while (i < members.length) {
                    if (members[i] instanceof IProject) {
                        String msg;
                        IProject project = (IProject)members[i];
                        try {
                            if (project.isNatureEnabled("net.sourceforge.phpeclipse.phpnature")) {
                                this.search((IContainer)project, result);
                            }
                        }
                        catch (CoreException e) {
                            msg = "Project: " + project.getLocation().toOSString() + " CoreException " + e.getMessage();
                            result.addError(msg);
                        }
                        catch (Exception e) {
                            msg = "Project: " + project.getLocation().toOSString() + " Exception " + e.getMessage();
                            result.addError(msg);
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                String msg = "Workspace: " + rootContainer.getLocation().toOSString() + " CoreException " + e.getMessage();
                result.addError(msg);
            }
        } else {
            IProject project = this.info.getSourceFile().getProject();
            try {
                if (project.isNatureEnabled("net.sourceforge.phpeclipse.phpnature")) {
                    this.search((IContainer)project, result);
                }
            }
            catch (CoreException e) {
                String msg = "Project: " + project.getLocation().toOSString() + " CoreException " + e.getMessage();
                result.addError(msg);
            }
            catch (Exception e) {
                String msg = "Project: " + project.getLocation().toOSString() + " Exception " + e.getMessage();
                result.addError(msg);
            }
        }
        pm.worked(50);
        if (ctxt != null) {
            IFile[] files = new IFile[this.phpFiles.size()];
            this.phpFiles.keySet().toArray(files);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IConditionChecker checker = ctxt.getChecker((Class)clazz);
            ValidateEditChecker editChecker = (ValidateEditChecker)checker;
            editChecker.addFiles(files);
        }
        pm.done();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createChange(IProgressMonitor pm, CompositeChange rootChange) {
        try {
            pm.beginTask(CoreTexts.renamePropertyDelegate_collectingChanges, 100);
            if (this.info.isUpdateProject()) {
                rootChange.addAll(this.createChangesForContainer(pm));
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            pm.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        pm.done();
    }

    protected Change[] createChangesForContainer(IProgressMonitor pm) {
        ArrayList<TextFileChange> result = new ArrayList<TextFileChange>();
        Iterator it = this.phpFiles.keySet().iterator();
        int numberOfFiles = this.phpFiles.size();
        double percent = 100 / numberOfFiles;
        int work = 0;
        int indx = 0;
        while (it.hasNext()) {
            IFile file = (IFile)it.next();
            List list = this.getKeyOffsets(file);
            if (list != null && list.size() > 0) {
                TextFileChange tfc = new TextFileChange(file.getName(), file);
                MultiTextEdit fileChangeRootEdit = new MultiTextEdit();
                tfc.setEdit((TextEdit)fileChangeRootEdit);
                int i = 0;
                while (i < list.size()) {
                    ReplaceEdit edit = new ReplaceEdit(((Integer)list.get(i)).intValue(), this.info.getOldName().length(), this.info.getNewName());
                    fileChangeRootEdit.addChild((TextEdit)edit);
                    ++i;
                }
                result.add(tfc);
            }
            work = new Double((double)(++indx) * percent).intValue();
            pm.worked(work);
        }
        return result.toArray(new Change[result.size()]);
    }

    protected boolean isEmpty(String candidate) {
        return candidate == null || candidate.trim().length() == 0;
    }

    private void search(IContainer rootContainer, RefactoringStatus status) {
        try {
            IResource[] members = rootContainer.members();
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IContainer) {
                    this.search((IContainer)members[i], status);
                } else {
                    IFile file = (IFile)members[i];
                    this.handleFile(file, status);
                }
                ++i;
            }
        }
        catch (CoreException cex) {
            status.addFatalError(cex.getMessage());
        }
    }

    private void handleFile(IFile file, RefactoringStatus status) {
        if (PHPFileUtil.isPHPFile(file)) {
            this.determineKeyOffsets(file, status);
        }
    }

    protected List getKeyOffsets(IFile file) {
        return (List)this.phpFiles.get(file);
    }

    private void determineKeyOffsets(IFile file, RefactoringStatus status) {
        ArrayList<Integer> matches = new ArrayList<Integer>();
        try {
            String content = this.readFileContent(file, status);
            Scanner scanner = new Scanner(true, false);
            scanner.setSource(content.toCharArray());
            scanner.setPHPMode(false);
            char[] word = this.info.getOldName().toCharArray();
            int fToken = 0;
            try {
                fToken = scanner.getNextToken();
                while (fToken != 0) {
                    if ((fToken == 150 || fToken == 138) && scanner.equalsCurrentTokenSource(word)) {
                        matches.add(new Integer(scanner.getCurrentTokenStartPosition()));
                    }
                    fToken = scanner.getNextToken();
                }
            }
            catch (InvalidInputException e) {
                String msg = "File: " + file.getLocation().toOSString() + " InvalidInputException " + e.getMessage();
                status.addError(msg);
            }
            catch (SyntaxError e) {
                String msg = "File: " + file.getLocation().toOSString() + " SyntaxError " + e.getMessage();
                status.addError(msg);
            }
        }
        catch (Exception e) {
            String msg = "File: " + file.getLocation().toOSString() + " Exception " + e.getMessage();
            status.addError(msg);
        }
        if (matches.size() > 0) {
            this.phpFiles.put(file, matches);
        }
    }

    private String readFileContent(IFile file, RefactoringStatus refStatus) {
        String result = null;
        try {
            InputStream is = file.getContents();
            byte[] buf = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int len = is.read(buf);
            while (len > 0) {
                bos.write(buf, 0, len);
                len = is.read(buf);
            }
            is.close();
            result = new String(bos.toByteArray());
        }
        catch (Exception ex) {
            String msg = ex.toString();
            refStatus.addFatalError(msg);
            String pluginId = PHPeclipsePlugin.getPluginId();
            Status status = new Status(4, pluginId, 0, msg, (Throwable)ex);
            PHPeclipsePlugin.getDefault().getLog().log((IStatus)status);
        }
        return result;
    }
}

